/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.api.core.ApiFuture;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.SpannerApiFutures;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.connection.AbstractMockServerTest;
import com.google.cloud.spanner.connection.Connection;
import com.google.cloud.spanner.connection.ITAbstractSpannerTest;
import com.google.cloud.spanner.connection.StatementResult;
import com.google.common.collect.ImmutableSet;
import com.google.longrunning.Operation;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.util.Arrays;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ExceptionMockServerTest
extends AbstractMockServerTest {
    private static final Statement UPDATE_STATEMENT = Statement.of((String)"update foo set bar=1 where baz=1");
    private static final Statement SELECT_STATEMENT = Statement.of((String)"select * from foo");
    private static final StatusRuntimeException NOT_FOUND_EXCEPTION = Status.INVALID_ARGUMENT.withDescription("Table 'foo' not found").asRuntimeException();

    @After
    public void clearRequests() {
        mockSpanner.clearRequests();
    }

    @Test
    public void testUpdateAsyncException() {
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.exception(UPDATE_STATEMENT, NOT_FOUND_EXCEPTION));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            SpannerException exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> SpannerApiFutures.get((ApiFuture)connection.executeUpdateAsync(UPDATE_STATEMENT)));
            Assert.assertNotNull((Object)exception.getSuppressed());
            Assert.assertEquals((long)1L, (long)exception.getSuppressed().length);
            Throwable suppressed = exception.getSuppressed()[0];
            String methodName = new Object(){}.getClass().getEnclosingMethod().getName();
            Assert.assertTrue((boolean)Arrays.stream(suppressed.getStackTrace()).anyMatch(element -> element.getClassName().equals(ExceptionMockServerTest.class.getName()) && element.getMethodName().equals(methodName)));
        }
    }

    @Test
    public void testUpdateException() {
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.exception(UPDATE_STATEMENT, NOT_FOUND_EXCEPTION));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            SpannerException exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.executeUpdate(UPDATE_STATEMENT));
            Assert.assertNotNull((Object)exception.getSuppressed());
            Assert.assertEquals((long)0L, (long)exception.getSuppressed().length);
        }
    }

    @Test
    public void testQueryAsyncException() {
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.exception(SELECT_STATEMENT, NOT_FOUND_EXCEPTION));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            SpannerException exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.executeQueryAsync(SELECT_STATEMENT, new Options.QueryOption[0]).toList(row -> row));
            Assert.assertNotNull((Object)exception.getSuppressed());
            Assert.assertEquals((long)1L, (long)exception.getSuppressed().length);
            Throwable suppressed = exception.getSuppressed()[0];
            String methodName = new Object(){}.getClass().getEnclosingMethod().getName();
            Assert.assertTrue((boolean)Arrays.stream(suppressed.getStackTrace()).anyMatch(element -> element.getClassName().equals(ExceptionMockServerTest.class.getName()) && element.getMethodName().equals(methodName)));
        }
    }

    @Test
    public void testQueryException() {
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.exception(SELECT_STATEMENT, NOT_FOUND_EXCEPTION));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            SpannerException exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.executeQuery(SELECT_STATEMENT, new Options.QueryOption[0]).next());
            Assert.assertNotNull((Object)exception.getSuppressed());
            Assert.assertEquals((long)0L, (long)exception.getSuppressed().length);
        }
    }

    @Test
    public void testCommitAsyncException() {
        mockSpanner.setCommitExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)NOT_FOUND_EXCEPTION));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.bufferedWrite(((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"foo").set("id").to(1L)).build());
            SpannerException exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> SpannerApiFutures.get((ApiFuture)connection.commitAsync()));
            Assert.assertNotNull((Object)exception.getSuppressed());
            Assert.assertEquals((long)1L, (long)exception.getSuppressed().length);
            Throwable suppressed = exception.getSuppressed()[0];
            String methodName = new Object(){}.getClass().getEnclosingMethod().getName();
            Assert.assertTrue((boolean)Arrays.stream(suppressed.getStackTrace()).anyMatch(element -> element.getClassName().equals(ExceptionMockServerTest.class.getName()) && element.getMethodName().equals(methodName)));
        }
    }

    @Test
    public void testCommitException() {
        mockSpanner.setCommitExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)NOT_FOUND_EXCEPTION));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.bufferedWrite(((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"foo").set("id").to(1L)).build());
            SpannerException exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> ((Connection)connection).commit());
            Assert.assertNotNull((Object)exception.getSuppressed());
            Assert.assertEquals((long)0L, (long)exception.getSuppressed().length);
        }
    }

    @Test
    public void testAllowedResultType() {
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(SELECT_COUNT_STATEMENT, SELECT_COUNT_RESULTSET_BEFORE_INSERT));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(INSERT_STATEMENT, 1L));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.updateReturning(INSERT_RETURNING_STATEMENT, SELECT_COUNT_RESULTSET_AFTER_INSERT));
        mockDatabaseAdmin.addResponse((AbstractMessage)Operation.newBuilder().setDone(true).setResponse(Any.pack((Message)Empty.getDefaultInstance())).setMetadata(Any.pack((Message)UpdateDatabaseDdlMetadata.getDefaultInstance())).build());
        Statement ddl = Statement.of((String)"create table foo");
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            Assert.assertEquals((Object)ErrorCode.INVALID_ARGUMENT, (Object)((SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.execute(SELECT_COUNT_STATEMENT, (Set)ImmutableSet.of()))).getErrorCode());
            Assert.assertEquals((Object)ErrorCode.INVALID_ARGUMENT, (Object)((SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.execute(SELECT_COUNT_STATEMENT, (Set)ImmutableSet.of((Object)StatementResult.ResultType.UPDATE_COUNT)))).getErrorCode());
            Assert.assertEquals((Object)ErrorCode.INVALID_ARGUMENT, (Object)((SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.execute(SELECT_COUNT_STATEMENT, (Set)ImmutableSet.of((Object)StatementResult.ResultType.NO_RESULT)))).getErrorCode());
            Assert.assertNotNull((Object)connection.execute(SELECT_COUNT_STATEMENT, (Set)ImmutableSet.of((Object)StatementResult.ResultType.RESULT_SET)).getResultSet());
            Assert.assertEquals((Object)ErrorCode.INVALID_ARGUMENT, (Object)((SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.execute(INSERT_STATEMENT, (Set)ImmutableSet.of()))).getErrorCode());
            Assert.assertEquals((Object)ErrorCode.INVALID_ARGUMENT, (Object)((SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.execute(INSERT_STATEMENT, (Set)ImmutableSet.of((Object)StatementResult.ResultType.RESULT_SET)))).getErrorCode());
            Assert.assertEquals((Object)ErrorCode.INVALID_ARGUMENT, (Object)((SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.execute(INSERT_STATEMENT, (Set)ImmutableSet.of((Object)StatementResult.ResultType.NO_RESULT)))).getErrorCode());
            Assert.assertNotNull((Object)connection.execute(INSERT_STATEMENT, (Set)ImmutableSet.of((Object)StatementResult.ResultType.UPDATE_COUNT)).getUpdateCount());
            Assert.assertEquals((Object)ErrorCode.INVALID_ARGUMENT, (Object)((SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.execute(INSERT_RETURNING_STATEMENT, (Set)ImmutableSet.of()))).getErrorCode());
            Assert.assertEquals((Object)ErrorCode.INVALID_ARGUMENT, (Object)((SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.execute(INSERT_RETURNING_STATEMENT, (Set)ImmutableSet.of((Object)StatementResult.ResultType.UPDATE_COUNT)))).getErrorCode());
            Assert.assertEquals((Object)ErrorCode.INVALID_ARGUMENT, (Object)((SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.execute(INSERT_RETURNING_STATEMENT, (Set)ImmutableSet.of((Object)StatementResult.ResultType.NO_RESULT)))).getErrorCode());
            Assert.assertNotNull((Object)connection.execute(INSERT_RETURNING_STATEMENT, (Set)ImmutableSet.of((Object)StatementResult.ResultType.RESULT_SET)).getResultSet());
            connection.commit();
            connection.setAutocommit(true);
            Assert.assertEquals((Object)ErrorCode.INVALID_ARGUMENT, (Object)((SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.execute(ddl, (Set)ImmutableSet.of()))).getErrorCode());
            Assert.assertEquals((Object)ErrorCode.INVALID_ARGUMENT, (Object)((SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.execute(ddl, (Set)ImmutableSet.of((Object)StatementResult.ResultType.RESULT_SET)))).getErrorCode());
            Assert.assertEquals((Object)ErrorCode.INVALID_ARGUMENT, (Object)((SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.execute(ddl, (Set)ImmutableSet.of((Object)StatementResult.ResultType.UPDATE_COUNT)))).getErrorCode());
            Assert.assertNotNull((Object)connection.execute(ddl, (Set)ImmutableSet.of((Object)StatementResult.ResultType.NO_RESULT)));
        }
    }
}

