/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.connection.ClientSideStatementImpl;
import com.google.cloud.spanner.connection.ClientSideStatementValueConverters;
import com.google.cloud.spanner.connection.PgTransactionMode;
import com.google.cloud.spanner.connection.ReadOnlyStalenessConverterTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class PgTransactionModeConverterTest {
    static PgTransactionMode create(PgTransactionMode.AccessMode accessMode) {
        return PgTransactionModeConverterTest.create(accessMode, null);
    }

    static PgTransactionMode create(PgTransactionMode.IsolationLevel isolationLevel) {
        return PgTransactionModeConverterTest.create(null, isolationLevel);
    }

    static PgTransactionMode create(PgTransactionMode.AccessMode accessMode, PgTransactionMode.IsolationLevel isolationLevel) {
        PgTransactionMode mode = new PgTransactionMode();
        mode.setAccessMode(accessMode);
        mode.setIsolationLevel(isolationLevel);
        return mode;
    }

    @Test
    public void testConvert() throws ClientSideStatementImpl.CompileException {
        String allowedValues = ReadOnlyStalenessConverterTest.getAllowedValues(ClientSideStatementValueConverters.PgTransactionModeConverter.class, Dialect.POSTGRESQL);
        Assert.assertNotNull((Object)allowedValues);
        ClientSideStatementValueConverters.PgTransactionModeConverter converter = new ClientSideStatementValueConverters.PgTransactionModeConverter(allowedValues);
        Assert.assertEquals((Object)PgTransactionModeConverterTest.create(PgTransactionMode.AccessMode.READ_WRITE_TRANSACTION), (Object)converter.convert("read write"));
        Assert.assertEquals((Object)PgTransactionModeConverterTest.create(PgTransactionMode.AccessMode.READ_WRITE_TRANSACTION), (Object)converter.convert("READ WRITE"));
        Assert.assertEquals((Object)PgTransactionModeConverterTest.create(PgTransactionMode.AccessMode.READ_WRITE_TRANSACTION), (Object)converter.convert("Read Write"));
        Assert.assertEquals((Object)PgTransactionModeConverterTest.create(PgTransactionMode.AccessMode.READ_WRITE_TRANSACTION), (Object)converter.convert("read   write"));
        Assert.assertEquals((Object)PgTransactionModeConverterTest.create(PgTransactionMode.AccessMode.READ_WRITE_TRANSACTION), (Object)converter.convert("READ\nWRITE"));
        Assert.assertEquals((Object)PgTransactionModeConverterTest.create(PgTransactionMode.AccessMode.READ_WRITE_TRANSACTION), (Object)converter.convert("Read\tWrite"));
        Assert.assertEquals((Object)PgTransactionModeConverterTest.create(PgTransactionMode.AccessMode.READ_ONLY_TRANSACTION), (Object)converter.convert("read only"));
        Assert.assertEquals((Object)PgTransactionModeConverterTest.create(PgTransactionMode.AccessMode.READ_ONLY_TRANSACTION), (Object)converter.convert("READ ONLY"));
        Assert.assertEquals((Object)PgTransactionModeConverterTest.create(PgTransactionMode.AccessMode.READ_ONLY_TRANSACTION), (Object)converter.convert("Read Only"));
        Assert.assertEquals((Object)PgTransactionModeConverterTest.create(PgTransactionMode.AccessMode.READ_ONLY_TRANSACTION), (Object)converter.convert("read   only"));
        Assert.assertEquals((Object)PgTransactionModeConverterTest.create(PgTransactionMode.AccessMode.READ_ONLY_TRANSACTION), (Object)converter.convert("READ\nONLY"));
        Assert.assertEquals((Object)PgTransactionModeConverterTest.create(PgTransactionMode.AccessMode.READ_ONLY_TRANSACTION), (Object)converter.convert("Read\tOnly"));
        Assert.assertEquals((Object)PgTransactionModeConverterTest.create(PgTransactionMode.IsolationLevel.ISOLATION_LEVEL_DEFAULT), (Object)converter.convert("isolation level default"));
        Assert.assertEquals((Object)PgTransactionModeConverterTest.create(PgTransactionMode.IsolationLevel.ISOLATION_LEVEL_DEFAULT), (Object)converter.convert("ISOLATION LEVEL DEFAULT"));
        Assert.assertEquals((Object)PgTransactionModeConverterTest.create(PgTransactionMode.IsolationLevel.ISOLATION_LEVEL_DEFAULT), (Object)converter.convert("Isolation Level Default"));
        Assert.assertEquals((Object)PgTransactionModeConverterTest.create(PgTransactionMode.IsolationLevel.ISOLATION_LEVEL_DEFAULT), (Object)converter.convert("isolation    level  default"));
        Assert.assertEquals((Object)PgTransactionModeConverterTest.create(PgTransactionMode.IsolationLevel.ISOLATION_LEVEL_DEFAULT), (Object)converter.convert("ISOLATION\nLEVEL\nDEFAULT"));
        Assert.assertEquals((Object)PgTransactionModeConverterTest.create(PgTransactionMode.IsolationLevel.ISOLATION_LEVEL_DEFAULT), (Object)converter.convert("Isolation\tLevel\tDefault"));
        Assert.assertEquals((Object)PgTransactionModeConverterTest.create(PgTransactionMode.IsolationLevel.ISOLATION_LEVEL_SERIALIZABLE), (Object)converter.convert("isolation level serializable"));
        Assert.assertEquals((Object)PgTransactionModeConverterTest.create(PgTransactionMode.IsolationLevel.ISOLATION_LEVEL_SERIALIZABLE), (Object)converter.convert("ISOLATION LEVEL SERIALIZABLE"));
        Assert.assertEquals((Object)PgTransactionModeConverterTest.create(PgTransactionMode.IsolationLevel.ISOLATION_LEVEL_SERIALIZABLE), (Object)converter.convert("Isolation Level Serializable"));
        Assert.assertEquals((Object)PgTransactionModeConverterTest.create(PgTransactionMode.IsolationLevel.ISOLATION_LEVEL_SERIALIZABLE), (Object)converter.convert("isolation    level  serializable"));
        Assert.assertEquals((Object)PgTransactionModeConverterTest.create(PgTransactionMode.IsolationLevel.ISOLATION_LEVEL_SERIALIZABLE), (Object)converter.convert("ISOLATION\nLEVEL\nSERIALIZABLE"));
        Assert.assertEquals((Object)PgTransactionModeConverterTest.create(PgTransactionMode.IsolationLevel.ISOLATION_LEVEL_SERIALIZABLE), (Object)converter.convert("Isolation\tLevel\tSerializable"));
        Assert.assertEquals((Object)new PgTransactionMode(), (Object)converter.convert(""));
        Assert.assertEquals((Object)new PgTransactionMode(), (Object)converter.convert(" "));
        Assert.assertNull((Object)converter.convert("random string"));
        Assert.assertNull((Object)converter.convert("read_write"));
        Assert.assertNull((Object)converter.convert("READ_WRITE"));
        Assert.assertNull((Object)converter.convert("read_only"));
        Assert.assertNull((Object)converter.convert("Read_Only"));
        Assert.assertNull((Object)converter.convert("READ_ONLY"));
        Assert.assertNull((Object)converter.convert("isolation_level default"));
        Assert.assertNull((Object)converter.convert("isolationlevel default"));
        Assert.assertNull((Object)converter.convert("isolation level read committed"));
        Assert.assertNull((Object)converter.convert("isolation level "));
        Assert.assertNull((Object)converter.convert("isolation level_default"));
        Assert.assertEquals((Object)PgTransactionModeConverterTest.create(PgTransactionMode.AccessMode.READ_WRITE_TRANSACTION, PgTransactionMode.IsolationLevel.ISOLATION_LEVEL_DEFAULT), (Object)converter.convert("read write isolation level default"));
        Assert.assertEquals((Object)PgTransactionModeConverterTest.create(PgTransactionMode.AccessMode.READ_WRITE_TRANSACTION, PgTransactionMode.IsolationLevel.ISOLATION_LEVEL_DEFAULT), (Object)converter.convert("  read write isolation level default  "));
        Assert.assertEquals((Object)PgTransactionModeConverterTest.create(PgTransactionMode.AccessMode.READ_WRITE_TRANSACTION, PgTransactionMode.IsolationLevel.ISOLATION_LEVEL_DEFAULT), (Object)converter.convert("read write, isolation level default"));
        Assert.assertEquals((Object)PgTransactionModeConverterTest.create(PgTransactionMode.AccessMode.READ_WRITE_TRANSACTION, PgTransactionMode.IsolationLevel.ISOLATION_LEVEL_DEFAULT), (Object)converter.convert("read write,isolation level default"));
        Assert.assertEquals((Object)PgTransactionModeConverterTest.create(PgTransactionMode.AccessMode.READ_WRITE_TRANSACTION, PgTransactionMode.IsolationLevel.ISOLATION_LEVEL_DEFAULT), (Object)converter.convert("read write , isolation level default"));
        Assert.assertEquals((Object)PgTransactionModeConverterTest.create(PgTransactionMode.AccessMode.READ_WRITE_TRANSACTION, PgTransactionMode.IsolationLevel.ISOLATION_LEVEL_DEFAULT), (Object)converter.convert("read write\nisolation level default"));
        Assert.assertEquals((Object)PgTransactionModeConverterTest.create(PgTransactionMode.AccessMode.READ_WRITE_TRANSACTION, PgTransactionMode.IsolationLevel.ISOLATION_LEVEL_DEFAULT), (Object)converter.convert("isolation level default read write "));
        Assert.assertEquals((Object)PgTransactionModeConverterTest.create(PgTransactionMode.AccessMode.READ_WRITE_TRANSACTION, PgTransactionMode.IsolationLevel.ISOLATION_LEVEL_DEFAULT), (Object)converter.convert("isolation level default, read write"));
        Assert.assertEquals((Object)PgTransactionModeConverterTest.create(PgTransactionMode.AccessMode.READ_WRITE_TRANSACTION, PgTransactionMode.IsolationLevel.ISOLATION_LEVEL_DEFAULT), (Object)converter.convert("isolation level default\nread write"));
        Assert.assertEquals((Object)PgTransactionModeConverterTest.create(PgTransactionMode.AccessMode.READ_ONLY_TRANSACTION, PgTransactionMode.IsolationLevel.ISOLATION_LEVEL_DEFAULT), (Object)converter.convert("read only isolation level default"));
        Assert.assertEquals((Object)PgTransactionModeConverterTest.create(PgTransactionMode.AccessMode.READ_ONLY_TRANSACTION, PgTransactionMode.IsolationLevel.ISOLATION_LEVEL_SERIALIZABLE), (Object)converter.convert("read only isolation level serializable"));
        Assert.assertNull((Object)converter.convert("isolation level default, read-only"));
        Assert.assertNull((Object)converter.convert("isolation level default, read"));
        Assert.assertEquals((Object)PgTransactionModeConverterTest.create(PgTransactionMode.AccessMode.READ_ONLY_TRANSACTION, PgTransactionMode.IsolationLevel.ISOLATION_LEVEL_DEFAULT), (Object)converter.convert("read write, isolation level default, read only"));
        Assert.assertEquals((Object)PgTransactionModeConverterTest.create(PgTransactionMode.AccessMode.READ_ONLY_TRANSACTION, PgTransactionMode.IsolationLevel.ISOLATION_LEVEL_SERIALIZABLE), (Object)converter.convert("isolation level default, read only, isolation level serializable"));
        Assert.assertEquals((Object)PgTransactionModeConverterTest.create(PgTransactionMode.AccessMode.READ_ONLY_TRANSACTION, PgTransactionMode.IsolationLevel.ISOLATION_LEVEL_SERIALIZABLE), (Object)converter.convert("read write, isolation level default, read only isolation level serializable"));
    }
}

