/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.connection.ClientSideStatementImpl;
import com.google.cloud.spanner.connection.ClientSideStatementValueConverters;
import com.google.cloud.spanner.connection.ReadOnlyStalenessConverterTest;
import com.google.common.io.ByteStreams;
import java.io.InputStream;
import java.util.Base64;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ProtoDescriptorsConverterTest {
    @Test
    public void testConvert() throws ClientSideStatementImpl.CompileException {
        byte[] protoDescriptors;
        String allowedValues = ReadOnlyStalenessConverterTest.getAllowedValues(ClientSideStatementValueConverters.ProtoDescriptorsConverter.class, Dialect.GOOGLE_STANDARD_SQL);
        Assert.assertNotNull((Object)allowedValues);
        ClientSideStatementValueConverters.ProtoDescriptorsConverter converter = new ClientSideStatementValueConverters.ProtoDescriptorsConverter(allowedValues);
        try {
            InputStream in = ProtoDescriptorsConverterTest.class.getClassLoader().getResourceAsStream("com/google/cloud/spanner/descriptors.pb");
            Assert.assertNotNull((Object)in);
            protoDescriptors = ByteStreams.toByteArray((InputStream)in);
        }
        catch (Exception e) {
            throw SpannerExceptionFactory.newSpannerException((Throwable)e);
        }
        Assert.assertNull((Object)converter.convert(""));
        Assert.assertNull((Object)converter.convert("null"));
        Assert.assertNull((Object)converter.convert(null));
        Assert.assertNull((Object)converter.convert("random string"));
        Assert.assertArrayEquals((byte[])converter.convert(Base64.getEncoder().encodeToString(protoDescriptors)), (byte[])protoDescriptors);
    }
}

