/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.api.core.ApiFuture;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.CommitResponse;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ProtobufResultSet;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.ResultSets;
import com.google.cloud.spanner.SingerProto;
import com.google.cloud.spanner.SpannerApiFutures;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionManager;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.Value;
import com.google.cloud.spanner.connection.AbstractStatementParser;
import com.google.cloud.spanner.connection.AnalyzeMode;
import com.google.cloud.spanner.connection.ChecksumResultSet;
import com.google.cloud.spanner.connection.ReadWriteTransaction;
import com.google.cloud.spanner.connection.SavepointSupport;
import com.google.cloud.spanner.connection.StatementExecutor;
import com.google.cloud.spanner.connection.UnitOfWork;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Duration;
import com.google.protobuf.Message;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.rpc.RetryInfo;
import com.google.spanner.v1.ResultSetStats;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.protobuf.ProtoUtils;
import io.opentelemetry.api.trace.Span;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class ReadWriteTransactionTest {
    private ReadWriteTransaction createSubject() {
        return this.createSubject(CommitBehavior.SUCCEED, false);
    }

    private ReadWriteTransaction createSubject(CommitBehavior commitBehavior) {
        return this.createSubject(commitBehavior, false);
    }

    private ReadWriteTransaction createSubject(CommitBehavior commitBehavior, boolean withRetry) {
        DatabaseClient client = (DatabaseClient)Mockito.mock(DatabaseClient.class);
        Mockito.when((Object)client.transactionManager(new Options.TransactionOption[0])).thenAnswer(invocation -> {
            TransactionContext txContext = (TransactionContext)Mockito.mock(TransactionContext.class);
            Mockito.when((Object)txContext.executeQuery((Statement)Mockito.any(Statement.class), new Options.QueryOption[0])).thenReturn((Object)((ResultSet)Mockito.mock(ResultSet.class)));
            ResultSet rsWithStats = (ResultSet)Mockito.mock(ResultSet.class);
            Mockito.when((Object)rsWithStats.getStats()).thenReturn((Object)ResultSetStats.getDefaultInstance());
            Mockito.when((Object)txContext.analyzeQuery((Statement)Mockito.any(Statement.class), (ReadContext.QueryAnalyzeMode)Mockito.any(ReadContext.QueryAnalyzeMode.class))).thenReturn((Object)rsWithStats);
            Mockito.when((Object)txContext.executeUpdate((Statement)Mockito.any(Statement.class), new Options.UpdateOption[0])).thenReturn((Object)1L);
            return new SimpleTransactionManager(txContext, commitBehavior);
        });
        return ((ReadWriteTransaction.Builder)((ReadWriteTransaction.Builder)ReadWriteTransaction.newBuilder().setDatabaseClient(client).setRetryAbortsInternally(withRetry).setSavepointSupport(SavepointSupport.FAIL_AFTER_ROLLBACK).setTransactionRetryListeners(Collections.emptyList()).withStatementExecutor(new StatementExecutor())).setSpan(Span.getInvalid())).build();
    }

    @Test
    public void testExecuteDdl() {
        AbstractStatementParser.ParsedStatement statement = (AbstractStatementParser.ParsedStatement)Mockito.mock(AbstractStatementParser.ParsedStatement.class);
        Mockito.when((Object)statement.getType()).thenReturn((Object)AbstractStatementParser.StatementType.DDL);
        ReadWriteTransaction transaction = this.createSubject();
        try {
            transaction.executeDdlAsync(UnitOfWork.CallType.SYNC, statement);
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerException ex) {
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)ex.getErrorCode());
        }
    }

    @Test
    public void testRunBatch() {
        ReadWriteTransaction subject = this.createSubject();
        try {
            subject.runBatchAsync(UnitOfWork.CallType.SYNC);
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerException ex) {
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)ex.getErrorCode());
        }
    }

    @Test
    public void testAbortBatch() {
        ReadWriteTransaction subject = this.createSubject();
        try {
            subject.abortBatch();
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerException ex) {
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)ex.getErrorCode());
        }
    }

    @Test
    public void testExecuteQuery() {
        AbstractStatementParser.ParsedStatement parsedStatement = (AbstractStatementParser.ParsedStatement)Mockito.mock(AbstractStatementParser.ParsedStatement.class);
        Mockito.when((Object)parsedStatement.getType()).thenReturn((Object)AbstractStatementParser.StatementType.QUERY);
        Mockito.when((Object)parsedStatement.isQuery()).thenReturn((Object)true);
        Statement statement = Statement.of((String)"SELECT * FROM FOO");
        Mockito.when((Object)parsedStatement.getStatement()).thenReturn((Object)statement);
        ReadWriteTransaction transaction = this.createSubject();
        ResultSet rs = (ResultSet)SpannerApiFutures.get((ApiFuture)transaction.executeQueryAsync(UnitOfWork.CallType.SYNC, parsedStatement, AnalyzeMode.NONE, new Options.QueryOption[0]));
        MatcherAssert.assertThat((Object)rs, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)rs.getStats(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testPlanQuery() {
        AbstractStatementParser.ParsedStatement parsedStatement = (AbstractStatementParser.ParsedStatement)Mockito.mock(AbstractStatementParser.ParsedStatement.class);
        Mockito.when((Object)parsedStatement.getType()).thenReturn((Object)AbstractStatementParser.StatementType.QUERY);
        Mockito.when((Object)parsedStatement.isQuery()).thenReturn((Object)true);
        Statement statement = Statement.of((String)"SELECT * FROM FOO");
        Mockito.when((Object)parsedStatement.getStatement()).thenReturn((Object)statement);
        ReadWriteTransaction transaction = this.createSubject();
        ResultSet rs = (ResultSet)SpannerApiFutures.get((ApiFuture)transaction.executeQueryAsync(UnitOfWork.CallType.SYNC, parsedStatement, AnalyzeMode.PLAN, new Options.QueryOption[0]));
        MatcherAssert.assertThat((Object)rs, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        while (rs.next()) {
        }
        MatcherAssert.assertThat((Object)rs.getStats(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testProfileQuery() {
        AbstractStatementParser.ParsedStatement parsedStatement = (AbstractStatementParser.ParsedStatement)Mockito.mock(AbstractStatementParser.ParsedStatement.class);
        Mockito.when((Object)parsedStatement.getType()).thenReturn((Object)AbstractStatementParser.StatementType.QUERY);
        Mockito.when((Object)parsedStatement.isQuery()).thenReturn((Object)true);
        Statement statement = Statement.of((String)"SELECT * FROM FOO");
        Mockito.when((Object)parsedStatement.getStatement()).thenReturn((Object)statement);
        ReadWriteTransaction transaction = this.createSubject();
        ResultSet rs = (ResultSet)SpannerApiFutures.get((ApiFuture)transaction.executeQueryAsync(UnitOfWork.CallType.SYNC, parsedStatement, AnalyzeMode.PROFILE, new Options.QueryOption[0]));
        MatcherAssert.assertThat((Object)rs, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        while (rs.next()) {
        }
        MatcherAssert.assertThat((Object)rs.getStats(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testExecuteUpdate() {
        AbstractStatementParser.ParsedStatement parsedStatement = (AbstractStatementParser.ParsedStatement)Mockito.mock(AbstractStatementParser.ParsedStatement.class);
        Mockito.when((Object)parsedStatement.getType()).thenReturn((Object)AbstractStatementParser.StatementType.UPDATE);
        Mockito.when((Object)parsedStatement.isUpdate()).thenReturn((Object)true);
        Statement statement = Statement.of((String)"UPDATE FOO SET BAR=1 WHERE ID=2");
        Mockito.when((Object)parsedStatement.getStatement()).thenReturn((Object)statement);
        ReadWriteTransaction transaction = this.createSubject();
        MatcherAssert.assertThat((Object)((Long)SpannerApiFutures.get((ApiFuture)transaction.executeUpdateAsync(UnitOfWork.CallType.SYNC, parsedStatement, new Options.UpdateOption[0]))), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testGetCommitTimestampBeforeCommit() {
        AbstractStatementParser.ParsedStatement parsedStatement = (AbstractStatementParser.ParsedStatement)Mockito.mock(AbstractStatementParser.ParsedStatement.class);
        Mockito.when((Object)parsedStatement.getType()).thenReturn((Object)AbstractStatementParser.StatementType.UPDATE);
        Mockito.when((Object)parsedStatement.isUpdate()).thenReturn((Object)true);
        Statement statement = Statement.of((String)"UPDATE FOO SET BAR=1 WHERE ID=2");
        Mockito.when((Object)parsedStatement.getStatement()).thenReturn((Object)statement);
        ReadWriteTransaction transaction = this.createSubject();
        MatcherAssert.assertThat((Object)((Long)SpannerApiFutures.get((ApiFuture)transaction.executeUpdateAsync(UnitOfWork.CallType.SYNC, parsedStatement, new Options.UpdateOption[0]))), (Matcher)CoreMatchers.is((Object)1L));
        try {
            transaction.getCommitTimestamp();
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerException ex) {
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)ex.getErrorCode());
        }
    }

    @Test
    public void testGetCommitTimestampAfterCommit() {
        AbstractStatementParser.ParsedStatement parsedStatement = (AbstractStatementParser.ParsedStatement)Mockito.mock(AbstractStatementParser.ParsedStatement.class);
        Mockito.when((Object)parsedStatement.getType()).thenReturn((Object)AbstractStatementParser.StatementType.UPDATE);
        Mockito.when((Object)parsedStatement.isUpdate()).thenReturn((Object)true);
        Statement statement = Statement.of((String)"UPDATE FOO SET BAR=1 WHERE ID=2");
        Mockito.when((Object)parsedStatement.getStatement()).thenReturn((Object)statement);
        ReadWriteTransaction transaction = this.createSubject();
        MatcherAssert.assertThat((Object)((Long)SpannerApiFutures.get((ApiFuture)transaction.executeUpdateAsync(UnitOfWork.CallType.SYNC, parsedStatement, new Options.UpdateOption[0]))), (Matcher)CoreMatchers.is((Object)1L));
        SpannerApiFutures.get((ApiFuture)transaction.commitAsync(UnitOfWork.CallType.SYNC));
        MatcherAssert.assertThat((Object)transaction.getCommitTimestamp(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void testGetReadTimestamp() {
        AbstractStatementParser.ParsedStatement parsedStatement = (AbstractStatementParser.ParsedStatement)Mockito.mock(AbstractStatementParser.ParsedStatement.class);
        Mockito.when((Object)parsedStatement.getType()).thenReturn((Object)AbstractStatementParser.StatementType.QUERY);
        Mockito.when((Object)parsedStatement.isQuery()).thenReturn((Object)true);
        Statement statement = Statement.of((String)"SELECT * FROM FOO");
        Mockito.when((Object)parsedStatement.getStatement()).thenReturn((Object)statement);
        ReadWriteTransaction transaction = this.createSubject();
        MatcherAssert.assertThat((Object)((ResultSet)SpannerApiFutures.get((ApiFuture)transaction.executeQueryAsync(UnitOfWork.CallType.SYNC, parsedStatement, AnalyzeMode.NONE, new Options.QueryOption[0]))), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        try {
            transaction.getReadTimestamp();
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerException ex) {
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)ex.getErrorCode());
        }
    }

    @Test
    public void testState() {
        AbstractStatementParser.ParsedStatement parsedStatement = (AbstractStatementParser.ParsedStatement)Mockito.mock(AbstractStatementParser.ParsedStatement.class);
        Mockito.when((Object)parsedStatement.getType()).thenReturn((Object)AbstractStatementParser.StatementType.QUERY);
        Mockito.when((Object)parsedStatement.isQuery()).thenReturn((Object)true);
        Statement statement = Statement.of((String)"SELECT * FROM FOO");
        Mockito.when((Object)parsedStatement.getStatement()).thenReturn((Object)statement);
        ReadWriteTransaction transaction = this.createSubject();
        MatcherAssert.assertThat((Object)transaction.getState(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)UnitOfWork.UnitOfWorkState.STARTED)));
        MatcherAssert.assertThat((Object)transaction.isActive(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((ResultSet)SpannerApiFutures.get((ApiFuture)transaction.executeQueryAsync(UnitOfWork.CallType.SYNC, parsedStatement, AnalyzeMode.NONE, new Options.QueryOption[0]))), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)transaction.getState(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)UnitOfWork.UnitOfWorkState.STARTED)));
        MatcherAssert.assertThat((Object)transaction.isActive(), (Matcher)CoreMatchers.is((Object)true));
        SpannerApiFutures.get((ApiFuture)transaction.commitAsync(UnitOfWork.CallType.SYNC));
        MatcherAssert.assertThat((Object)transaction.getState(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)UnitOfWork.UnitOfWorkState.COMMITTED)));
        MatcherAssert.assertThat((Object)transaction.isActive(), (Matcher)CoreMatchers.is((Object)false));
        transaction = this.createSubject();
        MatcherAssert.assertThat((Object)transaction.getState(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)UnitOfWork.UnitOfWorkState.STARTED)));
        MatcherAssert.assertThat((Object)transaction.isActive(), (Matcher)CoreMatchers.is((Object)true));
        SpannerApiFutures.get((ApiFuture)transaction.rollbackAsync(UnitOfWork.CallType.SYNC));
        MatcherAssert.assertThat((Object)transaction.getState(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)UnitOfWork.UnitOfWorkState.ROLLED_BACK)));
        MatcherAssert.assertThat((Object)transaction.isActive(), (Matcher)CoreMatchers.is((Object)false));
        transaction = this.createSubject(CommitBehavior.FAIL);
        MatcherAssert.assertThat((Object)transaction.getState(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)UnitOfWork.UnitOfWorkState.STARTED)));
        MatcherAssert.assertThat((Object)transaction.isActive(), (Matcher)CoreMatchers.is((Object)true));
        try {
            SpannerApiFutures.get((ApiFuture)transaction.commitAsync(UnitOfWork.CallType.SYNC));
        }
        catch (SpannerException spannerException) {
            // empty catch block
        }
        MatcherAssert.assertThat((Object)transaction.getState(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)UnitOfWork.UnitOfWorkState.COMMIT_FAILED)));
        MatcherAssert.assertThat((Object)transaction.isActive(), (Matcher)CoreMatchers.is((Object)false));
        transaction = this.createSubject(CommitBehavior.ABORT);
        MatcherAssert.assertThat((Object)transaction.getState(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)UnitOfWork.UnitOfWorkState.STARTED)));
        MatcherAssert.assertThat((Object)transaction.isActive(), (Matcher)CoreMatchers.is((Object)true));
        try {
            SpannerApiFutures.get((ApiFuture)transaction.commitAsync(UnitOfWork.CallType.SYNC));
        }
        catch (AbortedException abortedException) {
            // empty catch block
        }
        MatcherAssert.assertThat((Object)transaction.getState(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)UnitOfWork.UnitOfWorkState.COMMIT_FAILED)));
        MatcherAssert.assertThat((Object)transaction.isActive(), (Matcher)CoreMatchers.is((Object)false));
        transaction = this.createSubject(CommitBehavior.ABORT, true);
        MatcherAssert.assertThat((Object)transaction.getState(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)UnitOfWork.UnitOfWorkState.STARTED)));
        MatcherAssert.assertThat((Object)transaction.isActive(), (Matcher)CoreMatchers.is((Object)true));
        SpannerApiFutures.get((ApiFuture)transaction.commitAsync(UnitOfWork.CallType.SYNC));
        MatcherAssert.assertThat((Object)transaction.getState(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)UnitOfWork.UnitOfWorkState.COMMITTED)));
        MatcherAssert.assertThat((Object)transaction.isActive(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testIsReadOnly() {
        MatcherAssert.assertThat((Object)this.createSubject().isReadOnly(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testRetry() {
        for (RetryResults results : RetryResults.values()) {
            String sql1 = "UPDATE FOO SET BAR=1 WHERE BAZ>=100 AND BAZ<200";
            String sql2 = "UPDATE FOO SET BAR=2 WHERE BAZ>=200 AND BAZ<300";
            DatabaseClient client = (DatabaseClient)Mockito.mock(DatabaseClient.class);
            AbstractStatementParser.ParsedStatement update1 = (AbstractStatementParser.ParsedStatement)Mockito.mock(AbstractStatementParser.ParsedStatement.class);
            Mockito.when((Object)update1.getType()).thenReturn((Object)AbstractStatementParser.StatementType.UPDATE);
            Mockito.when((Object)update1.isUpdate()).thenReturn((Object)true);
            Mockito.when((Object)update1.getStatement()).thenReturn((Object)Statement.of((String)sql1));
            AbstractStatementParser.ParsedStatement update2 = (AbstractStatementParser.ParsedStatement)Mockito.mock(AbstractStatementParser.ParsedStatement.class);
            Mockito.when((Object)update2.getType()).thenReturn((Object)AbstractStatementParser.StatementType.UPDATE);
            Mockito.when((Object)update2.isUpdate()).thenReturn((Object)true);
            Mockito.when((Object)update2.getStatement()).thenReturn((Object)Statement.of((String)sql2));
            TransactionManager txManager = (TransactionManager)Mockito.mock(TransactionManager.class);
            TransactionContext txContext1 = (TransactionContext)Mockito.mock(TransactionContext.class);
            Mockito.when((Object)txManager.begin()).thenReturn((Object)txContext1);
            Mockito.when((Object)txManager.getState()).thenReturn(null, (Object[])new TransactionManager.TransactionState[]{TransactionManager.TransactionState.STARTED});
            Mockito.when((Object)client.transactionManager(new Options.TransactionOption[0])).thenReturn((Object)txManager);
            Mockito.when((Object)txContext1.executeUpdate(Statement.of((String)sql1), new Options.UpdateOption[0])).thenReturn((Object)90L);
            Mockito.when((Object)txContext1.executeUpdate(Statement.of((String)sql2), new Options.UpdateOption[0])).thenReturn((Object)80L);
            TransactionContext txContext2 = (TransactionContext)Mockito.mock(TransactionContext.class);
            Mockito.when((Object)txManager.resetForRetry()).thenReturn((Object)txContext2);
            Mockito.when((Object)client.transactionManager(new Options.TransactionOption[0])).thenReturn((Object)txManager);
            if (results == RetryResults.SAME) {
                Mockito.when((Object)txContext2.executeUpdate(Statement.of((String)sql1), new Options.UpdateOption[0])).thenReturn((Object)90L);
                Mockito.when((Object)txContext2.executeUpdate(Statement.of((String)sql2), new Options.UpdateOption[0])).thenReturn((Object)80L);
            } else if (results == RetryResults.DIFFERENT) {
                Mockito.when((Object)txContext2.executeUpdate(Statement.of((String)sql1), new Options.UpdateOption[0])).thenReturn((Object)90L);
                Mockito.when((Object)txContext2.executeUpdate(Statement.of((String)sql2), new Options.UpdateOption[0])).thenReturn((Object)90L);
            }
            ((TransactionManager)Mockito.doThrow((Throwable[])new Throwable[]{SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.ABORTED, (String)"commit aborted", (Throwable)ReadWriteTransactionTest.createAbortedExceptionWithMinimalRetry())}).doNothing().when((Object)txManager)).commit();
            ReadWriteTransaction subject = ((ReadWriteTransaction.Builder)((ReadWriteTransaction.Builder)ReadWriteTransaction.newBuilder().setRetryAbortsInternally(true).setSavepointSupport(SavepointSupport.FAIL_AFTER_ROLLBACK).setTransactionRetryListeners(Collections.emptyList()).setDatabaseClient(client).withStatementExecutor(new StatementExecutor())).setSpan(Span.getInvalid())).build();
            subject.executeUpdateAsync(UnitOfWork.CallType.SYNC, update1, new Options.UpdateOption[0]);
            subject.executeUpdateAsync(UnitOfWork.CallType.SYNC, update2, new Options.UpdateOption[0]);
            boolean expectedException = false;
            try {
                SpannerApiFutures.get((ApiFuture)subject.commitAsync(UnitOfWork.CallType.SYNC));
            }
            catch (SpannerException e) {
                if (results == RetryResults.DIFFERENT && e.getErrorCode() == ErrorCode.ABORTED) {
                    expectedException = true;
                }
                throw e;
            }
            MatcherAssert.assertThat((Object)expectedException, (Matcher)CoreMatchers.is((Object)(results == RetryResults.DIFFERENT ? 1 : 0)));
        }
    }

    @Test
    public void testChecksumResultSet() {
        DatabaseClient client = (DatabaseClient)Mockito.mock(DatabaseClient.class);
        ReadWriteTransaction transaction = ((ReadWriteTransaction.Builder)((ReadWriteTransaction.Builder)ReadWriteTransaction.newBuilder().setRetryAbortsInternally(true).setSavepointSupport(SavepointSupport.FAIL_AFTER_ROLLBACK).setTransactionRetryListeners(Collections.emptyList()).setDatabaseClient(client).withStatementExecutor(new StatementExecutor())).setSpan(Span.getInvalid())).build();
        AbstractStatementParser.ParsedStatement parsedStatement = (AbstractStatementParser.ParsedStatement)Mockito.mock(AbstractStatementParser.ParsedStatement.class);
        Statement statement = Statement.of((String)"SELECT * FROM FOO");
        Mockito.when((Object)parsedStatement.getStatement()).thenReturn((Object)statement);
        String arrayJson = "[{\"color\":\"red\",\"value\":\"#f00\"},{\"color\":\"green\",\"value\":\"#0f0\"},{\"color\":\"blue\",\"value\":\"#00f\"},{\"color\":\"cyan\",\"value\":\"#0ff\"},{\"color\":\"magenta\",\"value\":\"#f0f\"},{\"color\":\"yellow\",\"value\":\"#ff0\"},{\"color\":\"black\",\"value\":\"#000\"}]";
        String emptyArrayJson = "[]";
        String simpleJson = "{\"color\":\"red\",\"value\":\"#f00\"}";
        SingerProto.SingerInfo protoMessageVal = SingerProto.SingerInfo.newBuilder().setSingerId(111L).setNationality("COUNTRY1").setGenre(SingerProto.Genre.FOLK).build();
        SingerProto.Genre protoEnumVal = SingerProto.Genre.ROCK;
        ProtobufResultSet delegate1 = (ProtobufResultSet)ResultSets.forRows((Type)Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"ID", (Type)Type.int64()), Type.StructField.of((String)"NAME", (Type)Type.string()), Type.StructField.of((String)"AMOUNT", (Type)Type.numeric()), Type.StructField.of((String)"JSON", (Type)Type.json()), Type.StructField.of((String)"PROTO", (Type)Type.proto((String)protoMessageVal.getDescriptorForType().getFullName())), Type.StructField.of((String)"PROTOENUM", (Type)Type.protoEnum((String)protoEnumVal.getDescriptorForType().getFullName()))}), Arrays.asList(((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("ID").to(1L)).set("NAME").to("TEST 1")).set("AMOUNT").to(BigDecimal.valueOf(550L, 2))).set("JSON").to(Value.json((String)simpleJson))).set("PROTO").to((AbstractMessage)protoMessageVal)).set("PROTOENUM").to((ProtocolMessageEnum)protoEnumVal)).build(), ((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("ID").to(2L)).set("NAME").to("TEST 2")).set("AMOUNT").to(BigDecimal.valueOf(750L, 2))).set("JSON").to(Value.json((String)arrayJson))).set("PROTO").to((AbstractMessage)protoMessageVal)).set("PROTOENUM").to((ProtocolMessageEnum)SingerProto.Genre.JAZZ)).build()));
        ChecksumResultSet rs1 = transaction.createChecksumResultSet(delegate1, parsedStatement, AnalyzeMode.NONE, new Options.QueryOption[0]);
        ProtobufResultSet delegate2 = (ProtobufResultSet)ResultSets.forRows((Type)Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"ID", (Type)Type.int64()), Type.StructField.of((String)"NAME", (Type)Type.string()), Type.StructField.of((String)"AMOUNT", (Type)Type.numeric()), Type.StructField.of((String)"JSON", (Type)Type.json()), Type.StructField.of((String)"PROTO", (Type)Type.proto((String)protoMessageVal.getDescriptorForType().getFullName())), Type.StructField.of((String)"PROTOENUM", (Type)Type.protoEnum((String)protoEnumVal.getDescriptorForType().getFullName()))}), Arrays.asList(((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("ID").to(1L)).set("NAME").to("TEST 1")).set("AMOUNT").to(new BigDecimal("5.50"))).set("JSON").to(Value.json((String)simpleJson))).set("PROTO").to((AbstractMessage)protoMessageVal)).set("PROTOENUM").to((ProtocolMessageEnum)protoEnumVal)).build(), ((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("ID").to(2L)).set("NAME").to("TEST 2")).set("AMOUNT").to(new BigDecimal("7.50"))).set("JSON").to(Value.json((String)arrayJson))).set("PROTO").to((AbstractMessage)protoMessageVal)).set("PROTOENUM").to((ProtocolMessageEnum)SingerProto.Genre.JAZZ)).build()));
        ChecksumResultSet rs2 = transaction.createChecksumResultSet(delegate2, parsedStatement, AnalyzeMode.NONE, new Options.QueryOption[0]);
        ProtobufResultSet delegate3 = (ProtobufResultSet)ResultSets.forRows((Type)Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"ID", (Type)Type.int64()), Type.StructField.of((String)"NAME", (Type)Type.string()), Type.StructField.of((String)"AMOUNT", (Type)Type.numeric()), Type.StructField.of((String)"JSON", (Type)Type.json()), Type.StructField.of((String)"PROTO", (Type)Type.proto((String)protoMessageVal.getDescriptorForType().getFullName())), Type.StructField.of((String)"PROTOENUM", (Type)Type.protoEnum((String)protoEnumVal.getDescriptorForType().getFullName()))}), Arrays.asList(((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("ID").to(2L)).set("NAME").to("TEST 2")).set("AMOUNT").to(new BigDecimal("7.50"))).set("JSON").to(Value.json((String)arrayJson))).set("PROTO").to((AbstractMessage)protoMessageVal)).set("PROTOENUM").to((ProtocolMessageEnum)SingerProto.Genre.JAZZ)).build(), ((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("ID").to(1L)).set("NAME").to("TEST 1")).set("AMOUNT").to(new BigDecimal("5.50"))).set("JSON").to(Value.json((String)simpleJson))).set("PROTO").to((AbstractMessage)protoMessageVal)).set("PROTOENUM").to((ProtocolMessageEnum)protoEnumVal)).build()));
        ChecksumResultSet rs3 = transaction.createChecksumResultSet(delegate3, parsedStatement, AnalyzeMode.NONE, new Options.QueryOption[0]);
        ProtobufResultSet delegate4 = (ProtobufResultSet)ResultSets.forRows((Type)Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"ID", (Type)Type.int64()), Type.StructField.of((String)"NAME", (Type)Type.string()), Type.StructField.of((String)"AMOUNT", (Type)Type.numeric()), Type.StructField.of((String)"JSON", (Type)Type.json()), Type.StructField.of((String)"PROTO", (Type)Type.proto((String)protoMessageVal.getDescriptorForType().getFullName())), Type.StructField.of((String)"PROTOENUM", (Type)Type.protoEnum((String)protoEnumVal.getDescriptorForType().getFullName()))}), Arrays.asList(((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("ID").to(1L)).set("NAME").to("TEST 1")).set("AMOUNT").to(new BigDecimal("5.50"))).set("JSON").to(Value.json((String)simpleJson))).set("PROTO").to((AbstractMessage)protoMessageVal)).set("PROTOENUM").to((ProtocolMessageEnum)protoEnumVal)).build(), ((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("ID").to(2L)).set("NAME").to("TEST 2")).set("AMOUNT").to(new BigDecimal("7.50"))).set("JSON").to(Value.json((String)arrayJson))).set("PROTO").to((AbstractMessage)protoMessageVal)).set("PROTOENUM").to((ProtocolMessageEnum)SingerProto.Genre.JAZZ)).build(), ((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("ID").to(3L)).set("NAME").to("TEST 3")).set("AMOUNT").to(new BigDecimal("9.99"))).set("JSON").to(Value.json((String)emptyArrayJson))).set("PROTO").to(null, SingerProto.SingerInfo.getDescriptor())).set("PROTOENUM").to((ProtocolMessageEnum)SingerProto.Genre.POP)).build()));
        ChecksumResultSet rs4 = transaction.createChecksumResultSet(delegate4, parsedStatement, AnalyzeMode.NONE, new Options.QueryOption[0]);
        MatcherAssert.assertThat((Object)rs1.getChecksum(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)rs2.getChecksum())));
        while (rs1.next() && rs2.next() && rs3.next() && rs4.next()) {
            MatcherAssert.assertThat((Object)rs1.getChecksum(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)rs2.getChecksum())));
            MatcherAssert.assertThat((Object)rs1.getChecksum(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)rs3.getChecksum()))));
            MatcherAssert.assertThat((Object)rs1.getChecksum(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)rs4.getChecksum())));
        }
        MatcherAssert.assertThat((Object)rs1.getChecksum(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)rs2.getChecksum())));
        MatcherAssert.assertThat((Object)rs1.getChecksum(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)rs3.getChecksum()))));
        MatcherAssert.assertThat((Object)rs1.getChecksum(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)rs4.getChecksum())));
        MatcherAssert.assertThat((Object)rs4.next(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)rs1.getChecksum(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)rs4.getChecksum()))));
    }

    @Test
    public void testChecksumResultSetWithArray() {
        DatabaseClient client = (DatabaseClient)Mockito.mock(DatabaseClient.class);
        ReadWriteTransaction transaction = ((ReadWriteTransaction.Builder)((ReadWriteTransaction.Builder)ReadWriteTransaction.newBuilder().setRetryAbortsInternally(true).setSavepointSupport(SavepointSupport.FAIL_AFTER_ROLLBACK).setTransactionRetryListeners(Collections.emptyList()).setDatabaseClient(client).withStatementExecutor(new StatementExecutor())).setSpan(Span.getInvalid())).build();
        AbstractStatementParser.ParsedStatement parsedStatement = (AbstractStatementParser.ParsedStatement)Mockito.mock(AbstractStatementParser.ParsedStatement.class);
        Statement statement = Statement.of((String)"SELECT * FROM FOO");
        Mockito.when((Object)parsedStatement.getStatement()).thenReturn((Object)statement);
        ProtobufResultSet delegate1 = (ProtobufResultSet)ResultSets.forRows((Type)Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"ID", (Type)Type.int64()), Type.StructField.of((String)"PRICES", (Type)Type.array((Type)Type.int64()))}), Arrays.asList(((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("ID").to(1L)).set("PRICES").toInt64Array(new long[]{1L, 2L})).build(), ((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("ID").to(2L)).set("PRICES").toInt64Array(new long[]{3L, 4L})).build()));
        ChecksumResultSet rs1 = transaction.createChecksumResultSet(delegate1, parsedStatement, AnalyzeMode.NONE, new Options.QueryOption[0]);
        ProtobufResultSet delegate2 = (ProtobufResultSet)ResultSets.forRows((Type)Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"ID", (Type)Type.int64()), Type.StructField.of((String)"PRICES", (Type)Type.array((Type)Type.int64()))}), Arrays.asList(((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("ID").to(1L)).set("PRICES").toInt64Array(new long[]{1L, 2L})).build(), ((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("ID").to(2L)).set("PRICES").toInt64Array(new long[]{3L, 5L})).build()));
        ChecksumResultSet rs2 = transaction.createChecksumResultSet(delegate2, parsedStatement, AnalyzeMode.NONE, new Options.QueryOption[0]);
        rs1.next();
        rs2.next();
        MatcherAssert.assertThat((Object)rs1.getChecksum(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)rs2.getChecksum())));
        rs1.next();
        rs2.next();
        MatcherAssert.assertThat((Object)rs1.getChecksum(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo((Object)rs2.getChecksum()))));
    }

    @Test
    public void testGetCommitResponseBeforeCommit() {
        AbstractStatementParser.ParsedStatement parsedStatement = (AbstractStatementParser.ParsedStatement)Mockito.mock(AbstractStatementParser.ParsedStatement.class);
        Mockito.when((Object)parsedStatement.getType()).thenReturn((Object)AbstractStatementParser.StatementType.UPDATE);
        Mockito.when((Object)parsedStatement.isUpdate()).thenReturn((Object)true);
        Statement statement = Statement.of((String)"UPDATE FOO SET BAR=1 WHERE ID=2");
        Mockito.when((Object)parsedStatement.getStatement()).thenReturn((Object)statement);
        ReadWriteTransaction transaction = this.createSubject();
        SpannerApiFutures.get((ApiFuture)transaction.executeUpdateAsync(UnitOfWork.CallType.SYNC, parsedStatement, new Options.UpdateOption[0]));
        try {
            transaction.getCommitResponse();
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerException ex) {
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)ex.getErrorCode());
        }
        Assert.assertNull((Object)transaction.getCommitResponseOrNull());
    }

    @Test
    public void testGetCommitResponseAfterCommit() {
        AbstractStatementParser.ParsedStatement parsedStatement = (AbstractStatementParser.ParsedStatement)Mockito.mock(AbstractStatementParser.ParsedStatement.class);
        Mockito.when((Object)parsedStatement.getType()).thenReturn((Object)AbstractStatementParser.StatementType.UPDATE);
        Mockito.when((Object)parsedStatement.isUpdate()).thenReturn((Object)true);
        Statement statement = Statement.of((String)"UPDATE FOO SET BAR=1 WHERE ID=2");
        Mockito.when((Object)parsedStatement.getStatement()).thenReturn((Object)statement);
        ReadWriteTransaction transaction = this.createSubject();
        SpannerApiFutures.get((ApiFuture)transaction.executeUpdateAsync(UnitOfWork.CallType.SYNC, parsedStatement, new Options.UpdateOption[0]));
        SpannerApiFutures.get((ApiFuture)transaction.commitAsync(UnitOfWork.CallType.SYNC));
        Assert.assertNotNull((Object)transaction.getCommitResponse());
        Assert.assertNotNull((Object)transaction.getCommitResponseOrNull());
    }

    private static StatusRuntimeException createAbortedExceptionWithMinimalRetry() {
        Metadata.Key key = ProtoUtils.keyForProto((Message)RetryInfo.getDefaultInstance());
        Metadata trailers = new Metadata();
        RetryInfo retryInfo = RetryInfo.newBuilder().setRetryDelay(Duration.newBuilder().setNanos(1).setSeconds(0L)).build();
        trailers.put(key, (Object)retryInfo);
        return Status.ABORTED.asRuntimeException(trailers);
    }

    private static enum CommitBehavior {
        SUCCEED,
        FAIL,
        ABORT;

    }

    private static enum RetryResults {
        SAME,
        DIFFERENT;

    }

    private static class SimpleTransactionManager
    implements TransactionManager {
        private TransactionManager.TransactionState state;
        private CommitResponse commitResponse;
        private TransactionContext txContext;
        private CommitBehavior commitBehavior;

        private SimpleTransactionManager(TransactionContext txContext, CommitBehavior commitBehavior) {
            this.txContext = txContext;
            this.commitBehavior = commitBehavior;
        }

        public TransactionContext begin() {
            this.state = TransactionManager.TransactionState.STARTED;
            return this.txContext;
        }

        public void commit() {
            switch (this.commitBehavior) {
                case SUCCEED: {
                    this.commitResponse = new CommitResponse(Timestamp.ofTimeSecondsAndNanos((long)1L, (int)1));
                    this.state = TransactionManager.TransactionState.COMMITTED;
                    break;
                }
                case FAIL: {
                    this.state = TransactionManager.TransactionState.COMMIT_FAILED;
                    throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.UNKNOWN, (String)"commit failed");
                }
                case ABORT: {
                    this.state = TransactionManager.TransactionState.COMMIT_FAILED;
                    this.commitBehavior = CommitBehavior.SUCCEED;
                    throw SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.ABORTED, (String)"commit aborted", (Throwable)ReadWriteTransactionTest.createAbortedExceptionWithMinimalRetry());
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }

        public void rollback() {
            this.state = TransactionManager.TransactionState.ROLLED_BACK;
        }

        public TransactionContext resetForRetry() {
            return this.txContext;
        }

        public Timestamp getCommitTimestamp() {
            return this.commitResponse == null ? null : this.commitResponse.getCommitTimestamp();
        }

        public CommitResponse getCommitResponse() {
            return this.commitResponse;
        }

        public TransactionManager.TransactionState getState() {
            return this.state;
        }

        public void close() {
            if (this.state != TransactionManager.TransactionState.COMMITTED) {
                this.state = TransactionManager.TransactionState.ROLLED_BACK;
            }
        }
    }
}

