/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.connection.AbstractMockServerTest;
import com.google.cloud.spanner.connection.AutocommitDmlMode;
import com.google.cloud.spanner.connection.Connection;
import com.google.cloud.spanner.connection.ITAbstractSpannerTest;
import com.google.cloud.spanner.connection.SpannerPool;
import com.google.spanner.v1.CommitRequest;
import com.google.spanner.v1.ExecuteBatchDmlRequest;
import com.google.spanner.v1.ExecuteSqlRequest;
import java.util.Collections;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TaggingTest
extends AbstractMockServerTest {
    @Parameterized.Parameter
    public Dialect dialect;
    private Dialect currentDialect;

    @Parameterized.Parameters(name="dialect = {0}")
    public static Object[] data() {
        return Dialect.values();
    }

    @Before
    public void setupDialect() {
        if (this.currentDialect != this.dialect) {
            mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.detectDialectResult(this.dialect));
            SpannerPool.closeSpannerPool();
            this.currentDialect = this.dialect;
        }
    }

    @After
    public void clearRequests() {
        mockSpanner.clearRequests();
    }

    @Test
    public void testStatementTagNotAllowedForCommit() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setStatementTag("tag-1");
            SpannerException exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> ((Connection)connection).commit());
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)exception.getErrorCode());
        }
    }

    @Test
    public void testStatementTagNotAllowedForRollback() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setStatementTag("tag-1");
            SpannerException exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> ((Connection)connection).rollback());
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)exception.getErrorCode());
        }
    }

    @Test
    public void testStatementTagNotAllowedInsideBatch() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            for (boolean autocommit : new boolean[]{true, false}) {
                connection.setAutocommit(autocommit);
                connection.startBatchDml();
                SpannerException exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.setStatementTag("tag-1"));
                Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)exception.getErrorCode());
                connection.abortBatch();
            }
        }
    }

    @Test
    public void testQuery_NoTags() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            for (boolean autocommit : new boolean[]{true, false}) {
                connection.setAutocommit(autocommit);
                ResultSet ignore = connection.executeQuery(SELECT_COUNT_STATEMENT, new Options.QueryOption[0]);
                if (ignore != null) {
                    ignore.close();
                }
                Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
                Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0).getRequestOptions().getRequestTag());
                Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0).getRequestOptions().getTransactionTag());
                mockSpanner.clearRequests();
            }
        }
    }

    @Test
    public void testUpdate_NoTags() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            for (boolean autocommit : new boolean[]{true, false}) {
                connection.setAutocommit(autocommit);
                connection.executeUpdate(INSERT_STATEMENT);
                Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
                Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0).getRequestOptions().getRequestTag());
                Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0).getRequestOptions().getTransactionTag());
                mockSpanner.clearRequests();
            }
        }
    }

    @Test
    public void testPartitionedUpdate_NoTags() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            connection.setAutocommitDmlMode(AutocommitDmlMode.PARTITIONED_NON_ATOMIC);
            connection.executeUpdate(INSERT_STATEMENT);
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
            Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0).getRequestOptions().getRequestTag());
            Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0).getRequestOptions().getTransactionTag());
            mockSpanner.clearRequests();
        }
    }

    @Test
    public void testBatchUpdate_NoTags() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            for (boolean autocommit : new boolean[]{true, false}) {
                connection.setAutocommit(autocommit);
                connection.executeBatchUpdate(Collections.singletonList(INSERT_STATEMENT));
                Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteBatchDmlRequest.class));
                Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).get(0).getRequestOptions().getRequestTag());
                Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).get(0).getRequestOptions().getTransactionTag());
                mockSpanner.clearRequests();
            }
        }
    }

    @Test
    public void testQuery_StatementTag() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            for (boolean autocommit : new boolean[]{true, false}) {
                connection.setAutocommit(autocommit);
                connection.setStatementTag("tag-1");
                ResultSet ignore = connection.executeQuery(SELECT_COUNT_STATEMENT, new Options.QueryOption[0]);
                if (ignore != null) {
                    ignore.close();
                }
                Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
                Assert.assertEquals((Object)"tag-1", (Object)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0).getRequestOptions().getRequestTag());
                Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0).getRequestOptions().getTransactionTag());
                mockSpanner.clearRequests();
                ignore = connection.executeQuery(SELECT_COUNT_STATEMENT, new Options.QueryOption[0]);
                if (ignore != null) {
                    ignore.close();
                }
                Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
                Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0).getRequestOptions().getRequestTag());
                Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0).getRequestOptions().getTransactionTag());
                mockSpanner.clearRequests();
            }
        }
    }

    @Test
    public void testUpdate_StatementTag() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            for (boolean autocommit : new boolean[]{true, false}) {
                connection.setAutocommit(autocommit);
                connection.setStatementTag("tag-2");
                connection.executeUpdate(INSERT_STATEMENT);
                Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
                Assert.assertEquals((Object)"tag-2", (Object)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0).getRequestOptions().getRequestTag());
                Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0).getRequestOptions().getTransactionTag());
                mockSpanner.clearRequests();
                connection.executeUpdate(INSERT_STATEMENT);
                Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
                Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0).getRequestOptions().getRequestTag());
                Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0).getRequestOptions().getTransactionTag());
                mockSpanner.clearRequests();
            }
        }
    }

    @Test
    public void testPartitionedUpdate_StatementTag() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            connection.setAutocommitDmlMode(AutocommitDmlMode.PARTITIONED_NON_ATOMIC);
            connection.setStatementTag("tag-4");
            connection.executeUpdate(INSERT_STATEMENT);
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
            Assert.assertEquals((Object)"tag-4", (Object)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0).getRequestOptions().getRequestTag());
            Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0).getRequestOptions().getTransactionTag());
            mockSpanner.clearRequests();
            connection.executeUpdate(INSERT_STATEMENT);
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
            Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0).getRequestOptions().getRequestTag());
            Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0).getRequestOptions().getTransactionTag());
            mockSpanner.clearRequests();
        }
    }

    @Test
    public void testBatchUpdate_StatementTag() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            for (boolean autocommit : new boolean[]{true, false}) {
                connection.setAutocommit(autocommit);
                connection.setStatementTag("tag-3");
                connection.executeBatchUpdate(Collections.singletonList(INSERT_STATEMENT));
                Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteBatchDmlRequest.class));
                Assert.assertEquals((Object)"tag-3", (Object)mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).get(0).getRequestOptions().getRequestTag());
                Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).get(0).getRequestOptions().getTransactionTag());
                mockSpanner.clearRequests();
                connection.executeBatchUpdate(Collections.singletonList(INSERT_STATEMENT));
                Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteBatchDmlRequest.class));
                Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).get(0).getRequestOptions().getRequestTag());
                Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).get(0).getRequestOptions().getTransactionTag());
                mockSpanner.clearRequests();
            }
        }
    }

    @Test
    public void testQuery_TransactionTag() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setTransactionTag("tag-1");
            ResultSet ignore = connection.executeQuery(SELECT_COUNT_STATEMENT, new Options.QueryOption[0]);
            if (ignore != null) {
                ignore.close();
            }
            connection.commit();
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
            Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0).getRequestOptions().getRequestTag());
            Assert.assertEquals((Object)"tag-1", (Object)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0).getRequestOptions().getTransactionTag());
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
            Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(CommitRequest.class).get(0).getRequestOptions().getRequestTag());
            Assert.assertEquals((Object)"tag-1", (Object)mockSpanner.getRequestsOfType(CommitRequest.class).get(0).getRequestOptions().getTransactionTag());
            mockSpanner.clearRequests();
            ignore = connection.executeQuery(SELECT_COUNT_STATEMENT, new Options.QueryOption[0]);
            if (ignore != null) {
                ignore.close();
            }
            connection.commit();
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
            Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0).getRequestOptions().getRequestTag());
            Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0).getRequestOptions().getTransactionTag());
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
            Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(CommitRequest.class).get(0).getRequestOptions().getRequestTag());
            Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(CommitRequest.class).get(0).getRequestOptions().getTransactionTag());
            mockSpanner.clearRequests();
        }
    }

    @Test
    public void testUpdate_TransactionTag() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setTransactionTag("tag-2");
            connection.executeUpdate(INSERT_STATEMENT);
            connection.commit();
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
            Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0).getRequestOptions().getRequestTag());
            Assert.assertEquals((Object)"tag-2", (Object)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0).getRequestOptions().getTransactionTag());
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
            Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(CommitRequest.class).get(0).getRequestOptions().getRequestTag());
            Assert.assertEquals((Object)"tag-2", (Object)mockSpanner.getRequestsOfType(CommitRequest.class).get(0).getRequestOptions().getTransactionTag());
            mockSpanner.clearRequests();
            connection.executeUpdate(INSERT_STATEMENT);
            connection.commit();
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
            Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0).getRequestOptions().getRequestTag());
            Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0).getRequestOptions().getTransactionTag());
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
            Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(CommitRequest.class).get(0).getRequestOptions().getRequestTag());
            Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(CommitRequest.class).get(0).getRequestOptions().getTransactionTag());
            mockSpanner.clearRequests();
        }
    }

    @Test
    public void testBatchUpdate_TransactionTag() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setTransactionTag("tag-3");
            connection.executeBatchUpdate(Collections.singletonList(INSERT_STATEMENT));
            connection.commit();
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteBatchDmlRequest.class));
            Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).get(0).getRequestOptions().getRequestTag());
            Assert.assertEquals((Object)"tag-3", (Object)mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).get(0).getRequestOptions().getTransactionTag());
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
            Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(CommitRequest.class).get(0).getRequestOptions().getRequestTag());
            Assert.assertEquals((Object)"tag-3", (Object)mockSpanner.getRequestsOfType(CommitRequest.class).get(0).getRequestOptions().getTransactionTag());
            mockSpanner.clearRequests();
            connection.executeBatchUpdate(Collections.singletonList(INSERT_STATEMENT));
            connection.commit();
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteBatchDmlRequest.class));
            Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).get(0).getRequestOptions().getRequestTag());
            Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).get(0).getRequestOptions().getTransactionTag());
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
            Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(CommitRequest.class).get(0).getRequestOptions().getRequestTag());
            Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(CommitRequest.class).get(0).getRequestOptions().getTransactionTag());
            mockSpanner.clearRequests();
        }
    }

    @Test
    public void testDmlBatch_StatementTag() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            for (boolean autocommit : new boolean[]{true, false}) {
                connection.setAutocommit(autocommit);
                connection.setStatementTag("batch-tag");
                connection.startBatchDml();
                connection.execute(INSERT_STATEMENT);
                connection.execute(INSERT_STATEMENT);
                connection.runBatch();
                Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteBatchDmlRequest.class));
                Assert.assertEquals((Object)"batch-tag", (Object)mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).get(0).getRequestOptions().getRequestTag());
                Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).get(0).getRequestOptions().getTransactionTag());
                mockSpanner.clearRequests();
            }
        }
    }

    @Test
    public void testRunBatch_TransactionTag() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setTransactionTag("batch-tag");
            connection.startBatchDml();
            connection.execute(INSERT_STATEMENT);
            connection.execute(INSERT_STATEMENT);
            connection.runBatch();
            connection.commit();
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteBatchDmlRequest.class));
            Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).get(0).getRequestOptions().getRequestTag());
            Assert.assertEquals((Object)"batch-tag", (Object)mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).get(0).getRequestOptions().getTransactionTag());
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
            Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(CommitRequest.class).get(0).getRequestOptions().getRequestTag());
            Assert.assertEquals((Object)"batch-tag", (Object)mockSpanner.getRequestsOfType(CommitRequest.class).get(0).getRequestOptions().getTransactionTag());
            mockSpanner.clearRequests();
        }
    }

    @Test
    public void testShowSetTags() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.execute(Statement.of((String)String.format("SET %sSTATEMENT_TAG='tag1'", this.prefix())));
            try (ResultSet rs = connection.execute(Statement.of((String)String.format("SHOW VARIABLE %sSTATEMENT_TAG", this.prefix()))).getResultSet();){
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"tag1", (Object)rs.getString(String.format("%sSTATEMENT_TAG", this.prefix())));
                Assert.assertFalse((boolean)rs.next());
            }
            connection.execute(Statement.of((String)String.format("SET %sSTATEMENT_TAG=''", this.prefix())));
            rs = connection.execute(Statement.of((String)String.format("SHOW VARIABLE %sSTATEMENT_TAG", this.prefix()))).getResultSet();
            try {
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"", (Object)rs.getString(String.format("%sSTATEMENT_TAG", this.prefix())));
                Assert.assertFalse((boolean)rs.next());
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            connection.execute(Statement.of((String)String.format("SET %sTRANSACTION_TAG='tag2'", this.prefix())));
            rs = connection.execute(Statement.of((String)String.format("SHOW VARIABLE %sTRANSACTION_TAG", this.prefix()))).getResultSet();
            try {
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"tag2", (Object)rs.getString(String.format("%sTRANSACTION_TAG", this.prefix())));
                Assert.assertFalse((boolean)rs.next());
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            connection.execute(Statement.of((String)String.format("SET %sTRANSACTION_TAG=''", this.prefix())));
            rs = connection.execute(Statement.of((String)String.format("SHOW VARIABLE %sTRANSACTION_TAG", this.prefix()))).getResultSet();
            try {
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"", (Object)rs.getString(String.format("%sTRANSACTION_TAG", this.prefix())));
                Assert.assertFalse((boolean)rs.next());
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
    }

    @Test
    public void testQuery_StatementTagHint() {
        String sql = SELECT_COUNT_STATEMENT.getSql();
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            for (boolean autocommit : new boolean[]{true, false}) {
                connection.setAutocommit(autocommit);
                ResultSet ignore = connection.executeQuery(Statement.of((String)(this.statementTagHint("tag-1") + sql)), new Options.QueryOption[0]);
                if (ignore != null) {
                    ignore.close();
                }
                Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
                Assert.assertEquals((Object)"tag-1", (Object)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0).getRequestOptions().getRequestTag());
                mockSpanner.clearRequests();
            }
        }
    }

    @Test
    public void testUpdate_StatementTagHint() {
        String sql = INSERT_STATEMENT.getSql();
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            for (boolean autocommit : new boolean[]{true, false}) {
                connection.setAutocommit(autocommit);
                connection.executeUpdate(Statement.of((String)(this.statementTagHint("tag-2") + sql)));
                Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
                Assert.assertEquals((Object)"tag-2", (Object)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0).getRequestOptions().getRequestTag());
                Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0).getRequestOptions().getTransactionTag());
                mockSpanner.clearRequests();
            }
        }
    }

    @Test
    public void testPartitionedUpdate_StatementTagHint() {
        String sql = INSERT_STATEMENT.getSql();
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            connection.setAutocommitDmlMode(AutocommitDmlMode.PARTITIONED_NON_ATOMIC);
            connection.executeUpdate(Statement.of((String)(this.statementTagHint("tag-4") + sql)));
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
            Assert.assertEquals((Object)"tag-4", (Object)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0).getRequestOptions().getRequestTag());
            Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0).getRequestOptions().getTransactionTag());
            mockSpanner.clearRequests();
        }
    }

    @Test
    public void testBatchUpdate_StatementTagHint() {
        String sql = INSERT_STATEMENT.getSql();
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            for (boolean autocommit : new boolean[]{true, false}) {
                connection.setAutocommit(autocommit);
                connection.executeBatchUpdate(Collections.singletonList(Statement.of((String)(this.statementTagHint("tag-3") + sql))));
                Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteBatchDmlRequest.class));
                Assert.assertEquals((Object)"tag-3", (Object)mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).get(0).getRequestOptions().getRequestTag());
                Assert.assertEquals((Object)"", (Object)mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).get(0).getRequestOptions().getTransactionTag());
                mockSpanner.clearRequests();
            }
        }
    }

    private String statementTagHint(String tag) {
        switch (this.dialect) {
            case POSTGRESQL: {
                return "/*@statement_tag='" + tag + "'*/";
            }
        }
        return "@{statement_tag='" + tag + "'}";
    }

    private String prefix() {
        return this.dialect == Dialect.POSTGRESQL ? "SPANNER." : "";
    }
}

