/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection.it;

import com.google.cloud.spanner.AsyncResultSet;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ParallelIntegrationTest;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.connection.AsyncStatementResult;
import com.google.cloud.spanner.connection.ITAbstractSpannerTest;
import com.google.cloud.spanner.connection.StatementResult;
import com.google.cloud.spanner.connection.TransactionMode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={ParallelIntegrationTest.class})
@RunWith(value=Parameterized.class)
public class ITDmlReturningTest
extends ITAbstractSpannerTest {
    private final ImmutableMap<Dialect, Statement> UPDATE_RETURNING_MAP = ImmutableMap.of((Object)Dialect.GOOGLE_STANDARD_SQL, (Object)Statement.of((String)"UPDATE Singers SET LastName = 'XYZ' WHERE FirstName = 'ABC' THEN RETURN *"), (Object)Dialect.POSTGRESQL, (Object)Statement.of((String)"UPDATE Singers SET LastName = 'XYZ' WHERE FirstName = 'ABC' RETURNING *"));
    private final ImmutableMap<Dialect, String> DDL_MAP = ImmutableMap.of((Object)Dialect.GOOGLE_STANDARD_SQL, (Object)"CREATE TABLE Singers (  SingerId INT64,  FirstName STRING(1024),  LastName STRING(1024))  PRIMARY KEY(SingerId)", (Object)Dialect.POSTGRESQL, (Object)"CREATE TABLE Singers (  SingerId BIGINT PRIMARY KEY,  FirstName character varying(1024),  LastName character varying(1024))");
    private static final Set<Dialect> IS_INITIALIZED = new HashSet<Dialect>();
    @Parameterized.Parameter
    public Dialect dialect;

    @Parameterized.Parameters(name="dialect = {0}")
    public static Object[] data() {
        return Dialect.values();
    }

    private boolean checkAndSetInitialized() {
        return !IS_INITIALIZED.add(this.dialect);
    }

    @Before
    public void setupTable() {
        if (!this.checkAndSetInitialized()) {
            database = env.getTestHelper().createTestDatabase(this.dialect, Collections.singleton((String)this.DDL_MAP.get((Object)this.dialect)));
        }
        DatabaseClient client = env.getTestHelper().getDatabaseClient(database);
        client.write((Iterable)ImmutableList.of((Object)Mutation.delete((String)"SINGERS", (KeySet)KeySet.all())));
        List<String> firstNames = Arrays.asList("ABC", "ABC", "DEF", "PQR", "ABC");
        List<String> lastNames = Arrays.asList("XYZ", "DEF", "XYZ", "ABC", "GHI");
        ArrayList<Mutation> mutations = new ArrayList<Mutation>();
        for (int id = 1; id <= 5; ++id) {
            mutations.add(((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"SINGERS").set("SINGERID").to((long)id)).set("FIRSTNAME").to(firstNames.get(id - 1))).set("LASTNAME").to(lastNames.get(id - 1))).build());
        }
        env.getTestHelper().getDatabaseClient(database).write(mutations);
    }

    @Test
    public void testDmlReturningExecuteQuery() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();
             ResultSet rs = connection.executeQuery((Statement)this.UPDATE_RETURNING_MAP.get((Object)this.dialect), new Options.QueryOption[0]);){
            Assert.assertEquals((long)rs.getColumnCount(), (long)3L);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"ABC");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"ABC");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"ABC");
            Assert.assertFalse((boolean)rs.next());
            Assert.assertNotNull((Object)rs.getStats());
            Assert.assertEquals((long)rs.getStats().getRowCountExact(), (long)3L);
        }
    }

    @Test
    public void testDmlReturningExecuteQueryAsync() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();
             AsyncResultSet rs = connection.executeQueryAsync((Statement)this.UPDATE_RETURNING_MAP.get((Object)this.dialect), new Options.QueryOption[0]);){
            rs.setCallback((Executor)Executors.newSingleThreadExecutor(), resultSet -> {
                try {
                    block7: while (true) {
                        switch (resultSet.tryNext()) {
                            case OK: {
                                Assert.assertEquals((long)resultSet.getColumnCount(), (long)3L);
                                Assert.assertEquals((Object)resultSet.getString(1), (Object)"ABC");
                                continue block7;
                            }
                            case DONE: {
                                Assert.assertNotNull((Object)resultSet.getStats());
                                Assert.assertEquals((long)resultSet.getStats().getRowCountExact(), (long)3L);
                                return AsyncResultSet.CallbackResponse.DONE;
                            }
                            case NOT_READY: {
                                return AsyncResultSet.CallbackResponse.CONTINUE;
                            }
                        }
                        break;
                    }
                    throw new IllegalStateException();
                }
                catch (SpannerException e) {
                    return AsyncResultSet.CallbackResponse.DONE;
                }
            });
        }
    }

    @Test
    public void testDmlReturningExecuteUpdate() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(false);
            SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.executeUpdate((Statement)this.UPDATE_RETURNING_MAP.get((Object)this.dialect)));
            Assert.assertEquals((Object)e.getErrorCode(), (Object)ErrorCode.FAILED_PRECONDITION);
        }
    }

    @Test
    public void testDmlReturningExecuteUpdateAsync() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(false);
            SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.executeUpdateAsync((Statement)this.UPDATE_RETURNING_MAP.get((Object)this.dialect)));
            Assert.assertEquals((Object)e.getErrorCode(), (Object)ErrorCode.FAILED_PRECONDITION);
        }
    }

    @Test
    public void testDmlReturningExecuteBatchUpdate() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(false);
            Statement updateStmt = (Statement)Preconditions.checkNotNull((Object)((Statement)this.UPDATE_RETURNING_MAP.get((Object)this.dialect)));
            long[] counts = connection.executeBatchUpdate((Iterable)ImmutableList.of((Object)updateStmt, (Object)updateStmt, (Object)updateStmt));
            Assert.assertArrayEquals((long[])counts, (long[])new long[]{3L, 3L, 3L});
        }
    }

    @Test
    public void testDmlReturningExecuteBatchUpdateAsync() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(false);
            Statement updateStmt = (Statement)Preconditions.checkNotNull((Object)((Statement)this.UPDATE_RETURNING_MAP.get((Object)this.dialect)));
            long[] counts = (long[])connection.executeBatchUpdateAsync((Iterable)ImmutableList.of((Object)updateStmt, (Object)updateStmt, (Object)updateStmt)).get();
            Assert.assertArrayEquals((long[])counts, (long[])new long[]{3L, 3L, 3L});
        }
        catch (InterruptedException | ExecutionException exception) {
            // empty catch block
        }
    }

    @Test
    public void testDmlReturningExecute() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(false);
            StatementResult res = connection.execute((Statement)this.UPDATE_RETURNING_MAP.get((Object)this.dialect));
            Assert.assertEquals((Object)res.getResultType(), (Object)StatementResult.ResultType.RESULT_SET);
            try (ResultSet rs = res.getResultSet();){
                Assert.assertEquals((long)rs.getColumnCount(), (long)3L);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)rs.getString(1), (Object)"ABC");
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)rs.getString(1), (Object)"ABC");
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)rs.getString(1), (Object)"ABC");
                Assert.assertFalse((boolean)rs.next());
                Assert.assertNotNull((Object)rs.getStats());
                Assert.assertEquals((long)rs.getStats().getRowCountExact(), (long)3L);
            }
        }
    }

    @Test
    public void testDmlReturningExecuteAsync() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(false);
            AsyncStatementResult res = connection.executeAsync((Statement)this.UPDATE_RETURNING_MAP.get((Object)this.dialect));
            Assert.assertEquals((Object)res.getResultType(), (Object)StatementResult.ResultType.RESULT_SET);
            try (AsyncResultSet rs = res.getResultSetAsync();){
                rs.setCallback((Executor)Executors.newSingleThreadExecutor(), resultSet -> {
                    try {
                        block7: while (true) {
                            switch (resultSet.tryNext()) {
                                case OK: {
                                    Assert.assertEquals((long)resultSet.getColumnCount(), (long)3L);
                                    Assert.assertEquals((Object)resultSet.getString(1), (Object)"ABC");
                                    continue block7;
                                }
                                case DONE: {
                                    Assert.assertNotNull((Object)resultSet.getStats());
                                    Assert.assertEquals((long)resultSet.getStats().getRowCountExact(), (long)3L);
                                    return AsyncResultSet.CallbackResponse.DONE;
                                }
                                case NOT_READY: {
                                    return AsyncResultSet.CallbackResponse.CONTINUE;
                                }
                            }
                            break;
                        }
                        throw new IllegalStateException();
                    }
                    catch (SpannerException e) {
                        System.out.printf("Error in callback: %s%n", e.getMessage());
                        return AsyncResultSet.CallbackResponse.DONE;
                    }
                });
            }
        }
    }

    @Test
    public void testDmlReturningExecuteQueryReadOnlyMode() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setReadOnly(true);
            SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.executeQuery((Statement)this.UPDATE_RETURNING_MAP.get((Object)this.dialect), new Options.QueryOption[0]));
            Assert.assertEquals((Object)e.getErrorCode(), (Object)ErrorCode.FAILED_PRECONDITION);
        }
    }

    @Test
    public void testDmlReturningExecuteQueryReadOnlyTransaction() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setReadOnly(false);
            connection.setAutocommit(false);
            connection.setTransactionMode(TransactionMode.READ_ONLY_TRANSACTION);
            SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.executeQuery((Statement)this.UPDATE_RETURNING_MAP.get((Object)this.dialect), new Options.QueryOption[0]));
            Assert.assertEquals((Object)e.getErrorCode(), (Object)ErrorCode.FAILED_PRECONDITION);
        }
    }

    @Test
    public void testDmlReturningExecuteQueryAsyncReadOnlyMode() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setReadOnly(true);
            SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.executeQueryAsync((Statement)this.UPDATE_RETURNING_MAP.get((Object)this.dialect), new Options.QueryOption[0]));
            Assert.assertEquals((Object)e.getErrorCode(), (Object)ErrorCode.FAILED_PRECONDITION);
        }
    }

    @Test
    public void testDmlReturningExecuteQueryAsyncReadOnlyTransaction() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setReadOnly(false);
            connection.setAutocommit(false);
            connection.setTransactionMode(TransactionMode.READ_ONLY_TRANSACTION);
            SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.executeQueryAsync((Statement)this.UPDATE_RETURNING_MAP.get((Object)this.dialect), new Options.QueryOption[0]));
            Assert.assertEquals((Object)e.getErrorCode(), (Object)ErrorCode.FAILED_PRECONDITION);
        }
    }
}

