/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.it;

import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.IntegrationTestEnv;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ParallelIntegrationTest;
import com.google.cloud.spanner.testing.EmulatorSpannerHelper;
import com.google.cloud.spanner.testing.RemoteSpannerHelper;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.StreamSupport;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={ParallelIntegrationTest.class})
@RunWith(value=Parameterized.class)
public class ITDatabaseAdminDialectAwareTest {
    @ClassRule
    public static IntegrationTestEnv env = new IntegrationTestEnv();
    private static final Duration OPERATION_TIMEOUT = Duration.ofMinutes(20L);
    private DatabaseAdminClient client;
    private RemoteSpannerHelper testHelper;
    private List<DatabaseId> databases;
    @Parameterized.Parameter
    public Dialect dialect;

    @Parameterized.Parameters(name="dialect = {0}")
    public static Object[] data() {
        return Dialect.values();
    }

    @Before
    public void setUp() {
        this.testHelper = env.getTestHelper();
        this.client = this.testHelper.getClient().getDatabaseAdminClient();
        this.databases = new ArrayList<DatabaseId>();
    }

    @After
    public void tearDown() {
        if (this.databases != null) {
            for (DatabaseId id : this.databases) {
                try {
                    this.client.dropDatabase(id.getInstanceId().getInstance(), id.getDatabase());
                }
                catch (Exception e) {
                    System.err.println("Could not drop database " + id + ", skipping...: " + e.getMessage());
                }
            }
        }
    }

    @Test
    public void testCreateDatabaseWithDialect() throws Exception {
        Assume.assumeFalse((String)"emulator does not support different dialects", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        String projectId = this.testHelper.getInstanceId().getProject();
        String instanceId = this.testHelper.getInstanceId().getInstance();
        String databaseId = this.testHelper.getUniqueDatabaseId();
        Database databaseToCreate = this.client.newDatabaseBuilder(DatabaseId.of((String)projectId, (String)instanceId, (String)databaseId)).setDialect(this.dialect).build();
        this.databases.add(databaseToCreate.getId());
        Database createdDatabase = (Database)this.client.createDatabase(databaseToCreate, Collections.emptyList()).get(OPERATION_TIMEOUT.toMillis(), TimeUnit.MILLISECONDS);
        Assert.assertEquals((Object)this.dialect, (Object)createdDatabase.getDialect());
        Database retrievedDatabase = this.client.getDatabase(instanceId, databaseId);
        Assert.assertEquals((Object)this.dialect, (Object)retrievedDatabase.getDialect());
        Optional<Database> maybeListedDatabase = StreamSupport.stream(this.client.listDatabases(instanceId, new Options.ListOption[0]).iterateAll().spliterator(), false).filter(database -> database.getId().getDatabase().equals(databaseId)).findFirst();
        Assert.assertTrue((String)"Expected to find database in list", (boolean)maybeListedDatabase.isPresent());
        Assert.assertEquals((Object)this.dialect, (Object)maybeListedDatabase.get().getDialect());
    }
}

