/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.it;

import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.IntegrationTestEnv;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.MockSpannerTestUtil;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ParallelIntegrationTest;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionManager;
import com.google.cloud.spanner.TransactionRunner;
import com.google.cloud.spanner.testing.EmulatorSpannerHelper;
import com.google.common.collect.Lists;
import com.google.spanner.v1.DirectedReadOptions;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@Category(value={ParallelIntegrationTest.class})
@RunWith(value=JUnit4.class)
public class ITDirectedReadsTest {
    private static final DirectedReadOptions DIRECTED_READ_OPTIONS = DirectedReadOptions.newBuilder().setIncludeReplicas(DirectedReadOptions.IncludeReplicas.newBuilder().addReplicaSelections(DirectedReadOptions.ReplicaSelection.newBuilder().setLocation("us-west1").build())).build();
    @ClassRule
    public static IntegrationTestEnv env = new IntegrationTestEnv();
    private static Database db;

    @BeforeClass
    public static void setUp() {
        db = env.getTestHelper().createTestDatabase(new String[]{"CREATE TABLE TEST (ID INT64, NAME STRING(100)) PRIMARY KEY (ID)"});
    }

    @AfterClass
    public static void tearDown() {
        db.drop();
    }

    @Test
    public void testReadWriteTransactionRunner_queryWithDirectedReadOptionsViaRequest_throwsError() {
        Assume.assumeFalse((String)"Emulator does not support directed reads", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        SpannerOptions options = env.getTestHelper().getOptions().toBuilder().build();
        try (Spanner spanner = (Spanner)options.getService();){
            DatabaseClient client = spanner.getDatabaseClient(db.getId());
            TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
            SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> runner.run(transaction -> {
                try (ResultSet resultSet = transaction.executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[]{Options.directedRead((DirectedReadOptions)DIRECTED_READ_OPTIONS)});){
                    while (resultSet.next()) {
                    }
                }
                return null;
            }));
            Assert.assertEquals((Object)ErrorCode.INVALID_ARGUMENT, (Object)e.getErrorCode());
            Assert.assertTrue((boolean)e.getMessage().contains("Directed reads can only be performed in a read-only transaction."));
        }
    }

    @Test
    public void testReadWriteTransactionRunner_readWithDirectedReadOptionsViaRequest_throwsError() {
        Assume.assumeFalse((String)"Emulator does not support directed reads", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        SpannerOptions options = env.getTestHelper().getOptions().toBuilder().build();
        try (Spanner spanner = (Spanner)options.getService();){
            DatabaseClient client = spanner.getDatabaseClient(db.getId());
            TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
            SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> runner.run(transaction -> {
                try (ResultSet resultSet = transaction.read("TEST", KeySet.singleKey((Key)Key.of((Object[])new Object[]{1L})), (Iterable)Lists.newArrayList((Object[])new String[]{"NAME"}), new Options.ReadOption[]{Options.directedRead((DirectedReadOptions)DIRECTED_READ_OPTIONS)});){
                    while (resultSet.next()) {
                    }
                }
                return null;
            }));
            Assert.assertEquals((Object)ErrorCode.INVALID_ARGUMENT, (Object)e.getErrorCode());
            Assert.assertTrue((boolean)e.getMessage().contains("Directed reads can only be performed in a read-only transaction."));
        }
    }

    @Test
    public void testReadWriteTransactionManager_readWithDirectedReadOptionsViaRequest_throwsError() {
        Assume.assumeFalse((String)"Emulator does not support directed reads", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        SpannerOptions options = env.getTestHelper().getOptions().toBuilder().build();
        try (Spanner spanner = (Spanner)options.getService();){
            DatabaseClient client = spanner.getDatabaseClient(db.getId());
            try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[0]);){
                SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> {
                    TransactionContext transaction = manager.begin();
                    try {
                        ResultSet resultSet = transaction.read("TEST", KeySet.singleKey((Key)Key.of((Object[])new Object[]{1L})), (Iterable)Lists.newArrayList((Object[])new String[]{"NAME"}), new Options.ReadOption[]{Options.directedRead((DirectedReadOptions)DIRECTED_READ_OPTIONS)});
                        while (resultSet.next()) {
                        }
                        manager.commit();
                        Assert.assertNotNull((Object)manager.getCommitTimestamp());
                    }
                    catch (AbortedException ex) {
                        transaction = manager.resetForRetry();
                    }
                });
                Assert.assertEquals((Object)ErrorCode.INVALID_ARGUMENT, (Object)e.getErrorCode());
                Assert.assertTrue((boolean)e.getMessage().contains("Directed reads can only be performed in a read-only transaction."));
            }
        }
    }
}

