/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.it;

import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.IntegrationTestEnv;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ParallelIntegrationTest;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.it.DialectTestParameter;
import com.google.cloud.spanner.testing.EmulatorSpannerHelper;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={ParallelIntegrationTest.class})
@RunWith(value=Parameterized.class)
public class ITForeignKeyDeleteCascadeTest {
    @ClassRule
    public static IntegrationTestEnv env = new IntegrationTestEnv();
    private static final String TABLE_NAME_SINGER = "Singer";
    private static final String TABLE_NAME_CONCERT = "Concert";
    private static final String DELETE_RULE_COLUMN_NAME = "DELETE_RULE";
    private static Database GOOGLE_STANDARD_SQL_DATABASE;
    private static Database POSTGRESQL_DATABASE;
    private static List<Database> dbs;
    @Parameterized.Parameter(value=0)
    public DialectTestParameter dialect;

    @Parameterized.Parameters(name="Dialect = {0}")
    public static List<DialectTestParameter> data() {
        ArrayList<DialectTestParameter> params = new ArrayList<DialectTestParameter>();
        params.add(new DialectTestParameter(Dialect.GOOGLE_STANDARD_SQL));
        params.add(new DialectTestParameter(Dialect.POSTGRESQL));
        return params;
    }

    @BeforeClass
    public static void setUpDatabase() {
        if (!EmulatorSpannerHelper.isUsingEmulator()) {
            GOOGLE_STANDARD_SQL_DATABASE = env.getTestHelper().createTestDatabase((Iterable)ImmutableList.of((Object)"CREATE TABLE Singer (\n  singer_id   INT64 NOT NULL,\n  first_name  STRING(1024),\n) PRIMARY KEY(singer_id)\n", (Object)"CREATE TABLE Concert (\n  venue_id      INT64 NOT NULL,\n  singer_id     INT64 NOT NULL,\n  CONSTRAINT Fk_Concert_Singer FOREIGN KEY (singer_id) REFERENCES Singer (singer_id) ON DELETE CASCADE) PRIMARY KEY(venue_id, singer_id)"));
            POSTGRESQL_DATABASE = env.getTestHelper().createTestDatabase(Dialect.POSTGRESQL, (Iterable)ImmutableList.of((Object)"CREATE TABLE Singer (\n  singer_id   BIGINT PRIMARY KEY,\n  first_name  VARCHAR\n)", (Object)"CREATE TABLE Concert (\n      venue_id      BIGINT NOT NULL,\n      singer_id     BIGINT NOT NULL,\n      PRIMARY KEY (venue_id, singer_id),\n      CONSTRAINT Fk_Concert_Singer FOREIGN KEY (singer_id) REFERENCES Singer (singer_id) ON DELETE CASCADE\n      )"));
            dbs.add(GOOGLE_STANDARD_SQL_DATABASE);
            dbs.add(POSTGRESQL_DATABASE);
        }
    }

    @AfterClass
    public static void tearDown() {
        for (Database db : dbs) {
            db.drop();
        }
        dbs.clear();
    }

    @Test
    public void testForeignKeyDeleteCascadeConstraints_withCreateDDLStatements() {
        Assume.assumeFalse((String)"Emulator does not yet support foreign key delete cascade", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        DatabaseClient databaseClient = this.getCreatedDatabaseClient();
        try (ResultSet rs = databaseClient.singleUse().executeQuery(Statement.of((String)"SELECT DELETE_RULE\nFROM INFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS\nWHERE CONSTRAINT_NAME ='Fk_Concert_Singer'"), new Options.QueryOption[0]);){
            while (rs.next()) {
                Assert.assertEquals((Object)rs.getString(DELETE_RULE_COLUMN_NAME), (Object)"CASCADE");
            }
        }
    }

    @Test
    public void testForeignKeyDeleteCascadeConstraints_withAlterDDLStatements() throws Exception {
        Assume.assumeFalse((String)"Emulator does not yet support foreign key delete cascade", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        ImmutableList createStatements = this.dialect.dialect == Dialect.POSTGRESQL ? ImmutableList.of((Object)"CREATE TABLE Singer (\n  singer_id   BIGINT PRIMARY KEY,\n  first_name  VARCHAR\n)", (Object)"CREATE TABLE ConcertV2 (\n      venue_id      BIGINT NOT NULL,\n      singer_id     BIGINT NOT NULL,\n      PRIMARY KEY (venue_id, singer_id)\n      )", (Object)"ALTER TABLE ConcertV2 ADD CONSTRAINT Fk_Concert_Singer_V2 FOREIGN KEY(singer_id) REFERENCES Singer(singer_id) ON DELETE CASCADE") : ImmutableList.of((Object)"CREATE TABLE Singer (\n  singer_id   INT64 NOT NULL,\n  first_name  STRING(1024),\n) PRIMARY KEY(singer_id)\n", (Object)"CREATE TABLE ConcertV2 (\n  venue_id      INT64 NOT NULL,\n  singer_id     INT64 NOT NULL,\n) PRIMARY KEY(venue_id, singer_id)", (Object)"ALTER TABLE ConcertV2 ADD CONSTRAINT Fk_Concert_Singer_V2 FOREIGN KEY(singer_id) REFERENCES Singer(singer_id) ON DELETE CASCADE");
        Database createdDatabase = env.getTestHelper().createTestDatabase(this.dialect.dialect, (Iterable)createStatements);
        dbs.add(createdDatabase);
        DatabaseClient databaseClient = this.getCreatedDatabaseClient();
        try (ResultSet rs = databaseClient.singleUse().executeQuery(Statement.of((String)"SELECT DELETE_RULE\nFROM INFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS\nWHERE CONSTRAINT_NAME ='Fk_Concert_Singer'"), new Options.QueryOption[0]);){
            while (rs.next()) {
                Assert.assertEquals((Object)rs.getString(DELETE_RULE_COLUMN_NAME), (Object)"CASCADE");
            }
        }
        this.getDatabaseAdminClient().updateDatabaseDdl(env.getTestHelper().getInstanceId().getInstance(), createdDatabase.getId().getDatabase(), (Iterable)ImmutableList.of((Object)"ALTER TABLE ConcertV2\nDROP CONSTRAINT Fk_Concert_Singer_V2", (Object)"ALTER TABLE ConcertV2 ADD CONSTRAINT Fk_Concert_Singer_V2 FOREIGN KEY(singer_id) REFERENCES Singer(singer_id) "), null).get();
        rs = databaseClient.singleUse().executeQuery(Statement.of((String)"SELECT DELETE_RULE\nFROM INFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS\nWHERE CONSTRAINT_NAME ='Fk_Concert_Singer_V2'"), new Options.QueryOption[0]);
        try {
            while (rs.next()) {
                Assert.assertEquals((Object)rs.getString(DELETE_RULE_COLUMN_NAME), (Object)"NO ACTION");
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
    }

    @Test
    public void testForeignKeyDeleteCascadeConstraints_verifyValidInsertions() {
        Assume.assumeFalse((String)"Emulator does not yet support foreign key delete cascade", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        DatabaseClient databaseClient = this.getCreatedDatabaseClient();
        String singerInsertStatement = "INSERT INTO Singer (singer_id, first_name) VALUES (" + this.generateQueryParameters(2) + ")";
        Statement singerInsertStatementWithValues = ((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)singerInsertStatement).bind("p1").to(1L)).bind("p2").to("singerName")).build();
        String concertInsertStatement = "INSERT INTO Concert (venue_id, singer_id) VALUES (" + this.generateQueryParameters(2) + ")";
        Statement concertInsertStatementWithValues = ((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)concertInsertStatement).bind("p1").to(1L)).bind("p2").to(1L)).build();
        databaseClient.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
            transaction.batchUpdate((Iterable)ImmutableList.of((Object)singerInsertStatementWithValues, (Object)concertInsertStatementWithValues), new Options.UpdateOption[0]);
            return null;
        });
        try (ResultSet resultSet = databaseClient.singleUse().executeQuery(Statement.of((String)"SELECT * FROM Singer"), new Options.QueryOption[0]);){
            resultSet.next();
            Assert.assertEquals((long)1L, (long)resultSet.getLong("singer_id"));
            Assert.assertEquals((Object)"singerName", (Object)resultSet.getString("first_name"));
            Assert.assertFalse((boolean)resultSet.next());
        }
        resultSet = databaseClient.singleUse().executeQuery(Statement.of((String)"SELECT * FROM Concert"), new Options.QueryOption[0]);
        try {
            resultSet.next();
            Assert.assertEquals((long)1L, (long)resultSet.getLong("singer_id"));
            Assert.assertEquals((long)1L, (long)resultSet.getLong("venue_id"));
            Assert.assertFalse((boolean)resultSet.next());
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    @Test
    public void testForeignKeyDeleteCascadeConstraints_verifyInvalidInsertions() {
        Assume.assumeFalse((String)"Emulator does not yet support foreign key delete cascade", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        DatabaseClient databaseClient = this.getCreatedDatabaseClient();
        String concertInsertStatement = "INSERT INTO Concert (venue_id, singer_id) VALUES (" + this.generateQueryParameters(2) + ")";
        Statement concertInsertStatementWithInvalidValues = ((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)concertInsertStatement).bind("p1").to(2L)).bind("p2").to(2L)).build();
        SpannerException ex = (SpannerException)Assert.assertThrows(SpannerException.class, () -> databaseClient.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
            transaction.executeUpdate(concertInsertStatementWithInvalidValues, new Options.UpdateOption[0]);
            return null;
        }));
        Assert.assertEquals((Object)ex.getErrorCode(), (Object)ErrorCode.FAILED_PRECONDITION);
        Assert.assertTrue((boolean)ex.getMessage().contains("Cannot find referenced values"));
    }

    @Test
    public void testForeignKeyDeleteCascadeConstraints_forDeletions() {
        Assume.assumeFalse((String)"Emulator does not yet support foreign key delete cascade", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        DatabaseClient databaseClient = this.getCreatedDatabaseClient();
        String singerInsertStatement = "INSERT INTO Singer (singer_id, first_name) VALUES (" + this.generateQueryParameters(2) + ")";
        Statement singerInsertStatementWithValues = ((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)singerInsertStatement).bind("p1").to(3L)).bind("p2").to("singerName")).build();
        String concertInsertStatement = "INSERT INTO Concert (venue_id, singer_id) VALUES (" + this.generateQueryParameters(2) + ")";
        Statement concertInsertStatementWithValues = ((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)concertInsertStatement).bind("p1").to(3L)).bind("p2").to(3L)).build();
        databaseClient.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
            transaction.batchUpdate((Iterable)ImmutableList.of((Object)singerInsertStatementWithValues, (Object)concertInsertStatementWithValues), new Options.UpdateOption[0]);
            return null;
        });
        Statement singerDeleteStatementWithValues = ((Statement.Builder)Statement.newBuilder((String)("DELETE FROM Singer WHERE singer_id = " + this.generateQueryParameters(1))).bind("p1").to(3L)).build();
        databaseClient.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
            transaction.executeUpdate(singerDeleteStatementWithValues, new Options.UpdateOption[0]);
            return null;
        });
        try (ResultSet resultSet = databaseClient.singleUse().executeQuery(Statement.of((String)"SELECT * FROM Singer"), new Options.QueryOption[0]);){
            Assert.assertFalse((boolean)resultSet.next());
        }
        resultSet = databaseClient.singleUse().executeQuery(Statement.of((String)"SELECT * FROM Concert"), new Options.QueryOption[0]);
        try {
            Assert.assertFalse((boolean)resultSet.next());
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    @Test
    public void testForeignKeyDeleteCascadeConstraints_forMutations_onConflictDueToParentTable() {
        Assume.assumeFalse((String)"Emulator does not yet support foreign key delete cascade", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        DatabaseClient databaseClient = this.getCreatedDatabaseClient();
        SpannerException ex = (SpannerException)Assert.assertThrows(SpannerException.class, () -> databaseClient.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
            transaction.buffer(Arrays.asList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)TABLE_NAME_SINGER).set("singer_id").to(4L)).set("first_name").to("singerName")).build(), Mutation.delete((String)TABLE_NAME_SINGER, (Key)Key.of((Object[])new Object[]{4L}))));
            return null;
        }));
        Assert.assertEquals((Object)ex.getErrorCode(), (Object)ErrorCode.FAILED_PRECONDITION);
    }

    @Test
    public void testForeignKeyDeleteCascadeConstraints_forMutations_onConflictsDueToChildTable() {
        Assume.assumeFalse((String)"Emulator does not yet support foreign key delete cascade", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        DatabaseClient databaseClient = this.getCreatedDatabaseClient();
        String singerInsertStatement = "INSERT INTO Singer (singer_id, first_name) VALUES (" + this.generateQueryParameters(2) + ")";
        Statement singerInsertStatementWithValues = ((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)singerInsertStatement).bind("p1").to(5L)).bind("p2").to("singerName")).build();
        databaseClient.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
            transaction.executeUpdate(singerInsertStatementWithValues, new Options.UpdateOption[0]);
            return null;
        });
        SpannerException ex = (SpannerException)Assert.assertThrows(SpannerException.class, () -> databaseClient.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
            transaction.buffer(Arrays.asList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)TABLE_NAME_CONCERT).set("first_name").to(5L)).set("singer_id").to(5L)).build(), Mutation.delete((String)TABLE_NAME_SINGER, (Key)Key.of((Object[])new Object[]{5L}))));
            return null;
        }));
    }

    private DatabaseAdminClient getDatabaseAdminClient() {
        return env.getTestHelper().getClient().getDatabaseAdminClient();
    }

    private DatabaseClient getCreatedDatabaseClient() {
        if (this.dialect.dialect == Dialect.POSTGRESQL) {
            return env.getTestHelper().getDatabaseClient(POSTGRESQL_DATABASE);
        }
        return env.getTestHelper().getDatabaseClient(GOOGLE_STANDARD_SQL_DATABASE);
    }

    private String generateQueryParameters(int numParams) {
        List params = this.dialect.dialect == Dialect.POSTGRESQL ? IntStream.range(1, numParams + 1).mapToObj(paramIndex -> "$" + paramIndex).collect(Collectors.toList()) : IntStream.range(1, numParams + 1).mapToObj(paramIndex -> "@p" + paramIndex).collect(Collectors.toList());
        if (params.size() == 1) {
            return (String)params.get(0);
        }
        return String.join((CharSequence)",", params);
    }

    static {
        dbs = new ArrayList<Database>();
    }
}

