/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.it;

import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.IntegrationTestEnv;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ParallelIntegrationTest;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Value;
import com.google.cloud.spanner.testing.EmulatorSpannerHelper;
import com.google.cloud.spanner.testing.RemoteSpannerHelper;
import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.threeten.bp.Duration;

@Category(value={ParallelIntegrationTest.class})
@RunWith(value=JUnit4.class)
public class ITPgNumericTest {
    private static final Duration OPERATION_TIMEOUT = Duration.ofMinutes((long)5L);
    @ClassRule
    public static IntegrationTestEnv env = new IntegrationTestEnv();
    private static RemoteSpannerHelper testHelper;
    private static DatabaseAdminClient databaseAdminClient;
    private static List<DatabaseId> databasesToDrop;
    private static String projectId;
    private static String instanceId;
    private static String databaseId;
    private DatabaseClient databaseClient;
    private String tableName;

    @BeforeClass
    public static void beforeClass() throws Exception {
        Assume.assumeFalse((String)"PgNumeric is not supported in the emulator", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        testHelper = env.getTestHelper();
        databaseAdminClient = testHelper.getClient().getDatabaseAdminClient();
        databasesToDrop = new ArrayList<DatabaseId>();
        projectId = testHelper.getInstanceId().getProject();
        instanceId = testHelper.getInstanceId().getInstance();
        databaseId = testHelper.getUniqueDatabaseId();
        Database database = databaseAdminClient.newDatabaseBuilder(DatabaseId.of((String)projectId, (String)instanceId, (String)databaseId)).setDialect(Dialect.POSTGRESQL).build();
        databaseAdminClient.createDatabase(database, Collections.emptyList()).get(OPERATION_TIMEOUT.toMillis(), TimeUnit.MILLISECONDS);
        databasesToDrop.add(database.getId());
    }

    @AfterClass
    public static void afterClass() throws Exception {
        if (databasesToDrop != null) {
            for (DatabaseId id : databasesToDrop) {
                try {
                    databaseAdminClient.dropDatabase(id.getInstanceId().getInstance(), id.getDatabase());
                }
                catch (Exception e) {
                    System.err.println("Failed to drop database " + id + ", skipping...: " + e.getMessage());
                }
            }
        }
    }

    @Before
    public void setUp() throws Exception {
        this.databaseClient = testHelper.getClient().getDatabaseClient(DatabaseId.of((String)projectId, (String)instanceId, (String)databaseId));
        this.tableName = testHelper.getUniqueDatabaseId();
        databaseAdminClient.updateDatabaseDdl(instanceId, databaseId, Collections.singletonList("CREATE TABLE \"" + this.tableName + "\" (id BIGINT PRIMARY KEY, col1 NUMERIC)"), null).get(OPERATION_TIMEOUT.toMillis(), TimeUnit.MILLISECONDS);
    }

    @Test
    public void testLiteralPgNumeric() {
        Assume.assumeFalse((String)"PgNumeric is not supported in the emulator", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        this.databaseClient.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
            transaction.executeUpdate(Statement.of((String)("INSERT INTO " + this.tableName + " (id, col1) VALUES (1, 1.23), (2, 'NaN'), (3, null)")), new Options.UpdateOption[0]);
            return null;
        });
        try (ResultSet resultSet = this.databaseClient.singleUse().executeQuery(Statement.of((String)("SELECT * FROM " + this.tableName)), new Options.QueryOption[0]);){
            resultSet.next();
            Assert.assertEquals((Object)"1.23", (Object)resultSet.getString("col1"));
            Assert.assertEquals((Object)Value.pgNumeric((String)"1.23"), (Object)resultSet.getValue("col1"));
            resultSet.next();
            Assert.assertEquals((Object)"NaN", (Object)resultSet.getString("col1"));
            Assert.assertEquals((Object)Value.pgNumeric((String)"NaN"), (Object)resultSet.getValue("col1"));
            resultSet.next();
            Assert.assertTrue((boolean)resultSet.isNull("col1"));
        }
    }

    @Test
    public void testParameterizedWithPgNumericAsValue() {
        Assume.assumeFalse((String)"PgNumeric is not supported in the emulator", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        this.databaseClient.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
            transaction.executeUpdate(((Statement.Builder)((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)("INSERT INTO " + this.tableName + " (id, col1) VALUES (1, $1), (2, $2), (3, $3)")).bind("p1").to(Value.pgNumeric((String)"1.23"))).bind("p2").to(Value.pgNumeric((String)"NaN"))).bind("p3").to(Value.pgNumeric(null))).build(), new Options.UpdateOption[0]);
            return null;
        });
        try (ResultSet resultSet = this.databaseClient.singleUse().executeQuery(Statement.of((String)("SELECT * FROM " + this.tableName)), new Options.QueryOption[0]);){
            resultSet.next();
            Assert.assertEquals((Object)"1.23", (Object)resultSet.getString("col1"));
            Assert.assertEquals((Object)Value.pgNumeric((String)"1.23"), (Object)resultSet.getValue("col1"));
            resultSet.next();
            Assert.assertEquals((Object)"NaN", (Object)resultSet.getString("col1"));
            Assert.assertEquals((Object)Value.pgNumeric((String)"NaN"), (Object)resultSet.getValue("col1"));
            resultSet.next();
            Assert.assertTrue((boolean)resultSet.isNull("col1"));
        }
    }

    @Test
    public void testParameterizedWithPgNumericAsDouble() {
        Assume.assumeFalse((String)"PgNumeric is not supported in the emulator", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        this.databaseClient.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
            transaction.executeUpdate(((Statement.Builder)((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)("INSERT INTO " + this.tableName + " (id, col1) VALUES (1, $1), (2, $2), (3, $3)")).bind("p1").to(1.23)).bind("p2").to(Double.NaN)).bind("p3").to((Double)null)).build(), new Options.UpdateOption[0]);
            return null;
        });
        try (ResultSet resultSet = this.databaseClient.singleUse().executeQuery(Statement.of((String)("SELECT * FROM " + this.tableName)), new Options.QueryOption[0]);){
            resultSet.next();
            Assert.assertEquals((Object)"1.23", (Object)resultSet.getString("col1"));
            Assert.assertEquals((Object)Value.pgNumeric((String)"1.23"), (Object)resultSet.getValue("col1"));
            resultSet.next();
            Assert.assertEquals((Object)"NaN", (Object)resultSet.getString("col1"));
            Assert.assertEquals((Object)Value.pgNumeric((String)"NaN"), (Object)resultSet.getValue("col1"));
            resultSet.next();
            Assert.assertTrue((boolean)resultSet.isNull("col1"));
        }
    }

    @Test
    public void testParameterizedWithPgNumericAsInt() {
        Assume.assumeFalse((String)"PgNumeric is not supported in the emulator", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        this.databaseClient.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
            transaction.executeUpdate(((Statement.Builder)Statement.newBuilder((String)("INSERT INTO " + this.tableName + " (id, col1) VALUES (1, $1)")).bind("p1").to(1L)).build(), new Options.UpdateOption[0]);
            return null;
        });
        try (ResultSet resultSet = this.databaseClient.singleUse().executeQuery(Statement.of((String)("SELECT * FROM " + this.tableName)), new Options.QueryOption[0]);){
            resultSet.next();
            Assert.assertEquals((Object)"1", (Object)resultSet.getString("col1"));
            Assert.assertEquals((Object)Value.pgNumeric((String)"1"), (Object)resultSet.getValue("col1"));
        }
    }

    @Test
    public void testParameterizedWithPgNumericAsLong() {
        Assume.assumeFalse((String)"PgNumeric is not supported in the emulator", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        this.databaseClient.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
            transaction.executeUpdate(((Statement.Builder)Statement.newBuilder((String)("INSERT INTO " + this.tableName + " (id, col1) VALUES (1, $1)")).bind("p1").to(1L)).build(), new Options.UpdateOption[0]);
            return null;
        });
        try (ResultSet resultSet = this.databaseClient.singleUse().executeQuery(Statement.of((String)("SELECT * FROM " + this.tableName)), new Options.QueryOption[0]);){
            resultSet.next();
            Assert.assertEquals((Object)"1", (Object)resultSet.getString("col1"));
            Assert.assertEquals((Object)Value.pgNumeric((String)"1"), (Object)resultSet.getValue("col1"));
        }
    }

    @Test
    public void testMutationsWithPgNumericAsString() {
        Assume.assumeFalse((String)"PgNumeric is not supported in the emulator", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        this.databaseClient.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
            transaction.buffer((Iterable)ImmutableList.of((Object)((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)this.tableName).set("id").to(1L)).set("col1").to("1.23")).build(), (Object)((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)this.tableName).set("id").to(2L)).set("col1").to("NaN")).build(), (Object)((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)this.tableName).set("id").to(3L)).set("col1").to((String)null)).build()));
            return null;
        });
        try (ResultSet resultSet = this.databaseClient.singleUse().executeQuery(Statement.of((String)("SELECT * FROM " + this.tableName)), new Options.QueryOption[0]);){
            resultSet.next();
            Assert.assertEquals((Object)"1.23", (Object)resultSet.getString("col1"));
            Assert.assertEquals((Object)Value.pgNumeric((String)"1.23"), (Object)resultSet.getValue("col1"));
            resultSet.next();
            Assert.assertEquals((Object)"NaN", (Object)resultSet.getString("col1"));
            Assert.assertEquals((Object)Value.pgNumeric((String)"NaN"), (Object)resultSet.getValue("col1"));
            resultSet.next();
            Assert.assertTrue((boolean)resultSet.isNull("col1"));
        }
    }

    @Test
    public void testMutationsWithPgNumericAsInt() {
        Assume.assumeFalse((String)"PgNumeric is not supported in the emulator", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        this.databaseClient.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
            transaction.buffer((Iterable)ImmutableList.of((Object)((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)this.tableName).set("id").to(1L)).set("col1").to(1L)).build()));
            return null;
        });
        try (ResultSet resultSet = this.databaseClient.singleUse().executeQuery(Statement.of((String)("SELECT * FROM " + this.tableName)), new Options.QueryOption[0]);){
            resultSet.next();
            Assert.assertEquals((Object)"1", (Object)resultSet.getString("col1"));
            Assert.assertEquals((Object)Value.pgNumeric((String)"1"), (Object)resultSet.getValue("col1"));
        }
    }

    @Test
    public void testMutationsWithPgNumericAsLong() {
        Assume.assumeFalse((String)"PgNumeric is not supported in the emulator", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        this.databaseClient.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
            transaction.buffer((Iterable)ImmutableList.of((Object)((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)this.tableName).set("id").to(1L)).set("col1").to(1L)).build()));
            return null;
        });
        try (ResultSet resultSet = this.databaseClient.singleUse().executeQuery(Statement.of((String)("SELECT * FROM " + this.tableName)), new Options.QueryOption[0]);){
            resultSet.next();
            Assert.assertEquals((Object)"1", (Object)resultSet.getString("col1"));
            Assert.assertEquals((Object)Value.pgNumeric((String)"1"), (Object)resultSet.getValue("col1"));
        }
    }

    @Test
    public void testMutationsWithPgNumericAsBigDecimal() {
        Assume.assumeFalse((String)"PgNumeric is not supported in the emulator", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        this.databaseClient.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
            transaction.buffer((Iterable)ImmutableList.of((Object)((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)this.tableName).set("id").to(1L)).set("col1").to(new BigDecimal("1.23"))).build(), (Object)((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)this.tableName).set("id").to(3L)).set("col1").to((BigDecimal)null)).build()));
            return null;
        });
        try (ResultSet resultSet = this.databaseClient.singleUse().executeQuery(Statement.of((String)("SELECT * FROM " + this.tableName)), new Options.QueryOption[0]);){
            resultSet.next();
            Assert.assertEquals((Object)"1.23", (Object)resultSet.getString("col1"));
            Assert.assertEquals((Object)Value.pgNumeric((String)"1.23"), (Object)resultSet.getValue("col1"));
            resultSet.next();
            Assert.assertTrue((boolean)resultSet.isNull("col1"));
        }
    }

    @Test
    public void testMutationsWithPgNumericAsValue() {
        Assume.assumeFalse((String)"PgNumeric is not supported in the emulator", (boolean)EmulatorSpannerHelper.isUsingEmulator());
        this.databaseClient.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
            transaction.buffer((Iterable)ImmutableList.of((Object)((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)this.tableName).set("id").to(1L)).set("col1").to(Value.pgNumeric((String)"1.23"))).build(), (Object)((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)this.tableName).set("id").to(2L)).set("col1").to(Value.pgNumeric((String)"NaN"))).build(), (Object)((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)this.tableName).set("id").to(3L)).set("col1").to(Value.pgNumeric(null))).build()));
            return null;
        });
        try (ResultSet resultSet = this.databaseClient.singleUse().executeQuery(Statement.of((String)("SELECT * FROM " + this.tableName)), new Options.QueryOption[0]);){
            resultSet.next();
            Assert.assertEquals((Object)"1.23", (Object)resultSet.getString("col1"));
            Assert.assertEquals((Object)Value.pgNumeric((String)"1.23"), (Object)resultSet.getValue("col1"));
            resultSet.next();
            Assert.assertEquals((Object)"NaN", (Object)resultSet.getString("col1"));
            Assert.assertEquals((Object)Value.pgNumeric((String)"NaN"), (Object)resultSet.getValue("col1"));
            resultSet.next();
            Assert.assertTrue((boolean)resultSet.isNull("col1"));
        }
    }
}

