/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.spi.v1;

import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.spi.v1.SpannerRpc;
import com.google.protobuf.ListValue;
import com.google.protobuf.Value;
import com.google.spanner.v1.ResultSet;
import com.google.spanner.v1.ResultSetMetadata;
import com.google.spanner.v1.StructType;
import com.google.spanner.v1.Type;
import com.google.spanner.v1.TypeCode;
import io.grpc.BindableService;
import io.grpc.ForwardingServerCall;
import io.grpc.Metadata;
import io.grpc.Server;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.MetricReader;
import io.opentelemetry.sdk.testing.exporter.InMemoryMetricReader;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SpannerRpcMetricsTest {
    private static MockSpannerServiceImpl mockSpanner;
    private static Server server;
    private static InetSocketAddress address;
    private static Spanner spannerWithOpenTelemetry;
    private static DatabaseClient databaseClient;
    private static final Map<SpannerRpc.Option, Object> optionsMap;
    private static MockSpannerServiceImpl mockSpannerNoHeader;
    private static Server serverNoHeader;
    private static InetSocketAddress addressNoHeader;
    private static Spanner spannerNoHeaderNoOpenTelemetry;
    private static DatabaseClient databaseClientNoHeader;
    private static String instanceId;
    private static String databaseId;
    private static String projectId;
    private static AtomicInteger fakeServerTiming;
    private static final Statement SELECT1AND2;
    private static final ResultSetMetadata SELECT1AND2_METADATA;
    private static final ResultSet SELECT1_RESULTSET;
    private static final Statement UPDATE_FOO_STATEMENT;
    private static InMemoryMetricReader inMemoryMetricReader;
    private static InMemoryMetricReader inMemoryMetricReaderInjected;

    @BeforeClass
    public static void startServer() throws IOException {
        SpannerOptions.enableOpenTelemetryMetrics();
        mockSpanner = new MockSpannerServiceImpl();
        mockSpanner.setAbortProbability(0.0);
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(SELECT1AND2, SELECT1_RESULTSET));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(UPDATE_FOO_STATEMENT, 1L));
        address = new InetSocketAddress("localhost", 0);
        server = ((NettyServerBuilder)((NettyServerBuilder)NettyServerBuilder.forAddress((SocketAddress)address).addService((BindableService)mockSpanner)).intercept(new ServerInterceptor(){

            public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> serverCall, Metadata headers, ServerCallHandler<ReqT, RespT> serverCallHandler) {
                return serverCallHandler.startCall((ServerCall)new ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT>(serverCall){

                    public void sendHeaders(Metadata headers) {
                        headers.put(Metadata.Key.of((String)"server-timing", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)String.format("gfet4t7; dur=%d", fakeServerTiming.get()));
                        super.sendHeaders(headers);
                    }
                }, headers);
            }
        })).build().start();
        optionsMap.put(SpannerRpc.Option.CHANNEL_HINT, 1L);
        inMemoryMetricReader = InMemoryMetricReader.create();
        SdkMeterProvider sdkMeterProvider = SdkMeterProvider.builder().registerMetricReader((MetricReader)inMemoryMetricReader).build();
        GlobalOpenTelemetry.resetForTest();
        OpenTelemetrySdk.builder().setMeterProvider(sdkMeterProvider).buildAndRegisterGlobal();
        inMemoryMetricReaderInjected = InMemoryMetricReader.create();
        SdkMeterProvider sdkMeterProviderInjected = SdkMeterProvider.builder().registerMetricReader((MetricReader)inMemoryMetricReaderInjected).build();
        OpenTelemetrySdk openTelemetry = OpenTelemetrySdk.builder().setMeterProvider(sdkMeterProviderInjected).build();
        spannerWithOpenTelemetry = (Spanner)SpannerRpcMetricsTest.createSpannerOptionsWithOpenTelemetry(address, server, (OpenTelemetry)openTelemetry).getService();
        databaseClient = spannerWithOpenTelemetry.getDatabaseClient(DatabaseId.of((String)projectId, (String)instanceId, (String)databaseId));
        mockSpannerNoHeader = new MockSpannerServiceImpl();
        mockSpannerNoHeader.setAbortProbability(0.0);
        mockSpannerNoHeader.putStatementResult(MockSpannerServiceImpl.StatementResult.query(SELECT1AND2, SELECT1_RESULTSET));
        mockSpannerNoHeader.putStatementResult(MockSpannerServiceImpl.StatementResult.update(UPDATE_FOO_STATEMENT, 1L));
        addressNoHeader = new InetSocketAddress("localhost", 0);
        serverNoHeader = ((NettyServerBuilder)NettyServerBuilder.forAddress((SocketAddress)addressNoHeader).addService((BindableService)mockSpannerNoHeader)).build().start();
        spannerNoHeaderNoOpenTelemetry = (Spanner)SpannerRpcMetricsTest.createSpannerOptions(addressNoHeader, serverNoHeader).getService();
        databaseClientNoHeader = spannerNoHeaderNoOpenTelemetry.getDatabaseClient(DatabaseId.of((String)projectId, (String)instanceId, (String)databaseId));
    }

    @AfterClass
    public static void stopServer() throws InterruptedException {
        if (spannerWithOpenTelemetry != null) {
            spannerWithOpenTelemetry.close();
            server.shutdown();
            server.awaitTermination();
        }
        if (spannerNoHeaderNoOpenTelemetry != null) {
            spannerNoHeaderNoOpenTelemetry.close();
            serverNoHeader.shutdown();
            serverNoHeader.awaitTermination();
        }
    }

    @After
    public void reset() {
        mockSpanner.reset();
        mockSpannerNoHeader.reset();
    }

    @Test
    public void testGfeLatencyExecuteSqlWithInjectedOpenTelemetry() throws InterruptedException {
        databaseClient.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> transaction.executeUpdate(UPDATE_FOO_STATEMENT, new Options.UpdateOption[0]));
        double latency = this.getGfeLatencyMetric(this.getMetricData("spanner/gfe_latency", inMemoryMetricReaderInjected), "google.spanner.v1.Spanner/ExecuteSql");
        Assert.assertEquals((double)fakeServerTiming.get(), (double)latency, (double)0.0);
    }

    @Test
    public void testGfeMissingHeaderExecuteSqlWithGlobalOpenTelemetry() throws InterruptedException {
        databaseClient.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> transaction.executeUpdate(UPDATE_FOO_STATEMENT, new Options.UpdateOption[0]));
        long count = this.getHeaderLatencyMetric(this.getMetricData("spanner/gfe_header_missing_count", inMemoryMetricReaderInjected), "google.spanner.v1.Spanner/ExecuteSql");
        Assert.assertEquals((long)0L, (long)count);
        databaseClientNoHeader.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> transaction.executeUpdate(UPDATE_FOO_STATEMENT, new Options.UpdateOption[0]));
        long count1 = this.getHeaderLatencyMetric(this.getMetricData("spanner/gfe_header_missing_count", inMemoryMetricReader), "google.spanner.v1.Spanner/ExecuteSql");
        Assert.assertEquals((long)1L, (long)count1);
    }

    private static SpannerOptions createSpannerOptionsWithOpenTelemetry(InetSocketAddress address, Server server, OpenTelemetry openTelemetry) {
        String endpoint = address.getHostString() + ":" + server.getPort();
        return ((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("[PROJECT]")).setChannelConfigurator(input -> {
            input.usePlaintext();
            return input;
        }).setHost("http://" + endpoint).setCredentials((Credentials)NoCredentials.getInstance())).setOpenTelemetry(openTelemetry).build();
    }

    private static SpannerOptions createSpannerOptions(InetSocketAddress address, Server server) {
        String endpoint = address.getHostString() + ":" + server.getPort();
        return ((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("[PROJECT]")).setChannelConfigurator(input -> {
            input.usePlaintext();
            return input;
        }).setHost("http://" + endpoint).setCredentials((Credentials)NoCredentials.getInstance())).build();
    }

    private long getHeaderLatencyMetric(MetricData metricData, String methodName) {
        return metricData.getLongSumData().getPoints().stream().filter(x -> x.getAttributes().asMap().containsValue(methodName)).findFirst().get().getValue();
    }

    private double getGfeLatencyMetric(MetricData metricData, String methodName) {
        return metricData.getHistogramData().getPoints().stream().filter(x -> x.getAttributes().asMap().containsValue(methodName)).findFirst().get().getMax();
    }

    private MetricData getMetricData(String metricName, InMemoryMetricReader inMemoryMetricReader) {
        Collection metricDataCollection = inMemoryMetricReader.collectAllMetrics();
        Collection metricDataFiltered = metricDataCollection.stream().filter(x -> x.getName().equals(metricName)).collect(Collectors.toList());
        return (MetricData)metricDataFiltered.stream().findFirst().get();
    }

    static {
        optionsMap = new HashMap<SpannerRpc.Option, Object>();
        instanceId = "fake-instance";
        databaseId = "fake-database";
        projectId = "fake-project";
        fakeServerTiming = new AtomicInteger(new Random().nextInt(1000) + 1);
        SELECT1AND2 = Statement.of((String)"SELECT 1 AS COL1 UNION ALL SELECT 2 AS COL1");
        SELECT1AND2_METADATA = ResultSetMetadata.newBuilder().setRowType(StructType.newBuilder().addFields(StructType.Field.newBuilder().setName("COL1").setType(Type.newBuilder().setCode(TypeCode.INT64).build()).build()).build()).build();
        SELECT1_RESULTSET = ResultSet.newBuilder().addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("1").build()).build()).addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("2").build()).build()).setMetadata(SELECT1AND2_METADATA).build();
        UPDATE_FOO_STATEMENT = Statement.of((String)"UPDATE FOO SET BAR=1 WHERE BAZ=2");
    }
}

