/*
 * Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

-- Test valid values
-- Null (no timeout)
SET STATEMENT_TIMEOUT=default;
@EXPECT RESULT_SET 'STATEMENT_TIMEOUT','0'
SHOW VARIABLE STATEMENT_TIMEOUT;

-- Seconds
SET STATEMENT_TIMEOUT='1s';
@EXPECT RESULT_SET 'STATEMENT_TIMEOUT','1s'
SHOW VARIABLE STATEMENT_TIMEOUT;
SET STATEMENT_TIMEOUT = '2s';
@EXPECT RESULT_SET 'STATEMENT_TIMEOUT','2s'
SHOW VARIABLE STATEMENT_TIMEOUT;

SET STATEMENT_TIMEOUT='1S';
@EXPECT RESULT_SET 'STATEMENT_TIMEOUT','1s'
SHOW VARIABLE STATEMENT_TIMEOUT;

-- Milliseconds
SET STATEMENT_TIMEOUT='1ms';
@EXPECT RESULT_SET 'STATEMENT_TIMEOUT','1ms'
SHOW VARIABLE STATEMENT_TIMEOUT;

SET STATEMENT_TIMEOUT='1Ms';
@EXPECT RESULT_SET 'STATEMENT_TIMEOUT','1ms'
SHOW VARIABLE STATEMENT_TIMEOUT;

SET STATEMENT_TIMEOUT='1mS';
@EXPECT RESULT_SET 'STATEMENT_TIMEOUT','1ms'
SHOW VARIABLE STATEMENT_TIMEOUT;

SET STATEMENT_TIMEOUT='1MS';
@EXPECT RESULT_SET 'STATEMENT_TIMEOUT','1ms'
SHOW VARIABLE STATEMENT_TIMEOUT;

-- Microseconds
SET STATEMENT_TIMEOUT='1us';
@EXPECT RESULT_SET 'STATEMENT_TIMEOUT','1us'
SHOW VARIABLE STATEMENT_TIMEOUT;

SET STATEMENT_TIMEOUT='1Us';
@EXPECT RESULT_SET 'STATEMENT_TIMEOUT','1us'
SHOW VARIABLE STATEMENT_TIMEOUT;

SET STATEMENT_TIMEOUT='1uS';
@EXPECT RESULT_SET 'STATEMENT_TIMEOUT','1us'
SHOW VARIABLE STATEMENT_TIMEOUT;

SET STATEMENT_TIMEOUT='1US';
@EXPECT RESULT_SET 'STATEMENT_TIMEOUT','1us'
SHOW VARIABLE STATEMENT_TIMEOUT;

-- Nanoseconds
SET STATEMENT_TIMEOUT='1ns';
@EXPECT RESULT_SET 'STATEMENT_TIMEOUT','1ns'
SHOW VARIABLE STATEMENT_TIMEOUT;

SET STATEMENT_TIMEOUT='1Ns';
@EXPECT RESULT_SET 'STATEMENT_TIMEOUT','1ns'
SHOW VARIABLE STATEMENT_TIMEOUT;

SET STATEMENT_TIMEOUT='1nS';
@EXPECT RESULT_SET 'STATEMENT_TIMEOUT','1ns'
SHOW VARIABLE STATEMENT_TIMEOUT;

SET STATEMENT_TIMEOUT='1NS';
@EXPECT RESULT_SET 'STATEMENT_TIMEOUT','1ns'
SHOW VARIABLE STATEMENT_TIMEOUT;

-- Test flip to higher time unit
SET STATEMENT_TIMEOUT='1000ns';
@EXPECT RESULT_SET 'STATEMENT_TIMEOUT','1us'
SHOW VARIABLE STATEMENT_TIMEOUT;

SET STATEMENT_TIMEOUT='1001ns';
@EXPECT RESULT_SET 'STATEMENT_TIMEOUT','1001ns'
SHOW VARIABLE STATEMENT_TIMEOUT;

SET STATEMENT_TIMEOUT='1000us';
@EXPECT RESULT_SET 'STATEMENT_TIMEOUT','1ms'
SHOW VARIABLE STATEMENT_TIMEOUT;

SET STATEMENT_TIMEOUT='1001us';
@EXPECT RESULT_SET 'STATEMENT_TIMEOUT','1001us'
SHOW VARIABLE STATEMENT_TIMEOUT;

SET STATEMENT_TIMEOUT='1000000ns';
@EXPECT RESULT_SET 'STATEMENT_TIMEOUT','1ms'
SHOW VARIABLE STATEMENT_TIMEOUT;

SET STATEMENT_TIMEOUT='1000ms';
@EXPECT RESULT_SET 'STATEMENT_TIMEOUT','1s'
SHOW VARIABLE STATEMENT_TIMEOUT;

SET STATEMENT_TIMEOUT='1001ms';
@EXPECT RESULT_SET 'STATEMENT_TIMEOUT','1001ms'
SHOW VARIABLE STATEMENT_TIMEOUT;

SET STATEMENT_TIMEOUT='1000000000ns';
@EXPECT RESULT_SET 'STATEMENT_TIMEOUT','1s'
SHOW VARIABLE STATEMENT_TIMEOUT;

SET STATEMENT_TIMEOUT='1000000us';
@EXPECT RESULT_SET 'STATEMENT_TIMEOUT','1s'
SHOW VARIABLE STATEMENT_TIMEOUT;

-- No unit (milliseconds)
SET STATEMENT_TIMEOUT=1;
@EXPECT RESULT_SET 'STATEMENT_TIMEOUT','1ms'
SHOW VARIABLE STATEMENT_TIMEOUT;

SET STATEMENT_TIMEOUT=100;
@EXPECT RESULT_SET 'STATEMENT_TIMEOUT','100ms'
SHOW VARIABLE STATEMENT_TIMEOUT;

SET STATEMENT_TIMEOUT=10000;
@EXPECT RESULT_SET 'STATEMENT_TIMEOUT','10s'
SHOW VARIABLE STATEMENT_TIMEOUT;

-- Invalid suffixes
@EXPECT EXCEPTION INVALID_ARGUMENT
SET STATEMENT_TIMEOUT='1m';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET STATEMENT_TIMEOUT='1mi';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET STATEMENT_TIMEOUT='1h';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET STATEMENT_TIMEOUT='1mus';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET STATEMENT_TIMEOUT='1n';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET STATEMENT_TIMEOUT='1u';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET STATEMENT_TIMEOUT='1';

-- Invalid numbers
@EXPECT EXCEPTION INVALID_ARGUMENT
SET STATEMENT_TIMEOUT='-1s';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET STATEMENT_TIMEOUT='a1s';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET STATEMENT_TIMEOUT='0xas';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET STATEMENT_TIMEOUT='0x1s';

-- Invalid because of spaces
@EXPECT EXCEPTION INVALID_ARGUMENT
SET STATEMENT_TIMEOUT='1 s';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET STATEMENT_TIMEOUT=' 1s';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET STATEMENT_TIMEOUT='1s ';
@EXPECT EXCEPTION INVALID_ARGUMENT
SET STATEMENT_TIMEOUT='1m s';
