/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFutures;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.AsyncTransactionManagerImpl;
import com.google.cloud.spanner.CommitResponse;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.ISpan;
import com.google.cloud.spanner.OpenTelemetrySpan;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.SessionImpl;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.TransactionRunnerImpl;
import com.google.protobuf.ByteString;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Scope;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class AsyncTransactionManagerImplTest {
    @Mock
    private SessionImpl session;
    @Mock
    TransactionRunnerImpl.TransactionContextImpl transaction;

    @Test
    public void testCommitReturnsCommitStats() {
        Span oTspan = (Span)Mockito.mock(Span.class);
        OpenTelemetrySpan span = new OpenTelemetrySpan(oTspan);
        Mockito.when((Object)oTspan.makeCurrent()).thenReturn((Object)((Scope)Mockito.mock(Scope.class)));
        try (AsyncTransactionManagerImpl manager = new AsyncTransactionManagerImpl(this.session, (ISpan)span, new Options.TransactionOption[]{Options.commitStats()});){
            Mockito.when((Object)this.session.newTransaction((Options)ArgumentMatchers.eq((Object)Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[]{Options.commitStats()})), (ByteString)ArgumentMatchers.any())).thenReturn((Object)this.transaction);
            Mockito.when((Object)this.transaction.ensureTxnAsync()).thenReturn((Object)ApiFutures.immediateFuture(null));
            Timestamp commitTimestamp = Timestamp.ofTimeMicroseconds((long)1L);
            CommitResponse response = (CommitResponse)Mockito.mock(CommitResponse.class);
            Mockito.when((Object)response.getCommitTimestamp()).thenReturn((Object)commitTimestamp);
            Mockito.when((Object)this.transaction.commitAsync()).thenReturn((Object)ApiFutures.immediateFuture((Object)response));
            manager.beginAsync();
            manager.commitAsync();
            ((TransactionRunnerImpl.TransactionContextImpl)Mockito.verify((Object)this.transaction)).commitAsync();
        }
    }

    @Test
    public void testRetryUsesPreviousTransactionIdOnMultiplexedSession() {
        ByteString mockTransactionId = ByteString.copyFromUtf8((String)"mockTransactionId");
        ByteString mockPreviousTransactionId = ByteString.copyFromUtf8((String)"mockPreviousTransactionId");
        Span oTspan = (Span)Mockito.mock(Span.class);
        OpenTelemetrySpan span = new OpenTelemetrySpan(oTspan);
        Mockito.when((Object)oTspan.makeCurrent()).thenReturn((Object)((Scope)Mockito.mock(Scope.class)));
        Mockito.when((Object)this.session.getIsMultiplexed()).thenReturn((Object)true);
        this.transaction = (TransactionRunnerImpl.TransactionContextImpl)Mockito.mock(TransactionRunnerImpl.TransactionContextImpl.class);
        Mockito.when((Object)this.transaction.ensureTxnAsync()).thenReturn((Object)ApiFutures.immediateFuture(null));
        Mockito.when((Object)this.session.newTransaction((Options)ArgumentMatchers.eq((Object)Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[]{Options.commitStats()})), (ByteString)ArgumentMatchers.any())).thenReturn((Object)this.transaction);
        ((TransactionRunnerImpl.TransactionContextImpl)Mockito.doThrow((Throwable[])new Throwable[]{SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.ABORTED, (String)"")}).when((Object)this.transaction)).commitAsync();
        try (AsyncTransactionManagerImpl manager = new AsyncTransactionManagerImpl(this.session, (ISpan)span, new Options.TransactionOption[]{Options.commitStats()});){
            manager.beginAsync();
            ((SessionImpl)Mockito.verify((Object)this.session)).newTransaction(Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[]{Options.commitStats()}), ByteString.EMPTY);
            Assert.assertThrows(AbortedException.class, () -> ((AsyncTransactionManagerImpl)manager).commitAsync());
            Mockito.clearInvocations((Object[])new SessionImpl[]{this.session});
            Mockito.when((Object)this.transaction.getPreviousTransactionId()).thenReturn((Object)mockPreviousTransactionId);
            manager.resetForRetryAsync();
            ((SessionImpl)Mockito.verify((Object)this.session)).newTransaction(Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[]{Options.commitStats()}), mockPreviousTransactionId);
            Assert.assertThrows(AbortedException.class, () -> ((AsyncTransactionManagerImpl)manager).commitAsync());
            Mockito.clearInvocations((Object[])new SessionImpl[]{this.session});
            this.transaction.transactionId = mockTransactionId;
            manager.resetForRetryAsync();
            ((SessionImpl)Mockito.verify((Object)this.session)).newTransaction(Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[]{Options.commitStats()}), mockTransactionId);
            Mockito.when((Object)this.transaction.rollbackAsync()).thenReturn((Object)ApiFutures.immediateFuture(null));
            manager.closeAsync();
        }
    }
}

