/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.BuiltInOpenTelemetryMetricsProvider;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BuiltInOpenTelemetryMetricsProviderTest {
    @Test
    public void testGenerateClientHashWithSimpleUid() {
        String clientUid = "testClient";
        this.verifyHash(BuiltInOpenTelemetryMetricsProvider.generateClientHash((String)clientUid));
    }

    @Test
    public void testGenerateClientHashWithEmptyUid() {
        String clientUid = "";
        this.verifyHash(BuiltInOpenTelemetryMetricsProvider.generateClientHash((String)clientUid));
    }

    @Test
    public void testGenerateClientHashWithNullUid() {
        String clientUid = null;
        this.verifyHash(BuiltInOpenTelemetryMetricsProvider.generateClientHash(clientUid));
    }

    @Test
    public void testGenerateClientHashWithLongUid() {
        String clientUid = "aVeryLongUniqueClientIdentifierThatIsUnusuallyLong";
        this.verifyHash(BuiltInOpenTelemetryMetricsProvider.generateClientHash((String)clientUid));
    }

    @Test
    public void testGenerateClientHashWithSpecialCharacters() {
        String clientUid = "273d60f2-5604-42f1-b687-f5f1b975fd07@2316645@test#";
        this.verifyHash(BuiltInOpenTelemetryMetricsProvider.generateClientHash((String)clientUid));
    }

    private void verifyHash(String hash) {
        Assert.assertEquals((long)hash.length(), (long)6L);
        long hashValue = Long.parseLong(hash, 16);
        Assert.assertTrue((hashValue >= 0L && hashValue <= 1023L ? 1 : 0) != 0);
    }
}

