/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.ListValue;
import com.google.protobuf.Value;
import com.google.spanner.v1.ResultSetMetadata;
import com.google.spanner.v1.SpannerGrpc;
import com.google.spanner.v1.StructType;
import com.google.spanner.v1.Type;
import com.google.spanner.v1.TypeCode;
import io.grpc.Attributes;
import io.grpc.BindableService;
import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.Grpc;
import io.grpc.Metadata;
import io.grpc.Server;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ChannelUsageTest {
    @Parameterized.Parameter(value=0)
    public int numChannels;
    @Parameterized.Parameter(value=1)
    public boolean enableGcpPool;
    private static final Statement SELECT1 = Statement.of((String)"SELECT 1 AS COL1");
    private static final ResultSetMetadata SELECT1_METADATA = ResultSetMetadata.newBuilder().setRowType(StructType.newBuilder().addFields(StructType.Field.newBuilder().setName("COL1").setType(Type.newBuilder().setCode(TypeCode.INT64).build()).build()).build()).build();
    private static final com.google.spanner.v1.ResultSet SELECT1_RESULTSET = com.google.spanner.v1.ResultSet.newBuilder().addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("1").build()).build()).setMetadata(SELECT1_METADATA).build();
    private static MockSpannerServiceImpl mockSpanner;
    private static Server server;
    private static InetSocketAddress address;
    private static final Set<InetSocketAddress> batchCreateSessionLocalIps;
    private static final Set<InetSocketAddress> executeSqlLocalIps;
    private static Level originalLogLevel;

    @Parameterized.Parameters(name="num channels = {0}, enable GCP pool = {1}")
    public static Collection<Object[]> data() {
        return Arrays.asList({1, true}, {1, false}, {2, true}, {2, false}, {4, true}, {4, false});
    }

    @BeforeClass
    public static void startServer() throws IOException {
        mockSpanner = new MockSpannerServiceImpl();
        mockSpanner.setAbortProbability(0.0);
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(SELECT1, SELECT1_RESULTSET));
        address = new InetSocketAddress("localhost", 0);
        server = ((NettyServerBuilder)((NettyServerBuilder)NettyServerBuilder.forAddress((SocketAddress)address).addService((BindableService)mockSpanner)).intercept(new ServerInterceptor(){

            public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
                Assert.assertEquals((Object)"gzip", (Object)headers.get(Metadata.Key.of((String)"x-response-encoding", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER)));
                Attributes attributes = call.getAttributes();
                Attributes.Key key = attributes.keys().stream().filter(k -> k.equals(Grpc.TRANSPORT_ATTR_REMOTE_ADDR)).findFirst().orElse(null);
                if (key != null) {
                    if (call.getMethodDescriptor().equals(SpannerGrpc.getBatchCreateSessionsMethod())) {
                        batchCreateSessionLocalIps.add((InetSocketAddress)attributes.get(key));
                    }
                    if (call.getMethodDescriptor().equals(SpannerGrpc.getExecuteStreamingSqlMethod())) {
                        executeSqlLocalIps.add((InetSocketAddress)attributes.get(key));
                    }
                }
                return Contexts.interceptCall((Context)Context.current(), call, (Metadata)headers, next);
            }
        })).build().start();
    }

    @AfterClass
    public static void stopServer() throws InterruptedException {
        server.shutdown();
        server.awaitTermination();
    }

    @BeforeClass
    public static void disableLogging() {
        Logger logger = Logger.getLogger("");
        originalLogLevel = logger.getLevel();
        logger.setLevel(Level.OFF);
    }

    @AfterClass
    public static void resetLogging() {
        Logger logger = Logger.getLogger("");
        logger.setLevel(originalLogLevel);
    }

    @After
    public void reset() {
        mockSpanner.reset();
        batchCreateSessionLocalIps.clear();
        executeSqlLocalIps.clear();
    }

    private SpannerOptions createSpannerOptions() {
        String endpoint = address.getHostString() + ":" + server.getPort();
        SpannerOptions.Builder builder = (SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("[PROJECT]")).setChannelConfigurator(input -> {
            input.usePlaintext();
            return input;
        }).setNumChannels(this.numChannels).setCompressorName("gzip").setSessionPoolOption(SessionPoolOptions.newBuilder().setMinSessions(this.numChannels * 2).setMaxSessions(this.numChannels * 2).build()).setHost("http://" + endpoint).setCredentials((Credentials)NoCredentials.getInstance());
        if (this.enableGcpPool) {
            builder.enableGrpcGcpExtension();
        }
        return builder.build();
    }

    @Test
    public void testCreatesNumChannels() {
        try (Spanner spanner = (Spanner)this.createSpannerOptions().getService();){
            Assume.assumeFalse((String)"GRPC-GCP is currently not supported with multiplexed sessions", (this.isMultiplexedSessionsEnabled(spanner) && this.enableGcpPool ? 1 : 0) != 0);
            DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
            try (ResultSet resultSet = client.singleUse().executeQuery(SELECT1, new Options.QueryOption[0]);){
                while (resultSet.next()) {
                }
            }
        }
        Assert.assertEquals((long)this.numChannels, (long)batchCreateSessionLocalIps.size());
    }

    @Test
    public void testUsesAllChannels() throws InterruptedException {
        int multiplier = 2;
        try (Spanner spanner = (Spanner)this.createSpannerOptions().getService();){
            Assume.assumeFalse((String)"GRPC-GCP is currently not supported with multiplexed sessions", (boolean)this.isMultiplexedSessionsEnabled(spanner));
            DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
            ListeningExecutorService executor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(this.numChannels * 2));
            CountDownLatch latch = new CountDownLatch(this.numChannels * 2);
            for (int run = 0; run < this.numChannels * 2; ++run) {
                executor.submit(() -> {
                    try (ReadOnlyTransaction transaction = client.readOnlyTransaction();){
                        try (ResultSet resultSet = transaction.executeQuery(SELECT1, new Options.QueryOption[0]);){
                            while (resultSet.next()) {
                            }
                        }
                        latch.countDown();
                        latch.await();
                        resultSet = transaction.executeQuery(SELECT1, new Options.QueryOption[0]);
                        try {
                            while (resultSet.next()) {
                            }
                        }
                        finally {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                        }
                    }
                    return true;
                });
            }
            executor.shutdown();
            Assert.assertTrue((boolean)executor.awaitTermination(Duration.ofSeconds(10L)));
        }
        Assert.assertEquals((long)this.numChannels, (long)executeSqlLocalIps.size());
    }

    private boolean isMultiplexedSessionsEnabled(Spanner spanner) {
        if (spanner.getOptions() == null || ((SpannerOptions)spanner.getOptions()).getSessionPoolOptions() == null) {
            return false;
        }
        return ((SpannerOptions)spanner.getOptions()).getSessionPoolOptions().getUseMultiplexedSession();
    }

    static {
        batchCreateSessionLocalIps = ConcurrentHashMap.newKeySet();
        executeSqlLocalIps = ConcurrentHashMap.newKeySet();
    }
}

