/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.BatchClient;
import com.google.cloud.spanner.BatchReadOnlyTransaction;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerImpl;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.connection.AbstractMockServerTest;
import com.google.cloud.spanner.spi.v1.GapicSpannerRpc;
import com.google.common.base.Predicate;
import com.google.protobuf.AbstractMessage;
import com.google.spanner.v1.DeleteSessionRequest;
import com.google.spanner.v1.ExecuteSqlRequest;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Status;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class CloseSpannerWithOpenResultSetTest
extends AbstractMockServerTest {
    Spanner createSpanner() {
        return (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("p")).setHost(String.format("http://localhost:%d", this.getPort())).setChannelConfigurator(ManagedChannelBuilder::usePlaintext).setCredentials((Credentials)NoCredentials.getInstance())).setSessionPoolOption(SessionPoolOptions.newBuilder().setWaitForMinSessions(Duration.ofSeconds((long)5L)).build()).build().getService();
    }

    @BeforeClass
    public static void setWatchdogTimeout() {
        System.setProperty("com.google.cloud.spanner.watchdogTimeoutSeconds", "1");
    }

    @AfterClass
    public static void clearWatchdogTimeout() {
        System.clearProperty("com.google.cloud.spanner.watchdogTimeoutSeconds");
    }

    @After
    public void cleanup() {
        mockSpanner.unfreeze();
        mockSpanner.clearRequests();
    }

    @Test
    public void testBatchClient_closedSpannerWithOpenResultSet_streamsAreCancelled() {
        Spanner spanner = this.createSpanner();
        Assume.assumeFalse((boolean)((SpannerOptions)spanner.getOptions()).getSessionPoolOptions().getUseMultiplexedSession());
        BatchClient client = spanner.getBatchClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
        BatchReadOnlyTransaction transaction = client.batchReadOnlyTransaction(TimestampBound.strong());
        try {
            ResultSet resultSet = transaction.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]);
            try {
                mockSpanner.freezeAfterReturningNumRows(1);
                try {
                    Assert.assertTrue((boolean)resultSet.next());
                }
                catch (SpannerException exception) {
                    Assert.assertEquals((Object)ErrorCode.DEADLINE_EXCEEDED, (Object)exception.getErrorCode());
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (transaction != null) {
                        transaction.close();
                    }
                    return;
                }
                ((SpannerImpl)spanner).close(1L, TimeUnit.MILLISECONDS);
                SpannerException exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> {
                    while (resultSet.next()) {
                    }
                });
                Assert.assertEquals((Object)ErrorCode.CANCELLED, (Object)exception.getErrorCode());
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        throwable2.addSuppressed(throwable);
                    }
                }
            }
        }
        finally {
            if (transaction != null) {
                try {
                    transaction.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable3;
                    throwable3.addSuppressed(throwable);
                }
            }
        }
    }

    @Test
    public void testNormalDatabaseClient_closedSpannerWithOpenResultSet_sessionsAreDeleted() throws Exception {
        Spanner spanner = this.createSpanner();
        Assume.assumeFalse((boolean)((SpannerOptions)spanner.getOptions()).getSessionPoolOptions().getUseMultiplexedSession());
        DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
        ReadOnlyTransaction transaction = client.readOnlyTransaction(TimestampBound.strong());
        try {
            ResultSet resultSet = transaction.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]);
            try {
                mockSpanner.freezeAfterReturningNumRows(1);
                try {
                    Assert.assertTrue((boolean)resultSet.next());
                }
                catch (SpannerException exception) {
                    Assert.assertEquals((Object)ErrorCode.DEADLINE_EXCEEDED, (Object)exception.getErrorCode());
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (transaction != null) {
                        transaction.close();
                    }
                    return;
                }
                List executeSqlRequests = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).stream().filter(request -> request.getSql().equals(SELECT_RANDOM_STATEMENT.getSql())).collect(Collectors.toList());
                Assert.assertEquals((long)1L, (long)executeSqlRequests.size());
                ExecutorService service = Executors.newSingleThreadExecutor();
                service.submit(() -> ((Spanner)spanner).close());
                mockSpanner.waitForRequestsToContain((Predicate<? super AbstractMessage>)((Predicate)request -> request instanceof DeleteSessionRequest && ((DeleteSessionRequest)request).getName().equals(((ExecuteSqlRequest)executeSqlRequests.get(0)).getSession())), 1000L);
                service.shutdownNow();
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        throwable2.addSuppressed(throwable);
                    }
                }
            }
        }
        finally {
            if (transaction != null) {
                try {
                    transaction.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable3;
                    throwable3.addSuppressed(throwable);
                }
            }
        }
    }

    @Test
    public void testStreamsAreCleanedUp() throws Exception {
        String invalidSql = "select * from foo";
        Statement invalidStatement = Statement.of((String)invalidSql);
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.exception(invalidStatement, Status.NOT_FOUND.withDescription("Table not found: foo").asRuntimeException()));
        int numThreads = 16;
        int numQueries = 32;
        try (Spanner spanner = this.createSpanner();){
            BatchClient client = spanner.getBatchClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
            ExecutorService service = Executors.newFixedThreadPool(numThreads);
            ArrayList futures = new ArrayList(numQueries);
            for (int n = 0; n < numQueries; ++n) {
                futures.add(service.submit(() -> {
                    block20: {
                        try (BatchReadOnlyTransaction transaction = client.batchReadOnlyTransaction(TimestampBound.strong());){
                            if (ThreadLocalRandom.current().nextInt(10) < 2) {
                                try (ResultSet resultSet = transaction.executeQuery(invalidStatement, new Options.QueryOption[0]);){
                                    SpannerException exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> ((ResultSet)resultSet).next());
                                    Assert.assertEquals((Object)ErrorCode.NOT_FOUND, (Object)exception.getErrorCode());
                                    break block20;
                                }
                            }
                            try (ResultSet resultSet = transaction.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]);){
                                while (resultSet.next()) {
                                    Assert.assertNotNull((Object)resultSet.getCurrentRowAsStruct());
                                }
                            }
                        }
                    }
                }));
            }
            service.shutdown();
            for (Future future : futures) {
                future.get();
            }
            Assert.assertTrue((boolean)service.awaitTermination(1L, TimeUnit.MINUTES));
            Assert.assertEquals((long)0L, (long)((GapicSpannerRpc)((SpannerImpl)spanner).getRpc()).getNumActiveResponseObservers());
        }
    }
}

