/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.AbstractMockServerTest;
import com.google.cloud.spanner.AsyncRunner;
import com.google.cloud.spanner.AsyncTransactionManager;
import com.google.cloud.spanner.CommitResponse;
import com.google.cloud.spanner.DatabaseClientImpl;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.MockSpannerTestUtil;
import com.google.cloud.spanner.MultiplexedSessionDatabaseClient;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.SessionReference;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionManager;
import com.google.cloud.spanner.TransactionRunner;
import com.google.cloud.spanner.TransactionRunnerImpl;
import com.google.cloud.spanner.connection.RandomResultSetGenerator;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.ByteString;
import com.google.spanner.v1.BeginTransactionRequest;
import com.google.spanner.v1.CommitRequest;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.RequestOptions;
import com.google.spanner.v1.Session;
import io.grpc.Status;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class MultiplexedSessionDatabaseClientMockServerTest
extends AbstractMockServerTest {
    private static final Statement STATEMENT = Statement.of((String)"select * from random");

    @BeforeClass
    public static void setupResults() {
        mockSpanner.putStatementResults(MockSpannerServiceImpl.StatementResult.query(STATEMENT, new RandomResultSetGenerator(1).generate()));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(MockSpannerTestUtil.UPDATE_STATEMENT, 1L));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.exception(MockSpannerTestUtil.INVALID_UPDATE_STATEMENT, Status.INVALID_ARGUMENT.withDescription("invalid statement").asRuntimeException()));
    }

    @Override
    @Before
    public void createSpannerInstance() {
        this.spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("test-project")).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).setSessionPoolOption(SessionPoolOptions.newBuilder().setUseMultiplexedSession(true).setUseMultiplexedSessionBlindWrite(true).setUseMultiplexedSessionForRW(true).setMultiplexedSessionMaintenanceLoopFrequency(java.time.Duration.ofMillis(1L)).setMultiplexedSessionMaintenanceDuration(Duration.ofMillis((long)1L)).setFailOnSessionLeak().build()).build().getService();
    }

    @Test
    public void testMultiUseReadOnlyTransactionUsesSameSession() {
        DatabaseClientImpl client = (DatabaseClientImpl)this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
        try (ReadOnlyTransaction transaction = client.readOnlyTransaction();){
            try (ResultSet resultSet = transaction.executeQuery(STATEMENT, new Options.QueryOption[0]);){
                while (resultSet.next()) {
                }
            }
            this.waitForSessionToBeReplaced(client);
            resultSet = transaction.executeQuery(STATEMENT, new Options.QueryOption[0]);
            try {
                while (resultSet.next()) {
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
        List<ExecuteSqlRequest> requests = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class);
        Assert.assertEquals((long)2L, (long)requests.size());
        Assert.assertEquals((Object)requests.get(0).getSession(), (Object)requests.get(1).getSession());
        Assert.assertNotNull((Object)client.multiplexedSessionDatabaseClient);
        Assert.assertEquals((long)1L, (long)client.multiplexedSessionDatabaseClient.getNumSessionsAcquired().get());
        Assert.assertEquals((long)1L, (long)client.multiplexedSessionDatabaseClient.getNumSessionsReleased().get());
    }

    @Test
    public void testNewTransactionUsesNewSession() {
        DatabaseClientImpl client = (DatabaseClientImpl)this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
        try (ResultSet resultSet = client.singleUse().executeQuery(STATEMENT, new Options.QueryOption[0]);){
            while (resultSet.next()) {
            }
        }
        this.waitForSessionToBeReplaced(client);
        resultSet = client.singleUse().executeQuery(STATEMENT, new Options.QueryOption[0]);
        try {
            while (resultSet.next()) {
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        List<ExecuteSqlRequest> requests = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class);
        Assert.assertEquals((long)2L, (long)requests.size());
        Assert.assertNotEquals((Object)requests.get(0).getSession(), (Object)requests.get(1).getSession());
        Assert.assertNotNull((Object)client.multiplexedSessionDatabaseClient);
        Assert.assertEquals((long)2L, (long)client.multiplexedSessionDatabaseClient.getNumSessionsAcquired().get());
        Assert.assertEquals((long)2L, (long)client.multiplexedSessionDatabaseClient.getNumSessionsReleased().get());
    }

    @Test
    public void testMaintainerMaintainsMultipleClients() {
        DatabaseClientImpl client1 = (DatabaseClientImpl)this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)("d" + UUID.randomUUID())));
        DatabaseClientImpl client2 = (DatabaseClientImpl)this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)("d" + UUID.randomUUID())));
        for (DatabaseClientImpl client : ImmutableList.of((Object)client1, (Object)client2)) {
            try (ResultSet resultSet = client.singleUse().executeQuery(STATEMENT, new Options.QueryOption[0]);){
                while (resultSet.next()) {
                }
            }
            this.waitForSessionToBeReplaced(client);
            resultSet = client.singleUse().executeQuery(STATEMENT, new Options.QueryOption[0]);
            try {
                while (resultSet.next()) {
                }
            }
            finally {
                if (resultSet == null) continue;
                resultSet.close();
            }
        }
        List<ExecuteSqlRequest> requests = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class);
        Assert.assertEquals((long)4L, (long)requests.size());
        Set sessionIds = requests.stream().map(ExecuteSqlRequest::getSession).collect(Collectors.toSet());
        Assert.assertEquals((long)4L, (long)sessionIds.size());
        for (DatabaseClientImpl client : ImmutableList.of((Object)client1, (Object)client2)) {
            Assert.assertNotNull((Object)client.multiplexedSessionDatabaseClient);
            Assert.assertEquals((long)2L, (long)client.multiplexedSessionDatabaseClient.getNumSessionsAcquired().get());
            Assert.assertEquals((long)2L, (long)client.multiplexedSessionDatabaseClient.getNumSessionsReleased().get());
        }
    }

    @Test
    public void testUnimplementedErrorOnCreation_fallsBackToRegularSessions() {
        mockSpanner.setCreateSessionExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)((Object)Status.UNIMPLEMENTED.withDescription("Multiplexed sessions are not implemented").asRuntimeException())));
        DatabaseClientImpl client = (DatabaseClientImpl)this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
        Assert.assertNotNull((Object)client.multiplexedSessionDatabaseClient);
        SpannerException spannerException = (SpannerException)Assert.assertThrows(SpannerException.class, () -> ((MultiplexedSessionDatabaseClient)client.multiplexedSessionDatabaseClient).getCurrentSessionReference());
        Assert.assertEquals((Object)ErrorCode.UNIMPLEMENTED, (Object)spannerException.getErrorCode());
        try (ResultSet resultSet = client.singleUse().executeQuery(STATEMENT, new Options.QueryOption[0]);){
            while (resultSet.next()) {
            }
        }
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        List<ExecuteSqlRequest> requests = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class);
        Session session = mockSpanner.getSession(requests.get(0).getSession());
        Assert.assertNotNull((Object)session);
        Assert.assertFalse((boolean)session.getMultiplexed());
        Assert.assertNotNull((Object)client.multiplexedSessionDatabaseClient);
        Assert.assertEquals((long)0L, (long)client.multiplexedSessionDatabaseClient.getNumSessionsAcquired().get());
        Assert.assertEquals((long)0L, (long)client.multiplexedSessionDatabaseClient.getNumSessionsReleased().get());
    }

    @Test
    public void testUnimplementedErrorOnCreation_firstReceivesError_secondFallsBackToRegularSessions() {
        mockSpanner.setCreateSessionExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)((Object)Status.UNIMPLEMENTED.withDescription("Multiplexed sessions are not implemented").asRuntimeException())));
        mockSpanner.freeze();
        DatabaseClientImpl client = (DatabaseClientImpl)this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
        try (ResultSet resultSet = client.singleUse().executeQuery(STATEMENT, new Options.QueryOption[0]);){
            mockSpanner.unfreeze();
            SpannerException spannerException = (SpannerException)Assert.assertThrows(SpannerException.class, () -> ((ResultSet)resultSet).next());
            Assert.assertEquals((Object)ErrorCode.UNIMPLEMENTED, (Object)spannerException.getErrorCode());
        }
        resultSet = client.singleUse().executeQuery(STATEMENT, new Options.QueryOption[0]);
        try {
            while (resultSet.next()) {
            }
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        List<ExecuteSqlRequest> requests = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class);
        Session session = mockSpanner.getSession(requests.get(0).getSession());
        Assert.assertNotNull((Object)session);
        Assert.assertFalse((boolean)session.getMultiplexed());
        Assert.assertNotNull((Object)client.multiplexedSessionDatabaseClient);
        Assert.assertEquals((long)0L, (long)client.multiplexedSessionDatabaseClient.getNumSessionsAcquired().get());
        Assert.assertEquals((long)0L, (long)client.multiplexedSessionDatabaseClient.getNumSessionsReleased().get());
    }

    @Test
    public void testMaintainerInvalidatesMultiplexedSessionClientIfUnimplemented() {
        DatabaseClientImpl client = (DatabaseClientImpl)this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
        try (ResultSet resultSet = client.singleUse().executeQuery(STATEMENT, new Options.QueryOption[0]);){
            while (resultSet.next()) {
            }
        }
        mockSpanner.setCreateSessionExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)((Object)Status.UNIMPLEMENTED.withDescription("Multiplexed sessions are not implemented").asRuntimeException())));
        Assert.assertNotNull((Object)client.multiplexedSessionDatabaseClient);
        Stopwatch stopwatch = Stopwatch.createStarted();
        while (client.multiplexedSessionDatabaseClient.isMultiplexedSessionsSupported() && stopwatch.elapsed().compareTo(java.time.Duration.ofSeconds(5L)) < 0) {
            Thread.yield();
        }
        try (ResultSet resultSet = client.singleUse().executeQuery(STATEMENT, new Options.QueryOption[0]);){
            while (resultSet.next()) {
            }
        }
        Assert.assertEquals((long)2L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        List<ExecuteSqlRequest> requests = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class);
        Session session1 = mockSpanner.getSession(requests.get(0).getSession());
        Assert.assertNotNull((Object)session1);
        Assert.assertTrue((boolean)session1.getMultiplexed());
        Session session2 = mockSpanner.getSession(requests.get(1).getSession());
        Assert.assertNotNull((Object)session2);
        Assert.assertFalse((boolean)session2.getMultiplexed());
        Assert.assertNotNull((Object)client.multiplexedSessionDatabaseClient);
        Assert.assertEquals((long)1L, (long)client.multiplexedSessionDatabaseClient.getNumSessionsAcquired().get());
        Assert.assertEquals((long)1L, (long)client.multiplexedSessionDatabaseClient.getNumSessionsReleased().get());
    }

    @Test
    public void testWriteAtLeastOnceAborted() {
        DatabaseClientImpl client = (DatabaseClientImpl)this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
        mockSpanner.setCommitExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)((Object)mockSpanner.createAbortedException(ByteString.copyFromUtf8((String)"test")))));
        Timestamp timestamp = client.writeAtLeastOnce(Collections.singletonList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"FOO").set("ID").to(1L)).set("NAME").to("Bar")).build()));
        Assert.assertNotNull((Object)timestamp);
        List<CommitRequest> commitRequests = mockSpanner.getRequestsOfType(CommitRequest.class);
        Assert.assertEquals((long)2L, (long)commitRequests.size());
        for (CommitRequest request : commitRequests) {
            Assert.assertTrue((boolean)mockSpanner.getSession(request.getSession()).getMultiplexed());
        }
        Assert.assertNotNull((Object)client.multiplexedSessionDatabaseClient);
        Assert.assertEquals((long)1L, (long)client.multiplexedSessionDatabaseClient.getNumSessionsAcquired().get());
        Assert.assertEquals((long)1L, (long)client.multiplexedSessionDatabaseClient.getNumSessionsReleased().get());
    }

    @Test
    public void testWriteAtLeastOnce() {
        DatabaseClientImpl client = (DatabaseClientImpl)this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
        Timestamp timestamp = client.writeAtLeastOnce(Collections.singletonList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"FOO").set("ID").to(1L)).set("NAME").to("Bar")).build()));
        Assert.assertNotNull((Object)timestamp);
        List<CommitRequest> commitRequests = mockSpanner.getRequestsOfType(CommitRequest.class);
        Truth.assertThat(commitRequests).hasSize(1);
        CommitRequest commit = commitRequests.get(0);
        Assert.assertNotNull((Object)commit.getSingleUseTransaction());
        Assert.assertTrue((boolean)commit.getSingleUseTransaction().hasReadWrite());
        Assert.assertFalse((boolean)commit.getSingleUseTransaction().getExcludeTxnFromChangeStreams());
        Assert.assertNotNull((Object)commit.getRequestOptions());
        Assert.assertEquals((Object)RequestOptions.Priority.PRIORITY_UNSPECIFIED, (Object)commit.getRequestOptions().getPriority());
        Assert.assertTrue((boolean)mockSpanner.getSession(commit.getSession()).getMultiplexed());
        Assert.assertNotNull((Object)client.multiplexedSessionDatabaseClient);
        Assert.assertEquals((long)1L, (long)client.multiplexedSessionDatabaseClient.getNumSessionsAcquired().get());
        Assert.assertEquals((long)1L, (long)client.multiplexedSessionDatabaseClient.getNumSessionsReleased().get());
    }

    @Test
    public void testWriteAtLeastOnceWithCommitStats() {
        DatabaseClientImpl client = (DatabaseClientImpl)this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
        CommitResponse response = client.writeAtLeastOnceWithOptions(Collections.singletonList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"FOO").set("ID").to(1L)).set("NAME").to("Bar")).build()), new Options.TransactionOption[]{Options.commitStats()});
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getCommitTimestamp());
        Assert.assertNotNull((Object)response.getCommitStats());
        List<CommitRequest> commitRequests = mockSpanner.getRequestsOfType(CommitRequest.class);
        Truth.assertThat(commitRequests).hasSize(1);
        CommitRequest commit = commitRequests.get(0);
        Assert.assertNotNull((Object)commit.getSingleUseTransaction());
        Assert.assertTrue((boolean)commit.getSingleUseTransaction().hasReadWrite());
        Assert.assertFalse((boolean)commit.getSingleUseTransaction().getExcludeTxnFromChangeStreams());
        Assert.assertNotNull((Object)commit.getRequestOptions());
        Assert.assertEquals((Object)RequestOptions.Priority.PRIORITY_UNSPECIFIED, (Object)commit.getRequestOptions().getPriority());
        Assert.assertTrue((boolean)mockSpanner.getSession(commit.getSession()).getMultiplexed());
        Assert.assertNotNull((Object)client.multiplexedSessionDatabaseClient);
        Assert.assertEquals((long)1L, (long)client.multiplexedSessionDatabaseClient.getNumSessionsAcquired().get());
        Assert.assertEquals((long)1L, (long)client.multiplexedSessionDatabaseClient.getNumSessionsReleased().get());
    }

    @Test
    public void testWriteAtLeastOnceWithOptions() {
        DatabaseClientImpl client = (DatabaseClientImpl)this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
        client.writeAtLeastOnceWithOptions(Collections.singletonList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"FOO").set("ID").to(1L)).set("NAME").to("Bar")).build()), new Options.TransactionOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.LOW)});
        List<CommitRequest> commitRequests = mockSpanner.getRequestsOfType(CommitRequest.class);
        Truth.assertThat(commitRequests).hasSize(1);
        CommitRequest commit = commitRequests.get(0);
        Assert.assertNotNull((Object)commit.getSingleUseTransaction());
        Assert.assertTrue((boolean)commit.getSingleUseTransaction().hasReadWrite());
        Assert.assertFalse((boolean)commit.getSingleUseTransaction().getExcludeTxnFromChangeStreams());
        Assert.assertNotNull((Object)commit.getRequestOptions());
        Assert.assertEquals((Object)RequestOptions.Priority.PRIORITY_LOW, (Object)commit.getRequestOptions().getPriority());
        Assert.assertTrue((boolean)mockSpanner.getSession(commit.getSession()).getMultiplexed());
        Assert.assertNotNull((Object)client.multiplexedSessionDatabaseClient);
        Assert.assertEquals((long)1L, (long)client.multiplexedSessionDatabaseClient.getNumSessionsAcquired().get());
        Assert.assertEquals((long)1L, (long)client.multiplexedSessionDatabaseClient.getNumSessionsReleased().get());
    }

    @Test
    public void testWriteAtLeastOnceWithTagOptions() {
        DatabaseClientImpl client = (DatabaseClientImpl)this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
        client.writeAtLeastOnceWithOptions(Collections.singletonList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"FOO").set("ID").to(1L)).set("NAME").to("Bar")).build()), new Options.TransactionOption[]{Options.tag((String)"app=spanner,env=test")});
        List<CommitRequest> commitRequests = mockSpanner.getRequestsOfType(CommitRequest.class);
        Truth.assertThat(commitRequests).hasSize(1);
        CommitRequest commit = commitRequests.get(0);
        Assert.assertNotNull((Object)commit.getSingleUseTransaction());
        Assert.assertTrue((boolean)commit.getSingleUseTransaction().hasReadWrite());
        Assert.assertFalse((boolean)commit.getSingleUseTransaction().getExcludeTxnFromChangeStreams());
        Assert.assertNotNull((Object)commit.getRequestOptions());
        Truth.assertThat((String)commit.getRequestOptions().getTransactionTag()).isEqualTo((Object)"app=spanner,env=test");
        Truth.assertThat((String)commit.getRequestOptions().getRequestTag()).isEmpty();
        Assert.assertTrue((boolean)mockSpanner.getSession(commit.getSession()).getMultiplexed());
        Assert.assertNotNull((Object)client.multiplexedSessionDatabaseClient);
        Assert.assertEquals((long)1L, (long)client.multiplexedSessionDatabaseClient.getNumSessionsAcquired().get());
        Assert.assertEquals((long)1L, (long)client.multiplexedSessionDatabaseClient.getNumSessionsReleased().get());
    }

    @Test
    public void testWriteAtLeastOnceWithExcludeTxnFromChangeStreams() {
        DatabaseClientImpl client = (DatabaseClientImpl)this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
        client.writeAtLeastOnceWithOptions(Collections.singletonList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"FOO").set("ID").to(1L)).set("NAME").to("Bar")).build()), new Options.TransactionOption[]{Options.excludeTxnFromChangeStreams()});
        List<CommitRequest> commitRequests = mockSpanner.getRequestsOfType(CommitRequest.class);
        Truth.assertThat(commitRequests).hasSize(1);
        CommitRequest commit = commitRequests.get(0);
        Assert.assertNotNull((Object)commit.getSingleUseTransaction());
        Assert.assertTrue((boolean)commit.getSingleUseTransaction().hasReadWrite());
        Assert.assertTrue((boolean)commit.getSingleUseTransaction().getExcludeTxnFromChangeStreams());
        Assert.assertTrue((boolean)mockSpanner.getSession(commit.getSession()).getMultiplexed());
        Assert.assertNotNull((Object)client.multiplexedSessionDatabaseClient);
        Assert.assertEquals((long)1L, (long)client.multiplexedSessionDatabaseClient.getNumSessionsAcquired().get());
        Assert.assertEquals((long)1L, (long)client.multiplexedSessionDatabaseClient.getNumSessionsReleased().get());
    }

    @Test
    public void testReadWriteTransactionUsingTransactionRunner() {
        DatabaseClientImpl client = (DatabaseClientImpl)this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
        mockSpanner.setCommitExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)((Object)mockSpanner.createAbortedException(ByteString.copyFromUtf8((String)"test")))));
        client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
            try (ResultSet resultSet = transaction.executeQuery(STATEMENT, new Options.QueryOption[0]);){
                while (resultSet.next()) {
                }
            }
            return null;
        });
        List<ExecuteSqlRequest> executeSqlRequests = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class);
        Assert.assertEquals((long)2L, (long)executeSqlRequests.size());
        Assert.assertEquals((Object)executeSqlRequests.get(0).getSession(), (Object)executeSqlRequests.get(1).getSession());
        for (ExecuteSqlRequest request : executeSqlRequests) {
            Assert.assertTrue((boolean)mockSpanner.getSession(request.getSession()).getMultiplexed());
        }
        Assert.assertNotNull((Object)client.multiplexedSessionDatabaseClient);
        Assert.assertEquals((long)1L, (long)client.multiplexedSessionDatabaseClient.getNumSessionsAcquired().get());
        Assert.assertEquals((long)1L, (long)client.multiplexedSessionDatabaseClient.getNumSessionsReleased().get());
    }

    @Test
    public void testReadWriteTransactionUsingTransactionManager() {
        DatabaseClientImpl client = (DatabaseClientImpl)this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
        mockSpanner.setCommitExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)((Object)mockSpanner.createAbortedException(ByteString.copyFromUtf8((String)"test")))));
        try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[0]);){
            TransactionContext transaction = manager.begin();
            while (true) {
                try {
                    try (ResultSet resultSet = transaction.executeQuery(STATEMENT, new Options.QueryOption[0]);){
                        while (resultSet.next()) {
                        }
                    }
                    manager.commit();
                    Assert.assertNotNull((Object)manager.getCommitTimestamp());
                }
                catch (AbortedException e) {
                    transaction = manager.resetForRetry();
                    continue;
                }
                break;
            }
        }
        List<ExecuteSqlRequest> executeSqlRequests = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class);
        Assert.assertEquals((long)2L, (long)executeSqlRequests.size());
        Assert.assertEquals((Object)executeSqlRequests.get(0).getSession(), (Object)executeSqlRequests.get(1).getSession());
        for (ExecuteSqlRequest request : executeSqlRequests) {
            Assert.assertTrue((boolean)mockSpanner.getSession(request.getSession()).getMultiplexed());
        }
        Assert.assertNotNull((Object)client.multiplexedSessionDatabaseClient);
        Assert.assertEquals((long)1L, (long)client.multiplexedSessionDatabaseClient.getNumSessionsAcquired().get());
        Assert.assertEquals((long)1L, (long)client.multiplexedSessionDatabaseClient.getNumSessionsReleased().get());
    }

    @Test
    public void testMutationUsingWrite() {
        DatabaseClientImpl client = (DatabaseClientImpl)this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
        mockSpanner.setCommitExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)((Object)mockSpanner.createAbortedException(ByteString.copyFromUtf8((String)"test")))));
        Timestamp timestamp = client.write(Collections.singletonList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"FOO").set("ID").to(1L)).set("NAME").to("Bar")).build()));
        Assert.assertNotNull((Object)timestamp);
        List<CommitRequest> commitRequests = mockSpanner.getRequestsOfType(CommitRequest.class);
        Assert.assertEquals((long)2L, (long)commitRequests.size());
        for (CommitRequest request : commitRequests) {
            Assert.assertTrue((boolean)mockSpanner.getSession(request.getSession()).getMultiplexed());
        }
        Assert.assertNotNull((Object)client.multiplexedSessionDatabaseClient);
        Assert.assertEquals((long)1L, (long)client.multiplexedSessionDatabaseClient.getNumSessionsAcquired().get());
        Assert.assertEquals((long)1L, (long)client.multiplexedSessionDatabaseClient.getNumSessionsReleased().get());
    }

    @Test
    public void testMutationUsingWriteWithOptions() {
        DatabaseClientImpl client = (DatabaseClientImpl)this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
        CommitResponse response = client.writeWithOptions(Collections.singletonList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"FOO").set("ID").to(1L)).set("NAME").to("Bar")).build()), new Options.TransactionOption[]{Options.tag((String)"app=spanner,env=test")});
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getCommitTimestamp());
        List<CommitRequest> commitRequests = mockSpanner.getRequestsOfType(CommitRequest.class);
        Assert.assertEquals((long)1L, (long)commitRequests.size());
        CommitRequest commit = commitRequests.get(0);
        Assert.assertNotNull((Object)commit.getRequestOptions());
        Assert.assertEquals((Object)"app=spanner,env=test", (Object)commit.getRequestOptions().getTransactionTag());
        Assert.assertTrue((boolean)mockSpanner.getSession(commit.getSession()).getMultiplexed());
        Assert.assertNotNull((Object)client.multiplexedSessionDatabaseClient);
        Assert.assertEquals((long)1L, (long)client.multiplexedSessionDatabaseClient.getNumSessionsAcquired().get());
        Assert.assertEquals((long)1L, (long)client.multiplexedSessionDatabaseClient.getNumSessionsReleased().get());
    }

    @Test
    public void testReadWriteTransactionUsingAsyncTransactionManager() throws Exception {
        AtomicInteger attempt = new AtomicInteger();
        CountDownLatch abortedLatch = new CountDownLatch(1);
        DatabaseClientImpl client = (DatabaseClientImpl)this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
        try (AsyncTransactionManager manager = client.transactionManagerAsync(new Options.TransactionOption[0]);){
            AsyncTransactionManager.TransactionContextFuture transactionContextFuture = manager.beginAsync();
            while (true) {
                try {
                    attempt.incrementAndGet();
                    AsyncTransactionManager.AsyncTransactionStep updateCount = transactionContextFuture.then((transaction, ignored) -> transaction.executeUpdateAsync(MockSpannerTestUtil.UPDATE_STATEMENT, new Options.UpdateOption[0]), MoreExecutors.directExecutor());
                    updateCount.then((transaction, ignored) -> {
                        if (attempt.get() == 1) {
                            mockSpanner.abortTransaction(transaction);
                            abortedLatch.countDown();
                        }
                        return ApiFutures.immediateFuture(null);
                    }, MoreExecutors.directExecutor());
                    abortedLatch.await(10L, TimeUnit.SECONDS);
                    AsyncTransactionManager.CommitTimestampFuture commitTimestamp = updateCount.commitAsync();
                    Assert.assertEquals((long)1L, (long)((Long)updateCount.get()));
                    Assert.assertNotNull((Object)commitTimestamp.get());
                    Assert.assertEquals((long)2L, (long)attempt.get());
                }
                catch (AbortedException e) {
                    transactionContextFuture = manager.resetForRetryAsync();
                    continue;
                }
                break;
            }
        }
        List<ExecuteSqlRequest> executeSqlRequests = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class);
        Assert.assertEquals((long)2L, (long)executeSqlRequests.size());
        Assert.assertEquals((Object)executeSqlRequests.get(0).getSession(), (Object)executeSqlRequests.get(1).getSession());
        for (ExecuteSqlRequest request : executeSqlRequests) {
            Assert.assertTrue((boolean)mockSpanner.getSession(request.getSession()).getMultiplexed());
        }
        Assert.assertNotNull((Object)client.multiplexedSessionDatabaseClient);
        Assert.assertEquals((long)1L, (long)client.multiplexedSessionDatabaseClient.getNumSessionsAcquired().get());
        Assert.assertEquals((long)1L, (long)client.multiplexedSessionDatabaseClient.getNumSessionsReleased().get());
    }

    @Test
    public void testReadWriteTransactionUsingAsyncRunner() throws Exception {
        AtomicInteger attempt = new AtomicInteger();
        DatabaseClientImpl client = (DatabaseClientImpl)this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
        AsyncRunner runner = client.runAsync(new Options.TransactionOption[0]);
        ApiFuture updateCount = runner.runAsync(txn -> {
            ApiFuture updateCount1 = txn.executeUpdateAsync(MockSpannerTestUtil.UPDATE_STATEMENT, new Options.UpdateOption[0]);
            if (attempt.incrementAndGet() == 1) {
                mockSpanner.abortTransaction(txn);
            }
            return updateCount1;
        }, MoreExecutors.directExecutor());
        Assert.assertEquals((long)1L, (long)((Long)updateCount.get()));
        Assert.assertEquals((long)2L, (long)attempt.get());
        List<ExecuteSqlRequest> executeSqlRequests = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class);
        Assert.assertEquals((long)2L, (long)executeSqlRequests.size());
        Assert.assertEquals((Object)executeSqlRequests.get(0).getSession(), (Object)executeSqlRequests.get(1).getSession());
        for (ExecuteSqlRequest request : executeSqlRequests) {
            Assert.assertTrue((boolean)mockSpanner.getSession(request.getSession()).getMultiplexed());
        }
        Assert.assertNotNull((Object)client.multiplexedSessionDatabaseClient);
        Assert.assertEquals((long)1L, (long)client.multiplexedSessionDatabaseClient.getNumSessionsAcquired().get());
        Assert.assertEquals((long)1L, (long)client.multiplexedSessionDatabaseClient.getNumSessionsReleased().get());
    }

    @Test
    public void testAsyncRunnerIsNonBlockingWithMultiplexedSession() throws Exception {
        mockSpanner.freeze();
        DatabaseClientImpl client = (DatabaseClientImpl)this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
        AsyncRunner runner = client.runAsync(new Options.TransactionOption[0]);
        ApiFuture res = runner.runAsync(txn -> {
            txn.executeUpdateAsync(MockSpannerTestUtil.UPDATE_STATEMENT, new Options.UpdateOption[0]);
            return ApiFutures.immediateFuture(null);
        }, MoreExecutors.directExecutor());
        ApiFuture ts = runner.getCommitTimestamp();
        mockSpanner.unfreeze();
        Truth.assertThat((Object)res.get()).isNull();
        Truth.assertThat((Comparable)((Timestamp)ts.get())).isNotNull();
        List<ExecuteSqlRequest> executeSqlRequests = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class);
        Assert.assertEquals((long)1L, (long)executeSqlRequests.size());
        for (ExecuteSqlRequest request : executeSqlRequests) {
            Assert.assertTrue((boolean)mockSpanner.getSession(request.getSession()).getMultiplexed());
        }
        Assert.assertNotNull((Object)client.multiplexedSessionDatabaseClient);
        Assert.assertEquals((long)1L, (long)client.multiplexedSessionDatabaseClient.getNumSessionsAcquired().get());
        Assert.assertEquals((long)1L, (long)client.multiplexedSessionDatabaseClient.getNumSessionsReleased().get());
    }

    @Test
    public void testAbortedReadWriteTxnUsesPreviousTxnIdOnRetryWithInlineBegin() {
        DatabaseClientImpl client = (DatabaseClientImpl)this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
        mockSpanner.setCommitExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)((Object)mockSpanner.createAbortedException(ByteString.copyFromUtf8((String)"test")))));
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
        AtomicReference validTransactionId = new AtomicReference();
        runner.run(transaction -> {
            try (ResultSet resultSet = transaction.executeQuery(STATEMENT, new Options.QueryOption[0]);){
                while (resultSet.next()) {
                }
            }
            TransactionRunnerImpl.TransactionContextImpl impl = (TransactionRunnerImpl.TransactionContextImpl)transaction;
            if (validTransactionId.get() == null) {
                validTransactionId.set(impl.transactionId);
            }
            return null;
        });
        List<ExecuteSqlRequest> executeSqlRequests = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class);
        Assert.assertEquals((long)2L, (long)executeSqlRequests.size());
        for (ExecuteSqlRequest request : executeSqlRequests) {
            Assert.assertTrue((boolean)mockSpanner.getSession(request.getSession()).getMultiplexed());
        }
        Assert.assertTrue((boolean)executeSqlRequests.get(0).hasTransaction());
        Assert.assertTrue((boolean)executeSqlRequests.get(0).getTransaction().hasBegin());
        Assert.assertTrue((boolean)executeSqlRequests.get(0).getTransaction().getBegin().hasReadWrite());
        Assert.assertNotNull((Object)executeSqlRequests.get(0).getTransaction().getBegin().getReadWrite().getMultiplexedSessionPreviousTransactionId());
        Assert.assertEquals((Object)ByteString.EMPTY, (Object)executeSqlRequests.get(0).getTransaction().getBegin().getReadWrite().getMultiplexedSessionPreviousTransactionId());
        Assert.assertTrue((boolean)executeSqlRequests.get(1).hasTransaction());
        Assert.assertTrue((boolean)executeSqlRequests.get(1).getTransaction().hasBegin());
        Assert.assertTrue((boolean)executeSqlRequests.get(1).getTransaction().getBegin().hasReadWrite());
        Assert.assertNotNull((Object)executeSqlRequests.get(1).getTransaction().getBegin().getReadWrite().getMultiplexedSessionPreviousTransactionId());
        Assert.assertNotEquals((Object)ByteString.EMPTY, (Object)executeSqlRequests.get(1).getTransaction().getBegin().getReadWrite().getMultiplexedSessionPreviousTransactionId());
        Assert.assertEquals(validTransactionId.get(), (Object)executeSqlRequests.get(1).getTransaction().getBegin().getReadWrite().getMultiplexedSessionPreviousTransactionId());
    }

    @Test
    public void testAbortedReadWriteTxnUsesPreviousTxnIdOnRetryWithExplicitBegin() {
        DatabaseClientImpl client = (DatabaseClientImpl)this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
        mockSpanner.setCommitExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)((Object)mockSpanner.createAbortedException(ByteString.copyFromUtf8((String)"test")))));
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
        AtomicReference validTransactionId = new AtomicReference();
        Long updateCount = (Long)runner.run(transaction -> {
            TransactionRunnerImpl.TransactionContextImpl impl = (TransactionRunnerImpl.TransactionContextImpl)transaction;
            if (validTransactionId.get() == null) {
                validTransactionId.set(impl.transactionId);
            }
            SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> transaction.executeUpdate(MockSpannerTestUtil.INVALID_UPDATE_STATEMENT, new Options.UpdateOption[0]));
            Assert.assertEquals((Object)ErrorCode.INVALID_ARGUMENT, (Object)e.getErrorCode());
            return transaction.executeUpdate(MockSpannerTestUtil.UPDATE_STATEMENT, new Options.UpdateOption[0]);
        });
        Truth.assertThat((Long)updateCount).isEqualTo((Object)1L);
        List<BeginTransactionRequest> beginTransactionRequests = mockSpanner.getRequestsOfType(BeginTransactionRequest.class);
        Assert.assertEquals((long)2L, (long)beginTransactionRequests.size());
        for (BeginTransactionRequest request : beginTransactionRequests) {
            Assert.assertTrue((boolean)mockSpanner.getSession(request.getSession()).getMultiplexed());
        }
        Assert.assertTrue((boolean)beginTransactionRequests.get(0).hasOptions());
        Assert.assertTrue((boolean)beginTransactionRequests.get(0).getOptions().hasReadWrite());
        Assert.assertNotNull((Object)beginTransactionRequests.get(0).getOptions().getReadWrite().getMultiplexedSessionPreviousTransactionId());
        Assert.assertEquals((Object)ByteString.EMPTY, (Object)beginTransactionRequests.get(0).getOptions().getReadWrite().getMultiplexedSessionPreviousTransactionId());
        Assert.assertTrue((boolean)beginTransactionRequests.get(1).hasOptions());
        Assert.assertTrue((boolean)beginTransactionRequests.get(1).getOptions().hasReadWrite());
        Assert.assertNotNull((Object)beginTransactionRequests.get(1).getOptions().getReadWrite().getMultiplexedSessionPreviousTransactionId());
        Assert.assertNotEquals((Object)ByteString.EMPTY, (Object)beginTransactionRequests.get(1).getOptions().getReadWrite().getMultiplexedSessionPreviousTransactionId());
        Assert.assertEquals(validTransactionId.get(), (Object)beginTransactionRequests.get(1).getOptions().getReadWrite().getMultiplexedSessionPreviousTransactionId());
    }

    @Test
    public void testPrecommitTokenForResultSet() {
        DatabaseClientImpl client = (DatabaseClientImpl)this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
        Long count = (Long)client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
            long res = transaction.executeUpdate(MockSpannerTestUtil.UPDATE_STATEMENT, new Options.UpdateOption[0]);
            TransactionRunnerImpl.TransactionContextImpl impl = (TransactionRunnerImpl.TransactionContextImpl)transaction;
            Assert.assertNotNull((Object)impl.getLatestPrecommitToken());
            Assert.assertEquals((Object)ByteString.copyFromUtf8((String)"ResultSetPrecommitToken"), (Object)impl.getLatestPrecommitToken().getPrecommitToken());
            return res;
        });
        Assert.assertNotNull((Object)count);
        Assert.assertEquals((long)1L, (long)count);
        List<CommitRequest> commitRequests = mockSpanner.getRequestsOfType(CommitRequest.class);
        Assert.assertEquals((long)1L, (long)commitRequests.size());
        Assert.assertTrue((boolean)mockSpanner.getSession(commitRequests.get(0).getSession()).getMultiplexed());
        Assert.assertNotNull((Object)commitRequests.get(0).getPrecommitToken());
        Assert.assertEquals((Object)ByteString.copyFromUtf8((String)"ResultSetPrecommitToken"), (Object)commitRequests.get(0).getPrecommitToken().getPrecommitToken());
    }

    @Test
    public void testPrecommitTokenForExecuteBatchDmlResponse() {
        DatabaseClientImpl client = (DatabaseClientImpl)this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
        long[] count = (long[])client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
            long[] res = transaction.batchUpdate((Iterable)Lists.newArrayList((Object[])new Statement[]{MockSpannerTestUtil.UPDATE_STATEMENT}), new Options.UpdateOption[0]);
            TransactionRunnerImpl.TransactionContextImpl impl = (TransactionRunnerImpl.TransactionContextImpl)transaction;
            Assert.assertNotNull((Object)impl.getLatestPrecommitToken());
            Assert.assertEquals((Object)ByteString.copyFromUtf8((String)"ExecuteBatchDmlResponsePrecommitToken"), (Object)impl.getLatestPrecommitToken().getPrecommitToken());
            return res;
        });
        Assert.assertNotNull((Object)count);
        Assert.assertEquals((long)1L, (long)count.length);
        List<CommitRequest> commitRequests = mockSpanner.getRequestsOfType(CommitRequest.class);
        Assert.assertEquals((long)1L, (long)commitRequests.size());
        Assert.assertTrue((boolean)mockSpanner.getSession(commitRequests.get(0).getSession()).getMultiplexed());
        Assert.assertNotNull((Object)commitRequests.get(0).getPrecommitToken());
        Assert.assertEquals((Object)ByteString.copyFromUtf8((String)"ExecuteBatchDmlResponsePrecommitToken"), (Object)commitRequests.get(0).getPrecommitToken().getPrecommitToken());
    }

    @Test
    public void testPrecommitTokenForPartialResultSet() {
        DatabaseClientImpl client = (DatabaseClientImpl)this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
        client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
            ResultSet resultSet = transaction.executeQuery(STATEMENT, new Options.QueryOption[0]);
            while (resultSet.next()) {
            }
            TransactionRunnerImpl.TransactionContextImpl impl = (TransactionRunnerImpl.TransactionContextImpl)transaction;
            Assert.assertNotNull((Object)impl.getLatestPrecommitToken());
            Assert.assertEquals((Object)ByteString.copyFromUtf8((String)"PartialResultSetPrecommitToken"), (Object)impl.getLatestPrecommitToken().getPrecommitToken());
            return null;
        });
        List<CommitRequest> commitRequests = mockSpanner.getRequestsOfType(CommitRequest.class);
        Assert.assertEquals((long)1L, (long)commitRequests.size());
        Assert.assertTrue((boolean)mockSpanner.getSession(commitRequests.get(0).getSession()).getMultiplexed());
        Assert.assertNotNull((Object)commitRequests.get(0).getPrecommitToken());
        Assert.assertEquals((Object)ByteString.copyFromUtf8((String)"PartialResultSetPrecommitToken"), (Object)commitRequests.get(0).getPrecommitToken().getPrecommitToken());
    }

    @Test
    public void testTxnTracksPrecommitTokenWithLatestSeqNo() {
        DatabaseClientImpl client = (DatabaseClientImpl)this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
        client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
            transaction.executeUpdate(MockSpannerTestUtil.UPDATE_STATEMENT, new Options.UpdateOption[0]);
            ResultSet resultSet = transaction.executeQuery(STATEMENT, new Options.QueryOption[0]);
            while (resultSet.next()) {
            }
            transaction.batchUpdate((Iterable)Lists.newArrayList((Object[])new Statement[]{MockSpannerTestUtil.UPDATE_STATEMENT}), new Options.UpdateOption[0]);
            TransactionRunnerImpl.TransactionContextImpl impl = (TransactionRunnerImpl.TransactionContextImpl)transaction;
            Assert.assertNotNull((Object)impl.getLatestPrecommitToken());
            Assert.assertEquals((Object)ByteString.copyFromUtf8((String)"ExecuteBatchDmlResponsePrecommitToken"), (Object)impl.getLatestPrecommitToken().getPrecommitToken());
            return null;
        });
        List<CommitRequest> commitRequests = mockSpanner.getRequestsOfType(CommitRequest.class);
        Assert.assertEquals((long)1L, (long)commitRequests.size());
        Assert.assertTrue((boolean)mockSpanner.getSession(commitRequests.get(0).getSession()).getMultiplexed());
        Assert.assertNotNull((Object)commitRequests.get(0).getPrecommitToken());
        Assert.assertEquals((Object)ByteString.copyFromUtf8((String)"ExecuteBatchDmlResponsePrecommitToken"), (Object)commitRequests.get(0).getPrecommitToken().getPrecommitToken());
    }

    private void waitForSessionToBeReplaced(DatabaseClientImpl client) {
        Assert.assertNotNull((Object)client.multiplexedSessionDatabaseClient);
        SessionReference sessionReference = client.multiplexedSessionDatabaseClient.getCurrentSessionReference();
        while (sessionReference == client.multiplexedSessionDatabaseClient.getCurrentSessionReference()) {
            Thread.yield();
        }
    }
}

