/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.AbstractMockServerTest;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.FailOnOverkillTraceComponentImpl;
import com.google.cloud.spanner.JavaVersionUtil;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TracerTest;
import com.google.cloud.spanner.connection.RandomResultSetGenerator;
import com.google.common.collect.ImmutableList;
import io.grpc.Status;
import io.opencensus.trace.Status;
import io.opencensus.trace.Tracing;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.threeten.bp.Duration;

@Category(value={TracerTest.class})
@RunWith(value=JUnit4.class)
@Ignore(value="OpenCensus is too intrusive and affects other tests, so this test is by default disabled")
public class OpenCensusApiTracerTest
extends AbstractMockServerTest {
    private static final Statement SELECT_RANDOM = Statement.of((String)"SELECT * FROM random");
    private static final Statement UPDATE_RANDOM = Statement.of((String)"UPDATE random SET foo=1 WHERE id=1");
    private static final FailOnOverkillTraceComponentImpl failOnOverkillTraceComponent = new FailOnOverkillTraceComponentImpl();
    private DatabaseClient client;

    @BeforeClass
    public static void setupOpenTelemetry() throws Exception {
        Assume.assumeTrue((String)"This test is only supported on JDK11 and lower", (JavaVersionUtil.getJavaMajorVersion() < 12 ? 1 : 0) != 0);
        SpannerOptions.resetActiveTracingFramework();
        SpannerOptions.enableOpenCensusTraces();
        Field field = Tracing.class.getDeclaredField("traceComponent");
        field.setAccessible(true);
        Field modifiersField = null;
        try {
            modifiersField = Field.class.getDeclaredField("modifiers");
        }
        catch (NoSuchFieldException e) {
            Assume.assumeTrue((String)"Skipping test as reflection is not allowed on reflection class in this JDK build", (boolean)false);
        }
        modifiersField.setAccessible(true);
        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        field.set(null, (Object)failOnOverkillTraceComponent);
    }

    @BeforeClass
    public static void setupResults() {
        RandomResultSetGenerator generator = new RandomResultSetGenerator(1);
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(SELECT_RANDOM, generator.generate()));
        mockSpanner.putStatementResults(MockSpannerServiceImpl.StatementResult.update(UPDATE_RANDOM, 1L));
    }

    @After
    public void clearRequests() {
        mockSpanner.clearRequests();
        failOnOverkillTraceComponent.clearSpans();
        failOnOverkillTraceComponent.clearAnnotations();
    }

    @Override
    public void createSpannerInstance() {
        SpannerOptions.Builder builder = SpannerOptions.newBuilder();
        builder.getDatabaseAdminStubSettingsBuilder().updateDatabaseDdlOperationSettings().setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofNanos((long)1L)).setMaxRetryDelay(Duration.ofNanos((long)1L)).setRetryDelayMultiplier(1.0).setTotalTimeout(Duration.ofMinutes((long)10L)).build()));
        this.spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)builder.setProjectId("test-project")).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).setSessionPoolOption(SessionPoolOptions.newBuilder().setWaitForMinSessions(Duration.ofSeconds((long)5L)).setFailOnSessionLeak().build()).setEnableApiTracing(true).build().getService();
        this.client = this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
    }

    @Test
    public void testSingleUseQuery() {
        try (ResultSet resultSet = this.client.singleUse().executeQuery(SELECT_RANDOM, new Options.QueryOption[0]);){
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertFalse((boolean)resultSet.next());
        }
        Map<String, Boolean> spans = failOnOverkillTraceComponent.getSpans();
        this.assertContains("CloudSpanner.ReadOnlyTransaction", spans);
        this.assertContains("CloudSpannerOperation.ExecuteStreamingQuery", spans);
        this.assertContains("Spanner.ExecuteStreamingSql", spans);
    }

    @Test
    public void testExecuteUpdate() {
        Assert.assertNotNull((Object)this.client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> transaction.executeUpdate(UPDATE_RANDOM, new Options.UpdateOption[0])));
        Map<String, Boolean> spans = failOnOverkillTraceComponent.getSpans();
        this.assertContains("CloudSpanner.ReadWriteTransaction", spans);
        this.assertContains("CloudSpannerOperation.ExecuteUpdate", spans);
        this.assertContains("CloudSpannerOperation.Commit", spans);
        this.assertContains("Spanner.ExecuteSql", spans);
        this.assertContains("Spanner.Commit", spans);
    }

    @Test
    public void testBatchUpdate() {
        Assert.assertNotNull((Object)this.client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> transaction.batchUpdate((Iterable)ImmutableList.of((Object)UPDATE_RANDOM, (Object)UPDATE_RANDOM), new Options.UpdateOption[0])));
        Map<String, Boolean> spans = failOnOverkillTraceComponent.getSpans();
        this.assertContains("CloudSpanner.ReadWriteTransaction", spans);
        this.assertContains("CloudSpannerOperation.BatchUpdate", spans);
        this.assertContains("CloudSpannerOperation.Commit", spans);
        this.assertContains("Spanner.ExecuteBatchDml", spans);
        this.assertContains("Spanner.Commit", spans);
    }

    @Test
    public void testMultiUseReadOnlyQuery() {
        try (ReadOnlyTransaction readOnlyTransaction = this.client.readOnlyTransaction();
             ResultSet resultSet = readOnlyTransaction.executeQuery(SELECT_RANDOM, new Options.QueryOption[0]);){
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertFalse((boolean)resultSet.next());
        }
        Map<String, Boolean> spans = failOnOverkillTraceComponent.getSpans();
        this.assertContains("CloudSpanner.ReadOnlyTransaction", spans);
        this.assertContains("CloudSpannerOperation.ExecuteStreamingQuery", spans);
        this.assertContains("Spanner.ExecuteStreamingSql", spans);
    }

    @Test
    public void testReadWriteTransactionQuery() {
        this.client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
            try (ResultSet resultSet = transaction.executeQuery(SELECT_RANDOM, new Options.QueryOption[0]);){
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertFalse((boolean)resultSet.next());
            }
            return null;
        });
        Map<String, Boolean> spans = failOnOverkillTraceComponent.getSpans();
        this.assertContains("CloudSpanner.ReadWriteTransaction", spans);
        this.assertContains("CloudSpannerOperation.ExecuteStreamingQuery", spans);
        this.assertContains("CloudSpannerOperation.Commit", spans);
    }

    @Ignore(value="The client.write method overkills the span")
    @Test
    public void testRetryUnaryRpc() {
        mockSpanner.setBeginTransactionExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)Status.UNAVAILABLE.asRuntimeException()));
        this.client.write((Iterable)ImmutableList.of((Object)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"foo").set("bar").to(1L)).build()));
        List<FailOnOverkillTraceComponentImpl.TestSpan> spans = failOnOverkillTraceComponent.getTestSpans();
        FailOnOverkillTraceComponentImpl.TestSpan span = this.getSpan("Spanner.BeginTransaction", spans);
        Assert.assertNotNull((Object)span.getStatus());
        Assert.assertEquals((Object)Status.CanonicalCode.OK, (Object)span.getStatus().getCanonicalCode());
    }

    @Test
    public void testRetryQuery() {
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)Status.UNAVAILABLE.asRuntimeException()));
        try (ResultSet resultSet = this.client.singleUse().executeQuery(SELECT_RANDOM, new Options.QueryOption[0]);){
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertFalse((boolean)resultSet.next());
        }
        List<FailOnOverkillTraceComponentImpl.TestSpan> spans = failOnOverkillTraceComponent.getTestSpans();
        List<FailOnOverkillTraceComponentImpl.TestSpan> executeStreamingSqlSpans = this.getSpans("Spanner.ExecuteStreamingSql", spans);
        Assert.assertEquals((long)2L, (long)executeStreamingSqlSpans.size());
        FailOnOverkillTraceComponentImpl.TestSpan span1 = executeStreamingSqlSpans.get(0);
        Assert.assertNull((Object)span1.getStatus());
        FailOnOverkillTraceComponentImpl.TestSpan span2 = executeStreamingSqlSpans.get(1);
        Assert.assertNull((Object)span2.getStatus());
    }

    @Test
    public void testLroSucceeded() throws Exception {
        this.addUpdateDdlResponse();
        OperationFuture operationFuture = this.spanner.getDatabaseAdminClient().updateDatabaseDdl("i", "d", (Iterable)ImmutableList.of((Object)"create table foo (id int64) primary key (id)"), null);
        Assert.assertNull((Object)operationFuture.get());
        List<FailOnOverkillTraceComponentImpl.TestSpan> spans = failOnOverkillTraceComponent.getTestSpans();
        FailOnOverkillTraceComponentImpl.TestSpan updateDatabaseDdl = this.getSpan("DatabaseAdmin.UpdateDatabaseDdl", spans);
        Assert.assertNotNull((Object)((Object)updateDatabaseDdl));
        Assert.assertEquals((long)1L, (long)updateDatabaseDdl.getAnnotations().size());
        Assert.assertEquals((Object)"Attempt succeeded", (Object)updateDatabaseDdl.getAnnotations().get(0));
        FailOnOverkillTraceComponentImpl.TestSpan updateDatabaseDdlOperation = this.getSpan("DatabaseAdmin.UpdateDatabaseDdlOperation", spans);
        Assert.assertTrue((updateDatabaseDdlOperation.getAnnotations().size() >= 2 ? 1 : 0) != 0);
        this.assertContainsEvent("Operation started", updateDatabaseDdlOperation.getAnnotations());
        if (updateDatabaseDdlOperation.getAnnotations().size() > 2) {
            this.assertContainsEvent("Scheduling next poll", updateDatabaseDdlOperation.getAnnotations());
        }
        this.assertContainsEvent("Polling completed", updateDatabaseDdlOperation.getAnnotations());
        List<FailOnOverkillTraceComponentImpl.TestSpan> polls = this.getSpans("Operations.GetOperation", spans);
        Assert.assertEquals((long)2L, (long)polls.size());
    }

    @Test
    public void testLroCreationFailed() {
        mockDatabaseAdmin.addException((Exception)Status.INVALID_ARGUMENT.asRuntimeException());
        OperationFuture operationFuture = this.spanner.getDatabaseAdminClient().updateDatabaseDdl("i", "d", (Iterable)ImmutableList.of((Object)"create table foo (id int64) primary key (id)"), null);
        ExecutionException executionException = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> operationFuture.get());
        Assert.assertEquals((Object)ErrorCode.INVALID_ARGUMENT, (Object)SpannerExceptionFactory.asSpannerException((Throwable)executionException.getCause()).getErrorCode());
        List<FailOnOverkillTraceComponentImpl.TestSpan> spans = failOnOverkillTraceComponent.getTestSpans();
        FailOnOverkillTraceComponentImpl.TestSpan updateDatabaseDdl = this.getSpan("DatabaseAdmin.UpdateDatabaseDdl", spans);
        Assert.assertEquals((long)1L, (long)updateDatabaseDdl.getAnnotations().size());
    }

    @Test
    public void testLroOperationFailed() {
        this.addUpdateDdlError();
        OperationFuture operationFuture = this.spanner.getDatabaseAdminClient().updateDatabaseDdl("i", "d", (Iterable)ImmutableList.of((Object)"create table foo (id int64) primary key (id)"), null);
        ExecutionException executionException = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> operationFuture.get());
        Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)SpannerExceptionFactory.asSpannerException((Throwable)executionException.getCause()).getErrorCode());
        List<FailOnOverkillTraceComponentImpl.TestSpan> spans = failOnOverkillTraceComponent.getTestSpans();
        FailOnOverkillTraceComponentImpl.TestSpan updateDatabaseDdl = this.getSpan("DatabaseAdmin.UpdateDatabaseDdl", spans);
        Assert.assertEquals((long)1L, (long)updateDatabaseDdl.getAnnotations().size());
        Assert.assertEquals((Object)"Attempt succeeded", (Object)updateDatabaseDdl.getAnnotations().get(0));
        FailOnOverkillTraceComponentImpl.TestSpan updateDatabaseDdlOperation = this.getSpan("DatabaseAdmin.UpdateDatabaseDdlOperation", spans);
        Assert.assertTrue((updateDatabaseDdlOperation.getAnnotations().size() >= 2 ? 1 : 0) != 0);
        this.assertContainsEvent("Operation started", updateDatabaseDdlOperation.getAnnotations());
        if (updateDatabaseDdlOperation.getAnnotations().size() > 2) {
            this.assertContainsEvent("Starting poll attempt 0", updateDatabaseDdlOperation.getAnnotations());
        }
        this.assertContainsEvent("Polling completed", updateDatabaseDdlOperation.getAnnotations());
    }

    @Test
    public void testEnableWithEnvVar() {
        SpannerOptions.useEnvironment((SpannerOptions.SpannerEnvironment)new SpannerOptions.SpannerEnvironment(){

            public boolean isEnableApiTracing() {
                return true;
            }
        });
        Spanner spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("test-project")).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).setSessionPoolOption(SessionPoolOptions.newBuilder().setWaitForMinSessions(Duration.ofSeconds((long)5L)).setFailOnSessionLeak().build()).build().getService();
        DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
        try (ResultSet resultSet = client.singleUse().executeQuery(SELECT_RANDOM, new Options.QueryOption[0]);){
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertFalse((boolean)resultSet.next());
        }
        Map<String, Boolean> spans = failOnOverkillTraceComponent.getSpans();
        this.assertContains("CloudSpanner.ReadOnlyTransaction", spans);
        this.assertContains("CloudSpannerOperation.ExecuteStreamingQuery", spans);
        this.assertContains("Spanner.ExecuteStreamingSql", spans);
    }

    void assertContains(String expected, Map<String, Boolean> spans) {
        Assert.assertTrue((String)("Expected " + this.spansToString(spans) + " to contain " + expected), (boolean)spans.keySet().stream().anyMatch(span -> span.equals(expected)));
    }

    void assertContainsEvent(String expected, List<String> events) {
        Assert.assertTrue((String)("Expected " + this.eventsToString(events) + " to contain " + expected), (boolean)events.stream().anyMatch(event -> event.equals(expected)));
    }

    boolean equalsSpan(SpanData span, String name, Attributes attributes) {
        if (!span.getName().equals(name)) {
            return false;
        }
        for (Map.Entry entry : attributes.asMap().entrySet()) {
            if (!span.getAttributes().asMap().containsKey(entry.getKey())) {
                return false;
            }
            if (Objects.equals(entry.getValue(), span.getAttributes().get((AttributeKey)entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    FailOnOverkillTraceComponentImpl.TestSpan getSpan(String name, List<FailOnOverkillTraceComponentImpl.TestSpan> spans) {
        return spans.stream().filter(span -> span.getSpanName().equals(name)).findAny().orElseThrow(() -> new IllegalArgumentException("Span " + name + " not found"));
    }

    List<FailOnOverkillTraceComponentImpl.TestSpan> getSpans(String name, List<FailOnOverkillTraceComponentImpl.TestSpan> spans) {
        return spans.stream().filter(span -> Objects.equals(span.getSpanName(), name)).collect(Collectors.toList());
    }

    private String spansToString(Map<String, Boolean> spans) {
        return spans.keySet().stream().collect(Collectors.joining("\n", "\n", "\n"));
    }

    private String eventsToString(List<String> events) {
        return events.stream().collect(Collectors.joining("\n", "\n", "\n"));
    }
}

