/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.cloud.ByteArray;
import com.google.cloud.spanner.AbstractResultSet;
import com.google.cloud.spanner.GrpcResultSet;
import com.google.cloud.spanner.GrpcStreamIterator;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.spi.v1.SpannerRpc;
import com.google.common.io.Resources;
import com.google.common.truth.Truth;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import com.google.spanner.v1.MultiplexedSessionPrecommitToken;
import com.google.spanner.v1.PartialResultSet;
import com.google.spanner.v1.Transaction;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;

public class ReadFormatTestRunner
extends ParentRunner<JSONObject> {
    public ReadFormatTestRunner(Class<?> clazz) throws InitializationError {
        super(clazz);
    }

    protected Description describeChild(JSONObject child) {
        try {
            return Description.createTestDescription((Class)this.getTestClass().getJavaClass(), (String)child.getString("name"));
        }
        catch (JSONException e) {
            throw new IllegalStateException("Illegal json object: " + child.toString(), e);
        }
    }

    protected void runChild(JSONObject child, RunNotifier notifier) {
        EachTestNotifier eachNotifier = new EachTestNotifier(notifier, this.describeChild(child));
        eachNotifier.fireTestStarted();
        try {
            new TestCaseRunner(child).run();
            eachNotifier.fireTestFinished();
        }
        catch (AssertionError | Exception e) {
            eachNotifier.addFailure((Throwable)e);
        }
    }

    protected List<JSONObject> getChildren() {
        try {
            ArrayList<JSONObject> children = new ArrayList<JSONObject>();
            String jsonStr = Resources.toString((URL)Resources.getResource(((Object)((Object)this)).getClass(), (String)"read_tests.json"), (Charset)StandardCharsets.UTF_8);
            JSONObject json = new JSONObject(jsonStr);
            JSONArray testCases = json.getJSONArray("tests");
            for (int i = 0; i < testCases.length(); ++i) {
                JSONObject testCase = testCases.getJSONObject(i);
                children.add(testCase);
            }
            return children;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static class TestCaseRunner {
        private GrpcResultSet resultSet;
        private SpannerRpc.ResultStreamConsumer consumer;
        private GrpcStreamIterator stream;
        private JSONObject testCase;

        TestCaseRunner(JSONObject testCase) {
            this.testCase = testCase;
        }

        private void run() throws Exception {
            this.stream = new GrpcStreamIterator(10, false);
            this.stream.setCall(new SpannerRpc.StreamingCall(){

                public ApiCallContext getCallContext() {
                    return GrpcCallContext.createDefault();
                }

                public void cancel(@Nullable String message) {
                }

                public void request(int numMessages) {
                }
            }, false);
            this.consumer = this.stream.consumer();
            this.resultSet = new GrpcResultSet((AbstractResultSet.CloseableIterator)this.stream, (AbstractResultSet.Listener)new NoOpListener());
            JSONArray chunks = this.testCase.getJSONArray("chunks");
            JSONObject expectedResult = this.testCase.getJSONObject("result");
            for (int i = 0; i < chunks.length(); ++i) {
                PartialResultSet.Builder builder = PartialResultSet.newBuilder();
                JsonFormat.parser().merge(chunks.getString(i), (Message.Builder)builder);
                this.consumer.onPartialResultSet(builder.build());
            }
            this.consumer.onCompleted();
            this.assertResultSet(this.resultSet, expectedResult.getJSONArray("value"));
        }

        private void assertResultSet(GrpcResultSet actual, JSONArray expected) throws Exception {
            int i = 0;
            while (actual.next()) {
                Struct actualRow = actual.getCurrentRowAsStruct();
                JSONArray expectedRow = expected.getJSONArray(i);
                this.assertRow(actualRow, expectedRow);
                ++i;
            }
            Truth.assertThat((Integer)i).isEqualTo((Object)expected.length());
        }

        private void assertRow(Struct actualRow, JSONArray expectedRow) throws Exception {
            Truth.assertThat((Integer)actualRow.getColumnCount()).isEqualTo((Object)expectedRow.length());
            block11: for (int i = 0; i < expectedRow.length(); ++i) {
                switch (actualRow.getColumnType(i).getCode()) {
                    case BOOL: {
                        Truth.assertThat((Boolean)actualRow.getBoolean(i)).isEqualTo((Object)expectedRow.getBoolean(i));
                        continue block11;
                    }
                    case STRING: {
                        Truth.assertThat((String)actualRow.getString(i)).isEqualTo((Object)expectedRow.getString(i));
                        continue block11;
                    }
                    case JSON: {
                        Truth.assertThat((String)actualRow.getJson(i)).isEqualTo((Object)expectedRow.getString(i));
                        continue block11;
                    }
                    case INT64: {
                        Truth.assertThat((Long)actualRow.getLong(i)).isEqualTo((Object)expectedRow.getLong(i));
                        continue block11;
                    }
                    case FLOAT32: {
                        Truth.assertThat((Float)Float.valueOf(actualRow.getFloat(i))).isEqualTo((Object)Float.valueOf(expectedRow.getFloat(i)));
                        continue block11;
                    }
                    case FLOAT64: {
                        Truth.assertThat((Double)actualRow.getDouble(i)).isEqualTo((Object)expectedRow.getDouble(i));
                        continue block11;
                    }
                    case NUMERIC: {
                        Truth.assertThat((BigDecimal)actualRow.getBigDecimal(i)).isEqualTo((Object)expectedRow.getBigDecimal(i));
                        continue block11;
                    }
                    case BYTES: {
                        Truth.assertThat((Iterable)actualRow.getBytes(i)).isEqualTo((Object)ByteArray.fromBase64((String)expectedRow.getString(i)));
                        continue block11;
                    }
                    case ARRAY: {
                        Type elementType = actualRow.getColumnType(i).getArrayElementType();
                        this.assertArray(this.getRawList(actualRow, i, elementType), expectedRow.getJSONArray(i));
                        continue block11;
                    }
                    default: {
                        Assert.fail((String)("Unexpected type code:" + actualRow.getColumnType(i).getCode()));
                    }
                }
            }
        }

        private List<?> getRawList(Struct actualRow, int index, Type elementType) {
            List rawList = null;
            switch (elementType.getCode()) {
                case BOOL: {
                    rawList = actualRow.getBooleanList(index);
                    break;
                }
                case STRING: {
                    rawList = actualRow.getStringList(index);
                    break;
                }
                case JSON: {
                    rawList = actualRow.getJsonList(index);
                    break;
                }
                case BYTES: {
                    rawList = actualRow.getBytesList(index);
                    break;
                }
                case INT64: {
                    rawList = actualRow.getLongList(index);
                    break;
                }
                case FLOAT32: {
                    rawList = actualRow.getFloatList(index);
                    break;
                }
                case FLOAT64: {
                    rawList = actualRow.getDoubleList(index);
                    break;
                }
                case NUMERIC: {
                    rawList = actualRow.getBigDecimalList(index);
                    break;
                }
                case STRUCT: {
                    rawList = actualRow.getStructList(index);
                    break;
                }
                default: {
                    Assert.fail((String)("Unexpected type code:" + elementType.getCode()));
                }
            }
            return rawList;
        }

        private void assertArray(List<?> actualValues, JSONArray expectedList) throws Exception {
            Truth.assertThat((Integer)actualValues.size()).isEqualTo((Object)expectedList.length());
            for (int i = 0; i < actualValues.size(); ++i) {
                Object actualValue = actualValues.get(i);
                if (actualValue == null) {
                    Truth.assertThat((Boolean)expectedList.isNull(i)).isTrue();
                    continue;
                }
                if (actualValue instanceof Boolean) {
                    Truth.assertThat((Boolean)((Boolean)actualValue)).isEqualTo((Object)expectedList.getBoolean(i));
                    continue;
                }
                if (actualValue instanceof String) {
                    Truth.assertThat((String)((String)actualValue)).isEqualTo((Object)expectedList.getString(i));
                    continue;
                }
                if (actualValue instanceof Long) {
                    Truth.assertThat((Long)((Long)actualValue)).isEqualTo((Object)expectedList.getLong(i));
                    continue;
                }
                if (actualValue instanceof Double) {
                    if (expectedList.get(i) instanceof String) {
                        Truth.assertThat((Double)((Double)actualValue)).isEqualTo((Object)Double.valueOf(expectedList.getString(i)));
                        continue;
                    }
                    Truth.assertThat((Double)((Double)actualValue)).isEqualTo((Object)expectedList.getDouble(i));
                    continue;
                }
                if (actualValue instanceof BigDecimal) {
                    Truth.assertThat((BigDecimal)((BigDecimal)actualValue)).isEqualTo((Object)expectedList.getBigDecimal(i));
                    continue;
                }
                if (actualValue instanceof ByteArray) {
                    Truth.assertThat((Iterable)((ByteArray)actualValue)).isEqualTo((Object)ByteArray.fromBase64((String)expectedList.getString(i)));
                    continue;
                }
                if (!(actualValue instanceof Struct)) continue;
                Struct actualStruct = (Struct)actualValue;
                JSONArray expectedFields = expectedList.getJSONArray(i);
                this.assertRow(actualStruct, expectedFields);
            }
        }
    }

    private static class NoOpListener
    implements AbstractResultSet.Listener {
        private NoOpListener() {
        }

        public void onTransactionMetadata(Transaction transaction, boolean shouldIncludeId) throws SpannerException {
        }

        public SpannerException onError(SpannerException e, boolean withBeginTransaction) {
            return e;
        }

        public void onDone(boolean withBeginTransaction) {
        }

        public void onPrecommitToken(MultiplexedSessionPrecommitToken token) {
        }
    }
}

