/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFutures;
import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.ISpan;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.SessionImpl;
import com.google.cloud.spanner.SpannerBatchUpdateException;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TraceWrapper;
import com.google.cloud.spanner.TransactionRunnerImpl;
import com.google.cloud.spanner.spi.v1.SpannerRpc;
import com.google.cloud.spanner.v1.stub.SpannerStubSettings;
import com.google.protobuf.ByteString;
import com.google.protobuf.Timestamp;
import com.google.rpc.Status;
import com.google.spanner.v1.CommitRequest;
import com.google.spanner.v1.CommitResponse;
import com.google.spanner.v1.ExecuteBatchDmlRequest;
import com.google.spanner.v1.ExecuteBatchDmlResponse;
import io.opentelemetry.api.common.Attributes;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnit4.class)
public class TransactionContextImplTest {
    @Mock
    private SpannerRpc rpc;
    @Mock
    private SessionImpl session;
    @Mock
    private ISpan span;
    @Mock
    private TraceWrapper tracer;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.rpc.commitAsync((CommitRequest)Mockito.any(CommitRequest.class), Mockito.anyMap())).thenReturn((Object)ApiFutures.immediateFuture((Object)CommitResponse.newBuilder().setCommitTimestamp(Timestamp.newBuilder().setSeconds(99L).setNanos(10).build()).build()));
        Mockito.when((Object)this.session.getName()).thenReturn((Object)"test");
        ((ISpan)Mockito.doNothing().when((Object)this.span)).setStatus((Throwable)Mockito.any(Throwable.class));
        ((ISpan)Mockito.doNothing().when((Object)this.span)).end();
        ((ISpan)Mockito.doNothing().when((Object)this.span)).addAnnotation("Starting Commit");
        Mockito.when((Object)this.tracer.createStatementAttributes((Statement)Mockito.any(Statement.class), (Options)Mockito.any())).thenReturn((Object)Attributes.empty());
        Mockito.when((Object)this.tracer.createStatementBatchAttributes((Iterable)Mockito.any(Iterable.class), (Options)Mockito.any())).thenReturn((Object)Attributes.empty());
        Mockito.when((Object)this.tracer.spanBuilderWithExplicitParent("CloudSpannerOperation.Commit", this.span)).thenReturn((Object)this.span);
        Mockito.when((Object)this.tracer.spanBuilderWithExplicitParent((String)ArgumentMatchers.eq((Object)"CloudSpannerOperation.Commit"), (ISpan)ArgumentMatchers.eq((Object)this.span), (Attributes)Mockito.any(Attributes.class))).thenReturn((Object)this.span);
        Mockito.when((Object)this.tracer.spanBuilderWithExplicitParent((String)ArgumentMatchers.eq((Object)"CloudSpannerOperation.BatchUpdate"), (ISpan)ArgumentMatchers.eq((Object)this.span), (Attributes)Mockito.any(Attributes.class))).thenReturn((Object)this.span);
        Mockito.when((Object)this.rpc.getCommitRetrySettings()).thenReturn((Object)SpannerStubSettings.newBuilder().commitSettings().getRetrySettings());
    }

    private TransactionRunnerImpl.TransactionContextImpl createContext() {
        return ((TransactionRunnerImpl.TransactionContextImpl.Builder)((TransactionRunnerImpl.TransactionContextImpl.Builder)((TransactionRunnerImpl.TransactionContextImpl.Builder)((TransactionRunnerImpl.TransactionContextImpl.Builder)TransactionRunnerImpl.TransactionContextImpl.newBuilder().setSession(this.session)).setRpc(this.rpc)).setSpan(this.span)).setTracer(this.tracer)).setTransactionId(ByteString.copyFromUtf8((String)"test")).setOptions(Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[0])).build();
    }

    @Test
    public void testCanBufferBeforeCommit() {
        try (TransactionRunnerImpl.TransactionContextImpl context = this.createContext();){
            context.buffer(Mutation.delete((String)"test", (KeySet)KeySet.all()));
        }
    }

    @Test
    public void testCanBufferAsyncBeforeCommit() {
        try (TransactionRunnerImpl.TransactionContextImpl context = this.createContext();){
            context.bufferAsync(Mutation.delete((String)"test", (KeySet)KeySet.all()));
        }
    }

    @Test
    public void testCanBufferIterableBeforeCommit() {
        try (TransactionRunnerImpl.TransactionContextImpl context = this.createContext();){
            context.buffer(Collections.singleton(Mutation.delete((String)"test", (KeySet)KeySet.all())));
        }
    }

    @Test
    public void testCanBufferIterableAsyncBeforeCommit() {
        try (TransactionRunnerImpl.TransactionContextImpl context = this.createContext();){
            context.bufferAsync(Collections.singleton(Mutation.delete((String)"test", (KeySet)KeySet.all())));
        }
    }

    @Test
    public void testCannotBufferAfterCommit() {
        try (TransactionRunnerImpl.TransactionContextImpl context = this.createContext();){
            context.commit();
            Assert.assertThrows(IllegalStateException.class, () -> context.buffer(Mutation.delete((String)"test", (KeySet)KeySet.all())));
        }
    }

    @Test
    public void testCannotBufferAsyncAfterCommit() {
        try (TransactionRunnerImpl.TransactionContextImpl context = this.createContext();){
            context.commit();
            Assert.assertThrows(IllegalStateException.class, () -> context.bufferAsync(Mutation.delete((String)"test", (KeySet)KeySet.all())));
        }
    }

    @Test
    public void testCannotBufferIterableAfterCommit() {
        try (TransactionRunnerImpl.TransactionContextImpl context = this.createContext();){
            context.commit();
            Assert.assertThrows(IllegalStateException.class, () -> context.buffer(Collections.singleton(Mutation.delete((String)"test", (KeySet)KeySet.all()))));
        }
    }

    @Test
    public void testCannotBufferIterableAsyncAfterCommit() {
        try (TransactionRunnerImpl.TransactionContextImpl context = this.createContext();){
            context.commit();
            Assert.assertThrows(IllegalStateException.class, () -> context.bufferAsync(Collections.singleton(Mutation.delete((String)"test", (KeySet)KeySet.all()))));
        }
    }

    @Test
    public void testCannotCommitTwice() {
        try (TransactionRunnerImpl.TransactionContextImpl context = this.createContext();){
            context.commit();
            Assert.assertThrows(IllegalStateException.class, () -> context.commit());
        }
    }

    @Test(expected=AbortedException.class)
    public void batchDmlAborted() {
        this.batchDml(10);
    }

    @Test(expected=SpannerBatchUpdateException.class)
    public void batchDmlException() {
        this.batchDml(9);
    }

    @Test
    public void testReturnCommitStats() {
        ByteString transactionId = ByteString.copyFromUtf8((String)"test");
        try (TransactionRunnerImpl.TransactionContextImpl context = ((TransactionRunnerImpl.TransactionContextImpl.Builder)((TransactionRunnerImpl.TransactionContextImpl.Builder)((TransactionRunnerImpl.TransactionContextImpl.Builder)((TransactionRunnerImpl.TransactionContextImpl.Builder)TransactionRunnerImpl.TransactionContextImpl.newBuilder().setSession(this.session)).setRpc(this.rpc)).setSpan(this.span)).setTracer(this.tracer)).setTransactionId(transactionId).setOptions(Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[]{Options.commitStats()})).build();){
            context.commitAsync();
            CommitRequest request = CommitRequest.newBuilder().setReturnCommitStats(true).setSession(this.session.getName()).setTransactionId(transactionId).build();
            ((SpannerRpc)Mockito.verify((Object)this.rpc)).commitAsync((CommitRequest)ArgumentMatchers.eq((Object)request), Mockito.anyMap());
        }
    }

    private void batchDml(int status) {
        SessionImpl session = (SessionImpl)Mockito.mock(SessionImpl.class);
        Mockito.when((Object)session.getName()).thenReturn((Object)"test");
        SpannerRpc rpc = (SpannerRpc)Mockito.mock(SpannerRpc.class);
        ExecuteBatchDmlResponse response = ExecuteBatchDmlResponse.newBuilder().setStatus(Status.newBuilder().setCode(status).build()).build();
        Statement statement = Statement.of((String)"UPDATE FOO SET BAR=1");
        Mockito.when((Object)rpc.executeBatchDml((ExecuteBatchDmlRequest)Mockito.any(ExecuteBatchDmlRequest.class), Mockito.anyMap())).thenReturn((Object)response);
        try (TransactionRunnerImpl.TransactionContextImpl impl = ((TransactionRunnerImpl.TransactionContextImpl.Builder)((TransactionRunnerImpl.TransactionContextImpl.Builder)((TransactionRunnerImpl.TransactionContextImpl.Builder)((TransactionRunnerImpl.TransactionContextImpl.Builder)TransactionRunnerImpl.TransactionContextImpl.newBuilder().setSession(session)).setRpc(rpc)).setTransactionId(ByteString.copyFromUtf8((String)"test")).setOptions(Options.fromTransactionOptions((Options.TransactionOption[])new Options.TransactionOption[0])).setTracer(this.tracer)).setSpan(this.span)).build();){
            impl.batchUpdate(Collections.singletonList(statement), new Options.UpdateOption[0]);
        }
    }
}

