/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.admin.instance.v1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.resourcenames.ResourceName;
import com.google.cloud.spanner.admin.instance.v1.InstanceAdminClient;
import com.google.cloud.spanner.admin.instance.v1.InstanceAdminSettings;
import com.google.cloud.spanner.admin.instance.v1.MockInstanceAdmin;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import com.google.spanner.admin.instance.v1.AutoscalingConfig;
import com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest;
import com.google.spanner.admin.instance.v1.CreateInstancePartitionRequest;
import com.google.spanner.admin.instance.v1.CreateInstanceRequest;
import com.google.spanner.admin.instance.v1.DeleteInstanceConfigRequest;
import com.google.spanner.admin.instance.v1.DeleteInstancePartitionRequest;
import com.google.spanner.admin.instance.v1.DeleteInstanceRequest;
import com.google.spanner.admin.instance.v1.GetInstanceConfigRequest;
import com.google.spanner.admin.instance.v1.GetInstancePartitionRequest;
import com.google.spanner.admin.instance.v1.GetInstanceRequest;
import com.google.spanner.admin.instance.v1.Instance;
import com.google.spanner.admin.instance.v1.InstanceConfig;
import com.google.spanner.admin.instance.v1.InstanceConfigName;
import com.google.spanner.admin.instance.v1.InstanceName;
import com.google.spanner.admin.instance.v1.InstancePartition;
import com.google.spanner.admin.instance.v1.InstancePartitionName;
import com.google.spanner.admin.instance.v1.ListInstanceConfigOperationsRequest;
import com.google.spanner.admin.instance.v1.ListInstanceConfigOperationsResponse;
import com.google.spanner.admin.instance.v1.ListInstanceConfigsRequest;
import com.google.spanner.admin.instance.v1.ListInstanceConfigsResponse;
import com.google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest;
import com.google.spanner.admin.instance.v1.ListInstancePartitionOperationsResponse;
import com.google.spanner.admin.instance.v1.ListInstancePartitionsRequest;
import com.google.spanner.admin.instance.v1.ListInstancePartitionsResponse;
import com.google.spanner.admin.instance.v1.ListInstancesRequest;
import com.google.spanner.admin.instance.v1.ListInstancesResponse;
import com.google.spanner.admin.instance.v1.MoveInstanceRequest;
import com.google.spanner.admin.instance.v1.MoveInstanceResponse;
import com.google.spanner.admin.instance.v1.ProjectName;
import com.google.spanner.admin.instance.v1.UpdateInstanceConfigRequest;
import com.google.spanner.admin.instance.v1.UpdateInstancePartitionRequest;
import com.google.spanner.admin.instance.v1.UpdateInstanceRequest;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class InstanceAdminClientTest {
    private static MockInstanceAdmin mockInstanceAdmin;
    private static MockServiceHelper mockServiceHelper;
    private LocalChannelProvider channelProvider;
    private InstanceAdminClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockInstanceAdmin = new MockInstanceAdmin();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockInstanceAdmin));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        InstanceAdminSettings settings = ((InstanceAdminSettings.Builder)((InstanceAdminSettings.Builder)InstanceAdminSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = InstanceAdminClient.create((InstanceAdminSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void listInstanceConfigsTest() throws Exception {
        InstanceConfig responsesElement = InstanceConfig.newBuilder().build();
        ListInstanceConfigsResponse expectedResponse = ListInstanceConfigsResponse.newBuilder().setNextPageToken("").addAllInstanceConfigs(Arrays.asList(responsesElement)).build();
        mockInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        InstanceAdminClient.ListInstanceConfigsPagedResponse pagedListResponse = this.client.listInstanceConfigs(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getInstanceConfigsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListInstanceConfigsRequest actualRequest = (ListInstanceConfigsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listInstanceConfigsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            this.client.listInstanceConfigs(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listInstanceConfigsTest2() throws Exception {
        InstanceConfig responsesElement = InstanceConfig.newBuilder().build();
        ListInstanceConfigsResponse expectedResponse = ListInstanceConfigsResponse.newBuilder().setNextPageToken("").addAllInstanceConfigs(Arrays.asList(responsesElement)).build();
        mockInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        InstanceAdminClient.ListInstanceConfigsPagedResponse pagedListResponse = this.client.listInstanceConfigs(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getInstanceConfigsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListInstanceConfigsRequest actualRequest = (ListInstanceConfigsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listInstanceConfigsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listInstanceConfigs(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getInstanceConfigTest() throws Exception {
        InstanceConfig expectedResponse = InstanceConfig.newBuilder().setName(InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]").toString()).setDisplayName("displayName1714148973").addAllReplicas(new ArrayList()).addAllOptionalReplicas(new ArrayList()).setBaseConfig(InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]").toString()).putAllLabels(new HashMap()).setEtag("etag3123477").addAllLeaderOptions(new ArrayList()).setReconciling(true).build();
        mockInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        InstanceConfigName name = InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]");
        InstanceConfig actualResponse = this.client.getInstanceConfig(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetInstanceConfigRequest actualRequest = (GetInstanceConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getInstanceConfigExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)exception);
        try {
            InstanceConfigName name = InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]");
            this.client.getInstanceConfig(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getInstanceConfigTest2() throws Exception {
        InstanceConfig expectedResponse = InstanceConfig.newBuilder().setName(InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]").toString()).setDisplayName("displayName1714148973").addAllReplicas(new ArrayList()).addAllOptionalReplicas(new ArrayList()).setBaseConfig(InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]").toString()).putAllLabels(new HashMap()).setEtag("etag3123477").addAllLeaderOptions(new ArrayList()).setReconciling(true).build();
        mockInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        InstanceConfig actualResponse = this.client.getInstanceConfig(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetInstanceConfigRequest actualRequest = (GetInstanceConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getInstanceConfigExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getInstanceConfig(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createInstanceConfigTest() throws Exception {
        InstanceConfig expectedResponse = InstanceConfig.newBuilder().setName(InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]").toString()).setDisplayName("displayName1714148973").addAllReplicas(new ArrayList()).addAllOptionalReplicas(new ArrayList()).setBaseConfig(InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]").toString()).putAllLabels(new HashMap()).setEtag("etag3123477").addAllLeaderOptions(new ArrayList()).setReconciling(true).build();
        Operation resultOperation = Operation.newBuilder().setName("createInstanceConfigTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockInstanceAdmin.addResponse((AbstractMessage)resultOperation);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        InstanceConfig instanceConfig = InstanceConfig.newBuilder().build();
        String instanceConfigId = "instanceConfigId1750947762";
        InstanceConfig actualResponse = (InstanceConfig)this.client.createInstanceConfigAsync(parent, instanceConfig, instanceConfigId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateInstanceConfigRequest actualRequest = (CreateInstanceConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)instanceConfig, (Object)actualRequest.getInstanceConfig());
        Assert.assertEquals((Object)instanceConfigId, (Object)actualRequest.getInstanceConfigId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createInstanceConfigExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            InstanceConfig instanceConfig = InstanceConfig.newBuilder().build();
            String instanceConfigId = "instanceConfigId1750947762";
            this.client.createInstanceConfigAsync(parent, instanceConfig, instanceConfigId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createInstanceConfigTest2() throws Exception {
        InstanceConfig expectedResponse = InstanceConfig.newBuilder().setName(InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]").toString()).setDisplayName("displayName1714148973").addAllReplicas(new ArrayList()).addAllOptionalReplicas(new ArrayList()).setBaseConfig(InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]").toString()).putAllLabels(new HashMap()).setEtag("etag3123477").addAllLeaderOptions(new ArrayList()).setReconciling(true).build();
        Operation resultOperation = Operation.newBuilder().setName("createInstanceConfigTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockInstanceAdmin.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        InstanceConfig instanceConfig = InstanceConfig.newBuilder().build();
        String instanceConfigId = "instanceConfigId1750947762";
        InstanceConfig actualResponse = (InstanceConfig)this.client.createInstanceConfigAsync(parent, instanceConfig, instanceConfigId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateInstanceConfigRequest actualRequest = (CreateInstanceConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)instanceConfig, (Object)actualRequest.getInstanceConfig());
        Assert.assertEquals((Object)instanceConfigId, (Object)actualRequest.getInstanceConfigId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createInstanceConfigExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            InstanceConfig instanceConfig = InstanceConfig.newBuilder().build();
            String instanceConfigId = "instanceConfigId1750947762";
            this.client.createInstanceConfigAsync(parent, instanceConfig, instanceConfigId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void updateInstanceConfigTest() throws Exception {
        InstanceConfig expectedResponse = InstanceConfig.newBuilder().setName(InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]").toString()).setDisplayName("displayName1714148973").addAllReplicas(new ArrayList()).addAllOptionalReplicas(new ArrayList()).setBaseConfig(InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]").toString()).putAllLabels(new HashMap()).setEtag("etag3123477").addAllLeaderOptions(new ArrayList()).setReconciling(true).build();
        Operation resultOperation = Operation.newBuilder().setName("updateInstanceConfigTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockInstanceAdmin.addResponse((AbstractMessage)resultOperation);
        InstanceConfig instanceConfig = InstanceConfig.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        InstanceConfig actualResponse = (InstanceConfig)this.client.updateInstanceConfigAsync(instanceConfig, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateInstanceConfigRequest actualRequest = (UpdateInstanceConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)instanceConfig, (Object)actualRequest.getInstanceConfig());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateInstanceConfigExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)exception);
        try {
            InstanceConfig instanceConfig = InstanceConfig.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateInstanceConfigAsync(instanceConfig, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteInstanceConfigTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        InstanceConfigName name = InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]");
        this.client.deleteInstanceConfig(name);
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteInstanceConfigRequest actualRequest = (DeleteInstanceConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteInstanceConfigExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)exception);
        try {
            InstanceConfigName name = InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]");
            this.client.deleteInstanceConfig(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteInstanceConfigTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        this.client.deleteInstanceConfig(name);
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteInstanceConfigRequest actualRequest = (DeleteInstanceConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteInstanceConfigExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteInstanceConfig(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listInstanceConfigOperationsTest() throws Exception {
        Operation responsesElement = Operation.newBuilder().build();
        ListInstanceConfigOperationsResponse expectedResponse = ListInstanceConfigOperationsResponse.newBuilder().setNextPageToken("").addAllOperations(Arrays.asList(responsesElement)).build();
        mockInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        InstanceAdminClient.ListInstanceConfigOperationsPagedResponse pagedListResponse = this.client.listInstanceConfigOperations(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getOperationsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListInstanceConfigOperationsRequest actualRequest = (ListInstanceConfigOperationsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listInstanceConfigOperationsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            this.client.listInstanceConfigOperations(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listInstanceConfigOperationsTest2() throws Exception {
        Operation responsesElement = Operation.newBuilder().build();
        ListInstanceConfigOperationsResponse expectedResponse = ListInstanceConfigOperationsResponse.newBuilder().setNextPageToken("").addAllOperations(Arrays.asList(responsesElement)).build();
        mockInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        InstanceAdminClient.ListInstanceConfigOperationsPagedResponse pagedListResponse = this.client.listInstanceConfigOperations(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getOperationsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListInstanceConfigOperationsRequest actualRequest = (ListInstanceConfigOperationsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listInstanceConfigOperationsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listInstanceConfigOperations(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listInstancesTest() throws Exception {
        Instance responsesElement = Instance.newBuilder().build();
        ListInstancesResponse expectedResponse = ListInstancesResponse.newBuilder().setNextPageToken("").addAllInstances(Arrays.asList(responsesElement)).build();
        mockInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        InstanceAdminClient.ListInstancesPagedResponse pagedListResponse = this.client.listInstances(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getInstancesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListInstancesRequest actualRequest = (ListInstancesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listInstancesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            this.client.listInstances(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listInstancesTest2() throws Exception {
        Instance responsesElement = Instance.newBuilder().build();
        ListInstancesResponse expectedResponse = ListInstancesResponse.newBuilder().setNextPageToken("").addAllInstances(Arrays.asList(responsesElement)).build();
        mockInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        InstanceAdminClient.ListInstancesPagedResponse pagedListResponse = this.client.listInstances(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getInstancesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListInstancesRequest actualRequest = (ListInstancesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listInstancesExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listInstances(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listInstancePartitionsTest() throws Exception {
        InstancePartition responsesElement = InstancePartition.newBuilder().build();
        ListInstancePartitionsResponse expectedResponse = ListInstancePartitionsResponse.newBuilder().setNextPageToken("").addAllInstancePartitions(Arrays.asList(responsesElement)).build();
        mockInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
        InstanceAdminClient.ListInstancePartitionsPagedResponse pagedListResponse = this.client.listInstancePartitions(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getInstancePartitionsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListInstancePartitionsRequest actualRequest = (ListInstancePartitionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listInstancePartitionsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)exception);
        try {
            InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
            this.client.listInstancePartitions(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listInstancePartitionsTest2() throws Exception {
        InstancePartition responsesElement = InstancePartition.newBuilder().build();
        ListInstancePartitionsResponse expectedResponse = ListInstancePartitionsResponse.newBuilder().setNextPageToken("").addAllInstancePartitions(Arrays.asList(responsesElement)).build();
        mockInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        InstanceAdminClient.ListInstancePartitionsPagedResponse pagedListResponse = this.client.listInstancePartitions(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getInstancePartitionsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListInstancePartitionsRequest actualRequest = (ListInstancePartitionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listInstancePartitionsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listInstancePartitions(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getInstanceTest() throws Exception {
        Instance expectedResponse = Instance.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]").toString()).setConfig(InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]").toString()).setDisplayName("displayName1714148973").setNodeCount(1539922066).setProcessingUnits(-329117885).addAllReplicaComputeCapacity(new ArrayList()).setAutoscalingConfig(AutoscalingConfig.newBuilder().build()).putAllLabels(new HashMap()).addAllEndpointUris(new ArrayList()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).build();
        mockInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        InstanceName name = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
        Instance actualResponse = this.client.getInstance(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetInstanceRequest actualRequest = (GetInstanceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getInstanceExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)exception);
        try {
            InstanceName name = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
            this.client.getInstance(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getInstanceTest2() throws Exception {
        Instance expectedResponse = Instance.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]").toString()).setConfig(InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]").toString()).setDisplayName("displayName1714148973").setNodeCount(1539922066).setProcessingUnits(-329117885).addAllReplicaComputeCapacity(new ArrayList()).setAutoscalingConfig(AutoscalingConfig.newBuilder().build()).putAllLabels(new HashMap()).addAllEndpointUris(new ArrayList()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).build();
        mockInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Instance actualResponse = this.client.getInstance(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetInstanceRequest actualRequest = (GetInstanceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getInstanceExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getInstance(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createInstanceTest() throws Exception {
        Instance expectedResponse = Instance.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]").toString()).setConfig(InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]").toString()).setDisplayName("displayName1714148973").setNodeCount(1539922066).setProcessingUnits(-329117885).addAllReplicaComputeCapacity(new ArrayList()).setAutoscalingConfig(AutoscalingConfig.newBuilder().build()).putAllLabels(new HashMap()).addAllEndpointUris(new ArrayList()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("createInstanceTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockInstanceAdmin.addResponse((AbstractMessage)resultOperation);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        String instanceId = "instanceId902024336";
        Instance instance = Instance.newBuilder().build();
        Instance actualResponse = (Instance)this.client.createInstanceAsync(parent, instanceId, instance).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateInstanceRequest actualRequest = (CreateInstanceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)instanceId, (Object)actualRequest.getInstanceId());
        Assert.assertEquals((Object)instance, (Object)actualRequest.getInstance());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createInstanceExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            String instanceId = "instanceId902024336";
            Instance instance = Instance.newBuilder().build();
            this.client.createInstanceAsync(parent, instanceId, instance).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createInstanceTest2() throws Exception {
        Instance expectedResponse = Instance.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]").toString()).setConfig(InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]").toString()).setDisplayName("displayName1714148973").setNodeCount(1539922066).setProcessingUnits(-329117885).addAllReplicaComputeCapacity(new ArrayList()).setAutoscalingConfig(AutoscalingConfig.newBuilder().build()).putAllLabels(new HashMap()).addAllEndpointUris(new ArrayList()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("createInstanceTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockInstanceAdmin.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        String instanceId = "instanceId902024336";
        Instance instance = Instance.newBuilder().build();
        Instance actualResponse = (Instance)this.client.createInstanceAsync(parent, instanceId, instance).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateInstanceRequest actualRequest = (CreateInstanceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)instanceId, (Object)actualRequest.getInstanceId());
        Assert.assertEquals((Object)instance, (Object)actualRequest.getInstance());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createInstanceExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            String instanceId = "instanceId902024336";
            Instance instance = Instance.newBuilder().build();
            this.client.createInstanceAsync(parent, instanceId, instance).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void updateInstanceTest() throws Exception {
        Instance expectedResponse = Instance.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]").toString()).setConfig(InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]").toString()).setDisplayName("displayName1714148973").setNodeCount(1539922066).setProcessingUnits(-329117885).addAllReplicaComputeCapacity(new ArrayList()).setAutoscalingConfig(AutoscalingConfig.newBuilder().build()).putAllLabels(new HashMap()).addAllEndpointUris(new ArrayList()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("updateInstanceTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockInstanceAdmin.addResponse((AbstractMessage)resultOperation);
        Instance instance = Instance.newBuilder().build();
        FieldMask fieldMask = FieldMask.newBuilder().build();
        Instance actualResponse = (Instance)this.client.updateInstanceAsync(instance, fieldMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateInstanceRequest actualRequest = (UpdateInstanceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)instance, (Object)actualRequest.getInstance());
        Assert.assertEquals((Object)fieldMask, (Object)actualRequest.getFieldMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateInstanceExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)exception);
        try {
            Instance instance = Instance.newBuilder().build();
            FieldMask fieldMask = FieldMask.newBuilder().build();
            this.client.updateInstanceAsync(instance, fieldMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteInstanceTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        InstanceName name = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
        this.client.deleteInstance(name);
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteInstanceRequest actualRequest = (DeleteInstanceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteInstanceExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)exception);
        try {
            InstanceName name = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
            this.client.deleteInstance(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteInstanceTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        this.client.deleteInstance(name);
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteInstanceRequest actualRequest = (DeleteInstanceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteInstanceExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteInstance(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void setIamPolicyTest() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        InstanceName resource = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
        Policy policy = Policy.newBuilder().build();
        Policy actualResponse = this.client.setIamPolicy((ResourceName)resource, policy);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SetIamPolicyRequest actualRequest = (SetIamPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)resource.toString(), (Object)actualRequest.getResource());
        Assert.assertEquals((Object)policy, (Object)actualRequest.getPolicy());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void setIamPolicyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)exception);
        try {
            InstanceName resource = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
            Policy policy = Policy.newBuilder().build();
            this.client.setIamPolicy((ResourceName)resource, policy);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void setIamPolicyTest2() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        String resource = "resource-341064690";
        Policy policy = Policy.newBuilder().build();
        Policy actualResponse = this.client.setIamPolicy(resource, policy);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SetIamPolicyRequest actualRequest = (SetIamPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)resource, (Object)actualRequest.getResource());
        Assert.assertEquals((Object)policy, (Object)actualRequest.getPolicy());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void setIamPolicyExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)exception);
        try {
            String resource = "resource-341064690";
            Policy policy = Policy.newBuilder().build();
            this.client.setIamPolicy(resource, policy);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getIamPolicyTest() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        InstanceName resource = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
        Policy actualResponse = this.client.getIamPolicy((ResourceName)resource);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetIamPolicyRequest actualRequest = (GetIamPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)resource.toString(), (Object)actualRequest.getResource());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getIamPolicyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)exception);
        try {
            InstanceName resource = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
            this.client.getIamPolicy((ResourceName)resource);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getIamPolicyTest2() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        String resource = "resource-341064690";
        Policy actualResponse = this.client.getIamPolicy(resource);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetIamPolicyRequest actualRequest = (GetIamPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)resource, (Object)actualRequest.getResource());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getIamPolicyExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)exception);
        try {
            String resource = "resource-341064690";
            this.client.getIamPolicy(resource);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testIamPermissionsTest() throws Exception {
        TestIamPermissionsResponse expectedResponse = TestIamPermissionsResponse.newBuilder().addAllPermissions(new ArrayList()).build();
        mockInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        InstanceName resource = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
        ArrayList permissions = new ArrayList();
        TestIamPermissionsResponse actualResponse = this.client.testIamPermissions((ResourceName)resource, permissions);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        TestIamPermissionsRequest actualRequest = (TestIamPermissionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)resource.toString(), (Object)actualRequest.getResource());
        Assert.assertEquals(permissions, (Object)actualRequest.getPermissionsList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void testIamPermissionsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)exception);
        try {
            InstanceName resource = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
            ArrayList permissions = new ArrayList();
            this.client.testIamPermissions((ResourceName)resource, permissions);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testIamPermissionsTest2() throws Exception {
        TestIamPermissionsResponse expectedResponse = TestIamPermissionsResponse.newBuilder().addAllPermissions(new ArrayList()).build();
        mockInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        String resource = "resource-341064690";
        ArrayList permissions = new ArrayList();
        TestIamPermissionsResponse actualResponse = this.client.testIamPermissions(resource, permissions);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        TestIamPermissionsRequest actualRequest = (TestIamPermissionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)resource, (Object)actualRequest.getResource());
        Assert.assertEquals(permissions, (Object)actualRequest.getPermissionsList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void testIamPermissionsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)exception);
        try {
            String resource = "resource-341064690";
            ArrayList permissions = new ArrayList();
            this.client.testIamPermissions(resource, permissions);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getInstancePartitionTest() throws Exception {
        InstancePartition expectedResponse = InstancePartition.newBuilder().setName(InstancePartitionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[INSTANCE_PARTITION]").toString()).setConfig(InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]").toString()).setDisplayName("displayName1714148973").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).addAllReferencingDatabases(new ArrayList()).addAllReferencingBackups(new ArrayList()).setEtag("etag3123477").build();
        mockInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        InstancePartitionName name = InstancePartitionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[INSTANCE_PARTITION]");
        InstancePartition actualResponse = this.client.getInstancePartition(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetInstancePartitionRequest actualRequest = (GetInstancePartitionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getInstancePartitionExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)exception);
        try {
            InstancePartitionName name = InstancePartitionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[INSTANCE_PARTITION]");
            this.client.getInstancePartition(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getInstancePartitionTest2() throws Exception {
        InstancePartition expectedResponse = InstancePartition.newBuilder().setName(InstancePartitionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[INSTANCE_PARTITION]").toString()).setConfig(InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]").toString()).setDisplayName("displayName1714148973").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).addAllReferencingDatabases(new ArrayList()).addAllReferencingBackups(new ArrayList()).setEtag("etag3123477").build();
        mockInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        InstancePartition actualResponse = this.client.getInstancePartition(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetInstancePartitionRequest actualRequest = (GetInstancePartitionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getInstancePartitionExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getInstancePartition(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createInstancePartitionTest() throws Exception {
        InstancePartition expectedResponse = InstancePartition.newBuilder().setName(InstancePartitionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[INSTANCE_PARTITION]").toString()).setConfig(InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]").toString()).setDisplayName("displayName1714148973").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).addAllReferencingDatabases(new ArrayList()).addAllReferencingBackups(new ArrayList()).setEtag("etag3123477").build();
        Operation resultOperation = Operation.newBuilder().setName("createInstancePartitionTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockInstanceAdmin.addResponse((AbstractMessage)resultOperation);
        InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
        InstancePartition instancePartition = InstancePartition.newBuilder().build();
        String instancePartitionId = "instancePartitionId1364450768";
        InstancePartition actualResponse = (InstancePartition)this.client.createInstancePartitionAsync(parent, instancePartition, instancePartitionId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateInstancePartitionRequest actualRequest = (CreateInstancePartitionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)instancePartition, (Object)actualRequest.getInstancePartition());
        Assert.assertEquals((Object)instancePartitionId, (Object)actualRequest.getInstancePartitionId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createInstancePartitionExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)exception);
        try {
            InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
            InstancePartition instancePartition = InstancePartition.newBuilder().build();
            String instancePartitionId = "instancePartitionId1364450768";
            this.client.createInstancePartitionAsync(parent, instancePartition, instancePartitionId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createInstancePartitionTest2() throws Exception {
        InstancePartition expectedResponse = InstancePartition.newBuilder().setName(InstancePartitionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[INSTANCE_PARTITION]").toString()).setConfig(InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]").toString()).setDisplayName("displayName1714148973").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).addAllReferencingDatabases(new ArrayList()).addAllReferencingBackups(new ArrayList()).setEtag("etag3123477").build();
        Operation resultOperation = Operation.newBuilder().setName("createInstancePartitionTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockInstanceAdmin.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        InstancePartition instancePartition = InstancePartition.newBuilder().build();
        String instancePartitionId = "instancePartitionId1364450768";
        InstancePartition actualResponse = (InstancePartition)this.client.createInstancePartitionAsync(parent, instancePartition, instancePartitionId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateInstancePartitionRequest actualRequest = (CreateInstancePartitionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)instancePartition, (Object)actualRequest.getInstancePartition());
        Assert.assertEquals((Object)instancePartitionId, (Object)actualRequest.getInstancePartitionId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createInstancePartitionExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            InstancePartition instancePartition = InstancePartition.newBuilder().build();
            String instancePartitionId = "instancePartitionId1364450768";
            this.client.createInstancePartitionAsync(parent, instancePartition, instancePartitionId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteInstancePartitionTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        InstancePartitionName name = InstancePartitionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[INSTANCE_PARTITION]");
        this.client.deleteInstancePartition(name);
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteInstancePartitionRequest actualRequest = (DeleteInstancePartitionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteInstancePartitionExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)exception);
        try {
            InstancePartitionName name = InstancePartitionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[INSTANCE_PARTITION]");
            this.client.deleteInstancePartition(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteInstancePartitionTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        this.client.deleteInstancePartition(name);
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteInstancePartitionRequest actualRequest = (DeleteInstancePartitionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteInstancePartitionExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteInstancePartition(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateInstancePartitionTest() throws Exception {
        InstancePartition expectedResponse = InstancePartition.newBuilder().setName(InstancePartitionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[INSTANCE_PARTITION]").toString()).setConfig(InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]").toString()).setDisplayName("displayName1714148973").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).addAllReferencingDatabases(new ArrayList()).addAllReferencingBackups(new ArrayList()).setEtag("etag3123477").build();
        Operation resultOperation = Operation.newBuilder().setName("updateInstancePartitionTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockInstanceAdmin.addResponse((AbstractMessage)resultOperation);
        InstancePartition instancePartition = InstancePartition.newBuilder().build();
        FieldMask fieldMask = FieldMask.newBuilder().build();
        InstancePartition actualResponse = (InstancePartition)this.client.updateInstancePartitionAsync(instancePartition, fieldMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateInstancePartitionRequest actualRequest = (UpdateInstancePartitionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)instancePartition, (Object)actualRequest.getInstancePartition());
        Assert.assertEquals((Object)fieldMask, (Object)actualRequest.getFieldMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateInstancePartitionExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)exception);
        try {
            InstancePartition instancePartition = InstancePartition.newBuilder().build();
            FieldMask fieldMask = FieldMask.newBuilder().build();
            this.client.updateInstancePartitionAsync(instancePartition, fieldMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void listInstancePartitionOperationsTest() throws Exception {
        Operation responsesElement = Operation.newBuilder().build();
        ListInstancePartitionOperationsResponse expectedResponse = ListInstancePartitionOperationsResponse.newBuilder().setNextPageToken("").addAllOperations(Arrays.asList(responsesElement)).build();
        mockInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
        InstanceAdminClient.ListInstancePartitionOperationsPagedResponse pagedListResponse = this.client.listInstancePartitionOperations(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getOperationsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListInstancePartitionOperationsRequest actualRequest = (ListInstancePartitionOperationsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listInstancePartitionOperationsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)exception);
        try {
            InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
            this.client.listInstancePartitionOperations(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listInstancePartitionOperationsTest2() throws Exception {
        Operation responsesElement = Operation.newBuilder().build();
        ListInstancePartitionOperationsResponse expectedResponse = ListInstancePartitionOperationsResponse.newBuilder().setNextPageToken("").addAllOperations(Arrays.asList(responsesElement)).build();
        mockInstanceAdmin.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        InstanceAdminClient.ListInstancePartitionOperationsPagedResponse pagedListResponse = this.client.listInstancePartitionOperations(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getOperationsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListInstancePartitionOperationsRequest actualRequest = (ListInstancePartitionOperationsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listInstancePartitionOperationsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listInstancePartitionOperations(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void moveInstanceTest() throws Exception {
        MoveInstanceResponse expectedResponse = MoveInstanceResponse.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("moveInstanceTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockInstanceAdmin.addResponse((AbstractMessage)resultOperation);
        MoveInstanceRequest request = MoveInstanceRequest.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]").toString()).setTargetConfig(InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]").toString()).build();
        MoveInstanceResponse actualResponse = (MoveInstanceResponse)this.client.moveInstanceAsync(request).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockInstanceAdmin.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        MoveInstanceRequest actualRequest = (MoveInstanceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getName(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)request.getTargetConfig(), (Object)actualRequest.getTargetConfig());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void moveInstanceExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockInstanceAdmin.addException((Exception)exception);
        try {
            MoveInstanceRequest request = MoveInstanceRequest.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]").toString()).setTargetConfig(InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]").toString()).build();
            this.client.moveInstanceAsync(request).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }
}

