/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.AbortedDueToConcurrentModificationException;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.connection.AbstractMockServerTest;
import com.google.cloud.spanner.connection.Connection;
import com.google.cloud.spanner.connection.ITAbstractSpannerTest;
import com.google.cloud.spanner.connection.RandomResultSetGenerator;
import com.google.cloud.spanner.connection.SpannerPool;
import com.google.common.collect.ImmutableList;
import com.google.spanner.v1.BeginTransactionRequest;
import com.google.spanner.v1.CommitRequest;
import com.google.spanner.v1.ExecuteBatchDmlRequest;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.RollbackRequest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DelayTransactionStartUntilFirstWriteMockServerTest
extends AbstractMockServerTest {
    @Parameterized.Parameter
    public Dialect dialect;

    @Parameterized.Parameters(name="dialect = {0}")
    public static Object[] data() {
        return Dialect.values();
    }

    @Before
    public void setupDialect() {
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.detectDialectResult(this.dialect));
    }

    @After
    public void clearRequests() {
        mockSpanner.clearRequests();
        SpannerPool.closeSpannerPool();
    }

    @Test
    public void testEnable() {
        String prefix = this.dialect == Dialect.POSTGRESQL ? "spanner." : "";
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection(";delayTransactionStartUntilFirstWrite=true");){
            Assert.assertTrue((boolean)connection.isDelayTransactionStartUntilFirstWrite());
            try (ResultSet resultSet = connection.executeQuery(Statement.of((String)String.format("show variable %sdelay_transaction_start_until_first_write", prefix)), new Options.QueryOption[0]);){
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertTrue((boolean)resultSet.getBoolean(0));
                Assert.assertTrue((boolean)resultSet.getBoolean(prefix.toUpperCase() + "DELAY_TRANSACTION_START_UNTIL_FIRST_WRITE"));
                Assert.assertFalse((boolean)resultSet.next());
            }
        }
        connection = this.createConnection();
        try {
            Assert.assertFalse((boolean)connection.isDelayTransactionStartUntilFirstWrite());
            connection.execute(Statement.of((String)String.format("set %sdelay_transaction_start_until_first_write=true", prefix)));
            Assert.assertTrue((boolean)connection.isDelayTransactionStartUntilFirstWrite());
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    @Test
    public void testDisable() {
        String prefix = this.dialect == Dialect.POSTGRESQL ? "spanner." : "";
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            Assert.assertFalse((boolean)connection.isDelayTransactionStartUntilFirstWrite());
            try (ResultSet resultSet = connection.executeQuery(Statement.of((String)String.format("show variable %sdelay_transaction_start_until_first_write", prefix)), new Options.QueryOption[0]);){
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertFalse((boolean)resultSet.getBoolean(0));
                Assert.assertFalse((boolean)resultSet.getBoolean(prefix.toUpperCase() + "DELAY_TRANSACTION_START_UNTIL_FIRST_WRITE"));
                Assert.assertFalse((boolean)resultSet.next());
            }
        }
        connection = this.createConnection(";delayTransactionStartUntilFirstWrite=true");
        try {
            Assert.assertTrue((boolean)connection.isDelayTransactionStartUntilFirstWrite());
            connection.execute(Statement.of((String)String.format("set %sdelay_transaction_start_until_first_write=false", prefix)));
            Assert.assertFalse((boolean)connection.isDelayTransactionStartUntilFirstWrite());
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    @Test
    public void testDefaultUsesRealTransactions() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            this.executeRandomQuery(connection);
            connection.commit();
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
            ExecuteSqlRequest request = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0);
            Assert.assertTrue((boolean)request.hasTransaction());
            Assert.assertTrue((boolean)request.getTransaction().hasBegin());
            Assert.assertTrue((boolean)request.getTransaction().getBegin().hasReadWrite());
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
        }
    }

    @Test
    public void testTransactionWithOneQuery() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setDelayTransactionStartUntilFirstWrite(true);
            for (boolean commit : new boolean[]{true, false}) {
                this.executeRandomQuery(connection);
                if (commit) {
                    connection.commit();
                } else {
                    connection.rollback();
                }
                Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
                ExecuteSqlRequest request = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0);
                Assert.assertFalse((boolean)request.hasTransaction());
                Assert.assertEquals((long)0L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
                Assert.assertEquals((long)0L, (long)mockSpanner.countRequestsOfType(RollbackRequest.class));
                mockSpanner.clearRequests();
            }
        }
    }

    @Test
    public void testTransactionWithTwoQueries() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setDelayTransactionStartUntilFirstWrite(true);
            for (boolean commit : new boolean[]{true, false}) {
                this.executeRandomQuery(connection);
                this.executeRandomQuery(connection);
                if (commit) {
                    connection.commit();
                } else {
                    connection.rollback();
                }
                Assert.assertEquals((long)2L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
                Assert.assertFalse((boolean)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0).hasTransaction());
                Assert.assertFalse((boolean)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(1).hasTransaction());
                Assert.assertEquals((long)0L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
                mockSpanner.clearRequests();
            }
        }
    }

    @Test
    public void testTransactionWithSingleDml() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setDelayTransactionStartUntilFirstWrite(true);
            connection.executeUpdate(INSERT_STATEMENT);
            connection.commit();
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
            ExecuteSqlRequest request = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0);
            Assert.assertTrue((boolean)request.hasTransaction());
            Assert.assertTrue((boolean)request.getTransaction().hasBegin());
            Assert.assertTrue((boolean)request.getTransaction().getBegin().hasReadWrite());
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
        }
    }

    @Test
    public void testTransactionWithQueryFollowedByDml() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setDelayTransactionStartUntilFirstWrite(true);
            this.executeRandomQuery(connection);
            connection.executeUpdate(INSERT_STATEMENT);
            connection.commit();
            Assert.assertEquals((long)2L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
            ExecuteSqlRequest queryRequest = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0);
            Assert.assertFalse((boolean)queryRequest.hasTransaction());
            ExecuteSqlRequest dmlRequest = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(1);
            Assert.assertTrue((boolean)dmlRequest.hasTransaction());
            Assert.assertTrue((boolean)dmlRequest.getTransaction().hasBegin());
            Assert.assertTrue((boolean)dmlRequest.getTransaction().getBegin().hasReadWrite());
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
        }
    }

    @Test
    public void testTransactionWithDmlFollowedByQuery() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setDelayTransactionStartUntilFirstWrite(true);
            connection.executeUpdate(INSERT_STATEMENT);
            this.executeRandomQuery(connection);
            connection.commit();
            Assert.assertEquals((long)2L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
            ExecuteSqlRequest dmlRequest = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0);
            Assert.assertTrue((boolean)dmlRequest.hasTransaction());
            Assert.assertTrue((boolean)dmlRequest.getTransaction().hasBegin());
            Assert.assertTrue((boolean)dmlRequest.getTransaction().getBegin().hasReadWrite());
            ExecuteSqlRequest queryRequest = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(1);
            Assert.assertTrue((boolean)queryRequest.hasTransaction());
            Assert.assertTrue((boolean)queryRequest.getTransaction().hasId());
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
        }
    }

    @Test
    public void testTransactionWithQueryFollowedByBatchDml() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setDelayTransactionStartUntilFirstWrite(true);
            this.executeRandomQuery(connection);
            connection.executeBatchUpdate((Iterable)ImmutableList.of((Object)INSERT_STATEMENT, (Object)INSERT_STATEMENT));
            connection.commit();
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
            ExecuteSqlRequest queryRequest = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0);
            Assert.assertFalse((boolean)queryRequest.hasTransaction());
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteBatchDmlRequest.class));
            ExecuteBatchDmlRequest dmlRequest = mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).get(0);
            Assert.assertTrue((boolean)dmlRequest.hasTransaction());
            Assert.assertTrue((boolean)dmlRequest.getTransaction().hasBegin());
            Assert.assertTrue((boolean)dmlRequest.getTransaction().getBegin().hasReadWrite());
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
        }
    }

    @Test
    public void testTransactionWithBatchDmlFollowedByQuery() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setDelayTransactionStartUntilFirstWrite(true);
            connection.executeBatchUpdate((Iterable)ImmutableList.of((Object)INSERT_STATEMENT, (Object)INSERT_STATEMENT));
            this.executeRandomQuery(connection);
            connection.commit();
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteBatchDmlRequest.class));
            ExecuteBatchDmlRequest dmlRequest = mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).get(0);
            Assert.assertTrue((boolean)dmlRequest.hasTransaction());
            Assert.assertTrue((boolean)dmlRequest.getTransaction().hasBegin());
            Assert.assertTrue((boolean)dmlRequest.getTransaction().getBegin().hasReadWrite());
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
            ExecuteSqlRequest queryRequest = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0);
            Assert.assertTrue((boolean)queryRequest.hasTransaction());
            Assert.assertTrue((boolean)queryRequest.getTransaction().hasId());
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
        }
    }

    @Test
    public void testTransactionWithQueryFollowedByDmlReturning() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setDelayTransactionStartUntilFirstWrite(true);
            this.executeRandomQuery(connection);
            try (ResultSet resultSet = connection.executeQuery(this.dialect == Dialect.POSTGRESQL ? PG_INSERT_RETURNING_STATEMENT : INSERT_RETURNING_STATEMENT, new Options.QueryOption[0]);){
                while (resultSet.next()) {
                }
            }
            connection.commit();
            Assert.assertEquals((long)2L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
            ExecuteSqlRequest queryRequest = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0);
            Assert.assertFalse((boolean)queryRequest.hasTransaction());
            ExecuteSqlRequest dmlRequest = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(1);
            Assert.assertTrue((boolean)dmlRequest.hasTransaction());
            Assert.assertTrue((boolean)dmlRequest.getTransaction().hasBegin());
            Assert.assertTrue((boolean)dmlRequest.getTransaction().getBegin().hasReadWrite());
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
        }
    }

    @Test
    public void testTransactionWithDmlReturningFollowedByQuery() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setDelayTransactionStartUntilFirstWrite(true);
            try (ResultSet resultSet = connection.executeQuery(this.dialect == Dialect.POSTGRESQL ? PG_INSERT_RETURNING_STATEMENT : INSERT_RETURNING_STATEMENT, new Options.QueryOption[0]);){
                while (resultSet.next()) {
                }
            }
            this.executeRandomQuery(connection);
            connection.commit();
            Assert.assertEquals((long)2L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
            ExecuteSqlRequest dmlRequest = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0);
            Assert.assertTrue((boolean)dmlRequest.hasTransaction());
            Assert.assertTrue((boolean)dmlRequest.getTransaction().hasBegin());
            Assert.assertTrue((boolean)dmlRequest.getTransaction().getBegin().hasReadWrite());
            ExecuteSqlRequest queryRequest = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(1);
            Assert.assertTrue((boolean)queryRequest.hasTransaction());
            Assert.assertTrue((boolean)queryRequest.getTransaction().hasId());
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
        }
    }

    @Test
    public void testTransactionWithQueryFollowedByMutations() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setDelayTransactionStartUntilFirstWrite(true);
            this.executeRandomQuery(connection);
            connection.bufferedWrite(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"foo").set("id").to(1L)).set("value").to("one")).build());
            connection.commit();
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
            ExecuteSqlRequest queryRequest = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0);
            Assert.assertFalse((boolean)queryRequest.hasTransaction());
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(BeginTransactionRequest.class));
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
        }
    }

    @Test
    public void testTransactionWithMutationsFollowedByQuery() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setDelayTransactionStartUntilFirstWrite(true);
            connection.bufferedWrite(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)"foo").set("id").to(1L)).set("value").to("one")).build());
            this.executeRandomQuery(connection);
            connection.commit();
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
            ExecuteSqlRequest queryRequest = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0);
            Assert.assertFalse((boolean)queryRequest.hasTransaction());
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(BeginTransactionRequest.class));
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
        }
    }

    @Test
    public void testTransactionWithQueryFollowedByDmlAborted() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setDelayTransactionStartUntilFirstWrite(true);
            this.executeRandomQuery(connection);
            connection.executeUpdate(INSERT_STATEMENT);
            mockSpanner.abortNextStatement();
            connection.commit();
            Assert.assertEquals((long)3L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
            ExecuteSqlRequest queryRequest = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0);
            Assert.assertFalse((boolean)queryRequest.hasTransaction());
            ExecuteSqlRequest firstDmlRequest = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(1);
            Assert.assertTrue((boolean)firstDmlRequest.hasTransaction());
            Assert.assertTrue((boolean)firstDmlRequest.getTransaction().hasBegin());
            Assert.assertTrue((boolean)firstDmlRequest.getTransaction().getBegin().hasReadWrite());
            ExecuteSqlRequest secondDmlRequest = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(2);
            Assert.assertTrue((boolean)secondDmlRequest.hasTransaction());
            Assert.assertTrue((boolean)secondDmlRequest.getTransaction().hasBegin());
            Assert.assertTrue((boolean)secondDmlRequest.getTransaction().getBegin().hasReadWrite());
            Assert.assertEquals((long)2L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
        }
    }

    @Test
    public void testTransactionWithDmlFollowedByQueryAborted() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setDelayTransactionStartUntilFirstWrite(true);
            connection.executeUpdate(INSERT_STATEMENT);
            this.executeRandomQuery(connection);
            mockSpanner.abortNextStatement();
            connection.commit();
            Assert.assertEquals((long)4L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
            ExecuteSqlRequest firstQueryRequest = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0);
            Assert.assertTrue((boolean)firstQueryRequest.hasTransaction());
            Assert.assertTrue((boolean)firstQueryRequest.getTransaction().hasBegin());
            Assert.assertTrue((boolean)firstQueryRequest.getTransaction().getBegin().hasReadWrite());
            ExecuteSqlRequest firstDmlRequest = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(1);
            Assert.assertTrue((boolean)firstDmlRequest.hasTransaction());
            Assert.assertTrue((boolean)firstDmlRequest.getTransaction().hasId());
            ExecuteSqlRequest secondQueryRequest = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(2);
            Assert.assertTrue((boolean)secondQueryRequest.hasTransaction());
            Assert.assertTrue((boolean)firstQueryRequest.getTransaction().hasBegin());
            Assert.assertTrue((boolean)firstQueryRequest.getTransaction().getBegin().hasReadWrite());
            ExecuteSqlRequest secondDmlRequest = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(3);
            Assert.assertTrue((boolean)secondDmlRequest.hasTransaction());
            Assert.assertTrue((boolean)secondDmlRequest.getTransaction().hasId());
            Assert.assertEquals((long)2L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
        }
    }

    @Test
    public void testTransactionWithDmlFollowedByQueryWithFailedRetry() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setDelayTransactionStartUntilFirstWrite(true);
            connection.executeUpdate(INSERT_STATEMENT);
            this.executeRandomQuery(connection);
            mockSpanner.abortNextStatement();
            mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(SELECT_RANDOM_STATEMENT, new RandomResultSetGenerator(10).generate()));
            Assert.assertThrows(AbortedDueToConcurrentModificationException.class, () -> ((Connection)connection).commit());
            Assert.assertEquals((long)4L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
            ExecuteSqlRequest firstQueryRequest = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0);
            Assert.assertTrue((boolean)firstQueryRequest.hasTransaction());
            Assert.assertTrue((boolean)firstQueryRequest.getTransaction().hasBegin());
            Assert.assertTrue((boolean)firstQueryRequest.getTransaction().getBegin().hasReadWrite());
            ExecuteSqlRequest firstDmlRequest = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(1);
            Assert.assertTrue((boolean)firstDmlRequest.hasTransaction());
            Assert.assertTrue((boolean)firstDmlRequest.getTransaction().hasId());
            ExecuteSqlRequest secondQueryRequest = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(2);
            Assert.assertTrue((boolean)secondQueryRequest.hasTransaction());
            Assert.assertTrue((boolean)firstQueryRequest.getTransaction().hasBegin());
            Assert.assertTrue((boolean)firstQueryRequest.getTransaction().getBegin().hasReadWrite());
            ExecuteSqlRequest secondDmlRequest = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(3);
            Assert.assertTrue((boolean)secondDmlRequest.hasTransaction());
            Assert.assertTrue((boolean)secondDmlRequest.getTransaction().hasId());
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
        }
    }

    @Test
    public void testTransactionWithQueryFollowedByDmlAborted_RetrySucceedsWithModifiedQueryResults() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setDelayTransactionStartUntilFirstWrite(true);
            this.executeRandomQuery(connection);
            connection.executeUpdate(INSERT_STATEMENT);
            mockSpanner.abortNextStatement();
            mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(SELECT_RANDOM_STATEMENT, new RandomResultSetGenerator(10).generate()));
            connection.commit();
            Assert.assertEquals((long)3L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
            ExecuteSqlRequest queryRequest = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0);
            Assert.assertFalse((boolean)queryRequest.hasTransaction());
            ExecuteSqlRequest firstDmlRequest = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(1);
            Assert.assertTrue((boolean)firstDmlRequest.hasTransaction());
            Assert.assertTrue((boolean)firstDmlRequest.getTransaction().hasBegin());
            Assert.assertTrue((boolean)firstDmlRequest.getTransaction().getBegin().hasReadWrite());
            ExecuteSqlRequest secondDmlRequest = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(2);
            Assert.assertTrue((boolean)secondDmlRequest.hasTransaction());
            Assert.assertTrue((boolean)secondDmlRequest.getTransaction().hasBegin());
            Assert.assertTrue((boolean)secondDmlRequest.getTransaction().getBegin().hasReadWrite());
            Assert.assertEquals((long)2L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
        }
    }

    @Test
    public void testTransactionWithRollbackToSavepointWithoutRealTransaction() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setDelayTransactionStartUntilFirstWrite(true);
            this.executeRandomQuery(connection);
            connection.savepoint("s1");
            this.executeRandomQuery(connection);
            connection.rollbackToSavepoint("s1");
            this.executeRandomQuery(connection);
            connection.commit();
            Assert.assertEquals((long)3L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
            Assert.assertFalse((boolean)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0).hasTransaction());
            Assert.assertFalse((boolean)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(1).hasTransaction());
            Assert.assertFalse((boolean)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(2).hasTransaction());
            Assert.assertEquals((long)0L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
            Assert.assertEquals((long)0L, (long)mockSpanner.countRequestsOfType(RollbackRequest.class));
        }
    }

    private void executeRandomQuery(Connection connection) {
        try (ResultSet resultSet = connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]);){
            while (resultSet.next()) {
            }
        }
    }
}

