/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.connection.ClientSideStatementImpl;
import com.google.cloud.spanner.connection.ClientSideStatementValueConverter;
import com.google.cloud.spanner.connection.ClientSideStatementValueConverters;
import com.google.cloud.spanner.connection.ClientSideStatements;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ReadOnlyStalenessConverterTest {
    @Parameterized.Parameter
    public Dialect dialect;

    @Parameterized.Parameters(name="dialect = {0}")
    public static Object[] data() {
        return Dialect.values();
    }

    static String getAllowedValues(Class<? extends ClientSideStatementValueConverter<?>> converterClass, Dialect dialect) throws ClientSideStatementImpl.CompileException {
        Set statements = ClientSideStatements.getInstance((Dialect)dialect).getCompiledStatements();
        for (ClientSideStatementImpl statement : statements) {
            if (statement.getSetStatement() == null || !converterClass.getName().endsWith(statement.getSetStatement().getConverterName())) continue;
            return statement.getSetStatement().getAllowedValues();
        }
        return null;
    }

    @Test
    public void testConvert() throws ClientSideStatementImpl.CompileException {
        String allowedValues = ReadOnlyStalenessConverterTest.getAllowedValues(ClientSideStatementValueConverters.ReadOnlyStalenessConverter.class, this.dialect);
        MatcherAssert.assertThat((Object)allowedValues, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        ClientSideStatementValueConverters.ReadOnlyStalenessConverter converter = new ClientSideStatementValueConverters.ReadOnlyStalenessConverter(allowedValues);
        MatcherAssert.assertThat((Object)converter.convert("strong"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)TimestampBound.strong())));
        MatcherAssert.assertThat((Object)converter.convert("Strong"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)TimestampBound.strong())));
        MatcherAssert.assertThat((Object)converter.convert("STRONG"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)TimestampBound.strong())));
        MatcherAssert.assertThat((Object)converter.convert("read_timestamp 2018-10-01T23:11:15.10001Z"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)TimestampBound.ofReadTimestamp((Timestamp)Timestamp.parseTimestamp((String)"2018-10-01T23:11:15.10001Z")))));
        MatcherAssert.assertThat((Object)converter.convert("Read_Timestamp 2018-10-01T23:11:15.999Z"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)TimestampBound.ofReadTimestamp((Timestamp)Timestamp.parseTimestamp((String)"2018-10-01T23:11:15.999Z")))));
        MatcherAssert.assertThat((Object)converter.convert("READ_TIMESTAMP 2018-10-01T23:11:15.1000Z"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)TimestampBound.ofReadTimestamp((Timestamp)Timestamp.parseTimestamp((String)"2018-10-01T23:11:15.1000Z")))));
        MatcherAssert.assertThat((Object)converter.convert("read_timestamp    2018-10-01T23:11:15.999999999Z"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)TimestampBound.ofReadTimestamp((Timestamp)Timestamp.parseTimestamp((String)"2018-10-01T23:11:15.999999999Z")))));
        MatcherAssert.assertThat((Object)converter.convert("read_timestamp\t2018-10-01T23:11:15.10001Z"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)TimestampBound.ofReadTimestamp((Timestamp)Timestamp.parseTimestamp((String)"2018-10-01T23:11:15.10001Z")))));
        MatcherAssert.assertThat((Object)converter.convert("read_timestamp\n2018-10-01T23:11:15.10001Z"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)converter.convert("min_read_timestamp 2018-10-01T23:11:15.10001Z"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)TimestampBound.ofMinReadTimestamp((Timestamp)Timestamp.parseTimestamp((String)"2018-10-01T23:11:15.10001Z")))));
        MatcherAssert.assertThat((Object)converter.convert("Min_Read_Timestamp 2018-10-01T23:11:15.999Z"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)TimestampBound.ofMinReadTimestamp((Timestamp)Timestamp.parseTimestamp((String)"2018-10-01T23:11:15.999Z")))));
        MatcherAssert.assertThat((Object)converter.convert("MIN_READ_TIMESTAMP 2018-10-01T23:11:15.1000Z"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)TimestampBound.ofMinReadTimestamp((Timestamp)Timestamp.parseTimestamp((String)"2018-10-01T23:11:15.1000Z")))));
        MatcherAssert.assertThat((Object)converter.convert("min_read_timestamp    2018-10-01T23:11:15.999999999Z"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)TimestampBound.ofMinReadTimestamp((Timestamp)Timestamp.parseTimestamp((String)"2018-10-01T23:11:15.999999999Z")))));
        MatcherAssert.assertThat((Object)converter.convert("min_read_timestamp\t2018-10-01T23:11:15.10001Z"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)TimestampBound.ofMinReadTimestamp((Timestamp)Timestamp.parseTimestamp((String)"2018-10-01T23:11:15.10001Z")))));
        MatcherAssert.assertThat((Object)converter.convert("min_read_timestamp\n2018-10-01T23:11:15.10001Z"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)converter.convert("exact_staleness 10s"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)TimestampBound.ofExactStaleness((long)10L, (TimeUnit)TimeUnit.SECONDS))));
        MatcherAssert.assertThat((Object)converter.convert("Exact_Staleness 100ms"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)TimestampBound.ofExactStaleness((long)100L, (TimeUnit)TimeUnit.MILLISECONDS))));
        MatcherAssert.assertThat((Object)converter.convert("EXACT_STALENESS 99999us"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)TimestampBound.ofExactStaleness((long)99999L, (TimeUnit)TimeUnit.MICROSECONDS))));
        MatcherAssert.assertThat((Object)converter.convert("exact_staleness 999999999ns"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)TimestampBound.ofExactStaleness((long)999999999L, (TimeUnit)TimeUnit.NANOSECONDS))));
        MatcherAssert.assertThat((Object)converter.convert("exact_staleness 9223372036854775807ns"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)TimestampBound.ofExactStaleness((long)Long.MAX_VALUE, (TimeUnit)TimeUnit.NANOSECONDS))));
        MatcherAssert.assertThat((Object)converter.convert("max_staleness 10s"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)TimestampBound.ofMaxStaleness((long)10L, (TimeUnit)TimeUnit.SECONDS))));
        MatcherAssert.assertThat((Object)converter.convert("Max_Staleness 100ms"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)TimestampBound.ofMaxStaleness((long)100L, (TimeUnit)TimeUnit.MILLISECONDS))));
        MatcherAssert.assertThat((Object)converter.convert("MAX_STALENESS 99999us"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)TimestampBound.ofMaxStaleness((long)99999L, (TimeUnit)TimeUnit.MICROSECONDS))));
        MatcherAssert.assertThat((Object)converter.convert("max_staleness 999999999ns"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)TimestampBound.ofMaxStaleness((long)999999999L, (TimeUnit)TimeUnit.NANOSECONDS))));
        MatcherAssert.assertThat((Object)converter.convert("max_staleness 9223372036854775807ns"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)TimestampBound.ofMaxStaleness((long)Long.MAX_VALUE, (TimeUnit)TimeUnit.NANOSECONDS))));
        MatcherAssert.assertThat((Object)converter.convert(""), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)converter.convert(" "), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)converter.convert("random string"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)converter.convert("read_timestamp"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)converter.convert("min_read_timestamp"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)converter.convert("exact_staleness"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)converter.convert("max_staleness"), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }
}

