/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.api.core.ApiFuture;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AsyncResultSet;
import com.google.cloud.spanner.BatchClient;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerApiFutures;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.connection.AbstractStatementParser;
import com.google.cloud.spanner.connection.AnalyzeMode;
import com.google.cloud.spanner.connection.DirectExecuteResultSet;
import com.google.cloud.spanner.connection.NoopEndTransactionCallback;
import com.google.cloud.spanner.connection.ReadOnlyTransaction;
import com.google.cloud.spanner.connection.StatementExecutor;
import com.google.cloud.spanner.connection.UnitOfWork;
import com.google.spanner.v1.ResultSetStats;
import io.opentelemetry.api.trace.Span;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class ReadOnlyTransactionTest {
    private ReadOnlyTransaction createSubject() {
        return this.createSubject(TimestampBound.strong());
    }

    private ReadOnlyTransaction createSubject(TimestampBound staleness) {
        DatabaseClient client = (DatabaseClient)Mockito.mock(DatabaseClient.class);
        Mockito.when((Object)client.readOnlyTransaction(staleness)).thenReturn((Object)new SimpleReadOnlyTransaction(staleness));
        return ((ReadOnlyTransaction.Builder)((ReadOnlyTransaction.Builder)ReadOnlyTransaction.newBuilder().setDatabaseClient(client).setBatchClient((BatchClient)Mockito.mock(BatchClient.class)).setReadOnlyStaleness(staleness).withStatementExecutor(new StatementExecutor())).setSpan(Span.getInvalid())).build();
    }

    @Test
    public void testExecuteDdl() {
        AbstractStatementParser.ParsedStatement ddl = (AbstractStatementParser.ParsedStatement)Mockito.mock(AbstractStatementParser.ParsedStatement.class);
        Mockito.when((Object)ddl.getType()).thenReturn((Object)AbstractStatementParser.StatementType.DDL);
        try {
            this.createSubject().executeDdlAsync(UnitOfWork.CallType.SYNC, ddl);
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerException ex) {
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)ex.getErrorCode());
        }
    }

    @Test
    public void testExecuteUpdate() {
        AbstractStatementParser.ParsedStatement update = (AbstractStatementParser.ParsedStatement)Mockito.mock(AbstractStatementParser.ParsedStatement.class);
        Mockito.when((Object)update.getType()).thenReturn((Object)AbstractStatementParser.StatementType.UPDATE);
        try {
            this.createSubject().executeUpdateAsync(UnitOfWork.CallType.SYNC, update, new Options.UpdateOption[0]);
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerException ex) {
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)ex.getErrorCode());
        }
    }

    @Test
    public void testWriteIterable() {
        Mutation mutation = Mutation.newInsertBuilder((String)"foo").build();
        try {
            this.createSubject().writeAsync(UnitOfWork.CallType.SYNC, Arrays.asList(mutation, mutation));
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerException ex) {
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)ex.getErrorCode());
        }
    }

    @Test
    public void testRunBatch() {
        ReadOnlyTransaction subject = this.createSubject();
        try {
            subject.runBatchAsync(UnitOfWork.CallType.SYNC);
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerException ex) {
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)ex.getErrorCode());
        }
    }

    @Test
    public void testAbortBatch() {
        ReadOnlyTransaction subject = this.createSubject();
        try {
            subject.abortBatch();
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerException ex) {
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)ex.getErrorCode());
        }
    }

    @Test
    public void testGetCommitTimestamp() {
        ReadOnlyTransaction transaction = this.createSubject();
        SpannerApiFutures.get((ApiFuture)transaction.commitAsync(UnitOfWork.CallType.SYNC, (UnitOfWork.EndTransactionCallback)NoopEndTransactionCallback.INSTANCE));
        MatcherAssert.assertThat((Object)transaction.getState(), (Matcher)CoreMatchers.is((Object)UnitOfWork.UnitOfWorkState.COMMITTED));
        try {
            transaction.getCommitTimestamp();
            Assert.fail((String)"Expected exception");
        }
        catch (SpannerException ex) {
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)ex.getErrorCode());
        }
    }

    @Test
    public void testGetCommitResponse() {
        ReadOnlyTransaction transaction = this.createSubject();
        SpannerApiFutures.get((ApiFuture)transaction.commitAsync(UnitOfWork.CallType.SYNC, (UnitOfWork.EndTransactionCallback)NoopEndTransactionCallback.INSTANCE));
        try {
            transaction.getCommitResponse();
            Assert.fail((String)"expected FAILED_PRECONDITION");
        }
        catch (SpannerException e) {
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)e.getErrorCode());
        }
    }

    @Test
    public void testGetCommitResponseOrNull() {
        ReadOnlyTransaction transaction = this.createSubject();
        SpannerApiFutures.get((ApiFuture)transaction.commitAsync(UnitOfWork.CallType.SYNC, (UnitOfWork.EndTransactionCallback)NoopEndTransactionCallback.INSTANCE));
        Assert.assertNull((Object)transaction.getCommitResponseOrNull());
    }

    @Test
    public void testIsReadOnly() {
        MatcherAssert.assertThat((Object)this.createSubject().isReadOnly(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testExecuteQuery() {
        for (TimestampBound staleness : this.getTestTimestampBounds()) {
            AbstractStatementParser.ParsedStatement parsedStatement = (AbstractStatementParser.ParsedStatement)Mockito.mock(AbstractStatementParser.ParsedStatement.class);
            Mockito.when((Object)parsedStatement.getType()).thenReturn((Object)AbstractStatementParser.StatementType.QUERY);
            Mockito.when((Object)parsedStatement.isQuery()).thenReturn((Object)true);
            Statement statement = Statement.of((String)"SELECT * FROM FOO");
            Mockito.when((Object)parsedStatement.getStatement()).thenReturn((Object)statement);
            Mockito.when((Object)parsedStatement.getSqlWithoutComments()).thenReturn((Object)statement.getSql());
            ReadOnlyTransaction transaction = this.createSubject(staleness);
            ResultSet rs = (ResultSet)SpannerApiFutures.get((ApiFuture)transaction.executeQueryAsync(UnitOfWork.CallType.SYNC, parsedStatement, AnalyzeMode.NONE, new Options.QueryOption[0]));
            MatcherAssert.assertThat((Object)rs, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
            MatcherAssert.assertThat((Object)rs.getStats(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        }
    }

    @Test
    public void testExecuteQueryWithOptionsTest() {
        String sql = "SELECT * FROM FOO";
        Options.ReadAndQueryOption option = Options.prefetchChunks((int)10000);
        AbstractStatementParser.ParsedStatement parsedStatement = (AbstractStatementParser.ParsedStatement)Mockito.mock(AbstractStatementParser.ParsedStatement.class);
        Mockito.when((Object)parsedStatement.getType()).thenReturn((Object)AbstractStatementParser.StatementType.QUERY);
        Mockito.when((Object)parsedStatement.isQuery()).thenReturn((Object)true);
        Statement statement = Statement.of((String)sql);
        Mockito.when((Object)parsedStatement.getStatement()).thenReturn((Object)statement);
        Mockito.when((Object)parsedStatement.getSqlWithoutComments()).thenReturn((Object)statement.getSql());
        DatabaseClient client = (DatabaseClient)Mockito.mock(DatabaseClient.class);
        com.google.cloud.spanner.ReadOnlyTransaction tx = (com.google.cloud.spanner.ReadOnlyTransaction)Mockito.mock(com.google.cloud.spanner.ReadOnlyTransaction.class);
        ResultSet resWithOptions = (ResultSet)Mockito.mock(ResultSet.class);
        ResultSet resWithoutOptions = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)tx.executeQuery(Statement.of((String)sql), new Options.QueryOption[]{option})).thenReturn((Object)resWithOptions);
        Mockito.when((Object)tx.executeQuery(Statement.of((String)sql), new Options.QueryOption[0])).thenReturn((Object)resWithoutOptions);
        Mockito.when((Object)client.readOnlyTransaction(TimestampBound.strong())).thenReturn((Object)tx);
        ReadOnlyTransaction transaction = ((ReadOnlyTransaction.Builder)((ReadOnlyTransaction.Builder)ReadOnlyTransaction.newBuilder().setDatabaseClient(client).setBatchClient((BatchClient)Mockito.mock(BatchClient.class)).setReadOnlyStaleness(TimestampBound.strong()).withStatementExecutor(new StatementExecutor())).setSpan(Span.getInvalid())).build();
        DirectExecuteResultSet expectedWithOptions = DirectExecuteResultSet.ofResultSet((ResultSet)resWithOptions);
        MatcherAssert.assertThat((Object)((ResultSet)SpannerApiFutures.get((ApiFuture)transaction.executeQueryAsync(UnitOfWork.CallType.SYNC, parsedStatement, AnalyzeMode.NONE, new Options.QueryOption[]{option}))), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)expectedWithOptions)));
        DirectExecuteResultSet expectedWithoutOptions = DirectExecuteResultSet.ofResultSet((ResultSet)resWithoutOptions);
        MatcherAssert.assertThat((Object)((ResultSet)SpannerApiFutures.get((ApiFuture)transaction.executeQueryAsync(UnitOfWork.CallType.SYNC, parsedStatement, AnalyzeMode.NONE, new Options.QueryOption[0]))), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)expectedWithoutOptions)));
    }

    @Test
    public void testPlanQuery() {
        for (TimestampBound staleness : this.getTestTimestampBounds()) {
            AbstractStatementParser.ParsedStatement parsedStatement = (AbstractStatementParser.ParsedStatement)Mockito.mock(AbstractStatementParser.ParsedStatement.class);
            Mockito.when((Object)parsedStatement.getType()).thenReturn((Object)AbstractStatementParser.StatementType.QUERY);
            Mockito.when((Object)parsedStatement.isQuery()).thenReturn((Object)true);
            Statement statement = Statement.of((String)"SELECT * FROM FOO");
            Mockito.when((Object)parsedStatement.getStatement()).thenReturn((Object)statement);
            Mockito.when((Object)parsedStatement.getSqlWithoutComments()).thenReturn((Object)statement.getSql());
            ReadOnlyTransaction transaction = this.createSubject(staleness);
            ResultSet rs = (ResultSet)SpannerApiFutures.get((ApiFuture)transaction.executeQueryAsync(UnitOfWork.CallType.SYNC, parsedStatement, AnalyzeMode.PLAN, new Options.QueryOption[0]));
            MatcherAssert.assertThat((Object)rs, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
            while (rs.next()) {
            }
            MatcherAssert.assertThat((Object)rs.getStats(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        }
    }

    @Test
    public void testProfileQuery() {
        for (TimestampBound staleness : this.getTestTimestampBounds()) {
            AbstractStatementParser.ParsedStatement parsedStatement = (AbstractStatementParser.ParsedStatement)Mockito.mock(AbstractStatementParser.ParsedStatement.class);
            Mockito.when((Object)parsedStatement.getType()).thenReturn((Object)AbstractStatementParser.StatementType.QUERY);
            Mockito.when((Object)parsedStatement.isQuery()).thenReturn((Object)true);
            Statement statement = Statement.of((String)"SELECT * FROM FOO");
            Mockito.when((Object)parsedStatement.getStatement()).thenReturn((Object)statement);
            Mockito.when((Object)parsedStatement.getSqlWithoutComments()).thenReturn((Object)statement.getSql());
            ReadOnlyTransaction transaction = this.createSubject(staleness);
            ResultSet rs = (ResultSet)SpannerApiFutures.get((ApiFuture)transaction.executeQueryAsync(UnitOfWork.CallType.SYNC, parsedStatement, AnalyzeMode.PROFILE, new Options.QueryOption[0]));
            MatcherAssert.assertThat((Object)rs, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
            while (rs.next()) {
            }
            MatcherAssert.assertThat((Object)rs.getStats(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        }
    }

    @Test
    public void testGetReadTimestamp() {
        for (TimestampBound staleness : this.getTestTimestampBounds()) {
            boolean expectedException;
            ReadOnlyTransaction transaction;
            AbstractStatementParser.ParsedStatement parsedStatement;
            block3: {
                parsedStatement = (AbstractStatementParser.ParsedStatement)Mockito.mock(AbstractStatementParser.ParsedStatement.class);
                Mockito.when((Object)parsedStatement.getType()).thenReturn((Object)AbstractStatementParser.StatementType.QUERY);
                Mockito.when((Object)parsedStatement.isQuery()).thenReturn((Object)true);
                Statement statement = Statement.of((String)"SELECT * FROM FOO");
                Mockito.when((Object)parsedStatement.getStatement()).thenReturn((Object)statement);
                Mockito.when((Object)parsedStatement.getSqlWithoutComments()).thenReturn((Object)statement.getSql());
                transaction = this.createSubject(staleness);
                expectedException = false;
                try {
                    transaction.getReadTimestamp();
                }
                catch (SpannerException e) {
                    if (e.getErrorCode() != ErrorCode.FAILED_PRECONDITION) break block3;
                    expectedException = true;
                }
            }
            MatcherAssert.assertThat((Object)expectedException, (Matcher)CoreMatchers.is((Object)true));
            MatcherAssert.assertThat((Object)((ResultSet)SpannerApiFutures.get((ApiFuture)transaction.executeQueryAsync(UnitOfWork.CallType.SYNC, parsedStatement, AnalyzeMode.NONE, new Options.QueryOption[0]))), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
            MatcherAssert.assertThat((Object)transaction.getReadTimestamp(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        }
    }

    private List<TimestampBound> getTestTimestampBounds() {
        return Arrays.asList(TimestampBound.strong(), TimestampBound.ofReadTimestamp((Timestamp)Timestamp.now()), TimestampBound.ofMinReadTimestamp((Timestamp)Timestamp.now()), TimestampBound.ofExactStaleness((long)1L, (TimeUnit)TimeUnit.SECONDS), TimestampBound.ofMaxStaleness((long)100L, (TimeUnit)TimeUnit.MILLISECONDS));
    }

    @Test
    public void testState() {
        AbstractStatementParser.ParsedStatement parsedStatement = (AbstractStatementParser.ParsedStatement)Mockito.mock(AbstractStatementParser.ParsedStatement.class);
        Mockito.when((Object)parsedStatement.getType()).thenReturn((Object)AbstractStatementParser.StatementType.QUERY);
        Mockito.when((Object)parsedStatement.isQuery()).thenReturn((Object)true);
        Statement statement = Statement.of((String)"SELECT * FROM FOO");
        Mockito.when((Object)parsedStatement.getStatement()).thenReturn((Object)statement);
        Mockito.when((Object)parsedStatement.getSqlWithoutComments()).thenReturn((Object)statement.getSql());
        ReadOnlyTransaction transaction = this.createSubject();
        MatcherAssert.assertThat((Object)transaction.getState(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)UnitOfWork.UnitOfWorkState.STARTED)));
        MatcherAssert.assertThat((Object)transaction.isActive(), (Matcher)CoreMatchers.is((Object)true));
        SpannerApiFutures.get((ApiFuture)transaction.commitAsync(UnitOfWork.CallType.SYNC, (UnitOfWork.EndTransactionCallback)NoopEndTransactionCallback.INSTANCE));
        MatcherAssert.assertThat((Object)transaction.getState(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)UnitOfWork.UnitOfWorkState.COMMITTED)));
        MatcherAssert.assertThat((Object)transaction.isActive(), (Matcher)CoreMatchers.is((Object)false));
        transaction = this.createSubject();
        MatcherAssert.assertThat((Object)transaction.getState(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)UnitOfWork.UnitOfWorkState.STARTED)));
        MatcherAssert.assertThat((Object)transaction.isActive(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((ResultSet)SpannerApiFutures.get((ApiFuture)transaction.executeQueryAsync(UnitOfWork.CallType.SYNC, parsedStatement, AnalyzeMode.NONE, new Options.QueryOption[0]))), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)transaction.getState(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)UnitOfWork.UnitOfWorkState.STARTED)));
        MatcherAssert.assertThat((Object)transaction.isActive(), (Matcher)CoreMatchers.is((Object)true));
        SpannerApiFutures.get((ApiFuture)transaction.commitAsync(UnitOfWork.CallType.SYNC, (UnitOfWork.EndTransactionCallback)NoopEndTransactionCallback.INSTANCE));
        MatcherAssert.assertThat((Object)transaction.getState(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)UnitOfWork.UnitOfWorkState.COMMITTED)));
        MatcherAssert.assertThat((Object)transaction.isActive(), (Matcher)CoreMatchers.is((Object)false));
        transaction = this.createSubject();
        MatcherAssert.assertThat((Object)transaction.getState(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)UnitOfWork.UnitOfWorkState.STARTED)));
        MatcherAssert.assertThat((Object)transaction.isActive(), (Matcher)CoreMatchers.is((Object)true));
        SpannerApiFutures.get((ApiFuture)transaction.rollbackAsync(UnitOfWork.CallType.SYNC, (UnitOfWork.EndTransactionCallback)NoopEndTransactionCallback.INSTANCE));
        MatcherAssert.assertThat((Object)transaction.getState(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)UnitOfWork.UnitOfWorkState.ROLLED_BACK)));
        MatcherAssert.assertThat((Object)transaction.isActive(), (Matcher)CoreMatchers.is((Object)false));
        transaction = this.createSubject();
        MatcherAssert.assertThat((Object)transaction.getState(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)UnitOfWork.UnitOfWorkState.STARTED)));
        MatcherAssert.assertThat((Object)transaction.isActive(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)((ResultSet)SpannerApiFutures.get((ApiFuture)transaction.executeQueryAsync(UnitOfWork.CallType.SYNC, parsedStatement, AnalyzeMode.NONE, new Options.QueryOption[0]))), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)transaction.getState(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)UnitOfWork.UnitOfWorkState.STARTED)));
        MatcherAssert.assertThat((Object)transaction.isActive(), (Matcher)CoreMatchers.is((Object)true));
        SpannerApiFutures.get((ApiFuture)transaction.rollbackAsync(UnitOfWork.CallType.SYNC, (UnitOfWork.EndTransactionCallback)NoopEndTransactionCallback.INSTANCE));
        MatcherAssert.assertThat((Object)transaction.getState(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)UnitOfWork.UnitOfWorkState.ROLLED_BACK)));
        MatcherAssert.assertThat((Object)transaction.isActive(), (Matcher)CoreMatchers.is((Object)false));
    }

    private static final class SimpleReadOnlyTransaction
    implements com.google.cloud.spanner.ReadOnlyTransaction {
        private Timestamp readTimestamp = null;
        private final TimestampBound staleness;

        private SimpleReadOnlyTransaction(TimestampBound staleness) {
            this.staleness = staleness;
        }

        public ResultSet read(String table, KeySet keys, Iterable<String> columns, Options.ReadOption ... options) {
            return null;
        }

        public ResultSet readUsingIndex(String table, String index, KeySet keys, Iterable<String> columns, Options.ReadOption ... options) {
            return null;
        }

        public Struct readRow(String table, Key key, Iterable<String> columns) {
            return null;
        }

        public Struct readRowUsingIndex(String table, String index, Key key, Iterable<String> columns) {
            return null;
        }

        public ResultSet executeQuery(Statement statement, Options.QueryOption ... options) {
            if (this.readTimestamp == null) {
                switch (this.staleness.getMode()) {
                    case STRONG: {
                        this.readTimestamp = Timestamp.now();
                        break;
                    }
                    case READ_TIMESTAMP: {
                        this.readTimestamp = this.staleness.getReadTimestamp();
                        break;
                    }
                    case MIN_READ_TIMESTAMP: {
                        this.readTimestamp = this.staleness.getMinReadTimestamp();
                        break;
                    }
                    case EXACT_STALENESS: {
                        Calendar cal = Calendar.getInstance();
                        cal.add(14, (int)(-this.staleness.getExactStaleness(TimeUnit.MILLISECONDS)));
                        this.readTimestamp = Timestamp.of((Date)cal.getTime());
                        break;
                    }
                    case MAX_STALENESS: {
                        Calendar cal = Calendar.getInstance();
                        cal.add(14, (int)(-this.staleness.getMaxStaleness(TimeUnit.MILLISECONDS)));
                        this.readTimestamp = Timestamp.of((Date)cal.getTime());
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            return (ResultSet)Mockito.mock(ResultSet.class);
        }

        public ResultSet analyzeQuery(Statement statement, ReadContext.QueryAnalyzeMode queryMode) {
            ResultSet res = this.executeQuery(statement, new Options.QueryOption[0]);
            Mockito.when((Object)res.getStats()).thenReturn((Object)ResultSetStats.getDefaultInstance());
            return res;
        }

        public void close() {
        }

        public Timestamp getReadTimestamp() {
            return this.readTimestamp;
        }

        public AsyncResultSet readAsync(String table, KeySet keys, Iterable<String> columns, Options.ReadOption ... options) {
            return null;
        }

        public AsyncResultSet readUsingIndexAsync(String table, String index, KeySet keys, Iterable<String> columns, Options.ReadOption ... options) {
            return null;
        }

        public ApiFuture<Struct> readRowAsync(String table, Key key, Iterable<String> columns) {
            return null;
        }

        public ApiFuture<Struct> readRowUsingIndexAsync(String table, String index, Key key, Iterable<String> columns) {
            return null;
        }

        public AsyncResultSet executeQueryAsync(Statement statement, Options.QueryOption ... options) {
            return null;
        }
    }
}

