/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.AbortedDueToConcurrentModificationException;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.connection.AbstractMockServerTest;
import com.google.cloud.spanner.connection.Connection;
import com.google.cloud.spanner.connection.ITAbstractSpannerTest;
import com.google.cloud.spanner.connection.RandomResultSetGenerator;
import com.google.cloud.spanner.connection.SavepointSupport;
import com.google.cloud.spanner.connection.SpannerPool;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.AbstractMessage;
import com.google.spanner.v1.BeginTransactionRequest;
import com.google.spanner.v1.CommitRequest;
import com.google.spanner.v1.ExecuteBatchDmlRequest;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.RollbackRequest;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SavepointMockServerTest
extends AbstractMockServerTest {
    @Parameterized.Parameter(value=0)
    public Dialect dialect;
    @Parameterized.Parameter(value=1)
    public boolean useVirtualThreads;
    private Dialect currentDialect;

    @Parameterized.Parameters(name="dialect = {0}, useVirtualThreads = {1}")
    public static Collection<Object[]> data() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Dialect dialect : Dialect.values()) {
            for (boolean useVirtualThreads : new boolean[]{true, false}) {
                builder.add((Object)new Object[]{dialect, useVirtualThreads});
            }
        }
        return builder.build();
    }

    @Before
    public void setupDialect() {
        if (this.currentDialect != this.dialect) {
            SpannerPool.closeSpannerPool();
            mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.detectDialectResult(this.dialect));
            this.currentDialect = this.dialect;
        }
    }

    @After
    public void clearRequests() {
        mockSpanner.clearRequests();
    }

    @Override
    public ITAbstractSpannerTest.ITConnection createConnection() {
        return this.createConnection(";useVirtualThreads=" + this.useVirtualThreads + ";useVirtualGrpcTransportThreads=" + this.useVirtualThreads);
    }

    @Test
    public void testCreateSavepoint() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.savepoint("s1");
            if (this.dialect == Dialect.POSTGRESQL) {
                connection.savepoint("s1");
            } else {
                Assert.assertThrows(SpannerException.class, () -> connection.savepoint("s1"));
            }
            Assert.assertThrows(SpannerException.class, () -> connection.savepoint(null));
            Assert.assertThrows(SpannerException.class, () -> connection.savepoint(""));
            Assert.assertThrows(SpannerException.class, () -> connection.savepoint("1"));
            Assert.assertThrows(SpannerException.class, () -> connection.savepoint("-foo"));
            Assert.assertThrows(SpannerException.class, () -> connection.savepoint(Strings.repeat((String)"t", (int)129)));
        }
    }

    @Test
    public void testCreateSavepointWhenDisabled() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setSavepointSupport(SavepointSupport.DISABLED);
            Assert.assertThrows(SpannerException.class, () -> connection.savepoint("s1"));
        }
    }

    @Test
    public void testReleaseSavepoint() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.savepoint("s1");
            connection.releaseSavepoint("s1");
            Assert.assertThrows(SpannerException.class, () -> connection.releaseSavepoint("s1"));
            connection.savepoint("s1");
            connection.savepoint("s2");
            connection.releaseSavepoint("s1");
            Assert.assertThrows(SpannerException.class, () -> connection.releaseSavepoint("s2"));
            if (this.dialect == Dialect.POSTGRESQL) {
                connection.savepoint("s1");
                connection.savepoint("s2");
                connection.savepoint("s1");
                connection.releaseSavepoint("s1");
                connection.releaseSavepoint("s2");
                connection.releaseSavepoint("s1");
                Assert.assertThrows(SpannerException.class, () -> connection.releaseSavepoint("s1"));
            }
        }
    }

    @Test
    public void testRollbackToSavepoint() {
        for (SavepointSupport savepointSupport : new SavepointSupport[]{SavepointSupport.ENABLED, SavepointSupport.FAIL_AFTER_ROLLBACK}) {
            try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
                connection.setSavepointSupport(savepointSupport);
                connection.savepoint("s1");
                connection.rollbackToSavepoint("s1");
                connection.rollbackToSavepoint("s1");
                connection.savepoint("s2");
                connection.rollbackToSavepoint("s1");
                Assert.assertThrows(SpannerException.class, () -> connection.rollbackToSavepoint("s2"));
                if (this.dialect != Dialect.POSTGRESQL) continue;
                connection.savepoint("s2");
                connection.savepoint("s1");
                connection.rollbackToSavepoint("s1");
                connection.rollbackToSavepoint("s2");
                connection.rollbackToSavepoint("s1");
                connection.rollbackToSavepoint("s1");
                connection.releaseSavepoint("s1");
                Assert.assertThrows(SpannerException.class, () -> connection.rollbackToSavepoint("s1"));
            }
        }
    }

    @Test
    public void testSavepointInAutoCommit() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setAutocommit(true);
            Assert.assertThrows(SpannerException.class, () -> connection.savepoint("s1"));
            connection.beginTransaction();
            connection.savepoint("s1");
            connection.releaseSavepoint("s1");
        }
    }

    @Test
    public void testRollbackToSavepointInReadOnlyTransaction() {
        for (SavepointSupport savepointSupport : new SavepointSupport[]{SavepointSupport.ENABLED, SavepointSupport.FAIL_AFTER_ROLLBACK}) {
            try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
                int count;
                connection.setSavepointSupport(savepointSupport);
                connection.setReadOnly(true);
                connection.savepoint("s1");
                try (ResultSet resultSet = connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]);){
                    count = 0;
                    while (resultSet.next()) {
                        ++count;
                    }
                    Assert.assertEquals((long)100L, (long)count);
                }
                connection.rollbackToSavepoint("s1");
                resultSet = connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]);
                try {
                    count = 0;
                    while (resultSet.next()) {
                        ++count;
                    }
                    Assert.assertEquals((long)100L, (long)count);
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                connection.commit();
                Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(BeginTransactionRequest.class));
                BeginTransactionRequest beginRequest = mockSpanner.getRequestsOfType(BeginTransactionRequest.class).get(0);
                Assert.assertTrue((boolean)beginRequest.getOptions().hasReadOnly());
                Assert.assertEquals((long)0L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
            }
            mockSpanner.clearRequests();
        }
    }

    @Test
    public void testRollbackToSavepointInReadWriteTransaction() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            int count;
            connection.setSavepointSupport(SavepointSupport.ENABLED);
            connection.savepoint("s1");
            try (ResultSet resultSet = connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]);){
                count = 0;
                while (resultSet.next()) {
                    ++count;
                }
                Assert.assertEquals((long)100L, (long)count);
            }
            connection.rollbackToSavepoint("s1");
            resultSet = connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]);
            try {
                count = 0;
                while (resultSet.next()) {
                    ++count;
                }
                Assert.assertEquals((long)100L, (long)count);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            connection.commit();
            Assert.assertEquals((long)0L, (long)mockSpanner.countRequestsOfType(BeginTransactionRequest.class));
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(RollbackRequest.class));
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
            Assert.assertEquals((long)2L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
            List requests = mockSpanner.getRequests().stream().filter(request -> request instanceof ExecuteSqlRequest || request instanceof RollbackRequest || request instanceof CommitRequest).collect(Collectors.toList());
            Assert.assertEquals((long)4L, (long)requests.size());
            int index = 0;
            Assert.assertEquals(ExecuteSqlRequest.class, ((AbstractMessage)requests.get(index++)).getClass());
            Assert.assertEquals(RollbackRequest.class, ((AbstractMessage)requests.get(index++)).getClass());
            Assert.assertEquals(ExecuteSqlRequest.class, ((AbstractMessage)requests.get(index++)).getClass());
            Assert.assertEquals(CommitRequest.class, ((AbstractMessage)requests.get(index++)).getClass());
        }
    }

    @Test
    public void testRollbackToSavepointWithDmlStatements() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setSavepointSupport(SavepointSupport.ENABLED);
            try (ResultSet resultSet = connection.executeQuery(SELECT_RANDOM_STATEMENT, new Options.QueryOption[0]);){
                int count = 0;
                while (resultSet.next()) {
                    ++count;
                }
                Assert.assertEquals((long)100L, (long)count);
            }
            connection.savepoint("s1");
            connection.executeUpdate(INSERT_STATEMENT);
            connection.savepoint("s2");
            connection.executeUpdate(INSERT_STATEMENT);
            connection.rollbackToSavepoint("s2");
            connection.commit();
            Assert.assertEquals((long)0L, (long)mockSpanner.countRequestsOfType(BeginTransactionRequest.class));
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(RollbackRequest.class));
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
            Assert.assertEquals((long)5L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
            List requests = mockSpanner.getRequests().stream().filter(request -> request instanceof ExecuteSqlRequest || request instanceof RollbackRequest || request instanceof CommitRequest).collect(Collectors.toList());
            Assert.assertEquals((long)7L, (long)requests.size());
            int index = 0;
            Assert.assertEquals(ExecuteSqlRequest.class, ((AbstractMessage)requests.get(index++)).getClass());
            Assert.assertEquals(ExecuteSqlRequest.class, ((AbstractMessage)requests.get(index++)).getClass());
            Assert.assertEquals(ExecuteSqlRequest.class, ((AbstractMessage)requests.get(index++)).getClass());
            Assert.assertEquals(RollbackRequest.class, ((AbstractMessage)requests.get(index++)).getClass());
            Assert.assertEquals(ExecuteSqlRequest.class, ((AbstractMessage)requests.get(index++)).getClass());
            Assert.assertEquals(ExecuteSqlRequest.class, ((AbstractMessage)requests.get(index++)).getClass());
            Assert.assertEquals(CommitRequest.class, ((AbstractMessage)requests.get(index++)).getClass());
        }
    }

    @Test
    public void testRollbackToSavepointFails() {
        Statement statement = Statement.of((String)"select * from foo where bar=true");
        int numRows = 10;
        RandomResultSetGenerator generator = new RandomResultSetGenerator(numRows);
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(statement, generator.generate()));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setSavepointSupport(SavepointSupport.ENABLED);
            try (ResultSet resultSet = connection.executeQuery(statement, new Options.QueryOption[0]);){
                int count = 0;
                while (resultSet.next()) {
                    ++count;
                }
                Assert.assertEquals((long)numRows, (long)count);
            }
            connection.savepoint("s1");
            connection.executeUpdate(INSERT_STATEMENT);
            connection.executeUpdate(INSERT_STATEMENT);
            mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(statement, generator.generate()));
            connection.rollbackToSavepoint("s1");
            Assert.assertThrows(AbortedDueToConcurrentModificationException.class, () -> ((Connection)connection).commit());
            Assert.assertEquals((long)0L, (long)mockSpanner.countRequestsOfType(BeginTransactionRequest.class));
            Assert.assertEquals((long)2L, (long)mockSpanner.countRequestsOfType(RollbackRequest.class));
            Assert.assertEquals((long)0L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
            Assert.assertEquals((long)4L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
            List requests = mockSpanner.getRequests().stream().filter(request -> request instanceof ExecuteSqlRequest || request instanceof RollbackRequest || request instanceof CommitRequest).collect(Collectors.toList());
            Assert.assertEquals((long)6L, (long)requests.size());
            int index = 0;
            Assert.assertEquals(ExecuteSqlRequest.class, ((AbstractMessage)requests.get(index++)).getClass());
            Assert.assertEquals(ExecuteSqlRequest.class, ((AbstractMessage)requests.get(index++)).getClass());
            Assert.assertEquals(ExecuteSqlRequest.class, ((AbstractMessage)requests.get(index++)).getClass());
            Assert.assertEquals(RollbackRequest.class, ((AbstractMessage)requests.get(index++)).getClass());
            Assert.assertEquals(ExecuteSqlRequest.class, ((AbstractMessage)requests.get(index++)).getClass());
            Assert.assertEquals(RollbackRequest.class, ((AbstractMessage)requests.get(index++)).getClass());
        }
    }

    @Test
    public void testRollbackToSavepointWithFailAfterRollback() {
        Statement statement = Statement.of((String)"select * from foo where bar=true");
        int numRows = 10;
        RandomResultSetGenerator generator = new RandomResultSetGenerator(numRows);
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(statement, generator.generate()));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setSavepointSupport(SavepointSupport.FAIL_AFTER_ROLLBACK);
            try (ResultSet resultSet = connection.executeQuery(statement, new Options.QueryOption[0]);){
                int count = 0;
                while (resultSet.next()) {
                    ++count;
                }
                Assert.assertEquals((long)numRows, (long)count);
            }
            connection.savepoint("s1");
            connection.executeUpdate(INSERT_STATEMENT);
            connection.executeUpdate(INSERT_STATEMENT);
            connection.rollbackToSavepoint("s1");
            SpannerException exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> ((Connection)connection).commit());
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)exception.getErrorCode());
            Assert.assertEquals((Object)"FAILED_PRECONDITION: Using a read/write transaction after rolling back to a savepoint is not supported with SavepointSupport=FAIL_AFTER_ROLLBACK", (Object)exception.getMessage());
        }
    }

    @Test
    public void testRollbackToSavepointSucceedsWithRollback() {
        for (SavepointSupport savepointSupport : new SavepointSupport[]{SavepointSupport.ENABLED, SavepointSupport.FAIL_AFTER_ROLLBACK}) {
            Statement statement = Statement.of((String)"select * from foo where bar=true");
            int numRows = 10;
            RandomResultSetGenerator generator = new RandomResultSetGenerator(numRows);
            mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(statement, generator.generate()));
            try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
                connection.setSavepointSupport(savepointSupport);
                try (ResultSet resultSet = connection.executeQuery(statement, new Options.QueryOption[0]);){
                    int count = 0;
                    while (resultSet.next()) {
                        ++count;
                    }
                    Assert.assertEquals((long)numRows, (long)count);
                }
                connection.savepoint("s1");
                mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(statement, generator.generate()));
                connection.rollbackToSavepoint("s1");
                connection.rollback();
                Assert.assertEquals((long)0L, (long)mockSpanner.countRequestsOfType(BeginTransactionRequest.class));
                Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(RollbackRequest.class));
                Assert.assertEquals((long)0L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
                Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
            }
            mockSpanner.clearRequests();
        }
    }

    @Test
    public void testMultipleRollbacksWithChangedResults() {
        Statement statement = Statement.of((String)"select * from foo where bar=true");
        int numRows = 10;
        RandomResultSetGenerator generator = new RandomResultSetGenerator(numRows);
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(statement, generator.generate()));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            try (ResultSet resultSet = connection.executeQuery(statement, new Options.QueryOption[0]);){
                int count = 0;
                while (resultSet.next()) {
                    ++count;
                }
                Assert.assertEquals((long)numRows, (long)count);
            }
            connection.savepoint("s1");
            connection.executeUpdate(INSERT_STATEMENT);
            connection.savepoint("s2");
            connection.executeUpdate(INSERT_STATEMENT);
            mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(statement, generator.generate()));
            connection.rollbackToSavepoint("s2");
            connection.rollbackToSavepoint("s1");
            connection.rollback();
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(RollbackRequest.class));
            Assert.assertEquals((long)0L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
            Assert.assertEquals((long)3L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        }
    }

    @Test
    public void testMultipleRollbacks() {
        Statement statement = Statement.of((String)"select * from foo where bar=true");
        int numRows = 10;
        RandomResultSetGenerator generator = new RandomResultSetGenerator(numRows);
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(statement, generator.generate()));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setSavepointSupport(SavepointSupport.ENABLED);
            try (ResultSet resultSet = connection.executeQuery(statement, new Options.QueryOption[0]);){
                int count = 0;
                while (resultSet.next()) {
                    ++count;
                }
                Assert.assertEquals((long)numRows, (long)count);
            }
            connection.savepoint("s1");
            connection.executeUpdate(INSERT_STATEMENT);
            connection.savepoint("s2");
            connection.executeUpdate(INSERT_STATEMENT);
            connection.rollbackToSavepoint("s2");
            connection.rollbackToSavepoint("s1");
            connection.commit();
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(RollbackRequest.class));
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
            Assert.assertEquals((long)4L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
            List requests = mockSpanner.getRequests().stream().filter(request -> request instanceof ExecuteSqlRequest || request instanceof RollbackRequest || request instanceof CommitRequest).collect(Collectors.toList());
            Assert.assertEquals((long)6L, (long)requests.size());
            int index = 0;
            Assert.assertEquals(ExecuteSqlRequest.class, ((AbstractMessage)requests.get(index++)).getClass());
            Assert.assertEquals(ExecuteSqlRequest.class, ((AbstractMessage)requests.get(index++)).getClass());
            Assert.assertEquals(ExecuteSqlRequest.class, ((AbstractMessage)requests.get(index++)).getClass());
            Assert.assertEquals(RollbackRequest.class, ((AbstractMessage)requests.get(index++)).getClass());
            Assert.assertEquals(ExecuteSqlRequest.class, ((AbstractMessage)requests.get(index++)).getClass());
            Assert.assertEquals(CommitRequest.class, ((AbstractMessage)requests.get(index++)).getClass());
        }
    }

    @Test
    public void testRollbackMutations() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setSavepointSupport(SavepointSupport.ENABLED);
            connection.bufferedWrite(Mutation.newInsertBuilder((String)"foo1").build());
            connection.savepoint("s1");
            connection.executeUpdate(INSERT_STATEMENT);
            connection.bufferedWrite(Mutation.newInsertBuilder((String)"foo2").build());
            connection.savepoint("s2");
            connection.executeUpdate(INSERT_STATEMENT);
            connection.bufferedWrite(Mutation.newInsertBuilder((String)"foo3").build());
            connection.rollbackToSavepoint("s1");
            connection.commit();
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(RollbackRequest.class));
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
            Assert.assertEquals((long)2L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
            CommitRequest commitRequest = mockSpanner.getRequestsOfType(CommitRequest.class).get(0);
            Assert.assertEquals((long)1L, (long)commitRequest.getMutationsCount());
            Assert.assertEquals((Object)"foo1", (Object)commitRequest.getMutations(0).getInsert().getTable());
        }
    }

    @Test
    public void testRollbackBatchDml() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setSavepointSupport(SavepointSupport.ENABLED);
            connection.executeUpdate(INSERT_STATEMENT);
            connection.savepoint("s1");
            connection.executeBatchUpdate((Iterable)ImmutableList.of((Object)INSERT_STATEMENT, (Object)INSERT_STATEMENT));
            connection.savepoint("s2");
            connection.executeUpdate(INSERT_STATEMENT);
            connection.savepoint("s3");
            connection.executeBatchUpdate((Iterable)ImmutableList.of((Object)INSERT_STATEMENT, (Object)INSERT_STATEMENT));
            connection.savepoint("s4");
            connection.rollbackToSavepoint("s2");
            connection.commit();
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(RollbackRequest.class));
            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
            Assert.assertEquals((long)3L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
            Assert.assertEquals((long)3L, (long)mockSpanner.countRequestsOfType(ExecuteBatchDmlRequest.class));
            List requests = mockSpanner.getRequests().stream().filter(request -> request instanceof ExecuteSqlRequest || request instanceof RollbackRequest || request instanceof CommitRequest || request instanceof ExecuteBatchDmlRequest).collect(Collectors.toList());
            Assert.assertEquals((long)8L, (long)requests.size());
            int index = 0;
            Assert.assertEquals(ExecuteSqlRequest.class, ((AbstractMessage)requests.get(index++)).getClass());
            Assert.assertEquals(ExecuteBatchDmlRequest.class, ((AbstractMessage)requests.get(index++)).getClass());
            Assert.assertEquals(ExecuteSqlRequest.class, ((AbstractMessage)requests.get(index++)).getClass());
            Assert.assertEquals(ExecuteBatchDmlRequest.class, ((AbstractMessage)requests.get(index++)).getClass());
            Assert.assertEquals(RollbackRequest.class, ((AbstractMessage)requests.get(index++)).getClass());
            Assert.assertEquals(ExecuteSqlRequest.class, ((AbstractMessage)requests.get(index++)).getClass());
            Assert.assertEquals(ExecuteBatchDmlRequest.class, ((AbstractMessage)requests.get(index++)).getClass());
            Assert.assertEquals(CommitRequest.class, ((AbstractMessage)requests.get(index++)).getClass());
        }
    }

    @Test
    public void testRollbackToSavepointWithoutInternalRetries() {
        Statement statement = Statement.of((String)"select * from foo where bar=true");
        int numRows = 10;
        RandomResultSetGenerator generator = new RandomResultSetGenerator(numRows);
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(statement, generator.generate()));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setRetryAbortsInternally(false);
            connection.savepoint("s1");
            try (ResultSet resultSet = connection.executeQuery(statement, new Options.QueryOption[0]);){
                int count = 0;
                while (resultSet.next()) {
                    ++count;
                }
                Assert.assertEquals((long)numRows, (long)count);
            }
            connection.rollbackToSavepoint("s1");
            Assert.assertThrows(SpannerException.class, () -> connection.executeUpdate(INSERT_STATEMENT));
        }
    }

    @Test
    public void testRollbackToSavepointWithoutInternalRetriesInReadOnlyTransaction() {
        Statement statement = Statement.of((String)"select * from foo where bar=true");
        int numRows = 10;
        RandomResultSetGenerator generator = new RandomResultSetGenerator(numRows);
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(statement, generator.generate()));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            int count;
            connection.setRetryAbortsInternally(false);
            connection.setReadOnly(true);
            connection.savepoint("s1");
            try (ResultSet resultSet = connection.executeQuery(statement, new Options.QueryOption[0]);){
                count = 0;
                while (resultSet.next()) {
                    ++count;
                }
                Assert.assertEquals((long)numRows, (long)count);
            }
            connection.rollbackToSavepoint("s1");
            resultSet = connection.executeQuery(statement, new Options.QueryOption[0]);
            try {
                count = 0;
                while (resultSet.next()) {
                    ++count;
                }
                Assert.assertEquals((long)numRows, (long)count);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testKeepAlive() throws InterruptedException, TimeoutException {
        String keepAliveTag = "test_keep_alive_tag";
        System.setProperty("spanner.connection.keep_alive_interval_millis", "1");
        System.setProperty("spanner.connection.keep_alive_query_tag", keepAliveTag);
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setSavepointSupport(SavepointSupport.ENABLED);
            connection.setKeepTransactionAlive(true);
            connection.execute(INSERT_STATEMENT);
            this.verifyHasKeepAliveRequest(keepAliveTag);
            connection.savepoint("s1");
            connection.execute(INSERT_STATEMENT);
            connection.rollbackToSavepoint("s1");
            mockSpanner.waitForRequestsToContain(RollbackRequest.class, 1000L);
            String keepAliveTagAfterRollback = "test_keep_alive_tag_after_rollback";
            System.setProperty("spanner.connection.keep_alive_query_tag", keepAliveTagAfterRollback);
            Thread.sleep(2L);
            Assert.assertEquals((long)0L, (long)this.countKeepAliveRequest(keepAliveTagAfterRollback));
            connection.execute(INSERT_STATEMENT);
            this.verifyHasKeepAliveRequest(keepAliveTagAfterRollback);
        }
        finally {
            System.clearProperty("spanner.connection.keep_alive_interval_millis");
            System.clearProperty("spanner.connection.keep_alive_query_tag");
        }
    }

    private void verifyHasKeepAliveRequest(String tag) throws InterruptedException, TimeoutException {
        mockSpanner.waitForRequestsToContain((Predicate<? super AbstractMessage>)((Predicate)r -> {
            if (!(r instanceof ExecuteSqlRequest)) {
                return false;
            }
            ExecuteSqlRequest request = (ExecuteSqlRequest)r;
            return request.getSql().equals("SELECT 1") && request.getRequestOptions().getRequestTag().equals(tag);
        }), 1000L);
    }

    private long countKeepAliveRequest(String tag) {
        return mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).stream().filter(request -> request.getSql().equals("SELECT 1") && request.getRequestOptions().getRequestTag().equals(tag)).count();
    }
}

