/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.connection.AbstractStatementParser;
import com.google.cloud.spanner.connection.ConnectionImpl;
import com.google.cloud.spanner.connection.ConnectionStatementExecutor;
import com.google.cloud.spanner.connection.ConnectionStatementExecutorImpl;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class SetPgSessionCharacteristicsTest {
    private final AbstractStatementParser parser = AbstractStatementParser.getInstance((Dialect)Dialect.POSTGRESQL);

    @Test
    public void testSetIsolationLevelDefault() {
        ConnectionImpl connection = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        ConnectionStatementExecutorImpl executor = new ConnectionStatementExecutorImpl(connection);
        String sql = "set session characteristics as transaction isolation level default";
        AbstractStatementParser.ParsedStatement statement = this.parser.parse(Statement.of((String)sql));
        Assert.assertEquals((String)sql, (Object)AbstractStatementParser.StatementType.CLIENT_SIDE, (Object)statement.getType());
        statement.getClientSideStatement().execute((ConnectionStatementExecutor)executor, statement);
        ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.never())).setReadOnly(ArgumentMatchers.anyBoolean());
    }

    @Test
    public void testSetIsolationLevelSerializable() {
        ConnectionImpl connection = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        ConnectionStatementExecutorImpl executor = new ConnectionStatementExecutorImpl(connection);
        String sql = "set session characteristics as transaction isolation level serializable";
        AbstractStatementParser.ParsedStatement statement = this.parser.parse(Statement.of((String)sql));
        Assert.assertEquals((String)sql, (Object)AbstractStatementParser.StatementType.CLIENT_SIDE, (Object)statement.getType());
        statement.getClientSideStatement().execute((ConnectionStatementExecutor)executor, statement);
        ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.never())).setReadOnly(ArgumentMatchers.anyBoolean());
    }

    @Test
    public void testSetIsolationLevelReadOnly() {
        ConnectionImpl connection = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        ConnectionStatementExecutorImpl executor = new ConnectionStatementExecutorImpl(connection);
        String sql = "set\tsession\ncharacteristics as transaction read   only";
        AbstractStatementParser.ParsedStatement statement = this.parser.parse(Statement.of((String)sql));
        Assert.assertEquals((String)sql, (Object)AbstractStatementParser.StatementType.CLIENT_SIDE, (Object)statement.getType());
        statement.getClientSideStatement().execute((ConnectionStatementExecutor)executor, statement);
        ((ConnectionImpl)Mockito.verify((Object)connection)).setReadOnly(true);
        ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.never())).setReadOnly(false);
    }

    @Test
    public void testSetIsolationLevelReadWrite() {
        ConnectionImpl connection = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        ConnectionStatementExecutorImpl executor = new ConnectionStatementExecutorImpl(connection);
        String sql = "set   session   characteristics   as   transaction   read   write";
        AbstractStatementParser.ParsedStatement statement = this.parser.parse(Statement.of((String)sql));
        Assert.assertEquals((String)sql, (Object)AbstractStatementParser.StatementType.CLIENT_SIDE, (Object)statement.getType());
        statement.getClientSideStatement().execute((ConnectionStatementExecutor)executor, statement);
        ((ConnectionImpl)Mockito.verify((Object)connection)).setReadOnly(false);
        ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.never())).setReadOnly(true);
    }

    @Test
    public void testSetIsolationLevelSerializableReadWrite() {
        ConnectionImpl connection = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        ConnectionStatementExecutorImpl executor = new ConnectionStatementExecutorImpl(connection);
        String sql = "set   session   characteristics   as   transaction  isolation level serializable read write";
        AbstractStatementParser.ParsedStatement statement = this.parser.parse(Statement.of((String)sql));
        Assert.assertEquals((String)sql, (Object)AbstractStatementParser.StatementType.CLIENT_SIDE, (Object)statement.getType());
        statement.getClientSideStatement().execute((ConnectionStatementExecutor)executor, statement);
        ((ConnectionImpl)Mockito.verify((Object)connection)).setReadOnly(false);
        ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.never())).setReadOnly(true);
    }

    @Test
    public void testSetIsolationLevelSerializableReadOnly() {
        ConnectionImpl connection = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        ConnectionStatementExecutorImpl executor = new ConnectionStatementExecutorImpl(connection);
        String sql = "set   session   characteristics   as   transaction  isolation level serializable read only";
        AbstractStatementParser.ParsedStatement statement = this.parser.parse(Statement.of((String)sql));
        Assert.assertEquals((String)sql, (Object)AbstractStatementParser.StatementType.CLIENT_SIDE, (Object)statement.getType());
        statement.getClientSideStatement().execute((ConnectionStatementExecutor)executor, statement);
        ((ConnectionImpl)Mockito.verify((Object)connection)).setReadOnly(true);
    }

    @Test
    public void testSetMultipleTransactionModes() {
        ConnectionImpl connection = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        ConnectionStatementExecutorImpl executor = new ConnectionStatementExecutorImpl(connection);
        String sql = "set session characteristics as transaction isolation level default, read only, isolation level serializable, read write";
        AbstractStatementParser.ParsedStatement statement = this.parser.parse(Statement.of((String)sql));
        Assert.assertEquals((String)sql, (Object)AbstractStatementParser.StatementType.CLIENT_SIDE, (Object)statement.getType());
        statement.getClientSideStatement().execute((ConnectionStatementExecutor)executor, statement);
        ((ConnectionImpl)Mockito.verify((Object)connection)).setReadOnly(false);
        ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.never())).setReadOnly(true);
    }

    @Test
    public void testDefaultTransactionIsolation() {
        ConnectionImpl connection = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        ConnectionStatementExecutorImpl executor = new ConnectionStatementExecutorImpl(connection);
        for (String sql : new String[]{"set default_transaction_isolation = serializable", "set default_transaction_isolation = 'serializable'", "set default_transaction_isolation to serializable", "set default_transaction_isolation to 'serializable'", "set default_transaction_isolation to 'SERIALIZABLE'", "set default_transaction_isolation to \"SERIALIZABLE\"", "set default_transaction_isolation to default", "set default_transaction_isolation to DEFAULT", "set default_transaction_isolation = default", "set default_transaction_isolation = DEFAULT"}) {
            AbstractStatementParser.ParsedStatement statement = this.parser.parse(Statement.of((String)sql));
            Assert.assertEquals((String)sql, (Object)AbstractStatementParser.StatementType.CLIENT_SIDE, (Object)statement.getType());
            statement.getClientSideStatement().execute((ConnectionStatementExecutor)executor, statement);
        }
        ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.never())).setReadOnly(ArgumentMatchers.anyBoolean());
    }

    @Test
    public void testDefaultTransactionReadOnlyTrue() {
        String[] statements;
        ConnectionImpl connection = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        ConnectionStatementExecutorImpl executor = new ConnectionStatementExecutorImpl(connection);
        for (String sql : statements = new String[]{"set default_transaction_read_only = true", "set default_transaction_read_only = 'true'", "set default_transaction_read_only = \"true\"", "set default_transaction_read_only to true", "set default_transaction_read_only to 'true'", "set default_transaction_read_only to \"true\"", "set default_transaction_read_only = t", "set default_transaction_read_only = 'tr'", "set default_transaction_read_only = \"tru\"", "set default_transaction_read_only to tru", "set default_transaction_read_only to 'tr'", "set default_transaction_read_only to \"t\"", "set default_transaction_read_only = on", "set default_transaction_read_only = 1", "set default_transaction_read_only = yes", "set default_transaction_read_only = ye", "set default_transaction_read_only = y"}) {
            AbstractStatementParser.ParsedStatement statement = this.parser.parse(Statement.of((String)sql));
            Assert.assertEquals((String)sql, (Object)AbstractStatementParser.StatementType.CLIENT_SIDE, (Object)statement.getType());
            statement.getClientSideStatement().execute((ConnectionStatementExecutor)executor, statement);
        }
        ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)statements.length))).setReadOnly(true);
    }

    @Test
    public void testDefaultTransactionReadOnlyFalse() {
        String[] statements;
        ConnectionImpl connection = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        ConnectionStatementExecutorImpl executor = new ConnectionStatementExecutorImpl(connection);
        for (String sql : statements = new String[]{"set default_transaction_read_only = false", "set default_transaction_read_only = 'false'", "set default_transaction_read_only = \"false\"", "set default_transaction_read_only to false", "set default_transaction_read_only to 'false'", "set default_transaction_read_only to \"false\"", "set default_transaction_read_only = f", "set default_transaction_read_only = 'fa'", "set default_transaction_read_only = \"fal\"", "set default_transaction_read_only to fal", "set default_transaction_read_only to 'fa'", "set default_transaction_read_only to \"f\"", "set default_transaction_read_only = off", "set default_transaction_read_only = of", "set default_transaction_read_only = 0", "set default_transaction_read_only = no", "set default_transaction_read_only = n"}) {
            AbstractStatementParser.ParsedStatement statement = this.parser.parse(Statement.of((String)sql));
            Assert.assertEquals((String)sql, (Object)AbstractStatementParser.StatementType.CLIENT_SIDE, (Object)statement.getType());
            statement.getClientSideStatement().execute((ConnectionStatementExecutor)executor, statement);
        }
        ((ConnectionImpl)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)statements.length))).setReadOnly(false);
    }
}

