/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection.it;

import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ParallelIntegrationTest;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.connection.Connection;
import com.google.cloud.spanner.connection.ITAbstractSpannerTest;
import com.google.cloud.spanner.testing.EmulatorSpannerHelper;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={ParallelIntegrationTest.class})
@RunWith(value=Parameterized.class)
public class ITEmulatorConcurrentTransactionsTest
extends ITAbstractSpannerTest {
    @Parameterized.Parameter
    public boolean useAutoSavepointsForEmulator;

    @Parameterized.Parameters(name="Use auto-savepoints={0}")
    public static Object[] parameters() {
        return new Object[]{Boolean.TRUE, Boolean.FALSE};
    }

    @Override
    public void appendConnectionUri(StringBuilder uri) {
        uri.append(";autoConfigEmulator=true;autoCommit=false;useAutoSavepointsForEmulator=").append(this.useAutoSavepointsForEmulator);
    }

    @Override
    public boolean doCreateDefaultTestTable() {
        return true;
    }

    @BeforeClass
    public static void onlyOnEmulator() {
        Assume.assumeTrue((String)"This test is only intended for the emulator", (boolean)EmulatorSpannerHelper.isUsingEmulator());
    }

    @Before
    public void clearTestData() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.bufferedWrite(Mutation.delete((String)"TEST", (KeySet)KeySet.all()));
            connection.commit();
        }
    }

    @Test
    public void testInnerTransaction() {
        try (ITAbstractSpannerTest.ITConnection connection1 = this.createConnection();
             ITAbstractSpannerTest.ITConnection connection2 = this.createConnection();){
            Assert.assertEquals((long)1L, (long)connection1.executeUpdate(Statement.of((String)"insert into test (id, name) values (1, 'One')")));
            Assert.assertEquals((long)1L, (long)connection2.executeUpdate(Statement.of((String)"insert into test (id, name) values (2, 'Two')")));
            connection2.commit();
            connection1.commit();
        }
        this.verifyRowCount(2L);
    }

    @Test
    public void testOverlappingTransactions() {
        try (ITAbstractSpannerTest.ITConnection connection1 = this.createConnection();
             ITAbstractSpannerTest.ITConnection connection2 = this.createConnection();){
            Assert.assertEquals((long)1L, (long)connection1.executeUpdate(Statement.of((String)"insert into test (id, name) values (1, 'One')")));
            Assert.assertEquals((long)1L, (long)connection2.executeUpdate(Statement.of((String)"insert into test (id, name) values (2, 'Two')")));
            connection1.commit();
            connection2.commit();
        }
        this.verifyRowCount(2L);
    }

    @Test
    public void testSingleThreadRandomTransactions() {
        AtomicInteger numRowsInserted = new AtomicInteger();
        this.runRandomTransactions(numRowsInserted);
        this.verifyRowCount(numRowsInserted.get());
    }

    @Test
    public void testMultiThreadedRandomTransactions() throws Exception {
        int numThreads = ThreadLocalRandom.current().nextInt(10) + 5;
        ExecutorService executor = Executors.newFixedThreadPool(numThreads);
        AtomicInteger numRowsInserted = new AtomicInteger();
        ArrayList futures = new ArrayList(numThreads);
        for (int thread = 0; thread < numThreads; ++thread) {
            futures.add(executor.submit(() -> this.runRandomTransactions(numRowsInserted)));
        }
        executor.shutdown();
        Assert.assertTrue((boolean)executor.awaitTermination(60L, TimeUnit.SECONDS));
        for (Future future : futures) {
            Assert.assertNull(future.get());
        }
        this.verifyRowCount(numRowsInserted.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void runRandomTransactions(AtomicInteger numRowsInserted) {
        int numTransactions = ThreadLocalRandom.current().nextInt(25) + 5;
        String sql = "insert into test (id, name) values (@id, 'test')";
        ArrayList<ITAbstractSpannerTest.ITConnection> connections = new ArrayList<ITAbstractSpannerTest.ITConnection>(numTransactions);
        try {
            for (int i = 0; i < numTransactions; ++i) {
                connections.add(this.createConnection());
            }
            while (!connections.isEmpty()) {
                int index = ThreadLocalRandom.current().nextInt(connections.size());
                Connection connection = (Connection)connections.get(index);
                if (ThreadLocalRandom.current().nextInt(10) < 5) {
                    connection.commit();
                    connection.close();
                    Assert.assertEquals((Object)connection, connections.remove(index));
                } else {
                    Assert.assertEquals((long)1L, (long)connection.executeUpdate(((Statement.Builder)Statement.newBuilder((String)sql).bind("id").to(ThreadLocalRandom.current().nextLong())).build()));
                    numRowsInserted.incrementAndGet();
                }
                try {
                    Thread.sleep(ThreadLocalRandom.current().nextInt(1, 5));
                }
                catch (InterruptedException interruptedException) {
                    throw SpannerExceptionFactory.propagateInterrupt((InterruptedException)interruptedException);
                    return;
                }
            }
        }
        finally {
            for (Connection connection : connections) {
                connection.close();
            }
        }
    }

    private void verifyRowCount(long expected) {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();
             ResultSet resultSet = connection.executeQuery(Statement.of((String)"select count(1) from test"), new Options.QueryOption[0]);){
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((long)expected, (long)resultSet.getLong(0));
            Assert.assertFalse((boolean)resultSet.next());
        }
    }
}

