/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AbstractMultiplexedSessionDatabaseClient;
import com.google.cloud.spanner.AsyncRunner;
import com.google.cloud.spanner.AsyncTransactionManager;
import com.google.cloud.spanner.CommitResponse;
import com.google.cloud.spanner.DelayedAsyncRunner;
import com.google.cloud.spanner.DelayedAsyncTransactionManager;
import com.google.cloud.spanner.DelayedReadContext;
import com.google.cloud.spanner.DelayedTransactionManager;
import com.google.cloud.spanner.DelayedTransactionRunner;
import com.google.cloud.spanner.ISpan;
import com.google.cloud.spanner.MultiplexedSessionDatabaseClient;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.SessionReference;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.TransactionManager;
import com.google.cloud.spanner.TransactionRunner;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;

class DelayedMultiplexedSessionTransaction
extends AbstractMultiplexedSessionDatabaseClient {
    private final MultiplexedSessionDatabaseClient client;
    private final ISpan span;
    private final ApiFuture<SessionReference> sessionFuture;

    DelayedMultiplexedSessionTransaction(MultiplexedSessionDatabaseClient client, ISpan span, ApiFuture<SessionReference> sessionFuture) {
        this.client = client;
        this.span = span;
        this.sessionFuture = sessionFuture;
    }

    @Override
    public ReadContext singleUse() {
        return new DelayedReadContext(ApiFutures.transform(this.sessionFuture, sessionReference -> new MultiplexedSessionDatabaseClient.MultiplexedSessionTransaction(this.client, this.span, (SessionReference)sessionReference, -1, true).singleUse(), (Executor)MoreExecutors.directExecutor()));
    }

    @Override
    public ReadContext singleUse(TimestampBound bound) {
        return new DelayedReadContext(ApiFutures.transform(this.sessionFuture, sessionReference -> new MultiplexedSessionDatabaseClient.MultiplexedSessionTransaction(this.client, this.span, (SessionReference)sessionReference, -1, true).singleUse(bound), (Executor)MoreExecutors.directExecutor()));
    }

    @Override
    public ReadOnlyTransaction singleUseReadOnlyTransaction() {
        return new DelayedReadContext.DelayedReadOnlyTransaction((ApiFuture<ReadOnlyTransaction>)ApiFutures.transform(this.sessionFuture, sessionReference -> new MultiplexedSessionDatabaseClient.MultiplexedSessionTransaction(this.client, this.span, (SessionReference)sessionReference, -1, true).singleUseReadOnlyTransaction(), (Executor)MoreExecutors.directExecutor()));
    }

    @Override
    public ReadOnlyTransaction singleUseReadOnlyTransaction(TimestampBound bound) {
        return new DelayedReadContext.DelayedReadOnlyTransaction((ApiFuture<ReadOnlyTransaction>)ApiFutures.transform(this.sessionFuture, sessionReference -> new MultiplexedSessionDatabaseClient.MultiplexedSessionTransaction(this.client, this.span, (SessionReference)sessionReference, -1, true).singleUseReadOnlyTransaction(bound), (Executor)MoreExecutors.directExecutor()));
    }

    @Override
    public ReadOnlyTransaction readOnlyTransaction() {
        return new DelayedReadContext.DelayedReadOnlyTransaction((ApiFuture<ReadOnlyTransaction>)ApiFutures.transform(this.sessionFuture, sessionReference -> new MultiplexedSessionDatabaseClient.MultiplexedSessionTransaction(this.client, this.span, (SessionReference)sessionReference, -1, false).readOnlyTransaction(), (Executor)MoreExecutors.directExecutor()));
    }

    @Override
    public ReadOnlyTransaction readOnlyTransaction(TimestampBound bound) {
        return new DelayedReadContext.DelayedReadOnlyTransaction((ApiFuture<ReadOnlyTransaction>)ApiFutures.transform(this.sessionFuture, sessionReference -> new MultiplexedSessionDatabaseClient.MultiplexedSessionTransaction(this.client, this.span, (SessionReference)sessionReference, -1, false).readOnlyTransaction(bound), (Executor)MoreExecutors.directExecutor()));
    }

    @Override
    public CommitResponse writeAtLeastOnceWithOptions(Iterable<Mutation> mutations, Options.TransactionOption ... options) throws SpannerException {
        SessionReference sessionReference = this.getSessionReference();
        try (MultiplexedSessionDatabaseClient.MultiplexedSessionTransaction transaction = new MultiplexedSessionDatabaseClient.MultiplexedSessionTransaction(this.client, this.span, sessionReference, -1, true);){
            CommitResponse commitResponse = transaction.writeAtLeastOnceWithOptions(mutations, options);
            return commitResponse;
        }
    }

    @Override
    public Timestamp write(Iterable<Mutation> mutations) throws SpannerException {
        SessionReference sessionReference = this.getSessionReference();
        try (MultiplexedSessionDatabaseClient.MultiplexedSessionTransaction transaction = new MultiplexedSessionDatabaseClient.MultiplexedSessionTransaction(this.client, this.span, sessionReference, -1, false);){
            Timestamp timestamp = transaction.write(mutations);
            return timestamp;
        }
    }

    @Override
    public CommitResponse writeWithOptions(Iterable<Mutation> mutations, Options.TransactionOption ... options) throws SpannerException {
        SessionReference sessionReference = this.getSessionReference();
        try (MultiplexedSessionDatabaseClient.MultiplexedSessionTransaction transaction = new MultiplexedSessionDatabaseClient.MultiplexedSessionTransaction(this.client, this.span, sessionReference, -1, false);){
            CommitResponse commitResponse = transaction.writeWithOptions(mutations, options);
            return commitResponse;
        }
    }

    @Override
    public TransactionRunner readWriteTransaction(Options.TransactionOption ... options) {
        return new DelayedTransactionRunner((ApiFuture<TransactionRunner>)ApiFutures.transform(this.sessionFuture, sessionReference -> new MultiplexedSessionDatabaseClient.MultiplexedSessionTransaction(this.client, this.span, (SessionReference)sessionReference, -1, false).readWriteTransaction(options), (Executor)MoreExecutors.directExecutor()));
    }

    @Override
    public TransactionManager transactionManager(Options.TransactionOption ... options) {
        return new DelayedTransactionManager((ApiFuture<TransactionManager>)ApiFutures.transform(this.sessionFuture, sessionReference -> new MultiplexedSessionDatabaseClient.MultiplexedSessionTransaction(this.client, this.span, (SessionReference)sessionReference, -1, false).transactionManager(options), (Executor)MoreExecutors.directExecutor()));
    }

    @Override
    public AsyncRunner runAsync(Options.TransactionOption ... options) {
        return new DelayedAsyncRunner((ApiFuture<AsyncRunner>)ApiFutures.transform(this.sessionFuture, sessionReference -> new MultiplexedSessionDatabaseClient.MultiplexedSessionTransaction(this.client, this.span, (SessionReference)sessionReference, -1, false).runAsync(options), (Executor)MoreExecutors.directExecutor()));
    }

    @Override
    public AsyncTransactionManager transactionManagerAsync(Options.TransactionOption ... options) {
        return new DelayedAsyncTransactionManager((ApiFuture<AsyncTransactionManager>)ApiFutures.transform(this.sessionFuture, sessionReference -> new MultiplexedSessionDatabaseClient.MultiplexedSessionTransaction(this.client, this.span, (SessionReference)sessionReference, -1, false).transactionManagerAsync(options), (Executor)MoreExecutors.directExecutor()));
    }

    private SessionReference getSessionReference() {
        try {
            return (SessionReference)this.sessionFuture.get();
        }
        catch (ExecutionException executionException) {
            throw SpannerExceptionFactory.causeAsRunTimeException(executionException);
        }
        catch (InterruptedException interruptedException) {
            throw SpannerExceptionFactory.propagateInterrupt(interruptedException);
        }
    }
}

