/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.core.ExecutorProvider;
import com.google.cloud.spanner.AbstractReadContext;
import com.google.cloud.spanner.AsyncResultSet;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.ForwardingStructReader;
import com.google.cloud.spanner.GrpcStreamIterator;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.StreamingUtil;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.StructReader;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.spanner.v1.PartialResultSet;
import com.google.spanner.v1.ResultSetMetadata;
import com.google.spanner.v1.ResultSetStats;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;

class AsyncResultSetImpl
extends ForwardingStructReader
implements AbstractReadContext.ListenableAsyncResultSet,
AsyncResultSet.StreamMessageListener {
    private static final Logger log = Logger.getLogger(AsyncResultSetImpl.class.getName());
    static final int DEFAULT_BUFFER_SIZE = 10;
    private static final int MAX_WAIT_FOR_BUFFER_CONSUMPTION = 10;
    private static final SpannerException CANCELLED_EXCEPTION = SpannerExceptionFactory.newSpannerException(ErrorCode.CANCELLED, "This AsyncResultSet has been cancelled");
    private final Object monitor = new Object();
    private boolean closed;
    private final ExecutorProvider executorProvider;
    private final ListeningScheduledExecutorService service;
    private final BlockingDeque<Struct> buffer;
    private Struct currentRow;
    private final Supplier<ResultSet> delegateResultSet;
    private volatile SpannerException executionException;
    private Executor executor;
    private AsyncResultSet.ReadyCallback callback;
    private Collection<Runnable> listeners = new LinkedList<Runnable>();
    private State state = State.INITIALIZED;
    private volatile boolean produceRowsInitiated;
    private volatile boolean finished;
    private volatile SettableApiFuture<Void> result;
    private volatile boolean cursorReturnedDoneOrException;
    private volatile CountDownLatch pausedLatch = new CountDownLatch(1);
    private volatile CountDownLatch bufferConsumptionLatch = new CountDownLatch(0);
    private volatile CountDownLatch consumingLatch = new CountDownLatch(0);
    private final CallbackRunnable callbackRunnable = new CallbackRunnable();

    AsyncResultSetImpl(ExecutorProvider executorProvider, ResultSet delegate, int bufferSize) {
        this(executorProvider, (Supplier<ResultSet>)Suppliers.ofInstance((Object)((ResultSet)Preconditions.checkNotNull((Object)delegate))), bufferSize);
    }

    AsyncResultSetImpl(ExecutorProvider executorProvider, Supplier<ResultSet> delegate, int bufferSize) {
        super(delegate);
        this.executorProvider = (ExecutorProvider)Preconditions.checkNotNull((Object)executorProvider);
        this.delegateResultSet = (Supplier)Preconditions.checkNotNull(delegate);
        this.service = MoreExecutors.listeningDecorator((ScheduledExecutorService)executorProvider.getExecutor());
        this.buffer = new LinkedBlockingDeque<Struct>(bufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            if (this.state == State.INITIALIZED || this.state == State.SYNC) {
                ((ResultSet)this.delegateResultSet.get()).close();
            }
            this.closed = true;
        }
    }

    @Override
    public void addListener(Runnable listener) {
        Preconditions.checkState((this.state == State.INITIALIZED ? 1 : 0) != 0);
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(Runnable listener) {
        Preconditions.checkState((this.state == State.INITIALIZED ? 1 : 0) != 0);
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsyncResultSet.CursorState tryNext() throws SpannerException {
        Object object = this.monitor;
        synchronized (object) {
            if (this.state == State.CANCELLED) {
                this.cursorReturnedDoneOrException = true;
                throw CANCELLED_EXCEPTION;
            }
            if (this.buffer.isEmpty() && this.executionException != null) {
                this.cursorReturnedDoneOrException = true;
                throw this.executionException;
            }
            Preconditions.checkState((this.callback != null ? 1 : 0) != 0, (Object)"tryNext may only be called after a callback has been set.");
            Preconditions.checkState((this.state == State.CONSUMING ? 1 : 0) != 0, (Object)("tryNext may only be called from a DataReady callback. Current state: " + this.state.name()));
            if (this.finished && this.buffer.isEmpty()) {
                this.cursorReturnedDoneOrException = true;
                return AsyncResultSet.CursorState.DONE;
            }
        }
        if (!this.buffer.isEmpty()) {
            this.currentRow = (Struct)this.buffer.pop();
            this.replaceDelegate(this.currentRow);
            object = this.monitor;
            synchronized (object) {
                this.bufferConsumptionLatch.countDown();
            }
            return AsyncResultSet.CursorState.OK;
        }
        return AsyncResultSet.CursorState.NOT_READY;
    }

    private void closeDelegateResultSet() {
        try {
            ((ResultSet)this.delegateResultSet.get()).close();
        }
        catch (Throwable t) {
            log.log(Level.FINE, "Ignoring error from closing delegate result set", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApiFuture<Void> setCallback(Executor exec, AsyncResultSet.ReadyCallback cb) {
        Object object = this.monitor;
        synchronized (object) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"This AsyncResultSet has been closed");
            Preconditions.checkState((this.state == State.INITIALIZED ? 1 : 0) != 0, (Object)"callback may not be set multiple times");
            this.result = SettableApiFuture.create();
            this.state = State.STREAMING_INITIALIZED;
            this.service.execute((Runnable)new InitiateStreamingRunnable());
            this.executor = MoreExecutors.newSequentialExecutor((Executor)((Executor)Preconditions.checkNotNull((Object)exec)));
            this.callback = (AsyncResultSet.ReadyCallback)Preconditions.checkNotNull((Object)cb);
            this.pausedLatch.countDown();
            return this.result;
        }
    }

    private void initiateProduceRows() {
        if (this.state == State.STREAMING_INITIALIZED) {
            this.state = State.RUNNING;
        }
        this.produceRowsInitiated = true;
        this.service.execute((Runnable)new ProduceRowsRunnable());
    }

    Future<Void> getResult() {
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        Object object = this.monitor;
        synchronized (object) {
            Preconditions.checkState((this.state != State.INITIALIZED && this.state != State.SYNC ? 1 : 0) != 0, (Object)"cannot cancel a result set without a callback");
            this.state = State.CANCELLED;
            this.pausedLatch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        Object object = this.monitor;
        synchronized (object) {
            Preconditions.checkState((this.state != State.INITIALIZED && this.state != State.SYNC ? 1 : 0) != 0, (Object)"cannot resume a result set without a callback");
            if (this.state == State.PAUSED) {
                this.state = State.RUNNING;
                this.pausedLatch.countDown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> ApiFuture<List<T>> toListAsync(Function<StructReader, T> transformer, Executor executor) {
        Object object = this.monitor;
        synchronized (object) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"This AsyncResultSet has been closed");
            Preconditions.checkState((this.state == State.INITIALIZED ? 1 : 0) != 0, (Object)"This AsyncResultSet has already been used.");
            SettableApiFuture res = SettableApiFuture.create();
            CreateListCallback callback = new CreateListCallback(res, transformer);
            ApiFuture<Void> finished = this.setCallback(executor, callback);
            return ApiFutures.transformAsync(finished, ignored -> res, (Executor)MoreExecutors.directExecutor());
        }
    }

    @Override
    public <T> List<T> toList(Function<StructReader, T> transformer) throws SpannerException {
        ApiFuture<List<T>> future = this.toListAsync(transformer, MoreExecutors.directExecutor());
        try {
            return (List)future.get();
        }
        catch (ExecutionException e) {
            throw SpannerExceptionFactory.asSpannerException(e.getCause());
        }
        catch (Throwable e) {
            throw SpannerExceptionFactory.asSpannerException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean next() throws SpannerException {
        Object object = this.monitor;
        synchronized (object) {
            Preconditions.checkState((this.state == State.INITIALIZED || this.state == State.SYNC ? 1 : 0) != 0, (Object)"Cannot call next() on a result set with a callback.");
            this.state = State.SYNC;
        }
        boolean res = ((ResultSet)this.delegateResultSet.get()).next();
        this.currentRow = res ? ((ResultSet)this.delegateResultSet.get()).getCurrentRowAsStruct() : null;
        return res;
    }

    @Override
    public ResultSetStats getStats() {
        return ((ResultSet)this.delegateResultSet.get()).getStats();
    }

    @Override
    public ResultSetMetadata getMetadata() {
        return ((ResultSet)this.delegateResultSet.get()).getMetadata();
    }

    boolean initiateStreaming(AsyncResultSet.StreamMessageListener streamMessageListener) {
        return StreamingUtil.initiateStreaming((ResultSet)this.delegateResultSet.get(), streamMessageListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void checkValidState() {
        Object object = this.monitor;
        synchronized (object) {
            Preconditions.checkState((this.state == State.SYNC || this.state == State.CONSUMING || this.state == State.CANCELLED ? 1 : 0) != 0, (Object)"only allowed after a next() call or from within a ReadyCallback#cursorReady callback");
            Preconditions.checkState((this.state != State.SYNC || !this.closed ? 1 : 0) != 0, (Object)"ResultSet is closed");
        }
    }

    @Override
    public Struct getCurrentRowAsStruct() {
        this.checkValidState();
        return this.currentRow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStreamMessage(PartialResultSet partialResultSet, boolean bufferIsFull) {
        Object object = this.monitor;
        synchronized (object) {
            boolean startJobThread;
            if (this.produceRowsInitiated) {
                return;
            }
            boolean bl = startJobThread = !partialResultSet.getResumeToken().isEmpty() || bufferIsFull || partialResultSet == GrpcStreamIterator.END_OF_STREAM;
            if (startJobThread || this.state != State.STREAMING_INITIALIZED) {
                this.initiateProduceRows();
            }
        }
    }

    static /* synthetic */ boolean access$102(AsyncResultSetImpl x0, boolean x1) {
        x0.cursorReturnedDoneOrException = x1;
        return x0.cursorReturnedDoneOrException;
    }

    static /* synthetic */ AsyncResultSet.ReadyCallback access$300(AsyncResultSetImpl x0) {
        return x0.callback;
    }

    static /* synthetic */ CountDownLatch access$502(AsyncResultSetImpl x0, CountDownLatch x1) {
        x0.pausedLatch = x1;
        return x0.pausedLatch;
    }

    static /* synthetic */ BlockingDeque access$600(AsyncResultSetImpl x0) {
        return x0.buffer;
    }

    static /* synthetic */ boolean access$700(AsyncResultSetImpl x0) {
        return x0.finished;
    }

    static /* synthetic */ CountDownLatch access$800(AsyncResultSetImpl x0) {
        return x0.consumingLatch;
    }

    static /* synthetic */ CountDownLatch access$900(AsyncResultSetImpl x0) {
        return x0.bufferConsumptionLatch;
    }

    static /* synthetic */ Supplier access$1100(AsyncResultSetImpl x0) {
        return x0.delegateResultSet;
    }

    static /* synthetic */ void access$1300(AsyncResultSetImpl x0) {
        x0.closeDelegateResultSet();
    }

    static /* synthetic */ boolean access$702(AsyncResultSetImpl x0, boolean x1) {
        x0.finished = x1;
        return x0.finished;
    }

    static /* synthetic */ SettableApiFuture access$1400(AsyncResultSetImpl x0) {
        return x0.result;
    }

    static /* synthetic */ ExecutorProvider access$1500(AsyncResultSetImpl x0) {
        return x0.executorProvider;
    }

    static /* synthetic */ ListeningScheduledExecutorService access$1600(AsyncResultSetImpl x0) {
        return x0.service;
    }

    static /* synthetic */ Collection access$1700(AsyncResultSetImpl x0) {
        return x0.listeners;
    }

    static /* synthetic */ SpannerException access$400(AsyncResultSetImpl x0) {
        return x0.executionException;
    }

    static /* synthetic */ SpannerException access$1800() {
        return CANCELLED_EXCEPTION;
    }

    private class CallbackRunnable
    implements Runnable {
        private CallbackRunnable() {
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[TRYBLOCK]], but top level block is 33[CASE]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private static enum State {
        INITIALIZED,
        STREAMING_INITIALIZED,
        SYNC,
        CONSUMING,
        RUNNING,
        PAUSED,
        CANCELLED(true),
        DONE(true);

        private final boolean shouldStop;

        private State() {
            this.shouldStop = false;
        }

        private State(boolean shouldStop) {
            this.shouldStop = shouldStop;
        }

        static /* synthetic */ boolean access$1200(State x0) {
            return x0.shouldStop;
        }
    }

    private class InitiateStreamingRunnable
    implements Runnable {
        private InitiateStreamingRunnable() {
        }

        @Override
        public void run() {
            try {
                if (!AsyncResultSetImpl.this.initiateStreaming(AsyncResultSetImpl.this)) {
                    AsyncResultSetImpl.this.initiateProduceRows();
                }
            }
            catch (Throwable exception) {
                AsyncResultSetImpl.this.executionException = SpannerExceptionFactory.asSpannerException(exception);
                AsyncResultSetImpl.this.initiateProduceRows();
            }
        }
    }

    private class ProduceRowsRunnable
    implements Runnable {
        private ProduceRowsRunnable() {
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [36[DOLOOP]], but top level block is 16[MONITOR]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitIfPaused() throws InterruptedException {
            CountDownLatch pause;
            Object object = AsyncResultSetImpl.this.monitor;
            synchronized (object) {
                pause = AsyncResultSetImpl.this.pausedLatch;
            }
            pause.await();
        }

        private void startCallbackIfNecessary() {
            this.startCallbackWithBufferLatchIfNecessary(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startCallbackWithBufferLatchIfNecessary(int bufferLatch) {
            Object object = AsyncResultSetImpl.this.monitor;
            synchronized (object) {
                if (!(AsyncResultSetImpl.this.state != State.RUNNING && AsyncResultSetImpl.this.state != State.CANCELLED || AsyncResultSetImpl.this.cursorReturnedDoneOrException)) {
                    AsyncResultSetImpl.this.consumingLatch = new CountDownLatch(1);
                    if (bufferLatch > 0) {
                        AsyncResultSetImpl.this.bufferConsumptionLatch = new CountDownLatch(bufferLatch);
                    }
                    if (AsyncResultSetImpl.this.state == State.RUNNING) {
                        AsyncResultSetImpl.this.state = State.CONSUMING;
                    }
                    AsyncResultSetImpl.this.executor.execute(AsyncResultSetImpl.this.callbackRunnable);
                }
            }
        }
    }

    private static class CreateListCallback<T>
    implements AsyncResultSet.ReadyCallback {
        private final SettableApiFuture<List<T>> future;
        private final Function<StructReader, T> transformer;
        private final ImmutableList.Builder<T> builder = ImmutableList.builder();

        private CreateListCallback(SettableApiFuture<List<T>> future, Function<StructReader, T> transformer) {
            this.future = future;
            this.transformer = transformer;
        }

        @Override
        public AsyncResultSet.CallbackResponse cursorReady(AsyncResultSet resultSet) {
            try {
                while (true) {
                    switch (resultSet.tryNext()) {
                        case DONE: {
                            this.future.set((Object)this.builder.build());
                            return AsyncResultSet.CallbackResponse.DONE;
                        }
                        case NOT_READY: {
                            return AsyncResultSet.CallbackResponse.CONTINUE;
                        }
                        case OK: {
                            this.builder.add(this.transformer.apply((Object)resultSet));
                        }
                    }
                }
            }
            catch (Throwable t) {
                this.future.setException(t);
                return AsyncResultSet.CallbackResponse.DONE;
            }
        }
    }
}

