/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.connection.ConnectionPreconditions;
import com.google.cloud.spanner.connection.ConnectionProperty;
import java.util.Objects;

class ConnectionPropertyValue<T> {
    private final ConnectionProperty<T> property;
    private final T resetValue;
    private T value;

    static <T> ConnectionPropertyValue<T> cast(ConnectionPropertyValue<?> value) {
        return value;
    }

    ConnectionPropertyValue(ConnectionProperty<T> property, T resetValue, T value) {
        this.property = property;
        this.resetValue = resetValue;
        this.value = value;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ConnectionPropertyValue)) {
            return false;
        }
        ConnectionPropertyValue<T> other = ConnectionPropertyValue.cast((ConnectionPropertyValue)o);
        return Objects.equals(this.property, other.property) && Objects.equals(this.resetValue, other.resetValue) && Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        return Objects.hash(this.property, this.resetValue, this.value);
    }

    ConnectionProperty<T> getProperty() {
        return this.property;
    }

    T getResetValue() {
        return this.resetValue;
    }

    T getValue() {
        return this.value;
    }

    void setValue(T value, ConnectionProperty.Context context) {
        ConnectionPreconditions.checkState(this.property.getContext().ordinal() >= context.ordinal(), "Property has context " + (Object)((Object)this.property.getContext()) + " and cannot be set in context " + (Object)((Object)context));
        this.value = value;
    }

    ConnectionPropertyValue<T> copy() {
        return new ConnectionPropertyValue<T>(this.property, this.resetValue, this.value);
    }
}

