/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.core.SettableApiFuture;
import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.AbstractAsyncTransactionTest;
import com.google.cloud.spanner.AsyncResultSet;
import com.google.cloud.spanner.AsyncTransactionManager;
import com.google.cloud.spanner.CommitResponse;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.MockSpannerTestUtil;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.SessionPool;
import com.google.cloud.spanner.SpannerApiFutures;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionRunnerImpl;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.AbstractMessage;
import com.google.spanner.v1.BatchCreateSessionsRequest;
import com.google.spanner.v1.BeginTransactionRequest;
import com.google.spanner.v1.CommitRequest;
import com.google.spanner.v1.CreateSessionRequest;
import com.google.spanner.v1.ExecuteBatchDmlRequest;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.RollbackRequest;
import com.google.spanner.v1.TransactionSelector;
import io.grpc.Status;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class AsyncTransactionManagerTest
extends AbstractAsyncTransactionTest {
    @Parameterized.Parameter
    public Executor executor;

    @Parameterized.Parameters(name="executor = {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({MoreExecutors.directExecutor()}, {Executors.newSingleThreadExecutor()}, {Executors.newFixedThreadPool(4)});
    }

    @Test
    public void asyncTransactionManager_shouldRollbackOnCloseAsync() throws Exception {
        AsyncTransactionManager manager = this.client().transactionManagerAsync(new Options.TransactionOption[0]);
        TransactionContext txn = (TransactionContext)manager.beginAsync().get();
        txn.executeUpdateAsync(MockSpannerTestUtil.UPDATE_STATEMENT, new Options.UpdateOption[0]).get();
        TransactionSelector selector = ((TransactionRunnerImpl.TransactionContextImpl)((SessionPool.SessionPoolTransactionContext)txn).delegate).getTransactionSelector();
        SpannerApiFutures.get((ApiFuture)manager.closeAsync());
        mockSpanner.waitForRequestsToContain((Predicate<? super AbstractMessage>)((Predicate)input -> {
            if (input instanceof RollbackRequest) {
                RollbackRequest request = (RollbackRequest)input;
                return request.getTransactionId().equals((Object)selector.getId());
            }
            return false;
        }), 0L);
    }

    @Test
    public void testAsyncTransactionManager_returnsCommitStats() throws Exception {
        try (AsyncTransactionManager manager = this.client().transactionManagerAsync(new Options.TransactionOption[]{Options.commitStats()});){
            AsyncTransactionManager.TransactionContextFuture transactionContextFuture = manager.beginAsync();
            while (true) {
                try {
                    AsyncTransactionManager.CommitTimestampFuture commitTimestamp = transactionContextFuture.then((transactionContext, ignored) -> transactionContext.bufferAsync(Collections.singleton(Mutation.delete((String)"FOO", (Key)Key.of((Object[])new Object[]{"foo"})))), this.executor).commitAsync();
                    Assert.assertNotNull((Object)commitTimestamp.get());
                    Assert.assertNotNull((Object)manager.getCommitResponse().get());
                    Assert.assertNotNull((Object)((CommitResponse)manager.getCommitResponse().get()).getCommitStats());
                    Assert.assertEquals((long)1L, (long)((CommitResponse)manager.getCommitResponse().get()).getCommitStats().getMutationCount());
                }
                catch (AbortedException e) {
                    transactionContextFuture = manager.resetForRetryAsync();
                    continue;
                }
                break;
            }
        }
    }

    @Test
    public void asyncTransactionManagerUpdate() throws Exception {
        try (AsyncTransactionManager manager = this.client().transactionManagerAsync(new Options.TransactionOption[0]);){
            AsyncTransactionManager.TransactionContextFuture transactionContextFuture = manager.beginAsync();
            while (true) {
                try {
                    AsyncTransactionManager.AsyncTransactionStep updateCount = transactionContextFuture.then((transactionContext, ignored) -> transactionContext.executeUpdateAsync(MockSpannerTestUtil.UPDATE_STATEMENT, new Options.UpdateOption[0]), this.executor);
                    AsyncTransactionManager.CommitTimestampFuture commitTimestamp = updateCount.commitAsync();
                    Truth.assertThat((Long)((Long)updateCount.get())).isEqualTo((Object)1L);
                    Truth.assertThat((Comparable)commitTimestamp.get()).isNotNull();
                }
                catch (AbortedException e) {
                    transactionContextFuture = manager.resetForRetryAsync();
                    continue;
                }
                break;
            }
        }
    }

    @Test
    public void asyncTransactionManagerIsNonBlocking() throws Exception {
        mockSpanner.freeze();
        try (AsyncTransactionManager manager = this.clientWithEmptySessionPool().transactionManagerAsync(new Options.TransactionOption[0]);){
            AsyncTransactionManager.TransactionContextFuture transactionContextFuture = manager.beginAsync();
            while (true) {
                try {
                    AsyncTransactionManager.AsyncTransactionStep updateCount = transactionContextFuture.then((transactionContext, ignored) -> transactionContext.executeUpdateAsync(MockSpannerTestUtil.UPDATE_STATEMENT, new Options.UpdateOption[0]), this.executor);
                    AsyncTransactionManager.CommitTimestampFuture commitTimestamp = updateCount.commitAsync();
                    mockSpanner.unfreeze();
                    Truth.assertThat((Long)((Long)updateCount.get(10L, TimeUnit.SECONDS))).isEqualTo((Object)1L);
                    Truth.assertThat((Comparable)commitTimestamp.get(10L, TimeUnit.SECONDS)).isNotNull();
                }
                catch (AbortedException e) {
                    transactionContextFuture = manager.resetForRetryAsync();
                    continue;
                }
                break;
            }
        }
    }

    @Test
    public void asyncTransactionManagerInvalidUpdate() throws Exception {
        try (AsyncTransactionManager manager = this.client().transactionManagerAsync(new Options.TransactionOption[0]);){
            AsyncTransactionManager.TransactionContextFuture transactionContextFuture = manager.beginAsync();
            AsyncTransactionManager.CommitTimestampFuture commitTimestamp = transactionContextFuture.then((transaction, ignored) -> transaction.executeUpdateAsync(MockSpannerTestUtil.INVALID_UPDATE_STATEMENT, new Options.UpdateOption[0]), this.executor).commitAsync();
            SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> SpannerApiFutures.get((ApiFuture)commitTimestamp));
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.INVALID_ARGUMENT);
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"invalid statement");
        }
    }

    @Test
    public void asyncTransactionManagerCommitAborted() throws Exception {
        AtomicInteger attempt = new AtomicInteger();
        CountDownLatch abortedLatch = new CountDownLatch(1);
        try (AsyncTransactionManager manager = this.clientWithEmptySessionPool().transactionManagerAsync(new Options.TransactionOption[0]);){
            AsyncTransactionManager.TransactionContextFuture transactionContextFuture = manager.beginAsync();
            while (true) {
                try {
                    attempt.incrementAndGet();
                    AsyncTransactionManager.AsyncTransactionStep updateCount = transactionContextFuture.then((transaction, ignored) -> transaction.executeUpdateAsync(MockSpannerTestUtil.UPDATE_STATEMENT, new Options.UpdateOption[0]), this.executor);
                    updateCount.then((transaction, ignored) -> {
                        if (attempt.get() == 1) {
                            mockSpanner.abortTransaction(transaction);
                            abortedLatch.countDown();
                        }
                        return ApiFutures.immediateFuture(null);
                    }, this.executor);
                    abortedLatch.await(10L, TimeUnit.SECONDS);
                    AsyncTransactionManager.CommitTimestampFuture commitTimestamp = updateCount.commitAsync();
                    Truth.assertThat((Long)((Long)updateCount.get())).isEqualTo((Object)1L);
                    Truth.assertThat((Comparable)commitTimestamp.get()).isNotNull();
                    Truth.assertThat((Integer)attempt.get()).isEqualTo((Object)2);
                }
                catch (AbortedException e) {
                    transactionContextFuture = manager.resetForRetryAsync();
                    continue;
                }
                break;
            }
        }
    }

    @Test
    public void asyncTransactionManagerFireAndForgetInvalidUpdate() throws Exception {
        try (AsyncTransactionManager manager = this.clientWithEmptySessionPool().transactionManagerAsync(new Options.TransactionOption[0]);){
            AsyncTransactionManager.TransactionContextFuture transactionContextFuture = manager.beginAsync();
            while (true) {
                try {
                    AsyncTransactionManager.AsyncTransactionStep transaction = transactionContextFuture.then((transactionContext, ignored) -> {
                        transactionContext.executeUpdateAsync(MockSpannerTestUtil.INVALID_UPDATE_STATEMENT, new Options.UpdateOption[0]);
                        return transactionContext.executeUpdateAsync(MockSpannerTestUtil.UPDATE_STATEMENT, new Options.UpdateOption[0]);
                    }, this.executor);
                    AsyncTransactionManager.CommitTimestampFuture commitTimestamp = transaction.commitAsync();
                    Truth.assertThat((Comparable)commitTimestamp.get()).isNotNull();
                    Truth.assertThat((Long)((Long)transaction.get())).isEqualTo((Object)1L);
                }
                catch (AbortedException e) {
                    transactionContextFuture = manager.resetForRetryAsync();
                    continue;
                }
                break;
            }
        }
        ImmutableList expectedRequests = ImmutableList.of(BatchCreateSessionsRequest.class, ExecuteSqlRequest.class, BeginTransactionRequest.class, ExecuteSqlRequest.class, ExecuteSqlRequest.class, CommitRequest.class);
        if (this.isMultiplexedSessionsEnabled()) {
            Truth.assertThat(mockSpanner.getRequestTypes()).containsAtLeastElementsIn((Iterable)expectedRequests);
        } else {
            Truth.assertThat(mockSpanner.getRequestTypes()).containsExactlyElementsIn((Iterable)expectedRequests);
        }
    }

    @Test
    public void asyncTransactionManagerChain() throws Exception {
        try (AsyncTransactionManager manager = this.client().transactionManagerAsync(new Options.TransactionOption[0]);){
            AsyncTransactionManager.TransactionContextFuture transactionContextFuture = manager.beginAsync();
            while (true) {
                try {
                    AsyncTransactionManager.CommitTimestampFuture commitTimestamp = transactionContextFuture.then((transaction, ignored) -> transaction.executeUpdateAsync(MockSpannerTestUtil.UPDATE_STATEMENT, new Options.UpdateOption[0]), this.executor).then((transactionContext, ignored) -> transactionContext.readRowAsync("TestTable", Key.of((Object[])new Object[]{1L}), MockSpannerTestUtil.READ_COLUMN_NAMES), this.executor).then((ignored, input) -> ApiFutures.immediateFuture((Object)input.getString("Value")), this.executor).then((ignored, input) -> {
                        Truth.assertThat((String)input).isEqualTo((Object)"v1");
                        return ApiFutures.immediateFuture(null);
                    }, this.executor).commitAsync();
                    Truth.assertThat((Comparable)commitTimestamp.get()).isNotNull();
                }
                catch (AbortedException e) {
                    transactionContextFuture = manager.resetForRetryAsync();
                    continue;
                }
                break;
            }
        }
    }

    @Test
    public void asyncTransactionManagerChainWithErrorInTheMiddle() throws Exception {
        try (AsyncTransactionManager manager = this.client().transactionManagerAsync(new Options.TransactionOption[0]);){
            AsyncTransactionManager.TransactionContextFuture transactionContextFuture = manager.beginAsync();
            while (true) {
                try {
                    AsyncTransactionManager.CommitTimestampFuture commitTimestampFuture = transactionContextFuture.then((transactionContext, ignored) -> transactionContext.executeUpdateAsync(MockSpannerTestUtil.INVALID_UPDATE_STATEMENT, new Options.UpdateOption[0]), this.executor).then((ignored1, ignored2) -> {
                        throw new IllegalStateException("this should not be executed");
                    }, this.executor).commitAsync();
                    SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> SpannerApiFutures.get((ApiFuture)commitTimestampFuture));
                    Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.INVALID_ARGUMENT);
                }
                catch (AbortedException e) {
                    transactionContextFuture = manager.resetForRetryAsync();
                    continue;
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void asyncTransactionManagerUpdateAborted() throws Exception {
        try (AsyncTransactionManager manager = this.client().transactionManagerAsync(new Options.TransactionOption[0]);){
            mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(MockSpannerTestUtil.UPDATE_STATEMENT, 2L));
            AtomicInteger attempt = new AtomicInteger();
            AsyncTransactionManager.TransactionContextFuture transactionContextFuture = manager.beginAsync();
            while (true) {
                try {
                    AsyncTransactionManager.CommitTimestampFuture commitTimestampFuture = transactionContextFuture.then((ignored1, ignored2) -> {
                        if (attempt.incrementAndGet() == 1) {
                            mockSpanner.abortNextStatement();
                        } else {
                            mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(MockSpannerTestUtil.UPDATE_STATEMENT, 1L));
                        }
                        return ApiFutures.immediateFuture(null);
                    }, this.executor).then((transactionContext, ignored) -> transactionContext.executeUpdateAsync(MockSpannerTestUtil.UPDATE_STATEMENT, new Options.UpdateOption[0]), this.executor).commitAsync();
                    Truth.assertThat((Comparable)commitTimestampFuture.get()).isNotNull();
                }
                catch (AbortedException e) {
                    transactionContextFuture = manager.resetForRetryAsync();
                    continue;
                }
                break;
            }
            Truth.assertThat((Integer)attempt.get()).isEqualTo((Object)2);
        }
        finally {
            mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(MockSpannerTestUtil.UPDATE_STATEMENT, 1L));
        }
    }

    @Test
    public void asyncTransactionManagerUpdateAbortedWithoutGettingResult() throws Exception {
        AtomicInteger attempt = new AtomicInteger();
        try (AsyncTransactionManager manager = this.clientWithEmptySessionPool().transactionManagerAsync(new Options.TransactionOption[0]);){
            AsyncTransactionManager.TransactionContextFuture transactionContextFuture = manager.beginAsync();
            while (true) {
                try {
                    AsyncTransactionManager.CommitTimestampFuture commitTimestampFuture = transactionContextFuture.then((transaction, ignored) -> {
                        if (attempt.incrementAndGet() == 1) {
                            mockSpanner.abortNextStatement();
                        }
                        transaction.executeUpdateAsync(MockSpannerTestUtil.UPDATE_STATEMENT, new Options.UpdateOption[0]);
                        return ApiFutures.immediateFuture(null);
                    }, this.executor).commitAsync();
                    Truth.assertThat((Comparable)commitTimestampFuture.get()).isNotNull();
                    Truth.assertThat((Integer)attempt.get()).isEqualTo((Object)2);
                    Truth.assertThat(mockSpanner.getRequestTypes()).containsAtLeast(BatchCreateSessionsRequest.class, ExecuteSqlRequest.class, new Object[]{BeginTransactionRequest.class, ExecuteSqlRequest.class, CommitRequest.class});
                }
                catch (AbortedException e) {
                    transactionContextFuture = manager.resetForRetryAsync();
                    continue;
                }
                break;
            }
        }
    }

    @Test
    public void asyncTransactionManagerCommitFails() throws Exception {
        mockSpanner.setCommitExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)Status.INVALID_ARGUMENT.withDescription("mutation limit exceeded").asRuntimeException()));
        try (AsyncTransactionManager mgr = this.client().transactionManagerAsync(new Options.TransactionOption[0]);){
            AsyncTransactionManager.TransactionContextFuture txn = mgr.beginAsync();
            SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> SpannerApiFutures.get((ApiFuture)txn.then(AsyncTransactionManagerHelper.executeUpdateAsync(MockSpannerTestUtil.UPDATE_STATEMENT), this.executor).commitAsync()));
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.INVALID_ARGUMENT);
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"mutation limit exceeded");
        }
    }

    @Test
    public void asyncTransactionManagerWaitsUntilAsyncUpdateHasFinished() throws Exception {
        try (AsyncTransactionManager mgr = this.clientWithEmptySessionPool().transactionManagerAsync(new Options.TransactionOption[0]);){
            AsyncTransactionManager.TransactionContextFuture txn = mgr.beginAsync();
            while (true) {
                try {
                    txn.then((transaction, input) -> {
                        transaction.executeUpdateAsync(MockSpannerTestUtil.UPDATE_STATEMENT, new Options.UpdateOption[0]);
                        return ApiFutures.immediateFuture(null);
                    }, this.executor).commitAsync().get();
                    if (this.isMultiplexedSessionsEnabled()) {
                        Truth.assertThat(mockSpanner.getRequestTypes()).containsExactly(new Object[]{CreateSessionRequest.class, BatchCreateSessionsRequest.class, ExecuteSqlRequest.class, CommitRequest.class});
                    } else {
                        Truth.assertThat(mockSpanner.getRequestTypes()).containsExactly(new Object[]{BatchCreateSessionsRequest.class, ExecuteSqlRequest.class, CommitRequest.class});
                    }
                }
                catch (AbortedException e) {
                    txn = mgr.resetForRetryAsync();
                    continue;
                }
                break;
            }
        }
    }

    @Test
    public void asyncTransactionManagerBatchUpdate() throws Exception {
        try (AsyncTransactionManager manager = this.client().transactionManagerAsync(new Options.TransactionOption[0]);){
            AsyncTransactionManager.TransactionContextFuture transactionContextFuture = manager.beginAsync();
            while (true) {
                try {
                    AsyncTransactionManager.AsyncTransactionStep updateCounts = transactionContextFuture.then((transaction, ignored) -> transaction.batchUpdateAsync((Iterable)ImmutableList.of((Object)MockSpannerTestUtil.UPDATE_STATEMENT, (Object)MockSpannerTestUtil.UPDATE_STATEMENT), new Options.UpdateOption[0]), this.executor);
                    SpannerApiFutures.get((ApiFuture)updateCounts.commitAsync());
                    Truth.assertThat((long[])((long[])SpannerApiFutures.get((ApiFuture)updateCounts))).asList().containsExactly(new Object[]{1L, 1L});
                }
                catch (AbortedException e) {
                    transactionContextFuture = manager.resetForRetryAsync();
                    continue;
                }
                break;
            }
        }
    }

    @Test
    public void asyncTransactionManagerIsNonBlockingWithBatchUpdate() throws Exception {
        mockSpanner.freeze();
        try (AsyncTransactionManager manager = this.clientWithEmptySessionPool().transactionManagerAsync(new Options.TransactionOption[0]);){
            AsyncTransactionManager.TransactionContextFuture transactionContextFuture = manager.beginAsync();
            while (true) {
                try {
                    AsyncTransactionManager.AsyncTransactionStep updateCounts = transactionContextFuture.then((transactionContext, ignored) -> transactionContext.batchUpdateAsync(Collections.singleton(MockSpannerTestUtil.UPDATE_STATEMENT), new Options.UpdateOption[0]), this.executor);
                    AsyncTransactionManager.CommitTimestampFuture commitTimestampFuture = updateCounts.commitAsync();
                    mockSpanner.unfreeze();
                    Truth.assertThat((Comparable)commitTimestampFuture.get()).isNotNull();
                    Truth.assertThat((long[])((long[])updateCounts.get())).asList().containsExactly(new Object[]{1L});
                }
                catch (AbortedException e) {
                    transactionContextFuture = manager.resetForRetryAsync();
                    continue;
                }
                break;
            }
        }
    }

    @Test
    public void asyncTransactionManagerInvalidBatchUpdate() throws Exception {
        try (AsyncTransactionManager manager = this.client().transactionManagerAsync(new Options.TransactionOption[0]);){
            AsyncTransactionManager.TransactionContextFuture transactionContextFuture = manager.beginAsync();
            SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> SpannerApiFutures.get((ApiFuture)transactionContextFuture.then((transactionContext, ignored) -> transactionContext.batchUpdateAsync((Iterable)ImmutableList.of((Object)MockSpannerTestUtil.UPDATE_STATEMENT, (Object)MockSpannerTestUtil.INVALID_UPDATE_STATEMENT), new Options.UpdateOption[0]), this.executor).commitAsync()));
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.INVALID_ARGUMENT);
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"invalid statement");
        }
    }

    @Test
    public void asyncTransactionManagerFireAndForgetInvalidBatchUpdate() throws Exception {
        try (AsyncTransactionManager manager = this.clientWithEmptySessionPool().transactionManagerAsync(new Options.TransactionOption[0]);){
            AsyncTransactionManager.TransactionContextFuture transactionContextFuture = manager.beginAsync();
            while (true) {
                try {
                    AsyncTransactionManager.AsyncTransactionStep updateCounts = transactionContextFuture.then((transactionContext, ignored) -> {
                        transactionContext.batchUpdateAsync((Iterable)ImmutableList.of((Object)MockSpannerTestUtil.UPDATE_STATEMENT, (Object)MockSpannerTestUtil.INVALID_UPDATE_STATEMENT), new Options.UpdateOption[0]);
                        return ApiFutures.immediateFuture(null);
                    }, this.executor).then((transactionContext, ignored) -> transactionContext.batchUpdateAsync((Iterable)ImmutableList.of((Object)MockSpannerTestUtil.UPDATE_STATEMENT, (Object)MockSpannerTestUtil.UPDATE_STATEMENT), new Options.UpdateOption[0]), this.executor);
                    updateCounts.commitAsync().get();
                    Truth.assertThat((long[])((long[])updateCounts.get())).asList().containsExactly(new Object[]{1L, 1L});
                }
                catch (AbortedException e) {
                    transactionContextFuture = manager.resetForRetryAsync();
                    continue;
                }
                break;
            }
        }
        ImmutableList expectedRequests = ImmutableList.of(BatchCreateSessionsRequest.class, ExecuteBatchDmlRequest.class, ExecuteBatchDmlRequest.class, CommitRequest.class);
        if (this.isMultiplexedSessionsEnabled()) {
            Truth.assertThat(mockSpanner.getRequestTypes()).containsAtLeastElementsIn((Iterable)expectedRequests);
        } else {
            Truth.assertThat(mockSpanner.getRequestTypes()).containsExactlyElementsIn((Iterable)expectedRequests);
        }
    }

    @Test
    public void asyncTransactionManagerBatchUpdateAborted() throws Exception {
        AtomicInteger attempt = new AtomicInteger();
        try (AsyncTransactionManager manager = this.clientWithEmptySessionPool().transactionManagerAsync(new Options.TransactionOption[0]);){
            AsyncTransactionManager.TransactionContextFuture transactionContextFuture = manager.beginAsync();
            while (true) {
                try {
                    transactionContextFuture.then((transaction, ignored) -> {
                        if (attempt.incrementAndGet() == 1) {
                            return transaction.batchUpdateAsync((Iterable)ImmutableList.of((Object)MockSpannerTestUtil.UPDATE_STATEMENT, (Object)MockSpannerTestUtil.UPDATE_ABORTED_STATEMENT), new Options.UpdateOption[0]);
                        }
                        return transaction.batchUpdateAsync((Iterable)ImmutableList.of((Object)MockSpannerTestUtil.UPDATE_STATEMENT, (Object)MockSpannerTestUtil.UPDATE_STATEMENT), new Options.UpdateOption[0]);
                    }, this.executor).commitAsync().get();
                }
                catch (AbortedException e) {
                    transactionContextFuture = manager.resetForRetryAsync();
                    continue;
                }
                break;
            }
        }
        Truth.assertThat((Integer)attempt.get()).isEqualTo((Object)2);
        ImmutableList expectedRequests = ImmutableList.of(BatchCreateSessionsRequest.class, ExecuteBatchDmlRequest.class, BeginTransactionRequest.class, ExecuteBatchDmlRequest.class, CommitRequest.class);
        if (this.isMultiplexedSessionsEnabled()) {
            Truth.assertThat(mockSpanner.getRequestTypes()).containsAtLeastElementsIn((Iterable)expectedRequests);
        } else {
            Truth.assertThat(mockSpanner.getRequestTypes()).containsExactlyElementsIn((Iterable)expectedRequests);
        }
    }

    @Test
    public void asyncTransactionManagerBatchUpdateAbortedBeforeFirstStatement() throws Exception {
        AtomicInteger attempt = new AtomicInteger();
        try (AsyncTransactionManager manager = this.clientWithEmptySessionPool().transactionManagerAsync(new Options.TransactionOption[0]);){
            AsyncTransactionManager.TransactionContextFuture transactionContextFuture = manager.beginAsync();
            while (true) {
                try {
                    transactionContextFuture.then((transactionContext, ignored) -> {
                        if (attempt.incrementAndGet() == 1) {
                            mockSpanner.abortNextStatement();
                        }
                        return transactionContext.batchUpdateAsync((Iterable)ImmutableList.of((Object)MockSpannerTestUtil.UPDATE_STATEMENT, (Object)MockSpannerTestUtil.UPDATE_STATEMENT), new Options.UpdateOption[0]);
                    }, this.executor).commitAsync().get();
                }
                catch (AbortedException e) {
                    transactionContextFuture = manager.resetForRetryAsync();
                    continue;
                }
                break;
            }
        }
        Truth.assertThat((Integer)attempt.get()).isEqualTo((Object)2);
        ImmutableList expectedRequests = ImmutableList.of(BatchCreateSessionsRequest.class, ExecuteBatchDmlRequest.class, BeginTransactionRequest.class, ExecuteBatchDmlRequest.class, CommitRequest.class);
        if (this.isMultiplexedSessionsEnabled()) {
            Truth.assertThat(mockSpanner.getRequestTypes()).containsAtLeastElementsIn((Iterable)expectedRequests);
        } else {
            Truth.assertThat(mockSpanner.getRequestTypes()).containsExactlyElementsIn((Iterable)expectedRequests);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void asyncTransactionManagerWithBatchUpdateCommitAborted() throws Exception {
        try (AsyncTransactionManager manager = this.clientWithEmptySessionPool().transactionManagerAsync(new Options.TransactionOption[0]);){
            mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(MockSpannerTestUtil.UPDATE_STATEMENT, 2L));
            AtomicInteger attempt = new AtomicInteger();
            AsyncTransactionManager.TransactionContextFuture txn = manager.beginAsync();
            while (true) {
                try {
                    AsyncTransactionManager.AsyncTransactionStep updateCounts = txn.then((ignored1, ignored2) -> {
                        if (attempt.get() > 0) {
                            mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(MockSpannerTestUtil.UPDATE_STATEMENT, 1L));
                        }
                        return ApiFutures.immediateFuture(null);
                    }, this.executor).then((transactionContext, ignored) -> transactionContext.batchUpdateAsync((Iterable)ImmutableList.of((Object)MockSpannerTestUtil.UPDATE_STATEMENT, (Object)MockSpannerTestUtil.UPDATE_STATEMENT), new Options.UpdateOption[0]), this.executor);
                    updateCounts.then((transaction, ignored) -> {
                        if (attempt.incrementAndGet() == 1) {
                            mockSpanner.abortTransaction(transaction);
                        }
                        return ApiFutures.immediateFuture(null);
                    }, this.executor).commitAsync().get();
                    Truth.assertThat((long[])((long[])updateCounts.get())).asList().containsExactly(new Object[]{1L, 1L});
                    Truth.assertThat((Integer)attempt.get()).isEqualTo((Object)2);
                }
                catch (AbortedException e) {
                    txn = manager.resetForRetryAsync();
                    continue;
                }
                break;
            }
        }
        finally {
            mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(MockSpannerTestUtil.UPDATE_STATEMENT, 1L));
        }
        ImmutableList expectedRequests = ImmutableList.of(BatchCreateSessionsRequest.class, ExecuteBatchDmlRequest.class, CommitRequest.class, BeginTransactionRequest.class, ExecuteBatchDmlRequest.class, CommitRequest.class);
        if (this.isMultiplexedSessionsEnabled()) {
            Truth.assertThat(mockSpanner.getRequestTypes()).containsAtLeastElementsIn((Iterable)expectedRequests);
        } else {
            Truth.assertThat(mockSpanner.getRequestTypes()).containsExactlyElementsIn((Iterable)expectedRequests);
        }
    }

    @Test
    public void asyncTransactionManagerBatchUpdateAbortedWithoutGettingResult() throws Exception {
        AtomicInteger attempt = new AtomicInteger();
        try (AsyncTransactionManager manager = this.clientWithEmptySessionPool().transactionManagerAsync(new Options.TransactionOption[0]);){
            AsyncTransactionManager.TransactionContextFuture transactionContextFuture = manager.beginAsync();
            while (true) {
                try {
                    transactionContextFuture.then((transactionContext, ignored) -> {
                        if (attempt.incrementAndGet() == 1) {
                            mockSpanner.abortNextStatement();
                        }
                        transactionContext.batchUpdateAsync((Iterable)ImmutableList.of((Object)MockSpannerTestUtil.UPDATE_STATEMENT, (Object)MockSpannerTestUtil.UPDATE_STATEMENT), new Options.UpdateOption[0]);
                        return ApiFutures.immediateFuture(null);
                    }, this.executor).commitAsync().get();
                }
                catch (AbortedException e) {
                    transactionContextFuture = manager.resetForRetryAsync();
                    continue;
                }
                break;
            }
        }
        Truth.assertThat((Integer)attempt.get()).isEqualTo((Object)2);
        List<Class<? extends AbstractMessage>> requests = mockSpanner.getRequestTypes();
        requests.removeIf(request -> request == CreateSessionRequest.class);
        int size = Iterables.size(requests);
        Truth.assertThat((Integer)size).isIn(Range.closed((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(6)));
        if (size == 5) {
            Truth.assertThat(requests).containsExactly(new Object[]{BatchCreateSessionsRequest.class, ExecuteBatchDmlRequest.class, BeginTransactionRequest.class, ExecuteBatchDmlRequest.class, CommitRequest.class});
        } else {
            Truth.assertThat(requests).containsExactly(new Object[]{BatchCreateSessionsRequest.class, ExecuteBatchDmlRequest.class, CommitRequest.class, BeginTransactionRequest.class, ExecuteBatchDmlRequest.class, CommitRequest.class});
        }
    }

    @Test
    public void asyncTransactionManagerWithBatchUpdateCommitFails() {
        mockSpanner.setCommitExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)Status.INVALID_ARGUMENT.withDescription("mutation limit exceeded").asRuntimeException()));
        try (AsyncTransactionManager manager = this.clientWithEmptySessionPool().transactionManagerAsync(new Options.TransactionOption[0]);){
            AsyncTransactionManager.TransactionContextFuture transactionContextFuture = manager.beginAsync();
            SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> SpannerApiFutures.get((ApiFuture)transactionContextFuture.then((transactionContext, ignored) -> transactionContext.batchUpdateAsync((Iterable)ImmutableList.of((Object)MockSpannerTestUtil.UPDATE_STATEMENT, (Object)MockSpannerTestUtil.UPDATE_STATEMENT), new Options.UpdateOption[0]), this.executor).commitAsync()));
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.INVALID_ARGUMENT);
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"mutation limit exceeded");
        }
        ImmutableList expectedRequests = ImmutableList.of(BatchCreateSessionsRequest.class, ExecuteBatchDmlRequest.class, CommitRequest.class);
        if (this.isMultiplexedSessionsEnabled()) {
            Truth.assertThat(mockSpanner.getRequestTypes()).containsAtLeastElementsIn((Iterable)expectedRequests);
        } else {
            Truth.assertThat(mockSpanner.getRequestTypes()).containsExactlyElementsIn((Iterable)expectedRequests);
        }
    }

    @Test
    public void asyncTransactionManagerWaitsUntilAsyncBatchUpdateHasFinished() throws Exception {
        try (AsyncTransactionManager manager = this.clientWithEmptySessionPool().transactionManagerAsync(new Options.TransactionOption[0]);){
            AsyncTransactionManager.TransactionContextFuture transactionContextFuture = manager.beginAsync();
            while (true) {
                try {
                    transactionContextFuture.then((transactionContext, ignored) -> {
                        transactionContext.batchUpdateAsync((Iterable)ImmutableList.of((Object)MockSpannerTestUtil.UPDATE_STATEMENT), new Options.UpdateOption[0]);
                        return ApiFutures.immediateFuture(null);
                    }, this.executor).commitAsync().get();
                }
                catch (AbortedException e) {
                    transactionContextFuture = manager.resetForRetryAsync();
                    continue;
                }
                break;
            }
        }
        ImmutableList expectedRequests = ImmutableList.of(BatchCreateSessionsRequest.class, ExecuteBatchDmlRequest.class, CommitRequest.class);
        if (this.isMultiplexedSessionsEnabled()) {
            Truth.assertThat(mockSpanner.getRequestTypes()).containsAtLeastElementsIn((Iterable)expectedRequests);
        } else {
            Truth.assertThat(mockSpanner.getRequestTypes()).containsExactlyElementsIn((Iterable)expectedRequests);
        }
    }

    @Test
    public void asyncTransactionManagerReadRow() throws Exception {
        try (AsyncTransactionManager manager = this.client().transactionManagerAsync(new Options.TransactionOption[0]);){
            AsyncTransactionManager.TransactionContextFuture transactionContextFuture = manager.beginAsync();
            while (true) {
                try {
                    AsyncTransactionManager.AsyncTransactionStep value = transactionContextFuture.then((transactionContext, ignored) -> transactionContext.readRowAsync("TestTable", Key.of((Object[])new Object[]{1L}), MockSpannerTestUtil.READ_COLUMN_NAMES), this.executor).then((ignored, input) -> ApiFutures.immediateFuture((Object)input.getString("Value")), this.executor);
                    value.commitAsync().get();
                    Truth.assertThat((String)((String)value.get())).isEqualTo((Object)"v1");
                }
                catch (AbortedException e) {
                    transactionContextFuture = manager.resetForRetryAsync();
                    continue;
                }
                break;
            }
        }
    }

    @Test
    public void asyncTransactionManagerRead() throws Exception {
        try (AsyncTransactionManager manager = this.client().transactionManagerAsync(new Options.TransactionOption[0]);){
            AsyncTransactionManager.TransactionContextFuture transactionContextFuture = manager.beginAsync();
            while (true) {
                try {
                    AsyncTransactionManager.AsyncTransactionStep values = transactionContextFuture.then((transactionContext, ignored) -> transactionContext.readAsync("TestTable", KeySet.all(), MockSpannerTestUtil.READ_COLUMN_NAMES, new Options.ReadOption[0]).toListAsync(input -> input.getString("Value"), MoreExecutors.directExecutor()), this.executor);
                    values.commitAsync().get();
                    Truth.assertThat((Iterable)((Iterable)values.get())).containsExactly(new Object[]{"v1", "v2", "v3"});
                }
                catch (AbortedException e) {
                    transactionContextFuture = manager.resetForRetryAsync();
                    continue;
                }
                break;
            }
        }
    }

    @Test
    public void asyncTransactionManagerQuery() throws Exception {
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(Statement.of((String)"SELECT FirstName FROM Singers WHERE ID=1"), MockSpannerTestUtil.READ_FIRST_NAME_SINGERS_RESULTSET));
        long singerId = 1L;
        try (AsyncTransactionManager manager = this.client().transactionManagerAsync(new Options.TransactionOption[0]);){
            AsyncTransactionManager.TransactionContextFuture transactionContextFuture = manager.beginAsync();
            while (true) {
                String column = "FirstName";
                AsyncTransactionManager.CommitTimestampFuture commitTimestamp = transactionContextFuture.then((transactionContext, ignored) -> transactionContext.readRowAsync("Singers", Key.of((Object[])new Object[]{1L}), Collections.singleton("FirstName")), this.executor).then((transaction, input) -> {
                    String name = input.getString("FirstName");
                    return transaction.bufferAsync(((Mutation.WriteBuilder)Mutation.newUpdateBuilder((String)"Singers").set("FirstName").to(name.toUpperCase())).build());
                }, this.executor).commitAsync();
                try {
                    commitTimestamp.get();
                }
                catch (AbortedException e) {
                    transactionContextFuture = manager.resetForRetryAsync();
                    continue;
                }
                break;
            }
        }
    }

    @Test
    public void asyncTransactionManager_shouldPropagateStatementFailure() throws ExecutionException, InterruptedException, TimeoutException {
        DatabaseClient dbClient = this.client();
        try (AsyncTransactionManager transactionManager = dbClient.transactionManagerAsync(new Options.TransactionOption[0]);){
            AsyncTransactionManager.TransactionContextFuture txnContextFuture = transactionManager.beginAsync();
            AsyncTransactionManager.AsyncTransactionStep updateFuture = txnContextFuture.then((transaction, ignored) -> transaction.executeUpdateAsync(MockSpannerTestUtil.INVALID_UPDATE_STATEMENT, new Options.UpdateOption[0]), this.executor);
            final SettableApiFuture res = SettableApiFuture.create();
            ApiFutures.addCallback((ApiFuture)updateFuture, (ApiFutureCallback)new ApiFutureCallback<Long>(){

                public void onFailure(Throwable throwable) {
                    try {
                        Truth.assertThat((Throwable)throwable).isInstanceOf(SpannerException.class);
                        SpannerException e = (SpannerException)throwable;
                        Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.INVALID_ARGUMENT);
                        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"invalid statement");
                        res.set(null);
                    }
                    catch (Throwable t) {
                        res.setException(t);
                    }
                }

                public void onSuccess(Long aLong) {
                    res.setException((Throwable)((Object)new AssertionError((Object)"Statement should not succeed.")));
                }
            }, (Executor)this.executor);
            Truth.assertThat((Object)res.get(10L, TimeUnit.SECONDS)).isNull();
        }
    }

    @Test
    public void testAbandonedAsyncTransactionManager_rollbackFails() throws Exception {
        mockSpanner.setRollbackExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)Status.PERMISSION_DENIED.asRuntimeException()));
        boolean gotException = false;
        try (AsyncTransactionManager manager = this.client().transactionManagerAsync(new Options.TransactionOption[0]);){
            AsyncTransactionManager.TransactionContextFuture transactionContextFuture = manager.beginAsync();
            while (true) {
                try {
                    AsyncTransactionManager.AsyncTransactionStep updateCount = transactionContextFuture.then((transactionContext, ignored) -> transactionContext.executeUpdateAsync(MockSpannerTestUtil.UPDATE_STATEMENT, new Options.UpdateOption[0]), this.executor);
                    Assert.assertEquals((long)1L, (long)((Long)updateCount.get()));
                }
                catch (AbortedException e) {
                    transactionContextFuture = manager.resetForRetryAsync();
                    continue;
                }
                break;
            }
        }
        catch (SpannerException spannerException) {
            Assert.assertEquals((Object)ErrorCode.PERMISSION_DENIED, (Object)spannerException.getErrorCode());
            gotException = true;
        }
        Assert.assertTrue((boolean)gotException);
    }

    private boolean isMultiplexedSessionsEnabled() {
        if (this.spanner.getOptions() == null || ((SpannerOptions)this.spanner.getOptions()).getSessionPoolOptions() == null) {
            return false;
        }
        return ((SpannerOptions)this.spanner.getOptions()).getSessionPoolOptions().getUseMultiplexedSession();
    }

    public static class AsyncTransactionManagerHelper {
        public static <I> AsyncTransactionManager.AsyncTransactionFunction<I, AsyncResultSet> readAsync(String table, KeySet keys, Iterable<String> columns, Options.ReadOption ... options) {
            return (transaction, ignored) -> ApiFutures.immediateFuture((Object)transaction.readAsync(table, keys, columns, options));
        }

        public static <I> AsyncTransactionManager.AsyncTransactionFunction<I, Struct> readRowAsync(String table, Key key, Iterable<String> columns) {
            return (transaction, ignored) -> transaction.readRowAsync(table, key, columns);
        }

        public static <I> AsyncTransactionManager.AsyncTransactionFunction<I, Void> buffer(Mutation mutation) {
            return AsyncTransactionManagerHelper.buffer((Iterable<Mutation>)ImmutableList.of((Object)mutation));
        }

        public static <I> AsyncTransactionManager.AsyncTransactionFunction<I, Void> buffer(Iterable<Mutation> mutations) {
            return (transaction, ignored) -> {
                transaction.buffer(mutations);
                return ApiFutures.immediateFuture(null);
            };
        }

        public static <I> AsyncTransactionManager.AsyncTransactionFunction<I, Long> executeUpdateAsync(Statement statement) {
            return AsyncTransactionManagerHelper.executeUpdateAsync((SettableApiFuture<Long>)SettableApiFuture.create(), statement);
        }

        public static <I> AsyncTransactionManager.AsyncTransactionFunction<I, Long> executeUpdateAsync(final SettableApiFuture<Long> result, Statement statement) {
            return (transaction, ignored) -> {
                ApiFuture updateCount = transaction.executeUpdateAsync(statement, new Options.UpdateOption[0]);
                ApiFutures.addCallback((ApiFuture)updateCount, (ApiFutureCallback)new ApiFutureCallback<Long>(){

                    public void onFailure(Throwable t) {
                        result.setException(t);
                    }

                    public void onSuccess(Long input) {
                        result.set((Object)input);
                    }
                }, (Executor)MoreExecutors.directExecutor());
                return updateCount;
            };
        }

        public static <I> AsyncTransactionManager.AsyncTransactionFunction<I, long[]> batchUpdateAsync(Statement ... statements) {
            return AsyncTransactionManagerHelper.batchUpdateAsync((SettableApiFuture<long[]>)SettableApiFuture.create(), statements);
        }

        public static <I> AsyncTransactionManager.AsyncTransactionFunction<I, long[]> batchUpdateAsync(final SettableApiFuture<long[]> result, Statement ... statements) {
            return (transaction, ignored) -> {
                ApiFuture updateCounts = transaction.batchUpdateAsync(Arrays.asList(statements), new Options.UpdateOption[0]);
                ApiFutures.addCallback((ApiFuture)updateCounts, (ApiFutureCallback)new ApiFutureCallback<long[]>(){

                    public void onFailure(Throwable t) {
                        result.setException(t);
                    }

                    public void onSuccess(long[] input) {
                        result.set((Object)input);
                    }
                }, (Executor)MoreExecutors.directExecutor());
                return updateCounts;
            };
        }
    }
}

