/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.cloud.grpc.GrpcTransportOptions;
import com.google.cloud.spanner.CommitResponse;
import com.google.cloud.spanner.FakeClock;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.SessionImpl;
import com.google.cloud.spanner.SessionPool;
import com.google.cloud.spanner.SessionReference;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerImpl;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.spi.v1.SpannerRpc;
import com.google.protobuf.Empty;
import com.google.protobuf.Timestamp;
import java.util.HashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.mockito.Mockito;

abstract class BaseSessionPoolTest {
    ScheduledExecutorService mockExecutor;
    int sessionIndex;
    AtomicLong channelHint = new AtomicLong(0L);

    BaseSessionPoolTest() {
    }

    SessionImpl mockSession() {
        SessionImpl session = (SessionImpl)Mockito.mock(SessionImpl.class);
        HashMap<SpannerRpc.Option, Long> options = new HashMap<SpannerRpc.Option, Long>();
        options.put(SpannerRpc.Option.CHANNEL_HINT, this.channelHint.getAndIncrement());
        Mockito.when((Object)session.getOptions()).thenReturn(options);
        Mockito.when((Object)session.getName()).thenReturn((Object)("projects/dummy/instances/dummy/database/dummy/sessions/session" + this.sessionIndex));
        Mockito.when((Object)session.asyncClose()).thenReturn((Object)ApiFutures.immediateFuture((Object)Empty.getDefaultInstance()));
        Mockito.when((Object)session.writeWithOptions((Iterable)Mockito.any(Iterable.class), new Options.TransactionOption[0])).thenReturn((Object)new CommitResponse(com.google.spanner.v1.CommitResponse.getDefaultInstance()));
        Mockito.when((Object)session.writeAtLeastOnceWithOptions((Iterable)Mockito.any(Iterable.class), new Options.TransactionOption[0])).thenReturn((Object)new CommitResponse(com.google.spanner.v1.CommitResponse.getDefaultInstance()));
        ++this.sessionIndex;
        return session;
    }

    SessionImpl mockMultiplexedSession() {
        SessionImpl session = (SessionImpl)Mockito.mock(SessionImpl.class);
        HashMap options = new HashMap();
        Mockito.when((Object)session.getIsMultiplexed()).thenReturn((Object)true);
        Mockito.when((Object)session.getOptions()).thenReturn(options);
        Mockito.when((Object)session.getName()).thenReturn((Object)("projects/dummy/instances/dummy/database/dummy/sessions/session" + this.sessionIndex));
        Mockito.when((Object)session.asyncClose()).thenReturn((Object)ApiFutures.immediateFuture((Object)Empty.getDefaultInstance()));
        Mockito.when((Object)session.writeWithOptions((Iterable)Mockito.any(Iterable.class), new Options.TransactionOption[0])).thenReturn((Object)new CommitResponse(com.google.spanner.v1.CommitResponse.getDefaultInstance()));
        Mockito.when((Object)session.writeAtLeastOnceWithOptions((Iterable)Mockito.any(Iterable.class), new Options.TransactionOption[0])).thenReturn((Object)new CommitResponse(com.google.spanner.v1.CommitResponse.getDefaultInstance()));
        ++this.sessionIndex;
        return session;
    }

    SessionImpl buildMockSession(SpannerImpl spanner, final ReadContext context) {
        HashMap<SpannerRpc.Option, Long> options = new HashMap<SpannerRpc.Option, Long>();
        options.put(SpannerRpc.Option.CHANNEL_HINT, this.channelHint.getAndIncrement());
        SessionImpl session = new SessionImpl(spanner, new SessionReference("projects/dummy/instances/dummy/databases/dummy/sessions/session" + this.sessionIndex, options)){

            public ReadContext singleUse(TimestampBound bound) {
                return context;
            }

            public ApiFuture<Empty> asyncClose() {
                return ApiFutures.immediateFuture((Object)Empty.getDefaultInstance());
            }

            public CommitResponse writeAtLeastOnceWithOptions(Iterable<Mutation> mutations, Options.TransactionOption ... transactionOptions) throws SpannerException {
                return new CommitResponse(com.google.spanner.v1.CommitResponse.getDefaultInstance());
            }

            public CommitResponse writeWithOptions(Iterable<Mutation> mutations, Options.TransactionOption ... options) throws SpannerException {
                return new CommitResponse(com.google.spanner.v1.CommitResponse.getDefaultInstance());
            }
        };
        ++this.sessionIndex;
        return session;
    }

    SessionImpl buildMockMultiplexedSession(SpannerImpl spanner, final ReadContext context, Timestamp creationTime) {
        HashMap options = new HashMap();
        SessionImpl session = new SessionImpl(spanner, new SessionReference("projects/dummy/instances/dummy/databases/dummy/sessions/session" + this.sessionIndex, creationTime, true, options)){

            public ReadContext singleUse(TimestampBound bound) {
                return context;
            }

            public ApiFuture<Empty> asyncClose() {
                return ApiFutures.immediateFuture((Object)Empty.getDefaultInstance());
            }

            public CommitResponse writeAtLeastOnceWithOptions(Iterable<Mutation> mutations, Options.TransactionOption ... transactionOptions) throws SpannerException {
                return new CommitResponse(com.google.spanner.v1.CommitResponse.getDefaultInstance());
            }

            public CommitResponse writeWithOptions(Iterable<Mutation> mutations, Options.TransactionOption ... options) throws SpannerException {
                return new CommitResponse(com.google.spanner.v1.CommitResponse.getDefaultInstance());
            }
        };
        ++this.sessionIndex;
        return session;
    }

    void runMaintenanceLoop(FakeClock clock, SessionPool pool, long numCycles) {
        int i = 0;
        while ((long)i < numCycles) {
            pool.poolMaintainer.maintainPool();
            clock.currentTimeMillis.addAndGet(pool.poolMaintainer.loopFrequency);
            ++i;
        }
    }

    final class TestExecutorFactory
    implements GrpcTransportOptions.ExecutorFactory<ScheduledExecutorService> {
        TestExecutorFactory() {
        }

        public ScheduledExecutorService get() {
            ScheduledThreadPoolExecutor realExecutor = new ScheduledThreadPoolExecutor(2);
            BaseSessionPoolTest.this.mockExecutor = (ScheduledExecutorService)Mockito.spy((Object)realExecutor);
            ScheduledFuture mockFuture = (ScheduledFuture)Mockito.mock(ScheduledFuture.class);
            ((ScheduledExecutorService)Mockito.doReturn((Object)mockFuture).when((Object)BaseSessionPoolTest.this.mockExecutor)).scheduleAtFixedRate((Runnable)Mockito.any(Runnable.class), Mockito.anyLong(), Mockito.anyLong(), (TimeUnit)((Object)Mockito.any(TimeUnit.class)));
            return BaseSessionPoolTest.this.mockExecutor;
        }

        public void release(ScheduledExecutorService executor) {
            try {
                executor.shutdown();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

