/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.NanoClock;
import com.google.api.gax.retrying.RetrySettings;
import com.google.cloud.Timestamp;
import com.google.cloud.grpc.GrpcTransportOptions;
import com.google.cloud.spanner.BatchClient;
import com.google.cloud.spanner.BatchClientImpl;
import com.google.cloud.spanner.BatchReadOnlyTransaction;
import com.google.cloud.spanner.BatchTransactionId;
import com.google.cloud.spanner.Clock;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.SpannerImpl;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.spi.v1.SpannerRpc;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import com.google.protobuf.util.Timestamps;
import com.google.spanner.v1.BeginTransactionRequest;
import com.google.spanner.v1.Session;
import com.google.spanner.v1.Transaction;
import io.opentelemetry.api.OpenTelemetry;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnit4.class)
public final class BatchClientImplTest {
    private static final String DB_NAME = "projects/my-project/instances/my-instance/databases/my-db";
    private static final String SESSION_NAME = "projects/my-project/instances/my-instance/databases/my-db/sessions/s1";
    private static final ByteString TXN_ID = ByteString.copyFromUtf8((String)"my-txn");
    private static final String TIMESTAMP = "2017-11-15T10:54:20Z";
    private static boolean isMultiplexedSession = false;
    @Mock
    private SpannerRpc gapicRpc;
    @Mock
    private SpannerOptions spannerOptions;
    @Captor
    private ArgumentCaptor<Map<SpannerRpc.Option, Object>> optionsCaptor;
    @Mock
    private BatchTransactionId txnID;
    private BatchClient client;

    @BeforeClass
    public static void setupOpenTelemetry() {
        SpannerOptions.resetActiveTracingFramework();
        SpannerOptions.enableOpenTelemetryTraces();
        Boolean useMultiplexedSessionFromEnvVariablePartitionedOps = SessionPoolOptions.getUseMultiplexedSessionFromEnvVariablePartitionedOps();
        isMultiplexedSession = useMultiplexedSessionFromEnvVariablePartitionedOps != null && useMultiplexedSessionFromEnvVariablePartitionedOps != false;
    }

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        DatabaseId db = DatabaseId.of((String)DB_NAME);
        Mockito.when((Object)this.spannerOptions.getNumChannels()).thenReturn((Object)4);
        Mockito.when((Object)this.spannerOptions.getDatabaseRole()).thenReturn((Object)"role");
        Mockito.when((Object)this.spannerOptions.getPrefetchChunks()).thenReturn((Object)1);
        Mockito.when((Object)this.spannerOptions.getRetrySettings()).thenReturn((Object)RetrySettings.newBuilder().build());
        Mockito.when((Object)this.spannerOptions.getClock()).thenReturn((Object)NanoClock.getDefaultClock());
        Mockito.when((Object)this.spannerOptions.getSpannerRpcV1()).thenReturn((Object)this.gapicRpc);
        Mockito.when((Object)this.spannerOptions.getSessionLabels()).thenReturn(Collections.emptyMap());
        Mockito.when((Object)this.spannerOptions.getOpenTelemetry()).thenReturn((Object)OpenTelemetry.noop());
        GrpcTransportOptions transportOptions = (GrpcTransportOptions)Mockito.mock(GrpcTransportOptions.class);
        Mockito.when((Object)transportOptions.getExecutorFactory()).thenReturn((Object)((GrpcTransportOptions.ExecutorFactory)Mockito.mock(GrpcTransportOptions.ExecutorFactory.class)));
        Mockito.when((Object)this.spannerOptions.getTransportOptions()).thenReturn((Object)transportOptions);
        SessionPoolOptions sessionPoolOptions = (SessionPoolOptions)Mockito.mock(SessionPoolOptions.class);
        Mockito.when((Object)sessionPoolOptions.getPoolMaintainerClock()).thenReturn((Object)Clock.INSTANCE);
        Mockito.when((Object)sessionPoolOptions.getUseMultiplexedSessionPartitionedOps()).thenReturn((Object)isMultiplexedSession);
        Mockito.when((Object)sessionPoolOptions.getMultiplexedSessionMaintenanceDuration()).thenReturn((Object)Duration.ZERO);
        Mockito.when((Object)this.spannerOptions.getSessionPoolOptions()).thenReturn((Object)sessionPoolOptions);
        SpannerImpl spanner = new SpannerImpl(this.gapicRpc, this.spannerOptions);
        this.client = new BatchClientImpl(spanner.getSessionClient(db), isMultiplexedSession);
    }

    @Test
    public void testBatchReadOnlyTxnWithBound() throws Exception {
        Session sessionProto = Session.newBuilder().setName(SESSION_NAME).setMultiplexed(isMultiplexedSession).build();
        if (isMultiplexedSession) {
            Mockito.when((Object)this.gapicRpc.createSession((String)Mockito.eq((Object)DB_NAME), ArgumentMatchers.anyString(), Mockito.anyMap(), (Map)this.optionsCaptor.capture(), Mockito.eq((boolean)isMultiplexedSession))).thenReturn((Object)sessionProto);
        } else {
            Mockito.when((Object)this.gapicRpc.createSession((String)Mockito.eq((Object)DB_NAME), ArgumentMatchers.anyString(), Mockito.anyMap(), (Map)this.optionsCaptor.capture())).thenReturn((Object)sessionProto);
        }
        com.google.protobuf.Timestamp timestamp = Timestamps.parse((String)TIMESTAMP);
        Transaction txnMetadata = Transaction.newBuilder().setId(TXN_ID).setReadTimestamp(timestamp).build();
        Mockito.when((Object)this.gapicRpc.beginTransaction((BeginTransactionRequest)Mockito.any(), (Map)this.optionsCaptor.capture(), Mockito.eq((boolean)false))).thenReturn((Object)txnMetadata);
        BatchReadOnlyTransaction batchTxn = this.client.batchReadOnlyTransaction(TimestampBound.strong());
        Truth.assertThat((String)batchTxn.getBatchTransactionId().getSessionId()).isEqualTo((Object)SESSION_NAME);
        Truth.assertThat((Iterable)batchTxn.getBatchTransactionId().getTransactionId()).isEqualTo((Object)TXN_ID);
        Timestamp t = Timestamp.parseTimestamp((String)TIMESTAMP);
        Truth.assertThat((Comparable)batchTxn.getReadTimestamp()).isEqualTo((Object)t);
        Truth.assertThat((Comparable)batchTxn.getReadTimestamp()).isEqualTo((Object)batchTxn.getBatchTransactionId().getTimestamp());
    }

    @Test
    public void testBatchReadOnlyTxnWithTxnId() {
        Mockito.when((Object)this.txnID.getSessionId()).thenReturn((Object)SESSION_NAME);
        Mockito.when((Object)this.txnID.getTransactionId()).thenReturn((Object)TXN_ID);
        Timestamp t = Timestamp.parseTimestamp((String)TIMESTAMP);
        Mockito.when((Object)this.txnID.getTimestamp()).thenReturn((Object)t);
        BatchReadOnlyTransaction batchTxn = this.client.batchReadOnlyTransaction(this.txnID);
        Truth.assertThat((String)batchTxn.getBatchTransactionId().getSessionId()).isEqualTo((Object)SESSION_NAME);
        Truth.assertThat((Iterable)batchTxn.getBatchTransactionId().getTransactionId()).isEqualTo((Object)TXN_ID);
        Truth.assertThat((Comparable)batchTxn.getReadTimestamp()).isEqualTo((Object)t);
        Truth.assertThat((Comparable)batchTxn.getReadTimestamp()).isEqualTo((Object)batchTxn.getBatchTransactionId().getTimestamp());
    }

    @Test
    public void testGetDatabaseRole() {
        Assert.assertEquals((Object)this.client.getDatabaseRole(), (Object)"role");
    }
}

