/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.MockSpannerTestUtil;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.SlowTest;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerOptions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.inprocess.InProcessServerBuilder;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@Category(value={SlowTest.class})
@RunWith(value=JUnit4.class)
public class BatchCreateSessionsSlowTest {
    private static final String TEST_PROJECT = "my-project";
    private static final String TEST_DATABASE_ROLE = "my-role";
    private static MockSpannerServiceImpl mockSpanner;
    private static Server server;
    private static LocalChannelProvider channelProvider;
    private Spanner spanner;

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockSpanner = new MockSpannerServiceImpl();
        mockSpanner.setAbortProbability(0.0);
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(MockSpannerTestUtil.SELECT1, MockSpannerTestUtil.SELECT1_RESULTSET));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(MockSpannerTestUtil.READ_ONE_KEY_VALUE_STATEMENT, MockSpannerTestUtil.READ_ONE_KEY_VALUE_RESULTSET));
        String uniqueName = InProcessServerBuilder.generateName();
        server = ((InProcessServerBuilder)InProcessServerBuilder.forName((String)uniqueName).scheduledExecutorService((ScheduledExecutorService)new ScheduledThreadPoolExecutor(1)).addService((BindableService)mockSpanner)).build().start();
        channelProvider = LocalChannelProvider.create((String)uniqueName);
    }

    @AfterClass
    public static void stopServer() throws InterruptedException {
        server.shutdown();
        server.awaitTermination();
    }

    @Before
    public void setUp() {
        SessionPoolOptions sessionPoolOptions = SessionPoolOptions.newBuilder().setFailOnSessionLeak().build();
        this.spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(TEST_PROJECT)).setDatabaseRole(TEST_DATABASE_ROLE).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).setSessionPoolOption(sessionPoolOptions).build().getService();
        Assume.assumeFalse((boolean)sessionPoolOptions.getUseMultiplexedSession());
    }

    @After
    public void tearDown() {
        mockSpanner.unfreeze();
        this.spanner.close();
        mockSpanner.reset();
        mockSpanner.removeAllExecutionTimes();
    }

    @Test
    public void testBatchCreateSessionsTimesOut_whenDeadlineExceeded() throws Exception {
        mockSpanner.setBatchCreateSessionsExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(1000, 0));
        SpannerOptions.Builder builder = (SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(TEST_PROJECT)).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance());
        builder.getSpannerStubSettingsBuilder().batchCreateSessionsSettings().setSimpleTimeoutNoRetriesDuration(Duration.ofMillis(100L));
        try (Spanner spanner = (Spanner)builder.build().getService();){
            DatabaseId databaseId = DatabaseId.of((String)TEST_PROJECT, (String)"my-instance", (String)"my-database");
            DatabaseClient client = spanner.getDatabaseClient(databaseId);
            ListeningExecutorService service = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(1000));
            ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>(5000);
            AtomicInteger counter = new AtomicInteger();
            int i = 0;
            while (i < 5000) {
                int index = i++;
                futures.add(service.submit(() -> {
                    ResultSet rs = client.singleUse().executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);
                    SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> ((ResultSet)rs).next());
                    Assert.assertEquals((Object)ErrorCode.DEADLINE_EXCEEDED, (Object)e.getErrorCode());
                    System.out.printf("finished test %d\n", counter.incrementAndGet());
                    return null;
                }));
            }
            service.shutdown();
            Assert.assertEquals((long)5000L, (long)((List)Futures.allAsList(futures).get()).size());
        }
    }

    @Test
    public void testBatchCreateSessionsTimesOut_whenResourceExhausted() throws Exception {
        mockSpanner.setBatchCreateSessionsExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(2000, 0));
        SessionPoolOptions sessionPoolOptions = SessionPoolOptions.newBuilder().setAcquireSessionTimeoutDuration(Duration.ofMillis(60L)).build();
        SpannerOptions.Builder builder = ((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(TEST_PROJECT)).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).setSessionPoolOption(sessionPoolOptions);
        builder.getSpannerStubSettingsBuilder().batchCreateSessionsSettings().setSimpleTimeoutNoRetriesDuration(Duration.ofMillis(1000L));
        try (Spanner spanner = (Spanner)builder.build().getService();){
            DatabaseId databaseId = DatabaseId.of((String)TEST_PROJECT, (String)"my-instance", (String)"my-database");
            DatabaseClient client = spanner.getDatabaseClient(databaseId);
            ListeningExecutorService service = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(1000));
            ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>(5000);
            AtomicInteger counter = new AtomicInteger();
            for (int i = 0; i < 5000; ++i) {
                futures.add(service.submit(() -> {
                    ResultSet rs = client.singleUse().executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);
                    SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> ((ResultSet)rs).next());
                    Assert.assertEquals((Object)ErrorCode.RESOURCE_EXHAUSTED, (Object)e.getErrorCode());
                    System.out.printf("finished test %d\n", counter.incrementAndGet());
                    return null;
                }));
            }
            service.shutdown();
            Assert.assertEquals((long)5000L, (long)((List)Futures.allAsList(futures).get()).size());
        }
    }
}

