/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.tracing.ApiTracer;
import com.google.api.gax.tracing.MetricsTracer;
import com.google.cloud.spanner.CompositeTracer;
import com.google.cloud.spanner.OpenTelemetryApiTracer;
import com.google.common.collect.ImmutableList;
import com.google.spanner.v1.ReadRequest;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class CompositeTracerTest {
    @Rule
    public final MockitoRule mockitoRule = MockitoJUnit.rule();
    @Mock
    private ApiTracer child1;
    @Mock
    private ApiTracer child2;
    @Mock
    private OpenTelemetryApiTracer child3;
    @Mock
    private MetricsTracer child4;
    private CompositeTracer compositeTracer;

    @Before
    public void setup() {
        this.compositeTracer = new CompositeTracer((List)ImmutableList.of((Object)this.child1, (Object)this.child2, (Object)this.child3, (Object)this.child4));
    }

    @Test
    public void testInScope() {
        ApiTracer.Scope scope1 = (ApiTracer.Scope)Mockito.mock(ApiTracer.Scope.class);
        Mockito.when((Object)this.child1.inScope()).thenReturn((Object)scope1);
        ApiTracer.Scope scope2 = (ApiTracer.Scope)Mockito.mock(ApiTracer.Scope.class);
        Mockito.when((Object)this.child2.inScope()).thenReturn((Object)scope2);
        ApiTracer.Scope scope3 = (ApiTracer.Scope)Mockito.mock(ApiTracer.Scope.class);
        Mockito.when((Object)this.child3.inScope()).thenReturn((Object)scope3);
        ApiTracer.Scope scope4 = (ApiTracer.Scope)Mockito.mock(ApiTracer.Scope.class);
        Mockito.when((Object)this.child4.inScope()).thenReturn((Object)scope4);
        ApiTracer.Scope parentScope = this.compositeTracer.inScope();
        parentScope.close();
        ((ApiTracer.Scope)Mockito.verify((Object)scope1, (VerificationMode)Mockito.times((int)1))).close();
        ((ApiTracer.Scope)Mockito.verify((Object)scope2, (VerificationMode)Mockito.times((int)1))).close();
        ((ApiTracer.Scope)Mockito.verify((Object)scope3, (VerificationMode)Mockito.times((int)1))).close();
        ((ApiTracer.Scope)Mockito.verify((Object)scope4, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void testOperationSucceeded() {
        this.compositeTracer.operationSucceeded();
        ((ApiTracer)Mockito.verify((Object)this.child1, (VerificationMode)Mockito.times((int)1))).operationSucceeded();
        ((ApiTracer)Mockito.verify((Object)this.child2, (VerificationMode)Mockito.times((int)1))).operationSucceeded();
        ((OpenTelemetryApiTracer)Mockito.verify((Object)this.child3, (VerificationMode)Mockito.times((int)1))).operationSucceeded();
        ((MetricsTracer)Mockito.verify((Object)this.child4, (VerificationMode)Mockito.times((int)1))).operationSucceeded();
    }

    @Test
    public void testOperationCancelled() {
        this.compositeTracer.operationCancelled();
        ((ApiTracer)Mockito.verify((Object)this.child1, (VerificationMode)Mockito.times((int)1))).operationCancelled();
        ((ApiTracer)Mockito.verify((Object)this.child2, (VerificationMode)Mockito.times((int)1))).operationCancelled();
        ((OpenTelemetryApiTracer)Mockito.verify((Object)this.child3, (VerificationMode)Mockito.times((int)1))).operationCancelled();
        ((MetricsTracer)Mockito.verify((Object)this.child4, (VerificationMode)Mockito.times((int)1))).operationCancelled();
    }

    @Test
    public void testOperationFailed() {
        RuntimeException error = new RuntimeException();
        this.compositeTracer.operationFailed((Throwable)error);
        ((ApiTracer)Mockito.verify((Object)this.child1, (VerificationMode)Mockito.times((int)1))).operationFailed((Throwable)error);
        ((ApiTracer)Mockito.verify((Object)this.child2, (VerificationMode)Mockito.times((int)1))).operationFailed((Throwable)error);
        ((OpenTelemetryApiTracer)Mockito.verify((Object)this.child3, (VerificationMode)Mockito.times((int)1))).operationFailed((Throwable)error);
        ((MetricsTracer)Mockito.verify((Object)this.child4, (VerificationMode)Mockito.times((int)1))).operationFailed((Throwable)error);
    }

    @Test
    public void testConnectionSelected() {
        this.compositeTracer.connectionSelected("connection-one");
        ((ApiTracer)Mockito.verify((Object)this.child1, (VerificationMode)Mockito.times((int)1))).connectionSelected("connection-one");
        ((ApiTracer)Mockito.verify((Object)this.child2, (VerificationMode)Mockito.times((int)1))).connectionSelected("connection-one");
        ((OpenTelemetryApiTracer)Mockito.verify((Object)this.child3, (VerificationMode)Mockito.times((int)1))).connectionSelected("connection-one");
        ((MetricsTracer)Mockito.verify((Object)this.child4, (VerificationMode)Mockito.times((int)1))).connectionSelected("connection-one");
    }

    @Test
    public void testAttemptStarted() {
        ReadRequest request = ReadRequest.getDefaultInstance();
        this.compositeTracer.attemptStarted((Object)request, 3);
        ((ApiTracer)Mockito.verify((Object)this.child1, (VerificationMode)Mockito.times((int)1))).attemptStarted((Object)request, 3);
        ((ApiTracer)Mockito.verify((Object)this.child2, (VerificationMode)Mockito.times((int)1))).attemptStarted((Object)request, 3);
        ((OpenTelemetryApiTracer)Mockito.verify((Object)this.child3, (VerificationMode)Mockito.times((int)1))).attemptStarted((Object)request, 3);
        ((MetricsTracer)Mockito.verify((Object)this.child4, (VerificationMode)Mockito.times((int)1))).attemptStarted((Object)request, 3);
    }

    @Test
    public void testAttemptSucceeded() {
        this.compositeTracer.attemptSucceeded();
        ((ApiTracer)Mockito.verify((Object)this.child1, (VerificationMode)Mockito.times((int)1))).attemptSucceeded();
        ((ApiTracer)Mockito.verify((Object)this.child2, (VerificationMode)Mockito.times((int)1))).attemptSucceeded();
        ((OpenTelemetryApiTracer)Mockito.verify((Object)this.child3, (VerificationMode)Mockito.times((int)1))).attemptSucceeded();
        ((MetricsTracer)Mockito.verify((Object)this.child4, (VerificationMode)Mockito.times((int)1))).attemptSucceeded();
    }

    @Test
    public void testAttemptCancelled() {
        this.compositeTracer.attemptCancelled();
        ((ApiTracer)Mockito.verify((Object)this.child1, (VerificationMode)Mockito.times((int)1))).attemptCancelled();
        ((ApiTracer)Mockito.verify((Object)this.child2, (VerificationMode)Mockito.times((int)1))).attemptCancelled();
        ((OpenTelemetryApiTracer)Mockito.verify((Object)this.child3, (VerificationMode)Mockito.times((int)1))).attemptCancelled();
        ((MetricsTracer)Mockito.verify((Object)this.child4, (VerificationMode)Mockito.times((int)1))).attemptCancelled();
    }

    @Test
    public void testAttemptFailed() {
        RuntimeException error = new RuntimeException();
        Duration delay = Duration.ofMillis(10L);
        this.compositeTracer.attemptFailedDuration((Throwable)error, delay);
        ((ApiTracer)Mockito.verify((Object)this.child1, (VerificationMode)Mockito.times((int)1))).attemptFailedDuration((Throwable)error, delay);
        ((ApiTracer)Mockito.verify((Object)this.child2, (VerificationMode)Mockito.times((int)1))).attemptFailedDuration((Throwable)error, delay);
        ((OpenTelemetryApiTracer)Mockito.verify((Object)this.child3, (VerificationMode)Mockito.times((int)1))).attemptFailedDuration((Throwable)error, delay);
        ((MetricsTracer)Mockito.verify((Object)this.child4, (VerificationMode)Mockito.times((int)1))).attemptFailedDuration((Throwable)error, delay);
    }

    @Test
    public void testAttemptFailedRetriesExhausted() {
        RuntimeException error = new RuntimeException();
        this.compositeTracer.attemptFailedRetriesExhausted((Throwable)error);
        ((ApiTracer)Mockito.verify((Object)this.child1, (VerificationMode)Mockito.times((int)1))).attemptFailedRetriesExhausted((Throwable)error);
        ((ApiTracer)Mockito.verify((Object)this.child2, (VerificationMode)Mockito.times((int)1))).attemptFailedRetriesExhausted((Throwable)error);
        ((OpenTelemetryApiTracer)Mockito.verify((Object)this.child3, (VerificationMode)Mockito.times((int)1))).attemptFailedRetriesExhausted((Throwable)error);
        ((MetricsTracer)Mockito.verify((Object)this.child4, (VerificationMode)Mockito.times((int)1))).attemptFailedRetriesExhausted((Throwable)error);
    }

    @Test
    public void testAttemptPermanentFailure() {
        RuntimeException error = new RuntimeException();
        this.compositeTracer.attemptPermanentFailure((Throwable)error);
        ((ApiTracer)Mockito.verify((Object)this.child1, (VerificationMode)Mockito.times((int)1))).attemptPermanentFailure((Throwable)error);
        ((ApiTracer)Mockito.verify((Object)this.child2, (VerificationMode)Mockito.times((int)1))).attemptPermanentFailure((Throwable)error);
        ((OpenTelemetryApiTracer)Mockito.verify((Object)this.child3, (VerificationMode)Mockito.times((int)1))).attemptPermanentFailure((Throwable)error);
        ((MetricsTracer)Mockito.verify((Object)this.child4, (VerificationMode)Mockito.times((int)1))).attemptPermanentFailure((Throwable)error);
    }

    @Test
    public void testLroStartFailed() {
        RuntimeException error = new RuntimeException();
        this.compositeTracer.lroStartFailed((Throwable)error);
        ((ApiTracer)Mockito.verify((Object)this.child1, (VerificationMode)Mockito.times((int)1))).lroStartFailed((Throwable)error);
        ((ApiTracer)Mockito.verify((Object)this.child2, (VerificationMode)Mockito.times((int)1))).lroStartFailed((Throwable)error);
        ((OpenTelemetryApiTracer)Mockito.verify((Object)this.child3, (VerificationMode)Mockito.times((int)1))).lroStartFailed((Throwable)error);
        ((MetricsTracer)Mockito.verify((Object)this.child4, (VerificationMode)Mockito.times((int)1))).lroStartFailed((Throwable)error);
    }

    @Test
    public void testLroStartSucceeded() {
        this.compositeTracer.lroStartSucceeded();
        ((ApiTracer)Mockito.verify((Object)this.child1, (VerificationMode)Mockito.times((int)1))).lroStartSucceeded();
        ((ApiTracer)Mockito.verify((Object)this.child2, (VerificationMode)Mockito.times((int)1))).lroStartSucceeded();
        ((OpenTelemetryApiTracer)Mockito.verify((Object)this.child3, (VerificationMode)Mockito.times((int)1))).lroStartSucceeded();
        ((MetricsTracer)Mockito.verify((Object)this.child4, (VerificationMode)Mockito.times((int)1))).lroStartSucceeded();
    }

    @Test
    public void testResponseReceived() {
        this.compositeTracer.responseReceived();
        ((ApiTracer)Mockito.verify((Object)this.child1, (VerificationMode)Mockito.times((int)1))).responseReceived();
        ((ApiTracer)Mockito.verify((Object)this.child2, (VerificationMode)Mockito.times((int)1))).responseReceived();
        ((OpenTelemetryApiTracer)Mockito.verify((Object)this.child3, (VerificationMode)Mockito.times((int)1))).responseReceived();
        ((MetricsTracer)Mockito.verify((Object)this.child4, (VerificationMode)Mockito.times((int)1))).responseReceived();
    }

    @Test
    public void testRequestSent() {
        this.compositeTracer.requestSent();
        ((ApiTracer)Mockito.verify((Object)this.child1, (VerificationMode)Mockito.times((int)1))).requestSent();
        ((ApiTracer)Mockito.verify((Object)this.child2, (VerificationMode)Mockito.times((int)1))).requestSent();
        ((OpenTelemetryApiTracer)Mockito.verify((Object)this.child3, (VerificationMode)Mockito.times((int)1))).requestSent();
        ((MetricsTracer)Mockito.verify((Object)this.child4, (VerificationMode)Mockito.times((int)1))).requestSent();
    }

    @Test
    public void testBatchRequestSent() {
        this.compositeTracer.batchRequestSent(2L, 20L);
        ((ApiTracer)Mockito.verify((Object)this.child1, (VerificationMode)Mockito.times((int)1))).batchRequestSent(2L, 20L);
        ((ApiTracer)Mockito.verify((Object)this.child2, (VerificationMode)Mockito.times((int)1))).batchRequestSent(2L, 20L);
        ((OpenTelemetryApiTracer)Mockito.verify((Object)this.child3, (VerificationMode)Mockito.times((int)1))).batchRequestSent(2L, 20L);
        ((MetricsTracer)Mockito.verify((Object)this.child4, (VerificationMode)Mockito.times((int)1))).batchRequestSent(2L, 20L);
    }

    @Test
    public void testMethodsOverrideMetricsTracer() {
        Method[] metricsTracerMethods = MetricsTracer.class.getDeclaredMethods();
        Method[] compositeTracerMethods = CompositeTracer.class.getDeclaredMethods();
        List<String> visibleForTestingMethods = Arrays.asList("getAttributes", "extractStatus");
        HashSet<Method> compositeMethodsSet = new HashSet<Method>(Arrays.asList(compositeTracerMethods));
        for (Method metricsMethod : metricsTracerMethods) {
            if (!visibleForTestingMethods.contains(metricsMethod.getName()) && !this.containsMethod(compositeMethodsSet, metricsMethod)) {
                throw new AssertionError((Object)("Method not found in compositeTracerMethods: " + metricsMethod));
            }
        }
    }

    @Test
    public void testMethodsOverrideOpenTelemetryTracer() {
        Method[] compositeTracerMethods = CompositeTracer.class.getDeclaredMethods();
        List openTelemetryTracerMethods = Arrays.stream(OpenTelemetryApiTracer.class.getDeclaredMethods()).filter(method -> Modifier.isPublic(method.getModifiers())).collect(Collectors.toList());
        HashSet<Method> compositeMethodsSet = new HashSet<Method>(Arrays.asList(compositeTracerMethods));
        for (Method metricsMethod : openTelemetryTracerMethods) {
            if (!this.containsMethod(compositeMethodsSet, metricsMethod)) {
                throw new AssertionError((Object)("Method not found in compositeTracerMethods: " + metricsMethod));
            }
        }
    }

    private boolean compareMethods(Method actual, Method expected) {
        return actual.getName().equals(expected.getName()) && Arrays.equals(actual.getParameterTypes(), expected.getParameterTypes()) && actual.getModifiers() == expected.getModifiers() && actual.getReturnType().equals(expected.getReturnType());
    }

    public boolean containsMethod(Set<Method> methodSet, Method method) {
        for (Method m : methodSet) {
            if (!this.compareMethods(m, method)) continue;
            return true;
        }
        return false;
    }
}

