/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ServerStream;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.cloud.ByteArray;
import com.google.cloud.NoCredentials;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.AsyncResultSet;
import com.google.cloud.spanner.AsyncRunner;
import com.google.cloud.spanner.AsyncTransactionManager;
import com.google.cloud.spanner.BatchClient;
import com.google.cloud.spanner.BatchReadOnlyTransaction;
import com.google.cloud.spanner.Clock;
import com.google.cloud.spanner.CommitResponse;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseClientImpl;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.FakeClock;
import com.google.cloud.spanner.GrpcStreamIterator;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.MockSpannerTestUtil;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.MutationGroup;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.Partition;
import com.google.cloud.spanner.PartitionOptions;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SessionPool;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.SingerProto;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerApiFutures;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactoryTest;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.TraceWrapper;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionManager;
import com.google.cloud.spanner.TransactionRunner;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.Value;
import com.google.cloud.spanner.connection.RandomResultSetGenerator;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.BaseEncoding;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.SettableFuture;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.ByteString;
import com.google.protobuf.Duration;
import com.google.protobuf.ListValue;
import com.google.protobuf.MessageLite;
import com.google.protobuf.NullValue;
import com.google.rpc.RetryInfo;
import com.google.spanner.v1.BatchWriteRequest;
import com.google.spanner.v1.BatchWriteResponse;
import com.google.spanner.v1.BeginTransactionRequest;
import com.google.spanner.v1.CommitRequest;
import com.google.spanner.v1.CreateSessionRequest;
import com.google.spanner.v1.DeleteSessionRequest;
import com.google.spanner.v1.DirectedReadOptions;
import com.google.spanner.v1.ExecuteBatchDmlRequest;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.ReadRequest;
import com.google.spanner.v1.RequestOptions;
import com.google.spanner.v1.ResultSetMetadata;
import com.google.spanner.v1.ResultSetStats;
import com.google.spanner.v1.StructType;
import com.google.spanner.v1.Type;
import com.google.spanner.v1.TypeAnnotationCode;
import com.google.spanner.v1.TypeCode;
import io.grpc.BindableService;
import io.grpc.Context;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Server;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.inprocess.InProcessServerBuilder;
import io.grpc.protobuf.lite.ProtoLiteUtils;
import io.opencensus.trace.Tracing;
import io.opentelemetry.api.OpenTelemetry;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class DatabaseClientImplTest {
    private static final String TEST_PROJECT = "my-project";
    private static final String TEST_INSTANCE = "my-instance";
    private static final String TEST_DATABASE = "my-database";
    private static final String TEST_DATABASE_ROLE = "my-role";
    private static final String INSTANCE_NAME = String.format("projects/%s/instances/%s", "my-project", "my-instance");
    private static final String DATABASE_NAME = String.format("projects/%s/instances/%s/databases/%s", "my-project", "my-instance", "my-database");
    private static MockSpannerServiceImpl mockSpanner;
    private static Server server;
    private static LocalChannelProvider channelProvider;
    private static final Statement UPDATE_STATEMENT;
    private static final Statement INVALID_UPDATE_STATEMENT;
    private static final long UPDATE_COUNT = 1L;
    private static final com.google.rpc.Status STATUS_OK;
    private static final Iterable<MutationGroup> MUTATION_GROUPS;
    private static final Iterable<BatchWriteResponse> BATCH_WRITE_RESPONSES;
    private static final DirectedReadOptions DIRECTED_READ_OPTIONS1;
    private static final DirectedReadOptions DIRECTED_READ_OPTIONS2;
    private Spanner spanner;
    private Spanner spannerWithEmptySessionPool;
    private static ExecutorService executor;

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockSpanner = new MockSpannerServiceImpl();
        mockSpanner.setAbortProbability(0.0);
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(UPDATE_STATEMENT, 1L));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(MockSpannerTestUtil.SELECT1, MockSpannerTestUtil.SELECT1_RESULTSET));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(MockSpannerTestUtil.READ_ONE_KEY_VALUE_STATEMENT, MockSpannerTestUtil.READ_ONE_KEY_VALUE_RESULTSET));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.exception(INVALID_UPDATE_STATEMENT, Status.INVALID_ARGUMENT.withDescription("invalid statement").asRuntimeException()));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(MockSpannerTestUtil.SELECT1_FROM_TABLE, MockSpannerTestUtil.SELECT1_RESULTSET));
        mockSpanner.setBatchWriteResult(BATCH_WRITE_RESPONSES);
        executor = Executors.newSingleThreadExecutor();
        String uniqueName = InProcessServerBuilder.generateName();
        server = ((InProcessServerBuilder)InProcessServerBuilder.forName((String)uniqueName).scheduledExecutorService((ScheduledExecutorService)new ScheduledThreadPoolExecutor(1)).addService((BindableService)mockSpanner)).build().start();
        channelProvider = LocalChannelProvider.create((String)uniqueName);
    }

    @AfterClass
    public static void stopServer() throws InterruptedException {
        server.shutdown();
        server.awaitTermination();
        executor.shutdown();
    }

    @Before
    public void setUp() {
        this.spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(TEST_PROJECT)).setDatabaseRole(TEST_DATABASE_ROLE).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).setSessionPoolOption(SessionPoolOptions.newBuilder().setFailOnSessionLeak().build()).build().getService();
        this.spannerWithEmptySessionPool = (Spanner)((SpannerOptions)this.spanner.getOptions()).toBuilder().setSessionPoolOption(SessionPoolOptions.newBuilder().setMinSessions(0).setFailOnSessionLeak().build()).build().getService();
    }

    @After
    public void tearDown() {
        mockSpanner.unfreeze();
        this.spanner.close();
        this.spannerWithEmptySessionPool.close();
        mockSpanner.reset();
        mockSpanner.removeAllExecutionTimes();
    }

    @Test
    public void testPoolMaintainer_whenInactiveTransactionAndSessionIsNotFoundOnBackend_removeSessionsFromPool() {
        Assume.assumeFalse((String)"Session pool maintainer test skipped for multiplexed sessions", (boolean)this.isMultiplexedSessionsEnabledForRW());
        FakeClock poolMaintainerClock = new FakeClock();
        SessionPoolOptions.InactiveTransactionRemovalOptions inactiveTransactionRemovalOptions = SessionPoolOptions.InactiveTransactionRemovalOptions.newBuilder().setIdleTimeThreshold(java.time.Duration.ofSeconds(2L)).setActionOnInactiveTransaction(SessionPoolOptions.ActionOnInactiveTransaction.CLOSE).setExecutionFrequency(java.time.Duration.ofSeconds(1L)).build();
        SessionPoolOptions sessionPoolOptions = SessionPoolOptions.newBuilder().setMinSessions(1).setMaxSessions(1).setInactiveTransactionRemovalOptions(inactiveTransactionRemovalOptions).setLoopFrequency(1000L).setPoolMaintainerClock((Clock)poolMaintainerClock).build();
        try (Spanner spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(TEST_PROJECT)).setDatabaseRole(TEST_DATABASE_ROLE).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).setSessionPoolOption(sessionPoolOptions).build().getService();){
            DatabaseClientImpl client = (DatabaseClientImpl)spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
            Instant initialExecutionTime = client.pool.poolMaintainer.lastExecutionTime;
            poolMaintainerClock.currentTimeMillis.addAndGet(java.time.Duration.ofMinutes(3L).toMillis());
            try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[0]);){
                TransactionContext transaction = manager.begin();
                mockSpanner.setCommitExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)mockSpanner.createSessionNotFoundException("TEST_SESSION_NAME")));
                while (true) {
                    try {
                        transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]);
                        poolMaintainerClock.currentTimeMillis.addAndGet(java.time.Duration.ofMinutes(3L).toMillis());
                        client.pool.poolMaintainer.maintainPool();
                        manager.commit();
                        Assert.assertNotNull((Object)manager.getCommitTimestamp());
                    }
                    catch (AbortedException e) {
                        transaction = manager.resetForRetry();
                        mockSpanner.setCommitExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(0, 0));
                        continue;
                    }
                    break;
                }
            }
            Instant endExecutionTime = client.pool.poolMaintainer.lastExecutionTime;
            Assert.assertNotEquals((Object)endExecutionTime, (Object)initialExecutionTime);
            Assert.assertEquals((long)2L, (long)client.pool.numLeakedSessionsRemoved());
            Assert.assertTrue((client.pool.getNumberOfSessionsInPool() <= client.pool.totalSessions() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testPoolMaintainer_whenInactiveTransactionAndSessionExistsOnBackend_removeSessionsFromPool() {
        Assume.assumeFalse((String)"Session leaks tests are skipped for multiplexed sessions", (boolean)this.isMultiplexedSessionsEnabledForRW());
        FakeClock poolMaintainerClock = new FakeClock();
        SessionPoolOptions.InactiveTransactionRemovalOptions inactiveTransactionRemovalOptions = SessionPoolOptions.InactiveTransactionRemovalOptions.newBuilder().setIdleTimeThreshold(java.time.Duration.ofSeconds(2L)).setActionOnInactiveTransaction(SessionPoolOptions.ActionOnInactiveTransaction.CLOSE).setExecutionFrequency(java.time.Duration.ofSeconds(1L)).build();
        SessionPoolOptions sessionPoolOptions = SessionPoolOptions.newBuilder().setMinSessions(1).setMaxSessions(1).setInactiveTransactionRemovalOptions(inactiveTransactionRemovalOptions).setLoopFrequency(1000L).setPoolMaintainerClock((Clock)poolMaintainerClock).build();
        try (Spanner spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(TEST_PROJECT)).setDatabaseRole(TEST_DATABASE_ROLE).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).setSessionPoolOption(sessionPoolOptions).build().getService();){
            DatabaseClientImpl client = (DatabaseClientImpl)spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
            Instant initialExecutionTime = client.pool.poolMaintainer.lastExecutionTime;
            poolMaintainerClock.currentTimeMillis.addAndGet(java.time.Duration.ofMinutes(3L).toMillis());
            try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[0]);){
                TransactionContext transaction = manager.begin();
                while (true) {
                    try {
                        transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]);
                        poolMaintainerClock.currentTimeMillis.addAndGet(java.time.Duration.ofMinutes(3L).toMillis());
                        client.pool.poolMaintainer.maintainPool();
                        manager.commit();
                        Assert.assertNotNull((Object)manager.getCommitTimestamp());
                    }
                    catch (AbortedException e) {
                        transaction = manager.resetForRetry();
                        continue;
                    }
                    break;
                }
            }
            Instant endExecutionTime = client.pool.poolMaintainer.lastExecutionTime;
            Assert.assertNotEquals((Object)endExecutionTime, (Object)initialExecutionTime);
            Assert.assertEquals((long)1L, (long)client.pool.numLeakedSessionsRemoved());
            Assert.assertTrue((client.pool.getNumberOfSessionsInPool() <= client.pool.totalSessions() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testPoolMaintainer_whenLongRunningPartitionedUpdateRequest_takeNoAction() {
        FakeClock poolMaintainerClock = new FakeClock();
        SessionPoolOptions.InactiveTransactionRemovalOptions inactiveTransactionRemovalOptions = SessionPoolOptions.InactiveTransactionRemovalOptions.newBuilder().setIdleTimeThreshold(java.time.Duration.ofSeconds(2L)).setActionOnInactiveTransaction(SessionPoolOptions.ActionOnInactiveTransaction.CLOSE).setExecutionFrequency(java.time.Duration.ofSeconds(1L)).build();
        SessionPoolOptions sessionPoolOptions = SessionPoolOptions.newBuilder().setMinSessions(1).setMaxSessions(1).setInactiveTransactionRemovalOptions(inactiveTransactionRemovalOptions).setLoopFrequency(1000L).setPoolMaintainerClock((Clock)poolMaintainerClock).build();
        try (Spanner spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(TEST_PROJECT)).setDatabaseRole(TEST_DATABASE_ROLE).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).setSessionPoolOption(sessionPoolOptions).build().getService();){
            DatabaseClientImpl client = (DatabaseClientImpl)spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
            Instant initialExecutionTime = client.pool.poolMaintainer.lastExecutionTime;
            poolMaintainerClock.currentTimeMillis.addAndGet(java.time.Duration.ofMinutes(3L).toMillis());
            client.executePartitionedUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]);
            poolMaintainerClock.currentTimeMillis.addAndGet(java.time.Duration.ofMinutes(3L).toMillis());
            client.pool.poolMaintainer.maintainPool();
            Instant endExecutionTime = client.pool.poolMaintainer.lastExecutionTime;
            Assert.assertNotEquals((Object)endExecutionTime, (Object)initialExecutionTime);
            Assert.assertEquals((long)0L, (long)client.pool.numLeakedSessionsRemoved());
            Assert.assertTrue((client.pool.getNumberOfSessionsInPool() <= client.pool.totalSessions() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testPoolMaintainer_whenPDMLFollowedByInactiveTransaction_removeSessionsFromPool() {
        Assume.assumeFalse((String)"Session leaks tests are skipped for multiplexed sessions", (boolean)this.isMultiplexedSessionsEnabledForRW());
        FakeClock poolMaintainerClock = new FakeClock();
        SessionPoolOptions.InactiveTransactionRemovalOptions inactiveTransactionRemovalOptions = SessionPoolOptions.InactiveTransactionRemovalOptions.newBuilder().setIdleTimeThreshold(java.time.Duration.ofSeconds(2L)).setActionOnInactiveTransaction(SessionPoolOptions.ActionOnInactiveTransaction.CLOSE).setExecutionFrequency(java.time.Duration.ofSeconds(1L)).build();
        SessionPoolOptions sessionPoolOptions = SessionPoolOptions.newBuilder().setMinSessions(1).setMaxSessions(1).setInactiveTransactionRemovalOptions(inactiveTransactionRemovalOptions).setLoopFrequency(1000L).setPoolMaintainerClock((Clock)poolMaintainerClock).build();
        try (Spanner spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(TEST_PROJECT)).setDatabaseRole(TEST_DATABASE_ROLE).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).setSessionPoolOption(sessionPoolOptions).build().getService();){
            DatabaseClientImpl client = (DatabaseClientImpl)spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
            Instant initialExecutionTime = client.pool.poolMaintainer.lastExecutionTime;
            poolMaintainerClock.currentTimeMillis.addAndGet(java.time.Duration.ofMinutes(3L).toMillis());
            client.executePartitionedUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]);
            poolMaintainerClock.currentTimeMillis.addAndGet(java.time.Duration.ofMinutes(3L).toMillis());
            client.pool.poolMaintainer.maintainPool();
            Instant endExecutionTime = client.pool.poolMaintainer.lastExecutionTime;
            Assert.assertNotEquals((Object)endExecutionTime, (Object)initialExecutionTime);
            Assert.assertEquals((long)0L, (long)client.pool.numLeakedSessionsRemoved());
            Assert.assertTrue((client.pool.getNumberOfSessionsInPool() <= client.pool.totalSessions() ? 1 : 0) != 0);
            poolMaintainerClock.currentTimeMillis.addAndGet(java.time.Duration.ofMinutes(3L).toMillis());
            try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[0]);){
                TransactionContext transaction = manager.begin();
                while (true) {
                    try {
                        transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]);
                        poolMaintainerClock.currentTimeMillis.addAndGet(java.time.Duration.ofMinutes(3L).toMillis());
                        client.pool.poolMaintainer.maintainPool();
                        manager.commit();
                        Assert.assertNotNull((Object)manager.getCommitTimestamp());
                    }
                    catch (AbortedException e) {
                        transaction = manager.resetForRetry();
                        continue;
                    }
                    break;
                }
            }
            endExecutionTime = client.pool.poolMaintainer.lastExecutionTime;
            Assert.assertNotEquals((Object)endExecutionTime, (Object)initialExecutionTime);
            Assert.assertEquals((long)1L, (long)client.pool.numLeakedSessionsRemoved());
            Assert.assertTrue((client.pool.getNumberOfSessionsInPool() <= client.pool.totalSessions() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testPoolMaintainer_whenLongRunningReadsUsingTransactionRunner_retainSessionForTransaction() throws Exception {
        FakeClock poolMaintainerClock = new FakeClock();
        SessionPoolOptions.InactiveTransactionRemovalOptions inactiveTransactionRemovalOptions = SessionPoolOptions.InactiveTransactionRemovalOptions.newBuilder().setIdleTimeThreshold(java.time.Duration.ofSeconds(3L)).setActionOnInactiveTransaction(SessionPoolOptions.ActionOnInactiveTransaction.CLOSE).setExecutionFrequency(java.time.Duration.ofSeconds(1L)).build();
        SessionPoolOptions sessionPoolOptions = SessionPoolOptions.newBuilder().setMinSessions(1).setMaxSessions(1).setInactiveTransactionRemovalOptions(inactiveTransactionRemovalOptions).setLoopFrequency(1000L).setPoolMaintainerClock((Clock)poolMaintainerClock).build();
        try (Spanner spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(TEST_PROJECT)).setDatabaseRole(TEST_DATABASE_ROLE).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).setSessionPoolOption(sessionPoolOptions).build().getService();){
            DatabaseClientImpl client = (DatabaseClientImpl)spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
            Instant initialExecutionTime = client.pool.poolMaintainer.lastExecutionTime;
            TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
            runner.run(transaction -> {
                try (ResultSet resultSet = transaction.read("TestTable", KeySet.singleKey((Key)Key.of((Object[])new Object[]{1L})), MockSpannerTestUtil.READ_COLUMN_NAMES, new Options.ReadOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.HIGH)});){
                    this.consumeResults(resultSet);
                }
                poolMaintainerClock.currentTimeMillis.addAndGet(java.time.Duration.ofMillis(1050L).toMillis());
                resultSet = transaction.read("TestTable", KeySet.singleKey((Key)Key.of((Object[])new Object[]{1L})), MockSpannerTestUtil.READ_COLUMN_NAMES, new Options.ReadOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.HIGH)});
                try {
                    this.consumeResults(resultSet);
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                poolMaintainerClock.currentTimeMillis.addAndGet(java.time.Duration.ofMillis(2050L).toMillis());
                client.pool.poolMaintainer.maintainPool();
                return null;
            });
            Instant endExecutionTime = client.pool.poolMaintainer.lastExecutionTime;
            Assert.assertNotEquals((Object)endExecutionTime, (Object)initialExecutionTime);
            Assert.assertEquals((long)0L, (long)client.pool.numLeakedSessionsRemoved());
        }
    }

    @Test
    public void testPoolMaintainer_whenLongRunningQueriesUsingTransactionRunner_retainSessionForTransaction() {
        FakeClock poolMaintainerClock = new FakeClock();
        SessionPoolOptions.InactiveTransactionRemovalOptions inactiveTransactionRemovalOptions = SessionPoolOptions.InactiveTransactionRemovalOptions.newBuilder().setIdleTimeThreshold(java.time.Duration.ofSeconds(3L)).setActionOnInactiveTransaction(SessionPoolOptions.ActionOnInactiveTransaction.CLOSE).setExecutionFrequency(java.time.Duration.ofSeconds(1L)).build();
        SessionPoolOptions sessionPoolOptions = SessionPoolOptions.newBuilder().setMinSessions(1).setMaxSessions(1).setInactiveTransactionRemovalOptions(inactiveTransactionRemovalOptions).setLoopFrequency(1000L).setPoolMaintainerClock((Clock)poolMaintainerClock).build();
        try (Spanner spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(TEST_PROJECT)).setDatabaseRole(TEST_DATABASE_ROLE).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).setSessionPoolOption(sessionPoolOptions).build().getService();){
            DatabaseClientImpl client = (DatabaseClientImpl)spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
            Instant initialExecutionTime = client.pool.poolMaintainer.lastExecutionTime;
            TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
            runner.run(transaction -> {
                try (ResultSet resultSet = transaction.executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);){
                    this.consumeResults(resultSet);
                }
                poolMaintainerClock.currentTimeMillis.addAndGet(java.time.Duration.ofMillis(1050L).toMillis());
                resultSet = transaction.executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);
                try {
                    this.consumeResults(resultSet);
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                poolMaintainerClock.currentTimeMillis.addAndGet(java.time.Duration.ofMillis(2050L).toMillis());
                client.pool.poolMaintainer.maintainPool();
                return null;
            });
            Instant endExecutionTime = client.pool.poolMaintainer.lastExecutionTime;
            Assert.assertNotEquals((Object)endExecutionTime, (Object)initialExecutionTime);
            Assert.assertEquals((long)0L, (long)client.pool.numLeakedSessionsRemoved());
        }
    }

    @Test
    public void testPoolMaintainer_whenLongRunningUpdatesUsingTransactionManager_retainSessionForTransaction() {
        FakeClock poolMaintainerClock = new FakeClock();
        SessionPoolOptions.InactiveTransactionRemovalOptions inactiveTransactionRemovalOptions = SessionPoolOptions.InactiveTransactionRemovalOptions.newBuilder().setIdleTimeThreshold(java.time.Duration.ofSeconds(3L)).setActionOnInactiveTransaction(SessionPoolOptions.ActionOnInactiveTransaction.CLOSE).setExecutionFrequency(java.time.Duration.ofSeconds(1L)).build();
        SessionPoolOptions sessionPoolOptions = SessionPoolOptions.newBuilder().setMinSessions(1).setMaxSessions(1).setInactiveTransactionRemovalOptions(inactiveTransactionRemovalOptions).setLoopFrequency(1000L).setPoolMaintainerClock((Clock)poolMaintainerClock).build();
        try (Spanner spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(TEST_PROJECT)).setDatabaseRole(TEST_DATABASE_ROLE).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).setSessionPoolOption(sessionPoolOptions).build().getService();){
            DatabaseClientImpl client = (DatabaseClientImpl)spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
            Instant initialExecutionTime = client.pool.poolMaintainer.lastExecutionTime;
            try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[0]);){
                TransactionContext transaction = manager.begin();
                while (true) {
                    try {
                        transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]);
                        poolMaintainerClock.currentTimeMillis.addAndGet(java.time.Duration.ofMillis(1050L).toMillis());
                        transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]);
                        poolMaintainerClock.currentTimeMillis.addAndGet(java.time.Duration.ofMillis(2050L).toMillis());
                        client.pool.poolMaintainer.maintainPool();
                        manager.commit();
                        Assert.assertNotNull((Object)manager.getCommitTimestamp());
                    }
                    catch (AbortedException e) {
                        transaction = manager.resetForRetry();
                        continue;
                    }
                    break;
                }
            }
            Instant endExecutionTime = client.pool.poolMaintainer.lastExecutionTime;
            Assert.assertNotEquals((Object)endExecutionTime, (Object)initialExecutionTime);
            Assert.assertEquals((long)0L, (long)client.pool.numLeakedSessionsRemoved());
            Assert.assertTrue((client.pool.getNumberOfSessionsInPool() <= client.pool.totalSessions() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testPoolMaintainer_whenLongRunningReadsUsingTransactionManager_retainSessionForTransaction() {
        FakeClock poolMaintainerClock = new FakeClock();
        SessionPoolOptions.InactiveTransactionRemovalOptions inactiveTransactionRemovalOptions = SessionPoolOptions.InactiveTransactionRemovalOptions.newBuilder().setIdleTimeThreshold(java.time.Duration.ofSeconds(3L)).setActionOnInactiveTransaction(SessionPoolOptions.ActionOnInactiveTransaction.CLOSE).setExecutionFrequency(java.time.Duration.ofSeconds(1L)).build();
        SessionPoolOptions sessionPoolOptions = SessionPoolOptions.newBuilder().setMinSessions(1).setMaxSessions(1).setInactiveTransactionRemovalOptions(inactiveTransactionRemovalOptions).setLoopFrequency(1000L).setPoolMaintainerClock((Clock)poolMaintainerClock).build();
        try (Spanner spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(TEST_PROJECT)).setDatabaseRole(TEST_DATABASE_ROLE).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).setSessionPoolOption(sessionPoolOptions).build().getService();){
            DatabaseClientImpl client = (DatabaseClientImpl)spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
            Instant initialExecutionTime = client.pool.poolMaintainer.lastExecutionTime;
            try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[0]);){
                TransactionContext transaction = manager.begin();
                while (true) {
                    try {
                        try (ResultSet resultSet = transaction.read("TestTable", KeySet.singleKey((Key)Key.of((Object[])new Object[]{1L})), MockSpannerTestUtil.READ_COLUMN_NAMES, new Options.ReadOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.HIGH)});){
                            this.consumeResults(resultSet);
                        }
                        poolMaintainerClock.currentTimeMillis.addAndGet(java.time.Duration.ofMillis(1050L).toMillis());
                        resultSet = transaction.read("TestTable", KeySet.singleKey((Key)Key.of((Object[])new Object[]{1L})), MockSpannerTestUtil.READ_COLUMN_NAMES, new Options.ReadOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.HIGH)});
                        try {
                            this.consumeResults(resultSet);
                        }
                        finally {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                        }
                        poolMaintainerClock.currentTimeMillis.addAndGet(java.time.Duration.ofMillis(2050L).toMillis());
                        client.pool.poolMaintainer.maintainPool();
                        manager.commit();
                        Assert.assertNotNull((Object)manager.getCommitTimestamp());
                    }
                    catch (AbortedException e) {
                        transaction = manager.resetForRetry();
                        continue;
                    }
                    break;
                }
            }
            Instant endExecutionTime = client.pool.poolMaintainer.lastExecutionTime;
            Assert.assertNotEquals((Object)endExecutionTime, (Object)initialExecutionTime);
            Assert.assertEquals((long)0L, (long)client.pool.numLeakedSessionsRemoved());
            Assert.assertTrue((client.pool.getNumberOfSessionsInPool() <= client.pool.totalSessions() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testPoolMaintainer_whenLongRunningReadRowUsingTransactionManager_retainSessionForTransaction() {
        FakeClock poolMaintainerClock = new FakeClock();
        SessionPoolOptions.InactiveTransactionRemovalOptions inactiveTransactionRemovalOptions = SessionPoolOptions.InactiveTransactionRemovalOptions.newBuilder().setIdleTimeThreshold(java.time.Duration.ofSeconds(3L)).setActionOnInactiveTransaction(SessionPoolOptions.ActionOnInactiveTransaction.CLOSE).setExecutionFrequency(java.time.Duration.ofSeconds(1L)).build();
        SessionPoolOptions sessionPoolOptions = SessionPoolOptions.newBuilder().setMinSessions(1).setMaxSessions(1).setInactiveTransactionRemovalOptions(inactiveTransactionRemovalOptions).setLoopFrequency(1000L).setPoolMaintainerClock((Clock)poolMaintainerClock).build();
        try (Spanner spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(TEST_PROJECT)).setDatabaseRole(TEST_DATABASE_ROLE).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).setSessionPoolOption(sessionPoolOptions).build().getService();){
            DatabaseClientImpl client = (DatabaseClientImpl)spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
            Instant initialExecutionTime = client.pool.poolMaintainer.lastExecutionTime;
            try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[0]);){
                TransactionContext transaction = manager.begin();
                while (true) {
                    try {
                        transaction.readRow("TestTable", Key.of((Object[])new Object[]{1L}), MockSpannerTestUtil.READ_COLUMN_NAMES);
                        poolMaintainerClock.currentTimeMillis.addAndGet(java.time.Duration.ofMillis(1050L).toMillis());
                        transaction.readRow("TestTable", Key.of((Object[])new Object[]{1L}), MockSpannerTestUtil.READ_COLUMN_NAMES);
                        poolMaintainerClock.currentTimeMillis.addAndGet(java.time.Duration.ofMillis(2050L).toMillis());
                        client.pool.poolMaintainer.maintainPool();
                        manager.commit();
                        Assert.assertNotNull((Object)manager.getCommitTimestamp());
                    }
                    catch (AbortedException e) {
                        transaction = manager.resetForRetry();
                        continue;
                    }
                    break;
                }
            }
            Instant endExecutionTime = client.pool.poolMaintainer.lastExecutionTime;
            Assert.assertNotEquals((Object)endExecutionTime, (Object)initialExecutionTime);
            Assert.assertEquals((long)0L, (long)client.pool.numLeakedSessionsRemoved());
            Assert.assertTrue((client.pool.getNumberOfSessionsInPool() <= client.pool.totalSessions() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testPoolMaintainer_whenLongRunningAnalyzeUpdateStatementUsingTransactionManager_retainSessionForTransaction() {
        FakeClock poolMaintainerClock = new FakeClock();
        SessionPoolOptions.InactiveTransactionRemovalOptions inactiveTransactionRemovalOptions = SessionPoolOptions.InactiveTransactionRemovalOptions.newBuilder().setIdleTimeThreshold(java.time.Duration.ofSeconds(3L)).setActionOnInactiveTransaction(SessionPoolOptions.ActionOnInactiveTransaction.CLOSE).setExecutionFrequency(java.time.Duration.ofSeconds(1L)).build();
        SessionPoolOptions sessionPoolOptions = SessionPoolOptions.newBuilder().setMinSessions(1).setMaxSessions(1).setInactiveTransactionRemovalOptions(inactiveTransactionRemovalOptions).setLoopFrequency(1000L).setPoolMaintainerClock((Clock)poolMaintainerClock).build();
        try (Spanner spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(TEST_PROJECT)).setDatabaseRole(TEST_DATABASE_ROLE).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).setSessionPoolOption(sessionPoolOptions).build().getService();){
            DatabaseClientImpl client = (DatabaseClientImpl)spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
            Instant initialExecutionTime = client.pool.poolMaintainer.lastExecutionTime;
            try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[0]);){
                TransactionContext transaction = manager.begin();
                while (true) {
                    try {
                        try (ResultSet resultSet = transaction.analyzeUpdateStatement(UPDATE_STATEMENT, ReadContext.QueryAnalyzeMode.PROFILE, new Options.UpdateOption[0]);){
                            this.consumeResults(resultSet);
                        }
                        poolMaintainerClock.currentTimeMillis.addAndGet(java.time.Duration.ofMillis(1050L).toMillis());
                        resultSet = transaction.analyzeUpdateStatement(UPDATE_STATEMENT, ReadContext.QueryAnalyzeMode.PROFILE, new Options.UpdateOption[0]);
                        try {
                            this.consumeResults(resultSet);
                        }
                        finally {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                        }
                        poolMaintainerClock.currentTimeMillis.addAndGet(java.time.Duration.ofMillis(2050L).toMillis());
                        client.pool.poolMaintainer.maintainPool();
                        manager.commit();
                        Assert.assertNotNull((Object)manager.getCommitTimestamp());
                    }
                    catch (AbortedException e) {
                        transaction = manager.resetForRetry();
                        continue;
                    }
                    break;
                }
            }
            Instant endExecutionTime = client.pool.poolMaintainer.lastExecutionTime;
            Assert.assertNotEquals((Object)endExecutionTime, (Object)initialExecutionTime);
            Assert.assertEquals((long)0L, (long)client.pool.numLeakedSessionsRemoved());
            Assert.assertTrue((client.pool.getNumberOfSessionsInPool() <= client.pool.totalSessions() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testPoolMaintainer_whenLongRunningBatchUpdatesUsingTransactionManager_retainSessionForTransaction() {
        FakeClock poolMaintainerClock = new FakeClock();
        SessionPoolOptions.InactiveTransactionRemovalOptions inactiveTransactionRemovalOptions = SessionPoolOptions.InactiveTransactionRemovalOptions.newBuilder().setIdleTimeThreshold(java.time.Duration.ofSeconds(3L)).setActionOnInactiveTransaction(SessionPoolOptions.ActionOnInactiveTransaction.CLOSE).setExecutionFrequency(java.time.Duration.ofSeconds(1L)).build();
        SessionPoolOptions sessionPoolOptions = SessionPoolOptions.newBuilder().setMinSessions(1).setMaxSessions(1).setInactiveTransactionRemovalOptions(inactiveTransactionRemovalOptions).setLoopFrequency(1000L).setPoolMaintainerClock((Clock)poolMaintainerClock).build();
        try (Spanner spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(TEST_PROJECT)).setDatabaseRole(TEST_DATABASE_ROLE).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).setSessionPoolOption(sessionPoolOptions).build().getService();){
            DatabaseClientImpl client = (DatabaseClientImpl)spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
            Instant initialExecutionTime = client.pool.poolMaintainer.lastExecutionTime;
            try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[0]);){
                TransactionContext transaction = manager.begin();
                while (true) {
                    try {
                        transaction.batchUpdate((Iterable)Lists.newArrayList((Object[])new Statement[]{UPDATE_STATEMENT}), new Options.UpdateOption[0]);
                        poolMaintainerClock.currentTimeMillis.addAndGet(java.time.Duration.ofMillis(1050L).toMillis());
                        transaction.batchUpdate((Iterable)Lists.newArrayList((Object[])new Statement[]{UPDATE_STATEMENT}), new Options.UpdateOption[0]);
                        poolMaintainerClock.currentTimeMillis.addAndGet(java.time.Duration.ofMillis(2050L).toMillis());
                        client.pool.poolMaintainer.maintainPool();
                        manager.commit();
                        Assert.assertNotNull((Object)manager.getCommitTimestamp());
                    }
                    catch (AbortedException e) {
                        transaction = manager.resetForRetry();
                        continue;
                    }
                    break;
                }
            }
            Instant endExecutionTime = client.pool.poolMaintainer.lastExecutionTime;
            Assert.assertNotEquals((Object)endExecutionTime, (Object)initialExecutionTime);
            Assert.assertEquals((long)0L, (long)client.pool.numLeakedSessionsRemoved());
            Assert.assertTrue((client.pool.getNumberOfSessionsInPool() <= client.pool.totalSessions() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testPoolMaintainer_whenLongRunningBatchUpdatesAsyncUsingTransactionManager_retainSessionForTransaction() {
        FakeClock poolMaintainerClock = new FakeClock();
        SessionPoolOptions.InactiveTransactionRemovalOptions inactiveTransactionRemovalOptions = SessionPoolOptions.InactiveTransactionRemovalOptions.newBuilder().setIdleTimeThreshold(java.time.Duration.ofSeconds(3L)).setActionOnInactiveTransaction(SessionPoolOptions.ActionOnInactiveTransaction.CLOSE).setExecutionFrequency(java.time.Duration.ofSeconds(1L)).build();
        SessionPoolOptions sessionPoolOptions = SessionPoolOptions.newBuilder().setMinSessions(1).setMaxSessions(1).setInactiveTransactionRemovalOptions(inactiveTransactionRemovalOptions).setLoopFrequency(1000L).setPoolMaintainerClock((Clock)poolMaintainerClock).build();
        try (Spanner spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(TEST_PROJECT)).setDatabaseRole(TEST_DATABASE_ROLE).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).setSessionPoolOption(sessionPoolOptions).build().getService();){
            DatabaseClientImpl client = (DatabaseClientImpl)spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
            Instant initialExecutionTime = client.pool.poolMaintainer.lastExecutionTime;
            try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[0]);){
                TransactionContext transaction = manager.begin();
                while (true) {
                    try {
                        transaction.batchUpdateAsync((Iterable)Lists.newArrayList((Object[])new Statement[]{UPDATE_STATEMENT}), new Options.UpdateOption[0]);
                        poolMaintainerClock.currentTimeMillis.addAndGet(java.time.Duration.ofMillis(1050L).toMillis());
                        transaction.batchUpdateAsync((Iterable)Lists.newArrayList((Object[])new Statement[]{UPDATE_STATEMENT}), new Options.UpdateOption[0]);
                        poolMaintainerClock.currentTimeMillis.addAndGet(java.time.Duration.ofMillis(2050L).toMillis());
                        client.pool.poolMaintainer.maintainPool();
                        manager.commit();
                        Assert.assertNotNull((Object)manager.getCommitTimestamp());
                    }
                    catch (AbortedException e) {
                        transaction = manager.resetForRetry();
                        continue;
                    }
                    break;
                }
            }
            Instant endExecutionTime = client.pool.poolMaintainer.lastExecutionTime;
            Assert.assertNotEquals((Object)endExecutionTime, (Object)initialExecutionTime);
            Assert.assertEquals((long)0L, (long)client.pool.numLeakedSessionsRemoved());
            Assert.assertTrue((client.pool.getNumberOfSessionsInPool() <= client.pool.totalSessions() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testPoolMaintainer_whenLongRunningExecuteQueryUsingTransactionManager_retainSessionForTransaction() {
        FakeClock poolMaintainerClock = new FakeClock();
        SessionPoolOptions.InactiveTransactionRemovalOptions inactiveTransactionRemovalOptions = SessionPoolOptions.InactiveTransactionRemovalOptions.newBuilder().setIdleTimeThreshold(java.time.Duration.ofSeconds(3L)).setActionOnInactiveTransaction(SessionPoolOptions.ActionOnInactiveTransaction.CLOSE).setExecutionFrequency(java.time.Duration.ofSeconds(1L)).build();
        SessionPoolOptions sessionPoolOptions = SessionPoolOptions.newBuilder().setMinSessions(1).setMaxSessions(1).setInactiveTransactionRemovalOptions(inactiveTransactionRemovalOptions).setLoopFrequency(1000L).setPoolMaintainerClock((Clock)poolMaintainerClock).build();
        try (Spanner spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(TEST_PROJECT)).setDatabaseRole(TEST_DATABASE_ROLE).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).setSessionPoolOption(sessionPoolOptions).build().getService();){
            DatabaseClientImpl client = (DatabaseClientImpl)spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
            Instant initialExecutionTime = client.pool.poolMaintainer.lastExecutionTime;
            try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[0]);){
                TransactionContext transaction = manager.begin();
                while (true) {
                    try {
                        try (ResultSet resultSet = transaction.executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);){
                            this.consumeResults(resultSet);
                        }
                        poolMaintainerClock.currentTimeMillis.addAndGet(java.time.Duration.ofMillis(1050L).toMillis());
                        resultSet = transaction.executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);
                        try {
                            this.consumeResults(resultSet);
                        }
                        finally {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                        }
                        poolMaintainerClock.currentTimeMillis.addAndGet(java.time.Duration.ofMillis(2050L).toMillis());
                        client.pool.poolMaintainer.maintainPool();
                        manager.commit();
                        Assert.assertNotNull((Object)manager.getCommitTimestamp());
                    }
                    catch (AbortedException e) {
                        transaction = manager.resetForRetry();
                        continue;
                    }
                    break;
                }
            }
            Instant endExecutionTime = client.pool.poolMaintainer.lastExecutionTime;
            Assert.assertNotEquals((Object)endExecutionTime, (Object)initialExecutionTime);
            Assert.assertEquals((long)0L, (long)client.pool.numLeakedSessionsRemoved());
            Assert.assertTrue((client.pool.getNumberOfSessionsInPool() <= client.pool.totalSessions() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testPoolMaintainer_whenLongRunningExecuteQueryAsyncUsingTransactionManager_retainSessionForTransaction() {
        FakeClock poolMaintainerClock = new FakeClock();
        SessionPoolOptions.InactiveTransactionRemovalOptions inactiveTransactionRemovalOptions = SessionPoolOptions.InactiveTransactionRemovalOptions.newBuilder().setIdleTimeThreshold(java.time.Duration.ofSeconds(3L)).setActionOnInactiveTransaction(SessionPoolOptions.ActionOnInactiveTransaction.CLOSE).setExecutionFrequency(java.time.Duration.ofSeconds(1L)).build();
        SessionPoolOptions sessionPoolOptions = SessionPoolOptions.newBuilder().setMinSessions(1).setMaxSessions(1).setInactiveTransactionRemovalOptions(inactiveTransactionRemovalOptions).setLoopFrequency(1000L).setPoolMaintainerClock((Clock)poolMaintainerClock).build();
        try (Spanner spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(TEST_PROJECT)).setDatabaseRole(TEST_DATABASE_ROLE).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).setSessionPoolOption(sessionPoolOptions).build().getService();){
            DatabaseClientImpl client = (DatabaseClientImpl)spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
            Instant initialExecutionTime = client.pool.poolMaintainer.lastExecutionTime;
            try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[0]);){
                TransactionContext transaction = manager.begin();
                while (true) {
                    try {
                        try (AsyncResultSet resultSet = transaction.executeQueryAsync(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);){
                            this.consumeResults((ResultSet)resultSet);
                        }
                        poolMaintainerClock.currentTimeMillis.addAndGet(java.time.Duration.ofMillis(1050L).toMillis());
                        resultSet = transaction.executeQueryAsync(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);
                        try {
                            this.consumeResults((ResultSet)resultSet);
                        }
                        finally {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                        }
                        poolMaintainerClock.currentTimeMillis.addAndGet(java.time.Duration.ofMillis(2050L).toMillis());
                        client.pool.poolMaintainer.maintainPool();
                        manager.commit();
                        Assert.assertNotNull((Object)manager.getCommitTimestamp());
                    }
                    catch (AbortedException e) {
                        transaction = manager.resetForRetry();
                        continue;
                    }
                    break;
                }
            }
            Instant endExecutionTime = client.pool.poolMaintainer.lastExecutionTime;
            Assert.assertNotEquals((Object)endExecutionTime, (Object)initialExecutionTime);
            Assert.assertEquals((long)0L, (long)client.pool.numLeakedSessionsRemoved());
            Assert.assertTrue((client.pool.getNumberOfSessionsInPool() <= client.pool.totalSessions() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testPoolMaintainer_whenLongRunningAnalyzeQueryUsingTransactionManager_retainSessionForTransaction() {
        FakeClock poolMaintainerClock = new FakeClock();
        SessionPoolOptions.InactiveTransactionRemovalOptions inactiveTransactionRemovalOptions = SessionPoolOptions.InactiveTransactionRemovalOptions.newBuilder().setIdleTimeThreshold(java.time.Duration.ofSeconds(3L)).setActionOnInactiveTransaction(SessionPoolOptions.ActionOnInactiveTransaction.CLOSE).setExecutionFrequency(java.time.Duration.ofSeconds(1L)).build();
        SessionPoolOptions sessionPoolOptions = SessionPoolOptions.newBuilder().setMinSessions(1).setMaxSessions(1).setInactiveTransactionRemovalOptions(inactiveTransactionRemovalOptions).setLoopFrequency(1000L).setPoolMaintainerClock((Clock)poolMaintainerClock).build();
        try (Spanner spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(TEST_PROJECT)).setDatabaseRole(TEST_DATABASE_ROLE).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).setSessionPoolOption(sessionPoolOptions).build().getService();){
            DatabaseClientImpl client = (DatabaseClientImpl)spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
            Instant initialExecutionTime = client.pool.poolMaintainer.lastExecutionTime;
            try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[0]);){
                TransactionContext transaction = manager.begin();
                while (true) {
                    try {
                        try (ResultSet resultSet = transaction.analyzeQuery(MockSpannerTestUtil.SELECT1, ReadContext.QueryAnalyzeMode.PROFILE);){
                            this.consumeResults(resultSet);
                        }
                        poolMaintainerClock.currentTimeMillis.addAndGet(java.time.Duration.ofMillis(1050L).toMillis());
                        resultSet = transaction.analyzeQuery(MockSpannerTestUtil.SELECT1, ReadContext.QueryAnalyzeMode.PROFILE);
                        try {
                            this.consumeResults(resultSet);
                        }
                        finally {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                        }
                        poolMaintainerClock.currentTimeMillis.addAndGet(java.time.Duration.ofMillis(2050L).toMillis());
                        client.pool.poolMaintainer.maintainPool();
                        manager.commit();
                        Assert.assertNotNull((Object)manager.getCommitTimestamp());
                    }
                    catch (AbortedException e) {
                        transaction = manager.resetForRetry();
                        continue;
                    }
                    break;
                }
            }
            Instant endExecutionTime = client.pool.poolMaintainer.lastExecutionTime;
            Assert.assertNotEquals((Object)endExecutionTime, (Object)initialExecutionTime);
            Assert.assertEquals((long)0L, (long)client.pool.numLeakedSessionsRemoved());
            Assert.assertTrue((client.pool.getNumberOfSessionsInPool() <= client.pool.totalSessions() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testWrite() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        Timestamp timestamp = client.write(Collections.singletonList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"FOO").set("ID").to(1L)).set("NAME").to("Bar")).build()));
        Assert.assertNotNull((Object)timestamp);
        List<BeginTransactionRequest> beginTransactions = mockSpanner.getRequestsOfType(BeginTransactionRequest.class);
        Truth.assertThat(beginTransactions).hasSize(1);
        BeginTransactionRequest beginTransaction = beginTransactions.get(0);
        Assert.assertNotNull((Object)beginTransaction.getOptions());
        Assert.assertTrue((boolean)beginTransaction.getOptions().hasReadWrite());
        Assert.assertFalse((boolean)beginTransaction.getOptions().getExcludeTxnFromChangeStreams());
        List<CommitRequest> commitRequests = mockSpanner.getRequestsOfType(CommitRequest.class);
        Truth.assertThat(commitRequests).hasSize(1);
        CommitRequest commit = commitRequests.get(0);
        Assert.assertNotNull((Object)commit.getRequestOptions());
        Assert.assertEquals((Object)RequestOptions.Priority.PRIORITY_UNSPECIFIED, (Object)commit.getRequestOptions().getPriority());
    }

    @Test
    public void testWriteAborted() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        mockSpanner.setCommitExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)mockSpanner.createAbortedException(ByteString.copyFromUtf8((String)"test"))));
        Timestamp timestamp = client.write(Collections.singletonList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"FOO").set("ID").to(1L)).set("NAME").to("Bar")).build()));
        Assert.assertNotNull((Object)timestamp);
        List<CommitRequest> commitRequests = mockSpanner.getRequestsOfType(CommitRequest.class);
        Assert.assertEquals((long)2L, (long)commitRequests.size());
    }

    @Test
    public void testWriteAtLeastOnceAborted() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        mockSpanner.setCommitExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)mockSpanner.createAbortedException(ByteString.copyFromUtf8((String)"test"))));
        Timestamp timestamp = client.writeAtLeastOnce(Collections.singletonList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"FOO").set("ID").to(1L)).set("NAME").to("Bar")).build()));
        Assert.assertNotNull((Object)timestamp);
        List<CommitRequest> commitRequests = mockSpanner.getRequestsOfType(CommitRequest.class);
        Assert.assertEquals((long)2L, (long)commitRequests.size());
    }

    @Test
    public void testWriteWithOptions() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        client.writeWithOptions(Collections.singletonList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"FOO").set("ID").to(1L)).set("NAME").to("Bar")).build()), new Options.TransactionOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.HIGH)});
        List<BeginTransactionRequest> beginTransactions = mockSpanner.getRequestsOfType(BeginTransactionRequest.class);
        Truth.assertThat(beginTransactions).hasSize(1);
        BeginTransactionRequest beginTransaction = beginTransactions.get(0);
        Assert.assertNotNull((Object)beginTransaction.getOptions());
        Assert.assertTrue((boolean)beginTransaction.getOptions().hasReadWrite());
        Assert.assertFalse((boolean)beginTransaction.getOptions().getExcludeTxnFromChangeStreams());
        List<CommitRequest> commits = mockSpanner.getRequestsOfType(CommitRequest.class);
        Truth.assertThat(commits).hasSize(1);
        CommitRequest commit = commits.get(0);
        Assert.assertNotNull((Object)commit.getRequestOptions());
        Assert.assertEquals((Object)RequestOptions.Priority.PRIORITY_HIGH, (Object)commit.getRequestOptions().getPriority());
    }

    @Test
    public void testWriteWithCommitStats() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        CommitResponse response = client.writeWithOptions(Collections.singletonList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"FOO").set("ID").to(1L)).set("NAME").to("Bar")).build()), new Options.TransactionOption[]{Options.commitStats()});
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getCommitTimestamp());
        Assert.assertNotNull((Object)response.getCommitStats());
    }

    @Test
    public void testWriteWithExcludeTxnFromChangeStreams() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        client.writeWithOptions(Collections.singletonList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"FOO").set("ID").to(1L)).set("NAME").to("Bar")).build()), new Options.TransactionOption[]{Options.excludeTxnFromChangeStreams()});
        List<BeginTransactionRequest> beginTransactions = mockSpanner.getRequestsOfType(BeginTransactionRequest.class);
        Truth.assertThat(beginTransactions).hasSize(1);
        BeginTransactionRequest beginTransaction = beginTransactions.get(0);
        Assert.assertNotNull((Object)beginTransaction.getOptions());
        Assert.assertTrue((boolean)beginTransaction.getOptions().hasReadWrite());
        Assert.assertTrue((boolean)beginTransaction.getOptions().getExcludeTxnFromChangeStreams());
    }

    @Test
    public void testWriteAtLeastOnce() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        Timestamp timestamp = client.writeAtLeastOnce(Collections.singletonList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"FOO").set("ID").to(1L)).set("NAME").to("Bar")).build()));
        Assert.assertNotNull((Object)timestamp);
        List<CommitRequest> commitRequests = mockSpanner.getRequestsOfType(CommitRequest.class);
        Truth.assertThat(commitRequests).hasSize(1);
        CommitRequest commit = commitRequests.get(0);
        Assert.assertNotNull((Object)commit.getSingleUseTransaction());
        Assert.assertTrue((boolean)commit.getSingleUseTransaction().hasReadWrite());
        Assert.assertFalse((boolean)commit.getSingleUseTransaction().getExcludeTxnFromChangeStreams());
        Assert.assertNotNull((Object)commit.getRequestOptions());
        Assert.assertEquals((Object)RequestOptions.Priority.PRIORITY_UNSPECIFIED, (Object)commit.getRequestOptions().getPriority());
    }

    @Test
    public void testWriteAtLeastOnceWithCommitStats() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        CommitResponse response = client.writeAtLeastOnceWithOptions(Collections.singletonList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"FOO").set("ID").to(1L)).set("NAME").to("Bar")).build()), new Options.TransactionOption[]{Options.commitStats()});
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getCommitTimestamp());
        Assert.assertNotNull((Object)response.getCommitStats());
        List<CommitRequest> commitRequests = mockSpanner.getRequestsOfType(CommitRequest.class);
        Truth.assertThat(commitRequests).hasSize(1);
        CommitRequest commit = commitRequests.get(0);
        Assert.assertNotNull((Object)commit.getSingleUseTransaction());
        Assert.assertTrue((boolean)commit.getSingleUseTransaction().hasReadWrite());
        Assert.assertFalse((boolean)commit.getSingleUseTransaction().getExcludeTxnFromChangeStreams());
        Assert.assertNotNull((Object)commit.getRequestOptions());
        Assert.assertEquals((Object)RequestOptions.Priority.PRIORITY_UNSPECIFIED, (Object)commit.getRequestOptions().getPriority());
    }

    @Test
    public void testWriteAtLeastOnceWithOptions() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        client.writeAtLeastOnceWithOptions(Collections.singletonList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"FOO").set("ID").to(1L)).set("NAME").to("Bar")).build()), new Options.TransactionOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.LOW)});
        List<CommitRequest> commitRequests = mockSpanner.getRequestsOfType(CommitRequest.class);
        Truth.assertThat(commitRequests).hasSize(1);
        CommitRequest commit = commitRequests.get(0);
        Assert.assertNotNull((Object)commit.getSingleUseTransaction());
        Assert.assertTrue((boolean)commit.getSingleUseTransaction().hasReadWrite());
        Assert.assertFalse((boolean)commit.getSingleUseTransaction().getExcludeTxnFromChangeStreams());
        Assert.assertNotNull((Object)commit.getRequestOptions());
        Assert.assertEquals((Object)RequestOptions.Priority.PRIORITY_LOW, (Object)commit.getRequestOptions().getPriority());
    }

    @Test
    public void testWriteAtLeastOnceWithTagOptions() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        client.writeAtLeastOnceWithOptions(Collections.singletonList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"FOO").set("ID").to(1L)).set("NAME").to("Bar")).build()), new Options.TransactionOption[]{Options.tag((String)"app=spanner,env=test")});
        List<CommitRequest> commitRequests = mockSpanner.getRequestsOfType(CommitRequest.class);
        Truth.assertThat(commitRequests).hasSize(1);
        CommitRequest commit = commitRequests.get(0);
        Assert.assertNotNull((Object)commit.getSingleUseTransaction());
        Assert.assertTrue((boolean)commit.getSingleUseTransaction().hasReadWrite());
        Assert.assertFalse((boolean)commit.getSingleUseTransaction().getExcludeTxnFromChangeStreams());
        Assert.assertNotNull((Object)commit.getRequestOptions());
        Truth.assertThat((String)commit.getRequestOptions().getTransactionTag()).isEqualTo((Object)"app=spanner,env=test");
        Truth.assertThat((String)commit.getRequestOptions().getRequestTag()).isEmpty();
    }

    @Test
    public void testWriteAtLeastOnceWithExcludeTxnFromChangeStreams() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        client.writeAtLeastOnceWithOptions(Collections.singletonList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"FOO").set("ID").to(1L)).set("NAME").to("Bar")).build()), new Options.TransactionOption[]{Options.excludeTxnFromChangeStreams()});
        List<CommitRequest> commitRequests = mockSpanner.getRequestsOfType(CommitRequest.class);
        Truth.assertThat(commitRequests).hasSize(1);
        CommitRequest commit = commitRequests.get(0);
        Assert.assertNotNull((Object)commit.getSingleUseTransaction());
        Assert.assertTrue((boolean)commit.getSingleUseTransaction().hasReadWrite());
        Assert.assertTrue((boolean)commit.getSingleUseTransaction().getExcludeTxnFromChangeStreams());
    }

    @Test
    public void testBatchWriteAtLeastOnceWithoutOptions() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        ServerStream responseStream = client.batchWriteAtLeastOnce(MUTATION_GROUPS, new Options.TransactionOption[0]);
        int idx = 0;
        for (BatchWriteResponse response : responseStream) {
            Assert.assertEquals((Object)response.getStatus(), (Object)com.google.rpc.Status.newBuilder().setCode(0).build());
            Assert.assertEquals((Object)response.getIndexesList(), (Object)ImmutableList.of((Object)idx, (Object)(idx + 1)));
            idx += 2;
        }
        Assert.assertNotNull((Object)responseStream);
        List<BatchWriteRequest> requests = mockSpanner.getRequestsOfType(BatchWriteRequest.class);
        Assert.assertEquals((long)requests.size(), (long)1L);
        BatchWriteRequest request = requests.get(0);
        Assert.assertEquals((long)request.getMutationGroupsCount(), (long)4L);
        Assert.assertEquals((Object)request.getRequestOptions().getPriority(), (Object)RequestOptions.Priority.PRIORITY_UNSPECIFIED);
        Assert.assertFalse((boolean)request.getExcludeTxnFromChangeStreams());
    }

    @Test
    public void testBatchWriteAtLeastOnceWithOptions() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        this.consumeBatchWriteStream((ServerStream<BatchWriteResponse>)client.batchWriteAtLeastOnce(MUTATION_GROUPS, new Options.TransactionOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.LOW)}));
        List<BatchWriteRequest> requests = mockSpanner.getRequestsOfType(BatchWriteRequest.class);
        Assert.assertEquals((long)requests.size(), (long)1L);
        BatchWriteRequest request = requests.get(0);
        Assert.assertEquals((long)request.getMutationGroupsCount(), (long)4L);
        Assert.assertEquals((Object)request.getRequestOptions().getPriority(), (Object)RequestOptions.Priority.PRIORITY_LOW);
        Assert.assertFalse((boolean)request.getExcludeTxnFromChangeStreams());
    }

    @Test
    public void testBatchWriteAtLeastOnceWithTagOptions() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        this.consumeBatchWriteStream((ServerStream<BatchWriteResponse>)client.batchWriteAtLeastOnce(MUTATION_GROUPS, new Options.TransactionOption[]{Options.tag((String)"app=spanner,env=test")}));
        List<BatchWriteRequest> requests = mockSpanner.getRequestsOfType(BatchWriteRequest.class);
        Assert.assertEquals((long)requests.size(), (long)1L);
        BatchWriteRequest request = requests.get(0);
        Assert.assertEquals((long)request.getMutationGroupsCount(), (long)4L);
        Assert.assertEquals((Object)request.getRequestOptions().getTransactionTag(), (Object)"app=spanner,env=test");
        Truth.assertThat((String)request.getRequestOptions().getRequestTag()).isEmpty();
        Assert.assertFalse((boolean)request.getExcludeTxnFromChangeStreams());
    }

    @Test
    public void testBatchWriteAtLeastOnceWithExcludeTxnFromChangeStreams() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        this.consumeBatchWriteStream((ServerStream<BatchWriteResponse>)client.batchWriteAtLeastOnce(MUTATION_GROUPS, new Options.TransactionOption[]{Options.excludeTxnFromChangeStreams()}));
        List<BatchWriteRequest> requests = mockSpanner.getRequestsOfType(BatchWriteRequest.class);
        Assert.assertEquals((long)requests.size(), (long)1L);
        BatchWriteRequest request = requests.get(0);
        Assert.assertEquals((long)request.getMutationGroupsCount(), (long)4L);
        Assert.assertTrue((boolean)request.getExcludeTxnFromChangeStreams());
    }

    @Test
    public void testExecuteQueryWithTag() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        try (ResultSet resultSet = client.singleUse().executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[]{Options.tag((String)"app=spanner,env=test,action=query")});){
            this.consumeResults(resultSet);
        }
        List<ExecuteSqlRequest> requests = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class);
        Truth.assertThat(requests).hasSize(1);
        ExecuteSqlRequest request = requests.get(0);
        Assert.assertNotNull((Object)request.getRequestOptions());
        Truth.assertThat((String)request.getRequestOptions().getRequestTag()).isEqualTo((Object)"app=spanner,env=test,action=query");
        Truth.assertThat((String)request.getRequestOptions().getTransactionTag()).isEmpty();
    }

    @Test
    public void testExecuteQuery_withDirectedReadOptionsViaRequest() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        try (ResultSet resultSet = client.singleUse().executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[]{Options.directedRead((DirectedReadOptions)DIRECTED_READ_OPTIONS1)});){
            this.consumeResults(resultSet);
        }
        List<ExecuteSqlRequest> requests = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class);
        Assert.assertEquals((long)1L, (long)requests.size());
        ExecuteSqlRequest request = requests.get(0);
        Assert.assertTrue((boolean)request.hasDirectedReadOptions());
        Assert.assertEquals((Object)DIRECTED_READ_OPTIONS1, (Object)request.getDirectedReadOptions());
    }

    @Test
    public void testExecuteQuery_withDirectedReadOptionsViaSpannerOptions() {
        Spanner spannerWithDirectedReadOptions = (Spanner)((SpannerOptions)this.spanner.getOptions()).toBuilder().setDirectedReadOptions(DIRECTED_READ_OPTIONS2).build().getService();
        DatabaseClient client = spannerWithDirectedReadOptions.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        try (ResultSet resultSet = client.singleUse().executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);){
            this.consumeResults(resultSet);
        }
        List<ExecuteSqlRequest> requests = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class);
        Assert.assertEquals((long)requests.size(), (long)1L);
        ExecuteSqlRequest request = requests.get(0);
        Assert.assertTrue((boolean)request.hasDirectedReadOptions());
        Assert.assertEquals((Object)DIRECTED_READ_OPTIONS2, (Object)request.getDirectedReadOptions());
    }

    @Test
    public void testExecuteQuery_whenMultipleDirectedReadsOptions_preferRequestOption() {
        Spanner spannerWithDirectedReadOptions = (Spanner)((SpannerOptions)this.spanner.getOptions()).toBuilder().setDirectedReadOptions(DIRECTED_READ_OPTIONS2).build().getService();
        DatabaseClient client = spannerWithDirectedReadOptions.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        try (ResultSet resultSet = client.singleUse().executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[]{Options.directedRead((DirectedReadOptions)DIRECTED_READ_OPTIONS1)});){
            this.consumeResults(resultSet);
        }
        List<ExecuteSqlRequest> requests = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class);
        Assert.assertEquals((long)requests.size(), (long)1L);
        ExecuteSqlRequest request = requests.get(0);
        Assert.assertTrue((boolean)request.hasDirectedReadOptions());
        Assert.assertEquals((Object)DIRECTED_READ_OPTIONS1, (Object)request.getDirectedReadOptions());
    }

    @Test
    public void testExecuteReadWithTag() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        try (ResultSet resultSet = client.singleUse().read("TestTable", KeySet.singleKey((Key)Key.of((Object[])new Object[]{1L})), MockSpannerTestUtil.READ_COLUMN_NAMES, new Options.ReadOption[]{Options.tag((String)"app=spanner,env=test,action=read")});){
            this.consumeResults(resultSet);
        }
        List<ReadRequest> requests = mockSpanner.getRequestsOfType(ReadRequest.class);
        Truth.assertThat(requests).hasSize(1);
        ReadRequest request = requests.get(0);
        Assert.assertNotNull((Object)request.getRequestOptions());
        Truth.assertThat((String)request.getRequestOptions().getRequestTag()).isEqualTo((Object)"app=spanner,env=test,action=read");
        Truth.assertThat((String)request.getRequestOptions().getTransactionTag()).isEmpty();
    }

    @Test
    public void testExecuteReadWithOrderByOption() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        try (ResultSet resultSet = client.singleUse().read("TestTable", KeySet.singleKey((Key)Key.of((Object[])new Object[]{1L})), MockSpannerTestUtil.READ_COLUMN_NAMES, new Options.ReadOption[]{Options.orderBy((Options.RpcOrderBy)Options.RpcOrderBy.NO_ORDER)});){
            this.consumeResults(resultSet);
        }
        List<ReadRequest> requests = mockSpanner.getRequestsOfType(ReadRequest.class);
        Truth.assertThat(requests).hasSize(1);
        ReadRequest request = requests.get(0);
        Assert.assertEquals((Object)ReadRequest.OrderBy.ORDER_BY_NO_ORDER, (Object)request.getOrderBy());
    }

    @Test
    public void testUnsupportedTransactionWithLockHintOption() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        try (ResultSet resultSet = client.singleUse().read("TestTable", KeySet.singleKey((Key)Key.of((Object[])new Object[]{1L})), MockSpannerTestUtil.READ_COLUMN_NAMES, new Options.ReadOption[]{Options.lockHint((Options.RpcLockHint)Options.RpcLockHint.EXCLUSIVE)});){
            this.consumeResults(resultSet);
        }
        List<ReadRequest> requests = mockSpanner.getRequestsOfType(ReadRequest.class);
        Truth.assertThat(requests).hasSize(1);
        ReadRequest request = requests.get(0);
        Assert.assertEquals((Object)ReadRequest.LockHint.LOCK_HINT_UNSPECIFIED, (Object)request.getLockHint());
    }

    @Test
    public void testReadWriteTransactionWithLockHint() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
        runner.run(transaction -> {
            try (ResultSet resultSet = transaction.read("TestTable", KeySet.singleKey((Key)Key.of((Object[])new Object[]{1L})), MockSpannerTestUtil.READ_COLUMN_NAMES, new Options.ReadOption[]{Options.lockHint((Options.RpcLockHint)Options.RpcLockHint.EXCLUSIVE)});){
                this.consumeResults(resultSet);
            }
            return null;
        });
        List<ReadRequest> requests = mockSpanner.getRequestsOfType(ReadRequest.class);
        Truth.assertThat(requests).hasSize(1);
        ReadRequest request = requests.get(0);
        Assert.assertEquals((Object)ReadRequest.LockHint.LOCK_HINT_EXCLUSIVE, (Object)request.getLockHint());
    }

    @Test
    public void testExecuteReadWithDirectedReadOptions() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        try (ResultSet resultSet = client.singleUse().read("TestTable", KeySet.singleKey((Key)Key.of((Object[])new Object[]{1L})), MockSpannerTestUtil.READ_COLUMN_NAMES, new Options.ReadOption[]{Options.directedRead((DirectedReadOptions)DIRECTED_READ_OPTIONS1)});){
            this.consumeResults(resultSet);
        }
        List<ReadRequest> requests = mockSpanner.getRequestsOfType(ReadRequest.class);
        Assert.assertEquals((long)1L, (long)requests.size());
        ReadRequest request = requests.get(0);
        Assert.assertTrue((boolean)request.hasDirectedReadOptions());
        Assert.assertEquals((Object)DIRECTED_READ_OPTIONS1, (Object)request.getDirectedReadOptions());
    }

    @Test
    public void testExecuteReadWithDirectedReadOptionsViaSpannerOptions() {
        Spanner spannerWithDirectedReadOptions = (Spanner)((SpannerOptions)this.spanner.getOptions()).toBuilder().setDirectedReadOptions(DIRECTED_READ_OPTIONS2).build().getService();
        DatabaseClient client = spannerWithDirectedReadOptions.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        try (ResultSet resultSet = client.singleUse().read("TestTable", KeySet.singleKey((Key)Key.of((Object[])new Object[]{1L})), MockSpannerTestUtil.READ_COLUMN_NAMES, new Options.ReadOption[0]);){
            this.consumeResults(resultSet);
        }
        List<ReadRequest> requests = mockSpanner.getRequestsOfType(ReadRequest.class);
        Assert.assertEquals((long)requests.size(), (long)1L);
        ReadRequest request = requests.get(0);
        Assert.assertTrue((boolean)request.hasDirectedReadOptions());
        Assert.assertEquals((Object)DIRECTED_READ_OPTIONS2, (Object)request.getDirectedReadOptions());
    }

    @Test
    public void testReadWriteExecuteQueryWithDirectedReadOptionsViaSpannerOptions() {
        Spanner spannerWithDirectedReadOptions = (Spanner)((SpannerOptions)this.spanner.getOptions()).toBuilder().setDirectedReadOptions(DIRECTED_READ_OPTIONS2).build().getService();
        DatabaseClient client = spannerWithDirectedReadOptions.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
        runner.run(transaction -> {
            try (ResultSet resultSet = transaction.executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);){
                this.consumeResults(resultSet);
            }
            return null;
        });
        List<ExecuteSqlRequest> requests = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class);
        Assert.assertEquals((long)requests.size(), (long)1L);
        ExecuteSqlRequest request = requests.get(0);
        Assert.assertFalse((boolean)request.hasDirectedReadOptions());
    }

    @Test
    public void testReadWriteExecuteQueryWithTag() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[]{Options.tag((String)"app=spanner,env=test,action=txn")});
        runner.run(transaction -> {
            try (ResultSet resultSet = transaction.executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[]{Options.tag((String)"app=spanner,env=test,action=query")});){
                this.consumeResults(resultSet);
            }
            return null;
        });
        List<ExecuteSqlRequest> requests = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class);
        Truth.assertThat(requests).hasSize(1);
        ExecuteSqlRequest request = requests.get(0);
        Assert.assertNotNull((Object)request.getRequestOptions());
        Truth.assertThat((String)request.getRequestOptions().getRequestTag()).isEqualTo((Object)"app=spanner,env=test,action=query");
        Truth.assertThat((String)request.getRequestOptions().getTransactionTag()).isEqualTo((Object)"app=spanner,env=test,action=txn");
    }

    @Test
    public void testReadWriteExecuteReadWithTag() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[]{Options.tag((String)"app=spanner,env=test,action=txn")});
        runner.run(transaction -> {
            try (ResultSet resultSet = transaction.read("TestTable", KeySet.singleKey((Key)Key.of((Object[])new Object[]{1L})), MockSpannerTestUtil.READ_COLUMN_NAMES, new Options.ReadOption[]{Options.tag((String)"app=spanner,env=test,action=read")});){
                this.consumeResults(resultSet);
            }
            return null;
        });
        List<ReadRequest> requests = mockSpanner.getRequestsOfType(ReadRequest.class);
        Truth.assertThat(requests).hasSize(1);
        ReadRequest request = requests.get(0);
        Assert.assertNotNull((Object)request.getRequestOptions());
        Truth.assertThat((String)request.getRequestOptions().getRequestTag()).isEqualTo((Object)"app=spanner,env=test,action=read");
        Truth.assertThat((String)request.getRequestOptions().getTransactionTag()).isEqualTo((Object)"app=spanner,env=test,action=txn");
    }

    @Test
    public void testExecuteUpdateWithTag() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
        runner.run(transaction -> transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[]{Options.tag((String)"app=spanner,env=test,action=update")}));
        List<ExecuteSqlRequest> requests = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class);
        Truth.assertThat(requests).hasSize(1);
        ExecuteSqlRequest request = requests.get(0);
        Assert.assertNotNull((Object)request.getRequestOptions());
        Truth.assertThat((String)request.getRequestOptions().getRequestTag()).isEqualTo((Object)"app=spanner,env=test,action=update");
        Truth.assertThat((String)request.getRequestOptions().getTransactionTag()).isEmpty();
        Assert.assertNotNull((Object)request.getTransaction().getBegin());
        Assert.assertTrue((boolean)request.getTransaction().getBegin().hasReadWrite());
        Assert.assertFalse((boolean)request.getTransaction().getBegin().getExcludeTxnFromChangeStreams());
    }

    @Test
    public void testBatchUpdateWithTag() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[]{Options.tag((String)"app=spanner,env=test,action=txn")});
        runner.run(transaction -> transaction.batchUpdate(Collections.singletonList(UPDATE_STATEMENT), new Options.UpdateOption[]{Options.tag((String)"app=spanner,env=test,action=batch")}));
        List<ExecuteBatchDmlRequest> requests = mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class);
        Truth.assertThat(requests).hasSize(1);
        ExecuteBatchDmlRequest request = requests.get(0);
        Assert.assertNotNull((Object)request.getRequestOptions());
        Truth.assertThat((String)request.getRequestOptions().getRequestTag()).isEqualTo((Object)"app=spanner,env=test,action=batch");
        Truth.assertThat((String)request.getRequestOptions().getTransactionTag()).isEqualTo((Object)"app=spanner,env=test,action=txn");
        Assert.assertNotNull((Object)request.getTransaction().getBegin());
        Assert.assertTrue((boolean)request.getTransaction().getBegin().hasReadWrite());
        Assert.assertFalse((boolean)request.getTransaction().getBegin().getExcludeTxnFromChangeStreams());
    }

    @Test
    public void testPartitionedDMLWithTag() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        client.executePartitionedUpdate(UPDATE_STATEMENT, new Options.UpdateOption[]{Options.tag((String)"app=spanner,env=test,action=dml")});
        List<BeginTransactionRequest> beginTransactions = mockSpanner.getRequestsOfType(BeginTransactionRequest.class);
        Truth.assertThat(beginTransactions).hasSize(1);
        BeginTransactionRequest beginTransaction = beginTransactions.get(0);
        Assert.assertNotNull((Object)beginTransaction.getOptions());
        Assert.assertTrue((boolean)beginTransaction.getOptions().hasPartitionedDml());
        Assert.assertFalse((boolean)beginTransaction.getOptions().getExcludeTxnFromChangeStreams());
        List<ExecuteSqlRequest> requests = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class);
        Truth.assertThat(requests).hasSize(1);
        ExecuteSqlRequest request = requests.get(0);
        Assert.assertNotNull((Object)request.getRequestOptions());
        Truth.assertThat((String)request.getRequestOptions().getRequestTag()).isEqualTo((Object)"app=spanner,env=test,action=dml");
        Truth.assertThat((String)request.getRequestOptions().getTransactionTag()).isEmpty();
    }

    @Test
    public void testCommitWithTag() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[]{Options.tag((String)"app=spanner,env=test,action=commit")});
        runner.run(transaction -> {
            transaction.buffer(Mutation.delete((String)"TEST", (KeySet)KeySet.all()));
            return null;
        });
        List<BeginTransactionRequest> beginTransactions = mockSpanner.getRequestsOfType(BeginTransactionRequest.class);
        Truth.assertThat(beginTransactions).hasSize(1);
        BeginTransactionRequest beginTransaction = beginTransactions.get(0);
        Assert.assertNotNull((Object)beginTransaction.getOptions());
        Assert.assertTrue((boolean)beginTransaction.getOptions().hasReadWrite());
        Assert.assertFalse((boolean)beginTransaction.getOptions().getExcludeTxnFromChangeStreams());
        List<CommitRequest> requests = mockSpanner.getRequestsOfType(CommitRequest.class);
        Truth.assertThat(requests).hasSize(1);
        CommitRequest request = requests.get(0);
        Assert.assertNotNull((Object)request.getRequestOptions());
        Truth.assertThat((String)request.getRequestOptions().getRequestTag()).isEmpty();
        Truth.assertThat((String)request.getRequestOptions().getTransactionTag()).isEqualTo((Object)"app=spanner,env=test,action=commit");
    }

    @Test
    public void testTransactionManagerCommitWithTag() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[]{Options.tag((String)"app=spanner,env=test,action=manager")});){
            TransactionContext transaction = manager.begin();
            transaction.buffer(Mutation.delete((String)"TEST", (KeySet)KeySet.all()));
            manager.commit();
        }
        List<BeginTransactionRequest> beginTransactions = mockSpanner.getRequestsOfType(BeginTransactionRequest.class);
        Truth.assertThat(beginTransactions).hasSize(1);
        BeginTransactionRequest beginTransaction = beginTransactions.get(0);
        Assert.assertNotNull((Object)beginTransaction.getOptions());
        Assert.assertTrue((boolean)beginTransaction.getOptions().hasReadWrite());
        Assert.assertFalse((boolean)beginTransaction.getOptions().getExcludeTxnFromChangeStreams());
        List<CommitRequest> requests = mockSpanner.getRequestsOfType(CommitRequest.class);
        Truth.assertThat(requests).hasSize(1);
        CommitRequest request = requests.get(0);
        Assert.assertNotNull((Object)request.getRequestOptions());
        Truth.assertThat((String)request.getRequestOptions().getRequestTag()).isEmpty();
        Truth.assertThat((String)request.getRequestOptions().getTransactionTag()).isEqualTo((Object)"app=spanner,env=test,action=manager");
    }

    @Test
    public void testAsyncRunnerCommitWithTag() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        AsyncRunner runner = client.runAsync(new Options.TransactionOption[]{Options.tag((String)"app=spanner,env=test,action=runner")});
        SpannerApiFutures.get((ApiFuture)runner.runAsync(txn -> {
            txn.buffer(Mutation.delete((String)"TEST", (KeySet)KeySet.all()));
            return ApiFutures.immediateFuture(null);
        }, (Executor)executor));
        List<BeginTransactionRequest> beginTransactions = mockSpanner.getRequestsOfType(BeginTransactionRequest.class);
        Truth.assertThat(beginTransactions).hasSize(1);
        BeginTransactionRequest beginTransaction = beginTransactions.get(0);
        Assert.assertNotNull((Object)beginTransaction.getOptions());
        Assert.assertTrue((boolean)beginTransaction.getOptions().hasReadWrite());
        Assert.assertFalse((boolean)beginTransaction.getOptions().getExcludeTxnFromChangeStreams());
        List<CommitRequest> requests = mockSpanner.getRequestsOfType(CommitRequest.class);
        Truth.assertThat(requests).hasSize(1);
        CommitRequest request = requests.get(0);
        Assert.assertNotNull((Object)request.getRequestOptions());
        Truth.assertThat((String)request.getRequestOptions().getRequestTag()).isEmpty();
        Truth.assertThat((String)request.getRequestOptions().getTransactionTag()).isEqualTo((Object)"app=spanner,env=test,action=runner");
    }

    @Test
    public void testAsyncTransactionManagerCommitWithTag() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        try (AsyncTransactionManager manager = client.transactionManagerAsync(new Options.TransactionOption[]{Options.tag((String)"app=spanner,env=test,action=manager")});){
            AsyncTransactionManager.TransactionContextFuture transaction = manager.beginAsync();
            SpannerApiFutures.get((ApiFuture)transaction.then((txn, input) -> {
                txn.buffer(Mutation.delete((String)"TEST", (KeySet)KeySet.all()));
                return ApiFutures.immediateFuture(null);
            }, (Executor)executor).commitAsync());
        }
        List<BeginTransactionRequest> beginTransactions = mockSpanner.getRequestsOfType(BeginTransactionRequest.class);
        Truth.assertThat(beginTransactions).hasSize(1);
        BeginTransactionRequest beginTransaction = beginTransactions.get(0);
        Assert.assertNotNull((Object)beginTransaction.getOptions());
        Assert.assertTrue((boolean)beginTransaction.getOptions().hasReadWrite());
        Assert.assertFalse((boolean)beginTransaction.getOptions().getExcludeTxnFromChangeStreams());
        List<CommitRequest> requests = mockSpanner.getRequestsOfType(CommitRequest.class);
        Truth.assertThat(requests).hasSize(1);
        CommitRequest request = requests.get(0);
        Assert.assertNotNull((Object)request.getRequestOptions());
        Truth.assertThat((String)request.getRequestOptions().getRequestTag()).isEmpty();
        Truth.assertThat((String)request.getRequestOptions().getTransactionTag()).isEqualTo((Object)"app=spanner,env=test,action=manager");
    }

    @Test
    public void testReadWriteTxnWithExcludeTxnFromChangeStreams_executeUpdate() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[]{Options.excludeTxnFromChangeStreams()});
        runner.run(transaction -> transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]));
        List<ExecuteSqlRequest> requests = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class);
        Truth.assertThat(requests).hasSize(1);
        ExecuteSqlRequest request = requests.get(0);
        Assert.assertNotNull((Object)request.getTransaction().getBegin());
        Assert.assertTrue((boolean)request.getTransaction().getBegin().hasReadWrite());
        Assert.assertTrue((boolean)request.getTransaction().getBegin().getExcludeTxnFromChangeStreams());
    }

    @Test
    public void testReadWriteTxnWithExcludeTxnFromChangeStreams_batchUpdate() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[]{Options.excludeTxnFromChangeStreams()});
        runner.run(transaction -> transaction.batchUpdate(Collections.singletonList(UPDATE_STATEMENT), new Options.UpdateOption[0]));
        List<ExecuteBatchDmlRequest> requests = mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class);
        Truth.assertThat(requests).hasSize(1);
        ExecuteBatchDmlRequest request = requests.get(0);
        Assert.assertNotNull((Object)request.getTransaction().getBegin());
        Assert.assertTrue((boolean)request.getTransaction().getBegin().hasReadWrite());
        Assert.assertTrue((boolean)request.getTransaction().getBegin().getExcludeTxnFromChangeStreams());
    }

    @Test
    public void testPartitionedDMLWithExcludeTxnFromChangeStreams() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        client.executePartitionedUpdate(UPDATE_STATEMENT, new Options.UpdateOption[]{Options.excludeTxnFromChangeStreams()});
        List<BeginTransactionRequest> beginTransactions = mockSpanner.getRequestsOfType(BeginTransactionRequest.class);
        Truth.assertThat(beginTransactions).hasSize(1);
        BeginTransactionRequest beginTransaction = beginTransactions.get(0);
        Assert.assertNotNull((Object)beginTransaction.getOptions());
        Assert.assertTrue((boolean)beginTransaction.getOptions().hasPartitionedDml());
        Assert.assertTrue((boolean)beginTransaction.getOptions().getExcludeTxnFromChangeStreams());
    }

    @Test
    public void testCommitWithExcludeTxnFromChangeStreams() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[]{Options.excludeTxnFromChangeStreams()});
        runner.run(transaction -> {
            transaction.buffer(Mutation.delete((String)"TEST", (KeySet)KeySet.all()));
            return null;
        });
        List<BeginTransactionRequest> beginTransactions = mockSpanner.getRequestsOfType(BeginTransactionRequest.class);
        Truth.assertThat(beginTransactions).hasSize(1);
        BeginTransactionRequest beginTransaction = beginTransactions.get(0);
        Assert.assertNotNull((Object)beginTransaction.getOptions());
        Assert.assertTrue((boolean)beginTransaction.getOptions().hasReadWrite());
        Assert.assertTrue((boolean)beginTransaction.getOptions().getExcludeTxnFromChangeStreams());
    }

    @Test
    public void testTransactionManagerCommitWithExcludeTxnFromChangeStreams() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[]{Options.excludeTxnFromChangeStreams()});){
            TransactionContext transaction = manager.begin();
            transaction.buffer(Mutation.delete((String)"TEST", (KeySet)KeySet.all()));
            manager.commit();
        }
        List<BeginTransactionRequest> beginTransactions = mockSpanner.getRequestsOfType(BeginTransactionRequest.class);
        Truth.assertThat(beginTransactions).hasSize(1);
        BeginTransactionRequest beginTransaction = beginTransactions.get(0);
        Assert.assertNotNull((Object)beginTransaction.getOptions());
        Assert.assertTrue((boolean)beginTransaction.getOptions().hasReadWrite());
        Assert.assertTrue((boolean)beginTransaction.getOptions().getExcludeTxnFromChangeStreams());
    }

    @Test
    public void testAsyncRunnerCommitWithExcludeTxnFromChangeStreams() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        AsyncRunner runner = client.runAsync(new Options.TransactionOption[]{Options.excludeTxnFromChangeStreams()});
        SpannerApiFutures.get((ApiFuture)runner.runAsync(txn -> {
            txn.buffer(Mutation.delete((String)"TEST", (KeySet)KeySet.all()));
            return ApiFutures.immediateFuture(null);
        }, (Executor)executor));
        List<BeginTransactionRequest> beginTransactions = mockSpanner.getRequestsOfType(BeginTransactionRequest.class);
        Truth.assertThat(beginTransactions).hasSize(1);
        BeginTransactionRequest beginTransaction = beginTransactions.get(0);
        Assert.assertNotNull((Object)beginTransaction.getOptions());
        Assert.assertTrue((boolean)beginTransaction.getOptions().hasReadWrite());
        Assert.assertTrue((boolean)beginTransaction.getOptions().getExcludeTxnFromChangeStreams());
    }

    @Test
    public void testAsyncTransactionManagerCommitWithExcludeTxnFromChangeStreams() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        try (AsyncTransactionManager manager = client.transactionManagerAsync(new Options.TransactionOption[]{Options.excludeTxnFromChangeStreams()});){
            AsyncTransactionManager.TransactionContextFuture transaction = manager.beginAsync();
            SpannerApiFutures.get((ApiFuture)transaction.then((txn, input) -> {
                txn.buffer(Mutation.delete((String)"TEST", (KeySet)KeySet.all()));
                return ApiFutures.immediateFuture(null);
            }, (Executor)executor).commitAsync());
        }
        List<BeginTransactionRequest> beginTransactions = mockSpanner.getRequestsOfType(BeginTransactionRequest.class);
        Truth.assertThat(beginTransactions).hasSize(1);
        BeginTransactionRequest beginTransaction = beginTransactions.get(0);
        Assert.assertNotNull((Object)beginTransaction.getOptions());
        Assert.assertTrue((boolean)beginTransaction.getOptions().hasReadWrite());
        Assert.assertTrue((boolean)beginTransaction.getOptions().getExcludeTxnFromChangeStreams());
    }

    @Test
    public void testExecuteUpdateWithExcludeTxnFromChangeStreams() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
        SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> runner.run(transaction -> transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[]{Options.excludeTxnFromChangeStreams()})));
        Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.INVALID_ARGUMENT);
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"Options.excludeTxnFromChangeStreams() cannot be specified for individual DML requests. This option should be set at the transaction level.");
    }

    @Test
    public void testExecuteUpdateAsyncWithExcludeTxnFromChangeStreams() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        AsyncRunner runner = client.runAsync(new Options.TransactionOption[0]);
        SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> SpannerApiFutures.get((ApiFuture)runner.runAsync(txn -> {
            txn.executeUpdateAsync(UPDATE_STATEMENT, new Options.UpdateOption[]{Options.excludeTxnFromChangeStreams()});
            return ApiFutures.immediateFuture(null);
        }, (Executor)executor)));
        Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.INVALID_ARGUMENT);
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"Options.excludeTxnFromChangeStreams() cannot be specified for individual DML requests. This option should be set at the transaction level.");
    }

    @Test
    public void testAnalyzeUpdateWithExcludeTxnFromChangeStreams() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
        SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> runner.run(transaction -> transaction.analyzeUpdate(UPDATE_STATEMENT, ReadContext.QueryAnalyzeMode.PROFILE, new Options.UpdateOption[]{Options.excludeTxnFromChangeStreams()})));
        Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.INVALID_ARGUMENT);
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"Options.excludeTxnFromChangeStreams() cannot be specified for individual DML requests. This option should be set at the transaction level.");
    }

    @Test
    public void testAnalyzeUpdateStatementWithExcludeTxnFromChangeStreams() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
        SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> runner.run(transaction -> transaction.analyzeUpdateStatement(UPDATE_STATEMENT, ReadContext.QueryAnalyzeMode.PROFILE, new Options.UpdateOption[]{Options.excludeTxnFromChangeStreams()})));
        Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.INVALID_ARGUMENT);
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"Options.excludeTxnFromChangeStreams() cannot be specified for individual DML requests. This option should be set at the transaction level.");
    }

    @Test
    public void testBatchUpdateWithExcludeTxnFromChangeStreams() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
        SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> runner.run(transaction -> transaction.batchUpdate(Collections.singletonList(UPDATE_STATEMENT), new Options.UpdateOption[]{Options.excludeTxnFromChangeStreams()})));
        Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.INVALID_ARGUMENT);
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"Options.excludeTxnFromChangeStreams() cannot be specified for individual DML requests. This option should be set at the transaction level.");
    }

    @Test
    public void testBatchUpdateAsyncWithExcludeTxnFromChangeStreams() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        AsyncRunner runner = client.runAsync(new Options.TransactionOption[0]);
        SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> SpannerApiFutures.get((ApiFuture)runner.runAsync(txn -> {
            txn.batchUpdateAsync(Collections.singletonList(UPDATE_STATEMENT), new Options.UpdateOption[]{Options.excludeTxnFromChangeStreams()});
            return ApiFutures.immediateFuture(null);
        }, (Executor)executor)));
        Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.INVALID_ARGUMENT);
        Truth.assertThat((String)e.getMessage()).contains((CharSequence)"Options.excludeTxnFromChangeStreams() cannot be specified for individual DML requests. This option should be set at the transaction level.");
    }

    @Test
    public void singleUse() {
        DatabaseClientImpl client = (DatabaseClientImpl)this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        Set checkedOut = client.pool.checkedOutSessions;
        Truth.assertThat((Iterable)checkedOut).isEmpty();
        try (ResultSet rs = client.singleUse().executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);){
            Truth.assertThat((Boolean)rs.next()).isTrue();
            if (!this.isMultiplexedSessionsEnabled()) {
                Truth.assertThat((Iterable)checkedOut).hasSize(1);
            }
            Truth.assertThat((Long)rs.getLong(0)).isEqualTo((Object)1L);
            Truth.assertThat((Boolean)rs.next()).isFalse();
        }
        Truth.assertThat((Iterable)checkedOut).isEmpty();
    }

    @Test
    public void singleUseIsNonBlocking() {
        mockSpanner.freeze();
        DatabaseClient client = this.spannerWithEmptySessionPool.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        try (ResultSet rs = client.singleUse().executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);){
            mockSpanner.unfreeze();
            Truth.assertThat((Boolean)rs.next()).isTrue();
            Truth.assertThat((Long)rs.getLong(0)).isEqualTo((Object)1L);
            Truth.assertThat((Boolean)rs.next()).isFalse();
        }
    }

    @Test
    public void singleUseAsync() throws Exception {
        ApiFuture res;
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        AtomicInteger rowCount = new AtomicInteger();
        try (AsyncResultSet rs = client.singleUse().executeQueryAsync(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);){
            res = rs.setCallback((Executor)executor, resultSet -> {
                while (true) {
                    switch (resultSet.tryNext()) {
                        case OK: {
                            rowCount.incrementAndGet();
                            break;
                        }
                        case DONE: {
                            return AsyncResultSet.CallbackResponse.DONE;
                        }
                        case NOT_READY: {
                            return AsyncResultSet.CallbackResponse.CONTINUE;
                        }
                    }
                }
            });
        }
        res.get();
        Truth.assertThat((Integer)rowCount.get()).isEqualTo((Object)1);
    }

    @Test
    public void singleUseAsyncWithoutCallback() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        int rowCount = 0;
        try (AsyncResultSet rs = client.singleUse().executeQueryAsync(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);){
            while (rs.next()) {
                ++rowCount;
            }
        }
        Truth.assertThat((Integer)rowCount).isEqualTo((Object)1);
    }

    @Test
    public void singleUseBound() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        try (ResultSet rs = client.singleUse(TimestampBound.ofExactStaleness((long)15L, (TimeUnit)TimeUnit.SECONDS)).executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);){
            Truth.assertThat((Boolean)rs.next()).isTrue();
            Truth.assertThat((Long)rs.getLong(0)).isEqualTo((Object)1L);
            Truth.assertThat((Boolean)rs.next()).isFalse();
        }
    }

    @Test
    public void singleUseBoundIsNonBlocking() {
        mockSpanner.freeze();
        DatabaseClient client = this.spannerWithEmptySessionPool.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        try (ResultSet rs = client.singleUse(TimestampBound.ofExactStaleness((long)15L, (TimeUnit)TimeUnit.SECONDS)).executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);){
            mockSpanner.unfreeze();
            Truth.assertThat((Boolean)rs.next()).isTrue();
            Truth.assertThat((Long)rs.getLong(0)).isEqualTo((Object)1L);
            Truth.assertThat((Boolean)rs.next()).isFalse();
        }
    }

    @Test
    public void singleUseBoundAsync() throws Exception {
        ApiFuture res;
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        AtomicInteger rowCount = new AtomicInteger();
        try (AsyncResultSet rs = client.singleUse(TimestampBound.ofExactStaleness((long)15L, (TimeUnit)TimeUnit.SECONDS)).executeQueryAsync(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);){
            res = rs.setCallback((Executor)executor, resultSet -> {
                while (true) {
                    switch (resultSet.tryNext()) {
                        case OK: {
                            rowCount.incrementAndGet();
                            break;
                        }
                        case DONE: {
                            return AsyncResultSet.CallbackResponse.DONE;
                        }
                        case NOT_READY: {
                            return AsyncResultSet.CallbackResponse.CONTINUE;
                        }
                    }
                }
            });
        }
        res.get();
        Truth.assertThat((Integer)rowCount.get()).isEqualTo((Object)1);
    }

    @Test
    public void singleUseTransaction() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        try (ResultSet rs = client.singleUseReadOnlyTransaction().executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);){
            Truth.assertThat((Boolean)rs.next()).isTrue();
            Truth.assertThat((Long)rs.getLong(0)).isEqualTo((Object)1L);
            Truth.assertThat((Boolean)rs.next()).isFalse();
        }
    }

    @Test
    public void singleUseTransactionIsNonBlocking() {
        mockSpanner.freeze();
        DatabaseClient client = this.spannerWithEmptySessionPool.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        try (ResultSet rs = client.singleUseReadOnlyTransaction().executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);){
            mockSpanner.unfreeze();
            Truth.assertThat((Boolean)rs.next()).isTrue();
            Truth.assertThat((Long)rs.getLong(0)).isEqualTo((Object)1L);
            Truth.assertThat((Boolean)rs.next()).isFalse();
        }
    }

    @Test
    public void singleUseTransactionBound() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        try (ResultSet rs = client.singleUseReadOnlyTransaction(TimestampBound.ofExactStaleness((long)15L, (TimeUnit)TimeUnit.SECONDS)).executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);){
            Truth.assertThat((Boolean)rs.next()).isTrue();
            Truth.assertThat((Long)rs.getLong(0)).isEqualTo((Object)1L);
            Truth.assertThat((Boolean)rs.next()).isFalse();
        }
    }

    @Test
    public void singleUseTransactionBoundIsNonBlocking() {
        mockSpanner.freeze();
        DatabaseClient client = this.spannerWithEmptySessionPool.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        try (ResultSet rs = client.singleUseReadOnlyTransaction(TimestampBound.ofExactStaleness((long)15L, (TimeUnit)TimeUnit.SECONDS)).executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);){
            mockSpanner.unfreeze();
            Truth.assertThat((Boolean)rs.next()).isTrue();
            Truth.assertThat((Long)rs.getLong(0)).isEqualTo((Object)1L);
            Truth.assertThat((Boolean)rs.next()).isFalse();
        }
    }

    @Test
    public void readOnlyTransaction() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        try (ReadOnlyTransaction tx = client.readOnlyTransaction();
             ResultSet rs = tx.executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);){
            Truth.assertThat((Boolean)rs.next()).isTrue();
            Truth.assertThat((Long)rs.getLong(0)).isEqualTo((Object)1L);
            Truth.assertThat((Boolean)rs.next()).isFalse();
        }
    }

    @Test
    public void readOnlyTransactionIsNonBlocking() {
        mockSpanner.freeze();
        DatabaseClient client = this.spannerWithEmptySessionPool.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        try (ReadOnlyTransaction tx = client.readOnlyTransaction();
             ResultSet rs = tx.executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);){
            mockSpanner.unfreeze();
            Truth.assertThat((Boolean)rs.next()).isTrue();
            Truth.assertThat((Long)rs.getLong(0)).isEqualTo((Object)1L);
            Truth.assertThat((Boolean)rs.next()).isFalse();
        }
    }

    @Test
    public void readOnlyTransactionBound() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        try (ReadOnlyTransaction tx = client.readOnlyTransaction(TimestampBound.ofExactStaleness((long)15L, (TimeUnit)TimeUnit.SECONDS));
             ResultSet rs = tx.executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);){
            Truth.assertThat((Boolean)rs.next()).isTrue();
            Truth.assertThat((Long)rs.getLong(0)).isEqualTo((Object)1L);
            Truth.assertThat((Boolean)rs.next()).isFalse();
        }
    }

    @Test
    public void readOnlyTransactionBoundIsNonBlocking() {
        mockSpanner.freeze();
        DatabaseClient client = this.spannerWithEmptySessionPool.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        try (ReadOnlyTransaction tx = client.readOnlyTransaction(TimestampBound.ofExactStaleness((long)15L, (TimeUnit)TimeUnit.SECONDS));
             ResultSet rs = tx.executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);){
            mockSpanner.unfreeze();
            Truth.assertThat((Boolean)rs.next()).isTrue();
            Truth.assertThat((Long)rs.getLong(0)).isEqualTo((Object)1L);
            Truth.assertThat((Boolean)rs.next()).isFalse();
        }
    }

    @Test
    public void testReadWriteTransaction() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
        runner.run(transaction -> {
            transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]);
            return null;
        });
        Assert.assertNotNull((Object)runner.getCommitTimestamp());
    }

    @Test
    public void testReadWriteTransaction_returnsCommitStats() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[]{Options.commitStats()});
        runner.run(transaction -> {
            transaction.buffer(Mutation.delete((String)"FOO", (Key)Key.of((Object[])new Object[]{"foo"})));
            return null;
        });
        Assert.assertNotNull((Object)runner.getCommitResponse());
        Assert.assertNotNull((Object)runner.getCommitResponse().getCommitStats());
        Assert.assertEquals((long)1L, (long)runner.getCommitResponse().getCommitStats().getMutationCount());
    }

    @Test
    public void readWriteTransactionIsNonBlocking() {
        mockSpanner.freeze();
        DatabaseClient client = this.spannerWithEmptySessionPool.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
        mockSpanner.unfreeze();
        runner.run(transaction -> {
            transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]);
            return null;
        });
    }

    @Test
    public void testRunAsync() throws Exception {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        ExecutorService executor = Executors.newSingleThreadExecutor();
        AsyncRunner runner = client.runAsync(new Options.TransactionOption[0]);
        ApiFuture result = runner.runAsync(txn -> ApiFutures.immediateFuture((Object)txn.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0])), (Executor)executor);
        Assert.assertEquals((long)1L, (long)((Long)result.get()));
        Assert.assertNotNull((Object)runner.getCommitTimestamp().get());
        executor.shutdown();
    }

    @Test
    public void testRunAsync_returnsCommitStats() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        ExecutorService executor = Executors.newSingleThreadExecutor();
        AsyncRunner runner = client.runAsync(new Options.TransactionOption[]{Options.commitStats()});
        ApiFuture result = runner.runAsync(txn -> {
            txn.buffer(Mutation.delete((String)"FOO", (Key)Key.of((Object[])new Object[]{"foo"})));
            return ApiFutures.immediateFuture(null);
        }, (Executor)executor);
        Assert.assertNull((Object)SpannerApiFutures.get((ApiFuture)result));
        Assert.assertNotNull((Object)SpannerApiFutures.get((ApiFuture)runner.getCommitResponse()));
        Assert.assertNotNull((Object)((CommitResponse)SpannerApiFutures.get((ApiFuture)runner.getCommitResponse())).getCommitStats());
        Assert.assertEquals((long)1L, (long)((CommitResponse)SpannerApiFutures.get((ApiFuture)runner.getCommitResponse())).getCommitStats().getMutationCount());
        executor.shutdown();
    }

    @Test
    public void runAsyncIsNonBlocking() throws Exception {
        mockSpanner.freeze();
        DatabaseClient client = this.spannerWithEmptySessionPool.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        ExecutorService executor = Executors.newSingleThreadExecutor();
        AsyncRunner runner = client.runAsync(new Options.TransactionOption[0]);
        ApiFuture fut = runner.runAsync(txn -> ApiFutures.immediateFuture((Object)txn.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0])), (Executor)executor);
        mockSpanner.unfreeze();
        Truth.assertThat((Long)((Long)fut.get())).isEqualTo((Object)1L);
        executor.shutdown();
    }

    @Test
    public void runAsyncWithException() throws Exception {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        ExecutorService executor = Executors.newSingleThreadExecutor();
        AsyncRunner runner = client.runAsync(new Options.TransactionOption[0]);
        ApiFuture fut = runner.runAsync(txn -> ApiFutures.immediateFuture((Object)txn.executeUpdate(INVALID_UPDATE_STATEMENT, new Options.UpdateOption[0])), (Executor)executor);
        ExecutionException e = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> fut.get());
        Truth.assertThat((Throwable)e.getCause()).isInstanceOf(SpannerException.class);
        SpannerException se = (SpannerException)e.getCause();
        Truth.assertThat((Comparable)se.getErrorCode()).isEqualTo((Object)ErrorCode.INVALID_ARGUMENT);
        executor.shutdown();
    }

    @Test
    public void testTransactionManager() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[0]);){
            TransactionContext transaction = manager.begin();
            while (true) {
                try {
                    transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]);
                    manager.commit();
                    Assert.assertNotNull((Object)manager.getCommitTimestamp());
                }
                catch (AbortedException e) {
                    transaction = manager.resetForRetry();
                    continue;
                }
                break;
            }
        }
    }

    @Test
    public void testTransactionManager_returnsCommitStats() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[]{Options.commitStats()});){
            TransactionContext transaction = manager.begin();
            while (true) {
                try {
                    transaction.buffer(Mutation.delete((String)"FOO", (Key)Key.of((Object[])new Object[]{"foo"})));
                    manager.commit();
                    Assert.assertNotNull((Object)manager.getCommitResponse());
                    Assert.assertNotNull((Object)manager.getCommitResponse().getCommitStats());
                    Assert.assertEquals((long)1L, (long)manager.getCommitResponse().getCommitStats().getMutationCount());
                }
                catch (AbortedException e) {
                    transaction = manager.resetForRetry();
                    continue;
                }
                break;
            }
        }
    }

    @Test
    public void transactionManagerIsNonBlocking() throws Exception {
        mockSpanner.freeze();
        DatabaseClient client = this.spannerWithEmptySessionPool.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        try (TransactionManager txManager = client.transactionManager(new Options.TransactionOption[0]);){
            mockSpanner.unfreeze();
            TransactionContext transaction = txManager.begin();
            while (true) {
                try {
                    transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]);
                    txManager.commit();
                }
                catch (AbortedException e) {
                    Thread.sleep(e.getRetryDelayInMillis());
                    transaction = txManager.resetForRetry();
                    continue;
                }
                break;
            }
        }
    }

    @Test
    public void transactionManagerExecuteQueryAsync() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        AtomicInteger rowCount = new AtomicInteger();
        try (TransactionManager txManager = client.transactionManager(new Options.TransactionOption[0]);){
            TransactionContext transaction = txManager.begin();
            while (true) {
                try {
                    try (AsyncResultSet rs = transaction.executeQueryAsync(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);){
                        rs.setCallback((Executor)executor, resultSet -> {
                            try {
                                while (true) {
                                    switch (resultSet.tryNext()) {
                                        case OK: {
                                            rowCount.incrementAndGet();
                                            break;
                                        }
                                        case DONE: {
                                            return AsyncResultSet.CallbackResponse.DONE;
                                        }
                                        case NOT_READY: {
                                            return AsyncResultSet.CallbackResponse.CONTINUE;
                                        }
                                    }
                                }
                            }
                            catch (Throwable t) {
                                return AsyncResultSet.CallbackResponse.DONE;
                            }
                        });
                    }
                    txManager.commit();
                }
                catch (AbortedException e) {
                    transaction = txManager.resetForRetry();
                    continue;
                }
                break;
            }
        }
        Truth.assertThat((Integer)rowCount.get()).isEqualTo((Object)1);
    }

    @Test
    public void testExecutePartitionedDml() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        long updateCount = client.executePartitionedUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]);
        Truth.assertThat((Long)updateCount).isEqualTo((Object)1L);
    }

    @Test
    public void testExecutePartitionedDmlAborted() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        mockSpanner.abortNextTransaction();
        long updateCount = client.executePartitionedUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]);
        Truth.assertThat((Long)updateCount).isEqualTo((Object)1L);
    }

    @Test(expected=SpannerException.class)
    public void testExecutePartitionedDmlWithQuery() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        client.executePartitionedUpdate(MockSpannerTestUtil.SELECT1, new Options.UpdateOption[0]);
    }

    @Test(expected=SpannerException.class)
    public void testExecutePartitionedDmlWithException() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        client.executePartitionedUpdate(INVALID_UPDATE_STATEMENT, new Options.UpdateOption[0]);
    }

    @Test
    public void testPartitionedDmlDoesNotTimeout() {
        mockSpanner.setExecuteSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(20, 0));
        RetrySettings retrySettings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(java.time.Duration.ofMillis(1L)).setMaxRpcTimeoutDuration(java.time.Duration.ofMillis(1L)).setMaxAttempts(1).setTotalTimeoutDuration(java.time.Duration.ofMillis(1L)).build();
        SpannerOptions.Builder builder = (SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(TEST_PROJECT)).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance());
        builder.getSpannerStubSettingsBuilder().executeSqlSettings().setRetrySettings(retrySettings);
        try (Spanner spanner = (Spanner)builder.build().getService();){
            DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
            Truth.assertThat((Comparable)((SpannerOptions)spanner.getOptions()).getPartitionedDmlTimeoutDuration()).isEqualTo((Object)java.time.Duration.ofHours(2L));
            long updateCount = client.executePartitionedUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]);
            Truth.assertThat((Long)updateCount).isEqualTo((Object)1L);
            SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
                transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]);
                return null;
            }));
            Assert.assertEquals((Object)ErrorCode.DEADLINE_EXCEEDED, (Object)e.getErrorCode());
        }
    }

    @Test
    public void testPartitionedDmlWithLowerTimeout() {
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(1000, 0));
        SpannerOptions.Builder builder = (SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(TEST_PROJECT)).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance());
        builder.setPartitionedDmlTimeoutDuration(java.time.Duration.ofMillis(10L));
        try (Spanner spanner = (Spanner)builder.build().getService();){
            DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
            Truth.assertThat((Comparable)((SpannerOptions)spanner.getOptions()).getPartitionedDmlTimeoutDuration()).isEqualTo((Object)java.time.Duration.ofMillis(10L));
            mockSpanner.setExecuteSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(1000, 0));
            SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> client.executePartitionedUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]));
            Assert.assertEquals((Object)ErrorCode.DEADLINE_EXCEEDED, (Object)e.getErrorCode());
            mockSpanner.setExecuteSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10, 0));
            Long updateCount = (Long)client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]));
            Truth.assertThat((Long)updateCount).isEqualTo((Object)1L);
        }
    }

    @Test
    public void testPartitionedDmlWithHigherTimeout() {
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(100, 0));
        SpannerOptions.Builder builder = (SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(TEST_PROJECT)).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance());
        builder.setPartitionedDmlTimeoutDuration(java.time.Duration.ofMillis(5000L));
        builder.getSpannerStubSettingsBuilder().executeSqlSettings().setRetrySettings(builder.getSpannerStubSettingsBuilder().executeSqlSettings().getRetrySettings().toBuilder().setInitialRpcTimeoutDuration(java.time.Duration.ofMillis(10L)).setMaxRpcTimeoutDuration(java.time.Duration.ofMillis(10L)).setInitialRetryDelayDuration(java.time.Duration.ofMillis(1L)).setMaxRetryDelayDuration(java.time.Duration.ofMillis(1L)).build());
        try (Spanner spanner = (Spanner)builder.build().getService();){
            DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
            long updateCount = client.executePartitionedUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]);
            mockSpanner.setExecuteSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(100, 0));
            SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0])));
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.DEADLINE_EXCEEDED);
            Truth.assertThat((Long)updateCount).isEqualTo((Object)1L);
        }
    }

    @Test
    public void testPartitionedDmlRetriesOnUnavailable() {
        mockSpanner.setExecuteSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)Status.UNAVAILABLE.asRuntimeException()));
        SpannerOptions.Builder builder = (SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(TEST_PROJECT)).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance());
        try (Spanner spanner = (Spanner)builder.build().getService();){
            DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
            long updateCount = client.executePartitionedUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]);
            Truth.assertThat((Long)updateCount).isEqualTo((Object)1L);
        }
    }

    @Test
    public void testDatabaseOrInstanceDoesNotExistOnInitialization() throws Exception {
        StatusRuntimeException[] exceptions;
        for (StatusRuntimeException exception : exceptions = new StatusRuntimeException[]{SpannerExceptionFactoryTest.newStatusResourceNotFoundException("Database", "type.googleapis.com/google.spanner.admin.database.v1.Database", DATABASE_NAME), SpannerExceptionFactoryTest.newStatusResourceNotFoundException("Instance", "type.googleapis.com/google.spanner.admin.instance.v1.Instance", INSTANCE_NAME)}) {
            try (Spanner spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(TEST_PROJECT)).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).build().getService();){
                mockSpanner.setBatchCreateSessionsExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofStickyException((Exception)exception));
                DatabaseClientImpl dbClient = (DatabaseClientImpl)spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
                Stopwatch watch = Stopwatch.createStarted();
                while (watch.elapsed(TimeUnit.SECONDS) < 5L && dbClient.pool.getNumberOfSessionsBeingCreated() > 0) {
                    Thread.sleep(1L);
                }
                Truth.assertThat((Integer)dbClient.pool.getNumberOfSessionsInPool()).isEqualTo((Object)0);
                Truth.assertThat((Integer)dbClient.pool.getNumberOfSessionsBeingCreated()).isEqualTo((Object)0);
                mockSpanner.reset();
                mockSpanner.removeAllExecutionTimes();
            }
        }
    }

    @Test
    public void testDatabaseOrInstanceDoesNotExistOnCreate() {
        for (java.time.Duration waitForMinSessions : ImmutableList.of((Object)java.time.Duration.ZERO, (Object)java.time.Duration.ofSeconds(5L))) {
            StatusRuntimeException[] exceptions;
            for (StatusRuntimeException exception : exceptions = new StatusRuntimeException[]{SpannerExceptionFactoryTest.newStatusResourceNotFoundException("Database", "type.googleapis.com/google.spanner.admin.database.v1.Database", DATABASE_NAME), SpannerExceptionFactoryTest.newStatusResourceNotFoundException("Instance", "type.googleapis.com/google.spanner.admin.instance.v1.Instance", INSTANCE_NAME)}) {
                block15: {
                    mockSpanner.setCreateSessionExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofStickyException((Exception)exception));
                    mockSpanner.setBatchCreateSessionsExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofStickyException((Exception)exception));
                    try (Spanner spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(TEST_PROJECT)).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).setSessionPoolOption(SessionPoolOptions.newBuilder().setMinSessions(0).setWaitForMinSessionsDuration(waitForMinSessions).build()).build().getService();){
                        boolean useMultiplexedSession = ((SpannerOptions)spanner.getOptions()).getSessionPoolOptions().getUseMultiplexedSession();
                        DatabaseId databaseId = DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE);
                        if (useMultiplexedSession && !waitForMinSessions.isZero()) {
                            Assert.assertThrows(SpannerException.ResourceNotFoundException.class, () -> spanner.getDatabaseClient(databaseId));
                            break block15;
                        }
                        mockSpanner.freeze();
                        DatabaseClientImpl dbClient = (DatabaseClientImpl)spanner.getDatabaseClient(databaseId);
                        try (ResultSet rs = dbClient.singleUse().executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);){
                            mockSpanner.unfreeze();
                            Assert.assertThrows(SpannerException.ResourceNotFoundException.class, () -> ((ResultSet)rs).next());
                            Truth.assertThat(mockSpanner.getRequests()).hasSize(1);
                        }
                        Assert.assertThrows(SpannerException.ResourceNotFoundException.class, () -> dbClient.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0])));
                        Truth.assertThat(mockSpanner.getRequests()).hasSize(((SpannerOptions)spanner.getOptions()).getSessionPoolOptions().getUseMultiplexedSession() ? 2 : 1);
                    }
                }
                mockSpanner.reset();
                mockSpanner.removeAllExecutionTimes();
            }
        }
    }

    @Test
    public void testDatabaseOrInstanceDoesNotExistOnReplenish() throws Exception {
        StatusRuntimeException[] exceptions;
        for (StatusRuntimeException exception : exceptions = new StatusRuntimeException[]{SpannerExceptionFactoryTest.newStatusResourceNotFoundException("Database", "type.googleapis.com/google.spanner.admin.database.v1.Database", DATABASE_NAME), SpannerExceptionFactoryTest.newStatusResourceNotFoundException("Instance", "type.googleapis.com/google.spanner.admin.instance.v1.Instance", INSTANCE_NAME)}) {
            try (Spanner spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(TEST_PROJECT)).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).build().getService();){
                mockSpanner.setBatchCreateSessionsExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofStickyException((Exception)exception));
                DatabaseClientImpl dbClient = (DatabaseClientImpl)spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
                Stopwatch watch = Stopwatch.createStarted();
                while (watch.elapsed(TimeUnit.SECONDS) < 5L && dbClient.pool.getNumberOfSessionsBeingCreated() > 0) {
                    Thread.sleep(1L);
                }
                Truth.assertThat((Integer)dbClient.pool.getNumberOfSessionsInPool()).isEqualTo((Object)0);
                Truth.assertThat((Integer)dbClient.pool.getNumberOfSessionsBeingCreated()).isEqualTo((Object)0);
                dbClient.pool.poolMaintainer.maintainPool();
                watch.reset().start();
                while (watch.elapsed(TimeUnit.SECONDS) < 5L && dbClient.pool.getNumberOfSessionsBeingCreated() > 0) {
                    Thread.sleep(1L);
                }
                Truth.assertThat((Integer)dbClient.pool.getNumberOfSessionsInPool()).isEqualTo((Object)0);
                Truth.assertThat((Integer)dbClient.pool.getNumberOfSessionsBeingCreated()).isEqualTo((Object)0);
            }
            mockSpanner.reset();
            mockSpanner.removeAllExecutionTimes();
        }
    }

    @Test
    public void testDatabaseOrInstanceIsDeletedAndThenRecreated() throws Exception {
        StatusRuntimeException[] exceptions;
        for (StatusRuntimeException exception : exceptions = new StatusRuntimeException[]{SpannerExceptionFactoryTest.newStatusResourceNotFoundException("Database", "type.googleapis.com/google.spanner.admin.database.v1.Database", DATABASE_NAME), SpannerExceptionFactoryTest.newStatusResourceNotFoundException("Instance", "type.googleapis.com/google.spanner.admin.instance.v1.Instance", INSTANCE_NAME)}) {
            try (Spanner spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(TEST_PROJECT)).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).build().getService();){
                DatabaseClientImpl dbClient = (DatabaseClientImpl)spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
                Stopwatch watch = Stopwatch.createStarted();
                while (watch.elapsed(TimeUnit.SECONDS) < 5L && dbClient.pool.getNumberOfSessionsBeingCreated() > 0) {
                    Thread.sleep(1L);
                }
                mockSpanner.setStickyGlobalExceptions(true);
                mockSpanner.addException((Exception)exception);
                try (ResultSet rs = dbClient.singleUse().executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);){
                    Assert.assertThrows(SpannerException.ResourceNotFoundException.class, () -> ((ResultSet)rs).next());
                }
                Assert.assertThrows(SpannerException.ResourceNotFoundException.class, () -> dbClient.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> null));
                mockSpanner.reset();
                if (!((SpannerOptions)spanner.getOptions()).getSessionPoolOptions().getUseMultiplexedSession()) {
                    Assert.assertThrows(SpannerException.ResourceNotFoundException.class, () -> dbClient.singleUse().executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]));
                }
                if (!((SpannerOptions)spanner.getOptions()).getSessionPoolOptions().getUseMultiplexedSessionForRW()) {
                    Assert.assertThrows(SpannerException.ResourceNotFoundException.class, () -> dbClient.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> null));
                }
                Truth.assertThat(mockSpanner.getRequests()).isEmpty();
                DatabaseClientImpl newClient = (DatabaseClientImpl)spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
                Truth.assertThat((Object)newClient).isNotSameInstanceAs((Object)dbClient);
                try (ResultSet rs = newClient.singleUse().executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);){
                    this.consumeResults(rs);
                }
                Truth.assertThat(mockSpanner.getRequests()).isNotEmpty();
            }
            mockSpanner.reset();
            mockSpanner.removeAllExecutionTimes();
        }
    }

    @Test
    public void testGetInvalidatedClientMultipleTimes() {
        StatusRuntimeException[] exceptions;
        for (StatusRuntimeException exception : exceptions = new StatusRuntimeException[]{SpannerExceptionFactoryTest.newStatusResourceNotFoundException("Database", "type.googleapis.com/google.spanner.admin.database.v1.Database", DATABASE_NAME), SpannerExceptionFactoryTest.newStatusResourceNotFoundException("Instance", "type.googleapis.com/google.spanner.admin.instance.v1.Instance", INSTANCE_NAME)}) {
            mockSpanner.setCreateSessionExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofStickyException((Exception)exception));
            mockSpanner.setBatchCreateSessionsExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofStickyException((Exception)exception));
            try (Spanner spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(TEST_PROJECT)).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).setSessionPoolOption(SessionPoolOptions.newBuilder().setMinSessions(0).build()).build().getService();){
                for (int run = 0; run < 2; ++run) {
                    DatabaseClientImpl dbClient = (DatabaseClientImpl)spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
                    for (int useClient = 0; useClient < 2; ++useClient) {
                        Assert.assertThrows(SpannerException.ResourceNotFoundException.class, () -> dbClient.singleUse().executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]).next());
                        if (((SpannerOptions)spanner.getOptions()).getSessionPoolOptions().getUseMultiplexedSession()) {
                            Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CreateSessionRequest.class));
                            Assert.assertEquals((long)0L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
                            continue;
                        }
                        Truth.assertThat(mockSpanner.getRequests()).hasSize(run + 1);
                        Truth.assertThat((Boolean)dbClient.pool.isValid()).isFalse();
                    }
                }
            }
            mockSpanner.reset();
            mockSpanner.removeAllExecutionTimes();
        }
    }

    @Test
    public void testAllowNestedTransactions() throws InterruptedException {
        DatabaseClientImpl client = (DatabaseClientImpl)this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        int minSessions = ((SpannerOptions)this.spanner.getOptions()).getSessionPoolOptions().getMinSessions();
        Stopwatch watch = Stopwatch.createStarted();
        while (watch.elapsed(TimeUnit.SECONDS) < 5L && client.pool.getNumberOfSessionsInPool() < minSessions) {
            Thread.sleep(1L);
        }
        Truth.assertThat((Integer)client.pool.getNumberOfSessionsInPool()).isEqualTo((Object)minSessions);
        int expectedMinSessions = ((SpannerOptions)this.spanner.getOptions()).getSessionPoolOptions().getUseMultiplexedSessionForRW() ? minSessions : minSessions - 1;
        Long res = (Long)client.readWriteTransaction(new Options.TransactionOption[0]).allowNestedTransaction().run(transaction -> {
            Truth.assertThat((Integer)client.pool.getNumberOfSessionsInPool()).isEqualTo((Object)expectedMinSessions);
            return transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]);
        });
        Truth.assertThat((Long)res).isEqualTo((Object)1L);
        Truth.assertThat((Integer)client.pool.getNumberOfSessionsInPool()).isEqualTo((Object)minSessions);
    }

    @Test
    public void testNestedTransactionsUsingTwoDatabases() throws InterruptedException {
        DatabaseClientImpl client1 = (DatabaseClientImpl)this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)"my-database-1"));
        DatabaseClientImpl client2 = (DatabaseClientImpl)this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)"my-database-2"));
        int minSessions = ((SpannerOptions)this.spanner.getOptions()).getSessionPoolOptions().getMinSessions();
        Stopwatch watch = Stopwatch.createStarted();
        while (watch.elapsed(TimeUnit.SECONDS) < 5L && (client1.pool.getNumberOfSessionsInPool() < minSessions || client2.pool.getNumberOfSessionsInPool() < minSessions)) {
            Thread.sleep(1L);
        }
        Truth.assertThat((Integer)client1.pool.getNumberOfSessionsInPool()).isEqualTo((Object)minSessions);
        Truth.assertThat((Integer)client2.pool.getNumberOfSessionsInPool()).isEqualTo((Object)minSessions);
        int expectedMinSessions = this.isMultiplexedSessionsEnabledForRW() ? minSessions : minSessions - 1;
        Long res = (Long)client1.readWriteTransaction(new Options.TransactionOption[0]).allowNestedTransaction().run(transaction -> {
            Truth.assertThat((Integer)client1.pool.getNumberOfSessionsInPool()).isEqualTo((Object)expectedMinSessions);
            Truth.assertThat((Integer)client2.pool.getNumberOfSessionsInPool()).isEqualTo((Object)minSessions);
            Long add = (Long)client2.readWriteTransaction(new Options.TransactionOption[0]).run(transaction1 -> {
                Truth.assertThat((Integer)client1.pool.getNumberOfSessionsInPool()).isEqualTo((Object)expectedMinSessions);
                Truth.assertThat((Integer)client2.pool.getNumberOfSessionsInPool()).isEqualTo((Object)expectedMinSessions);
                try (ResultSet rs = transaction1.executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);){
                    if (rs.next()) {
                        Long l = rs.getLong(0);
                        return l;
                    }
                    Long l = 0L;
                    return l;
                }
            });
            Assert.assertNotNull((Object)add);
            try (ResultSet rs = transaction.executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);){
                if (rs.next()) {
                    Long l = add + rs.getLong(0);
                    return l;
                }
                Long l = add;
                return l;
            }
        });
        Truth.assertThat((Long)res).isEqualTo((Object)2L);
        Truth.assertThat((Integer)client1.pool.getNumberOfSessionsInPool()).isEqualTo((Object)minSessions);
        Truth.assertThat((Integer)client2.pool.getNumberOfSessionsInPool()).isEqualTo((Object)minSessions);
    }

    @Test
    public void testBackendQueryOptions() {
        try (Spanner spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("[PROJECT]")).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).setSessionPoolOption(SessionPoolOptions.newBuilder().setMinSessions(0).build()).build().getService();){
            DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE"));
            try (ResultSet rs = client.singleUse().executeQuery(Statement.newBuilder((String)MockSpannerTestUtil.SELECT1.getSql()).withQueryOptions(ExecuteSqlRequest.QueryOptions.newBuilder().setOptimizerVersion("1").setOptimizerStatisticsPackage("custom-package").build()).build(), new Options.QueryOption[0]);){
                this.consumeResults(rs);
            }
            List<AbstractMessage> requests = mockSpanner.getRequests();
            Truth.assertThat(requests).isNotEmpty();
            Truth.assertThat((Object)requests.get(requests.size() - 1)).isInstanceOf(ExecuteSqlRequest.class);
            ExecuteSqlRequest request = (ExecuteSqlRequest)requests.get(requests.size() - 1);
            Truth.assertThat((Object)request.getQueryOptions()).isNotNull();
            Truth.assertThat((String)request.getQueryOptions().getOptimizerVersion()).isEqualTo((Object)"1");
            Truth.assertThat((String)request.getQueryOptions().getOptimizerStatisticsPackage()).isEqualTo((Object)"custom-package");
        }
    }

    @Test
    public void testBackendQueryOptionsWithAnalyzeQuery() {
        try (Spanner spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("[PROJECT]")).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).setSessionPoolOption(SessionPoolOptions.newBuilder().setMinSessions(0).build()).build().getService();){
            DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE"));
            try (ReadOnlyTransaction tx = client.readOnlyTransaction();
                 ResultSet rs = tx.analyzeQuery(Statement.newBuilder((String)MockSpannerTestUtil.SELECT1.getSql()).withQueryOptions(ExecuteSqlRequest.QueryOptions.newBuilder().setOptimizerVersion("1").setOptimizerStatisticsPackage("custom-package").build()).build(), ReadContext.QueryAnalyzeMode.PROFILE);){
                this.consumeResults(rs);
            }
            List<AbstractMessage> requests = mockSpanner.getRequests();
            Truth.assertThat(requests).isNotEmpty();
            Truth.assertThat((Object)requests.get(requests.size() - 1)).isInstanceOf(ExecuteSqlRequest.class);
            ExecuteSqlRequest request = (ExecuteSqlRequest)requests.get(requests.size() - 1);
            Truth.assertThat((Object)request.getQueryOptions()).isNotNull();
            Truth.assertThat((String)request.getQueryOptions().getOptimizerVersion()).isEqualTo((Object)"1");
            Truth.assertThat((String)request.getQueryOptions().getOptimizerStatisticsPackage()).isEqualTo((Object)"custom-package");
            Truth.assertThat((Comparable)request.getQueryMode()).isEqualTo((Object)ExecuteSqlRequest.QueryMode.PROFILE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBackendPartitionQueryOptions() {
        try (Spanner spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("[PROJECT]")).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).setSessionPoolOption(SessionPoolOptions.newBuilder().setMinSessions(0).build()).setDirectedReadOptions(DIRECTED_READ_OPTIONS2).build().getService();){
            BatchClient client = spanner.getBatchClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE"));
            BatchReadOnlyTransaction transaction = client.batchReadOnlyTransaction(TimestampBound.strong());
            List partitions = transaction.partitionQuery(PartitionOptions.newBuilder().setMaxPartitions(10L).build(), Statement.newBuilder((String)MockSpannerTestUtil.SELECT1.getSql()).withQueryOptions(ExecuteSqlRequest.QueryOptions.newBuilder().setOptimizerVersion("1").setOptimizerStatisticsPackage("custom-package").build()).build(), new Options.QueryOption[]{Options.directedRead((DirectedReadOptions)DIRECTED_READ_OPTIONS1)});
            try (ResultSet rs = transaction.execute((Partition)partitions.get(0));){
                this.consumeResults(rs);
            }
            finally {
                transaction.cleanup();
            }
            List<AbstractMessage> requests = mockSpanner.getRequests();
            assert (requests.size() >= 2) : "required to have at least 2 requests";
            Truth.assertThat((Object)requests.get(requests.size() - 1)).isInstanceOf(DeleteSessionRequest.class);
            Truth.assertThat((Object)requests.get(requests.size() - 2)).isInstanceOf(ExecuteSqlRequest.class);
            ExecuteSqlRequest executeSqlRequest = (ExecuteSqlRequest)requests.get(requests.size() - 2);
            Truth.assertThat((Object)executeSqlRequest.getQueryOptions()).isNotNull();
            Truth.assertThat((String)executeSqlRequest.getQueryOptions().getOptimizerVersion()).isEqualTo((Object)"1");
            Truth.assertThat((String)executeSqlRequest.getQueryOptions().getOptimizerStatisticsPackage()).isEqualTo((Object)"custom-package");
            Truth.assertThat((Object)executeSqlRequest.getDirectedReadOptions()).isEqualTo((Object)DIRECTED_READ_OPTIONS1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBackendPartitionQueryOptions_whenDirectedReadOptionsViaSpannerOptions_assertOptions() {
        try (Spanner spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("[PROJECT]")).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).setSessionPoolOption(SessionPoolOptions.newBuilder().setMinSessions(0).build()).setDirectedReadOptions(DIRECTED_READ_OPTIONS2).build().getService();){
            BatchClient client = spanner.getBatchClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE"));
            BatchReadOnlyTransaction transaction = client.batchReadOnlyTransaction(TimestampBound.strong());
            List partitions = transaction.partitionQuery(PartitionOptions.newBuilder().setMaxPartitions(10L).build(), Statement.newBuilder((String)MockSpannerTestUtil.SELECT1.getSql()).withQueryOptions(ExecuteSqlRequest.QueryOptions.newBuilder().setOptimizerVersion("1").setOptimizerStatisticsPackage("custom-package").build()).build(), new Options.QueryOption[0]);
            try (ResultSet rs = transaction.execute((Partition)partitions.get(0));){
                this.consumeResults(rs);
            }
            finally {
                transaction.cleanup();
            }
            List<AbstractMessage> requests = mockSpanner.getRequests();
            assert (requests.size() >= 2) : "required to have at least 2 requests";
            Truth.assertThat((Object)requests.get(requests.size() - 1)).isInstanceOf(DeleteSessionRequest.class);
            Truth.assertThat((Object)requests.get(requests.size() - 2)).isInstanceOf(ExecuteSqlRequest.class);
            ExecuteSqlRequest executeSqlRequest = (ExecuteSqlRequest)requests.get(requests.size() - 2);
            Truth.assertThat((Object)executeSqlRequest.getQueryOptions()).isNotNull();
            Truth.assertThat((String)executeSqlRequest.getQueryOptions().getOptimizerVersion()).isEqualTo((Object)"1");
            Truth.assertThat((String)executeSqlRequest.getQueryOptions().getOptimizerStatisticsPackage()).isEqualTo((Object)"custom-package");
            Truth.assertThat((Object)executeSqlRequest.getDirectedReadOptions()).isEqualTo((Object)DIRECTED_READ_OPTIONS2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBackendPartitionReadOptions() {
        try (Spanner spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("[PROJECT]")).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).setSessionPoolOption(SessionPoolOptions.newBuilder().setMinSessions(0).build()).setDirectedReadOptions(DIRECTED_READ_OPTIONS2).build().getService();){
            BatchClient client = spanner.getBatchClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE"));
            BatchReadOnlyTransaction transaction = client.batchReadOnlyTransaction(TimestampBound.strong());
            List partitions = transaction.partitionRead(PartitionOptions.newBuilder().setMaxPartitions(10L).build(), "FOO", KeySet.all(), (Iterable)Lists.newArrayList((Object[])new String[]{"1"}), new Options.ReadOption[]{Options.directedRead((DirectedReadOptions)DIRECTED_READ_OPTIONS1)});
            try (ResultSet rs = transaction.execute((Partition)partitions.get(0));){
                this.consumeResults(rs);
            }
            finally {
                transaction.cleanup();
            }
            List<AbstractMessage> requests = mockSpanner.getRequests();
            assert (requests.size() >= 2) : "required to have at least 2 requests";
            Truth.assertThat((Object)requests.get(requests.size() - 1)).isInstanceOf(DeleteSessionRequest.class);
            Truth.assertThat((Object)requests.get(requests.size() - 2)).isInstanceOf(ReadRequest.class);
            ReadRequest readRequest = (ReadRequest)requests.get(requests.size() - 2);
            Truth.assertThat((Object)readRequest.getDirectedReadOptions()).isEqualTo((Object)DIRECTED_READ_OPTIONS1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBackendPartitionReadOptions_whenDirectedReadOptionsViaSpannerOptions_assertOptions() {
        try (Spanner spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("[PROJECT]")).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).setSessionPoolOption(SessionPoolOptions.newBuilder().setMinSessions(0).build()).setDirectedReadOptions(DIRECTED_READ_OPTIONS2).build().getService();){
            BatchClient client = spanner.getBatchClient(DatabaseId.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE"));
            BatchReadOnlyTransaction transaction = client.batchReadOnlyTransaction(TimestampBound.strong());
            List partitions = transaction.partitionRead(PartitionOptions.newBuilder().setMaxPartitions(10L).build(), "FOO", KeySet.all(), (Iterable)Lists.newArrayList((Object[])new String[]{"1"}), new Options.ReadOption[0]);
            try (ResultSet rs = transaction.execute((Partition)partitions.get(0));){
                while (rs.next()) {
                }
            }
            finally {
                transaction.cleanup();
            }
            List<AbstractMessage> requests = mockSpanner.getRequests();
            assert (requests.size() >= 2) : "required to have at least 2 requests";
            Truth.assertThat((Object)requests.get(requests.size() - 1)).isInstanceOf(DeleteSessionRequest.class);
            Truth.assertThat((Object)requests.get(requests.size() - 2)).isInstanceOf(ReadRequest.class);
            ReadRequest readRequest = (ReadRequest)requests.get(requests.size() - 2);
            Truth.assertThat((Object)readRequest.getDirectedReadOptions()).isEqualTo((Object)DIRECTED_READ_OPTIONS2);
        }
    }

    @Test
    public void testAsyncQuery() throws Exception {
        ApiFuture resultSetClosed;
        int EXPECTED_ROW_COUNT = 10;
        RandomResultSetGenerator generator = new RandomResultSetGenerator(10);
        com.google.spanner.v1.ResultSet resultSet = generator.generate();
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(Statement.of((String)"SELECT * FROM RANDOM"), resultSet));
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        ExecutorService executor = Executors.newSingleThreadExecutor();
        SettableFuture finished = SettableFuture.create();
        ArrayList receivedResults = new ArrayList();
        try (AsyncResultSet rs = client.singleUse().executeQueryAsync(Statement.of((String)"SELECT * FROM RANDOM"), new Options.QueryOption[0]);){
            resultSetClosed = rs.setCallback((Executor)executor, asyncResultSet -> {
                try {
                    block7: while (true) {
                        switch (rs.tryNext()) {
                            case DONE: {
                                finished.set((Object)true);
                                return AsyncResultSet.CallbackResponse.DONE;
                            }
                            case NOT_READY: {
                                return AsyncResultSet.CallbackResponse.CONTINUE;
                            }
                            case OK: {
                                receivedResults.add(asyncResultSet.getCurrentRowAsStruct());
                                continue block7;
                            }
                        }
                        break;
                    }
                    throw new IllegalStateException("Unknown cursor state");
                }
                catch (Throwable t) {
                    finished.setException(t);
                    return AsyncResultSet.CallbackResponse.DONE;
                }
            });
        }
        Truth.assertThat((Boolean)((Boolean)finished.get())).isTrue();
        Truth.assertThat((Integer)receivedResults.size()).isEqualTo((Object)10);
        resultSetClosed.get();
    }

    @Test
    public void testClientIdReusedOnDatabaseNotFound() {
        mockSpanner.setBatchCreateSessionsExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofStickyException((Exception)SpannerExceptionFactoryTest.newStatusResourceNotFoundException(TEST_DATABASE, "type.googleapis.com/google.spanner.admin.database.v1.Database", "project/my-project/instances/my-instance/databases/my-database")));
        try (Spanner spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(TEST_PROJECT)).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).build().getService();){
            DatabaseId databaseId = DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE);
            String prevClientId = null;
            for (int i = 0; i < 100; ++i) {
                try {
                    DatabaseClientImpl client = (DatabaseClientImpl)spanner.getDatabaseClient(databaseId);
                    if (prevClientId != null) {
                        Truth.assertThat((String)client.clientId).isEqualTo((Object)prevClientId);
                    }
                    prevClientId = client.clientId;
                    client.singleUse().readRow("MyTable", Key.of((Object[])new Object[]{0}), Collections.singletonList("MyColumn"));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBatchCreateSessionsPermissionDenied() {
        for (java.time.Duration waitForMinSessions : ImmutableList.of((Object)java.time.Duration.ZERO, (Object)java.time.Duration.ofSeconds(5L))) {
            mockSpanner.setBatchCreateSessionsExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofStickyException((Exception)Status.PERMISSION_DENIED.withDescription("Not permitted").asRuntimeException()));
            mockSpanner.setCreateSessionExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofStickyException((Exception)Status.PERMISSION_DENIED.withDescription("Not permitted").asRuntimeException()));
            if (waitForMinSessions.isZero()) {
                mockSpanner.freeze();
            }
            try {
                Spanner spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(TEST_PROJECT)).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).setSessionPoolOption(SessionPoolOptions.newBuilder().setWaitForMinSessionsDuration(waitForMinSessions).build()).build().getService();
                try {
                    SpannerException spannerException;
                    DatabaseClient client;
                    DatabaseId databaseId = DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE);
                    if (waitForMinSessions.isZero()) {
                        client = spanner.getDatabaseClient(databaseId);
                        ResultSet resultSet = client.singleUse().executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);
                        mockSpanner.unfreeze();
                        spannerException = (SpannerException)Assert.assertThrows(SpannerException.class, () -> ((ResultSet)resultSet).next());
                    } else if (((SpannerOptions)spanner.getOptions()).getSessionPoolOptions().getUseMultiplexedSession()) {
                        spannerException = (SpannerException)Assert.assertThrows(SpannerException.class, () -> spanner.getDatabaseClient(databaseId));
                    } else {
                        client = spanner.getDatabaseClient(databaseId);
                        spannerException = (SpannerException)Assert.assertThrows(SpannerException.class, () -> client.singleUse().executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]).next());
                    }
                    Assert.assertEquals((Object)ErrorCode.PERMISSION_DENIED, (Object)spannerException.getErrorCode());
                }
                finally {
                    if (spanner == null) continue;
                    spanner.close();
                }
            }
            finally {
                mockSpanner.setBatchCreateSessionsExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.none());
                mockSpanner.setCreateSessionExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.none());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExceptionIncludesStatement() {
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)Status.INVALID_ARGUMENT.withDescription("Invalid query").asRuntimeException()));
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        try (ResultSet rs = client.singleUse().executeQuery(((Statement.Builder)Statement.newBuilder((String)"SELECT * FROM FOO WHERE ID=@id").bind("id").to(1L)).build(), new Options.QueryOption[0]);){
            SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> ((ResultSet)rs).next());
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.INVALID_ARGUMENT);
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"Statement: 'SELECT * FROM FOO WHERE ID=@id'");
            Truth.assertThat((String)e.getMessage()).doesNotContain((CharSequence)"id: 1");
        }
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)Status.INVALID_ARGUMENT.withDescription("Invalid query").asRuntimeException()));
        Logger logger = Logger.getLogger(GrpcStreamIterator.class.getName());
        Level currentLevel = logger.getLevel();
        try (ResultSet rs = client.singleUse().executeQuery(((Statement.Builder)Statement.newBuilder((String)"SELECT * FROM FOO WHERE ID=@id").bind("id").to(1L)).build(), new Options.QueryOption[0]);){
            logger.setLevel(Level.FINEST);
            SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> ((ResultSet)rs).next());
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.INVALID_ARGUMENT);
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"Statement: 'SELECT * FROM FOO WHERE ID=@id {id: 1}'");
        }
        finally {
            logger.setLevel(currentLevel);
        }
    }

    @Test
    public void testReadDoesNotIncludeStatement() {
        mockSpanner.setStreamingReadExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)Status.INVALID_ARGUMENT.withDescription("Invalid read").asRuntimeException()));
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        try (ResultSet rs = client.singleUse().read("FOO", KeySet.singleKey((Key)Key.of((Object[])new Object[]{1L})), (Iterable)ImmutableList.of((Object)"BAR"), new Options.ReadOption[0]);){
            SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> ((ResultSet)rs).next());
            Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.INVALID_ARGUMENT);
            Truth.assertThat((String)e.getMessage()).doesNotContain((CharSequence)"Statement:");
        }
    }

    @Test
    public void testSpecificTimeout() {
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10000, 0));
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        Context.current().withValue(SpannerOptions.CALL_CONTEXT_CONFIGURATOR_KEY, (Object)SpannerOptions.SpannerCallContextTimeoutConfigurator.create().withExecuteQueryTimeoutDuration(java.time.Duration.ofNanos(1L))).run(() -> {
            try (ResultSet rs = client.singleUse().executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);){
                SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> ((ResultSet)rs).next());
                Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.DEADLINE_EXCEEDED);
            }
            client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[0]));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBatchCreateSessionsFailure_shouldNotPropagateToCloseMethod() {
        Assume.assumeFalse((String)"BatchCreateSessions RPC is not invoked for multiplexed sessions", (boolean)this.isMultiplexedSessionsEnabled());
        try {
            mockSpanner.setBatchCreateSessionsExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofStickyException((Exception)Status.FAILED_PRECONDITION.asRuntimeException()));
            DatabaseClient client = this.spannerWithEmptySessionPool.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
            try (ResultSet rs = client.singleUse().executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);){
                SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> ((ResultSet)rs).next());
                Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.FAILED_PRECONDITION);
            }
        }
        finally {
            mockSpanner.setBatchCreateSessionsExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.none());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateSessionsFailure_shouldNotPropagateToCloseMethod() {
        Assume.assumeTrue((String)"CreateSessions is not invoked for regular sessions", (boolean)this.isMultiplexedSessionsEnabled());
        try {
            mockSpanner.setCreateSessionExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofStickyException((Exception)Status.RESOURCE_EXHAUSTED.asRuntimeException()));
            mockSpanner.freeze();
            DatabaseClient client = this.spannerWithEmptySessionPool.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
            try (ResultSet rs = client.singleUse().executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);){
                mockSpanner.unfreeze();
                SpannerException e = (SpannerException)Assert.assertThrows(SpannerException.class, () -> ((ResultSet)rs).next());
                Truth.assertThat((Comparable)e.getErrorCode()).isEqualTo((Object)ErrorCode.RESOURCE_EXHAUSTED);
            }
        }
        finally {
            mockSpanner.setCreateSessionExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.none());
        }
    }

    @Test
    public void testReadWriteTransaction_usesOptions() {
        SessionPool pool = (SessionPool)Mockito.mock(SessionPool.class);
        SessionPool.PooledSessionFuture session = (SessionPool.PooledSessionFuture)Mockito.mock(SessionPool.PooledSessionFuture.class);
        Mockito.when((Object)pool.getSession()).thenReturn((Object)session);
        Options.TransactionOption option = (Options.TransactionOption)Mockito.mock(Options.TransactionOption.class);
        TraceWrapper traceWrapper = new TraceWrapper(Tracing.getTracer(), OpenTelemetry.noop().getTracer(""), false);
        DatabaseClientImpl client = new DatabaseClientImpl(pool, traceWrapper);
        client.readWriteTransaction(new Options.TransactionOption[]{option});
        ((SessionPool.PooledSessionFuture)Mockito.verify((Object)session)).readWriteTransaction(new Options.TransactionOption[]{option});
    }

    @Test
    public void testTransactionManager_usesOptions() {
        SessionPool pool = (SessionPool)Mockito.mock(SessionPool.class);
        SessionPool.PooledSessionFuture session = (SessionPool.PooledSessionFuture)Mockito.mock(SessionPool.PooledSessionFuture.class);
        Mockito.when((Object)pool.getSession()).thenReturn((Object)session);
        Options.TransactionOption option = (Options.TransactionOption)Mockito.mock(Options.TransactionOption.class);
        DatabaseClientImpl client = new DatabaseClientImpl(pool, (TraceWrapper)Mockito.mock(TraceWrapper.class));
        try (TransactionManager ignore = client.transactionManager(new Options.TransactionOption[]{option});){
            ((SessionPool.PooledSessionFuture)Mockito.verify((Object)session)).transactionManager(new Options.TransactionOption[]{option});
        }
    }

    @Test
    public void testRunAsync_usesOptions() {
        SessionPool pool = (SessionPool)Mockito.mock(SessionPool.class);
        SessionPool.PooledSessionFuture session = (SessionPool.PooledSessionFuture)Mockito.mock(SessionPool.PooledSessionFuture.class);
        Mockito.when((Object)pool.getSession()).thenReturn((Object)session);
        Options.TransactionOption option = (Options.TransactionOption)Mockito.mock(Options.TransactionOption.class);
        DatabaseClientImpl client = new DatabaseClientImpl(pool, (TraceWrapper)Mockito.mock(TraceWrapper.class));
        client.runAsync(new Options.TransactionOption[]{option});
        ((SessionPool.PooledSessionFuture)Mockito.verify((Object)session)).runAsync(new Options.TransactionOption[]{option});
    }

    @Test
    public void testTransactionManagerAsync_usesOptions() {
        SessionPool pool = (SessionPool)Mockito.mock(SessionPool.class);
        SessionPool.PooledSessionFuture session = (SessionPool.PooledSessionFuture)Mockito.mock(SessionPool.PooledSessionFuture.class);
        Mockito.when((Object)pool.getSession()).thenReturn((Object)session);
        Options.TransactionOption option = (Options.TransactionOption)Mockito.mock(Options.TransactionOption.class);
        DatabaseClientImpl client = new DatabaseClientImpl(pool, (TraceWrapper)Mockito.mock(TraceWrapper.class));
        try (AsyncTransactionManager ignore = client.transactionManagerAsync(new Options.TransactionOption[]{option});){
            ((SessionPool.PooledSessionFuture)Mockito.verify((Object)session)).transactionManagerAsync(new Options.TransactionOption[]{option});
        }
    }

    @Test
    public void testExecuteQueryWithPriority() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        try (ResultSet resultSet = client.singleUse().executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.HIGH)});){
            while (resultSet.next()) {
            }
        }
        List<ExecuteSqlRequest> requests = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class);
        Truth.assertThat(requests).hasSize(1);
        ExecuteSqlRequest request = requests.get(0);
        Assert.assertNotNull((Object)request.getRequestOptions());
        Assert.assertEquals((Object)RequestOptions.Priority.PRIORITY_HIGH, (Object)request.getRequestOptions().getPriority());
    }

    @Test
    public void testExecuteReadWithPriority() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        try (ResultSet resultSet = client.singleUse().read("TestTable", KeySet.singleKey((Key)Key.of((Object[])new Object[]{1L})), MockSpannerTestUtil.READ_COLUMN_NAMES, new Options.ReadOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.HIGH)});){
            while (resultSet.next()) {
            }
        }
        List<ReadRequest> requests = mockSpanner.getRequestsOfType(ReadRequest.class);
        Truth.assertThat(requests).hasSize(1);
        ReadRequest request = requests.get(0);
        Assert.assertNotNull((Object)request.getRequestOptions());
        Assert.assertEquals((Object)RequestOptions.Priority.PRIORITY_HIGH, (Object)request.getRequestOptions().getPriority());
    }

    @Test
    public void testReadWriteExecuteQueryWithPriority() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
        runner.run(transaction -> {
            try (ResultSet resultSet = transaction.executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.HIGH)});){
                while (resultSet.next()) {
                }
            }
            return null;
        });
        List<ExecuteSqlRequest> requests = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class);
        Truth.assertThat(requests).hasSize(1);
        ExecuteSqlRequest request = requests.get(0);
        Assert.assertNotNull((Object)request.getRequestOptions());
        Assert.assertEquals((Object)RequestOptions.Priority.PRIORITY_HIGH, (Object)request.getRequestOptions().getPriority());
    }

    @Test
    public void testReadWriteExecuteReadWithPriority() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
        runner.run(transaction -> {
            try (ResultSet resultSet = transaction.read("TestTable", KeySet.singleKey((Key)Key.of((Object[])new Object[]{1L})), MockSpannerTestUtil.READ_COLUMN_NAMES, new Options.ReadOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.HIGH)});){
                while (resultSet.next()) {
                }
            }
            return null;
        });
        List<ReadRequest> requests = mockSpanner.getRequestsOfType(ReadRequest.class);
        Truth.assertThat(requests).hasSize(1);
        ReadRequest request = requests.get(0);
        Assert.assertNotNull((Object)request.getRequestOptions());
        Assert.assertEquals((Object)RequestOptions.Priority.PRIORITY_HIGH, (Object)request.getRequestOptions().getPriority());
    }

    @Test
    public void testExecuteUpdateWithPriority() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
        runner.run(transaction -> transaction.executeUpdate(UPDATE_STATEMENT, new Options.UpdateOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.HIGH)}));
        List<ExecuteSqlRequest> requests = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class);
        Truth.assertThat(requests).hasSize(1);
        ExecuteSqlRequest request = requests.get(0);
        Assert.assertNotNull((Object)request.getRequestOptions());
        Assert.assertEquals((Object)RequestOptions.Priority.PRIORITY_HIGH, (Object)request.getRequestOptions().getPriority());
    }

    @Test
    public void testBatchUpdateWithPriority() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
        runner.run(transaction -> transaction.batchUpdate(Collections.singletonList(UPDATE_STATEMENT), new Options.UpdateOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.HIGH)}));
        List<ExecuteBatchDmlRequest> requests = mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class);
        Truth.assertThat(requests).hasSize(1);
        ExecuteBatchDmlRequest request = requests.get(0);
        Assert.assertNotNull((Object)request.getRequestOptions());
        Assert.assertEquals((Object)RequestOptions.Priority.PRIORITY_HIGH, (Object)request.getRequestOptions().getPriority());
    }

    @Test
    public void testPartitionedDMLWithPriority() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        client.executePartitionedUpdate(UPDATE_STATEMENT, new Options.UpdateOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.HIGH)});
        List<ExecuteSqlRequest> requests = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class);
        Truth.assertThat(requests).hasSize(1);
        ExecuteSqlRequest request = requests.get(0);
        Assert.assertNotNull((Object)request.getRequestOptions());
        Assert.assertEquals((Object)RequestOptions.Priority.PRIORITY_HIGH, (Object)request.getRequestOptions().getPriority());
    }

    @Test
    public void testCommitWithPriority() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.HIGH)});
        runner.run(transaction -> {
            transaction.buffer(Mutation.delete((String)"TEST", (KeySet)KeySet.all()));
            return null;
        });
        List<CommitRequest> requests = mockSpanner.getRequestsOfType(CommitRequest.class);
        Truth.assertThat(requests).hasSize(1);
        CommitRequest request = requests.get(0);
        Assert.assertNotNull((Object)request.getRequestOptions());
        Assert.assertEquals((Object)RequestOptions.Priority.PRIORITY_HIGH, (Object)request.getRequestOptions().getPriority());
    }

    @Test
    public void testTransactionManagerCommitWithPriority() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        try (TransactionManager manager = client.transactionManager(new Options.TransactionOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.HIGH)});){
            TransactionContext transaction = manager.begin();
            transaction.buffer(Mutation.delete((String)"TEST", (KeySet)KeySet.all()));
            manager.commit();
        }
        List<CommitRequest> requests = mockSpanner.getRequestsOfType(CommitRequest.class);
        Truth.assertThat(requests).hasSize(1);
        CommitRequest request = requests.get(0);
        Assert.assertNotNull((Object)request.getRequestOptions());
        Assert.assertEquals((Object)RequestOptions.Priority.PRIORITY_HIGH, (Object)request.getRequestOptions().getPriority());
    }

    @Test
    public void testAsyncRunnerCommitWithPriority() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        AsyncRunner runner = client.runAsync(new Options.TransactionOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.HIGH)});
        SpannerApiFutures.get((ApiFuture)runner.runAsync(txn -> {
            txn.buffer(Mutation.delete((String)"TEST", (KeySet)KeySet.all()));
            return ApiFutures.immediateFuture(null);
        }, (Executor)executor));
        List<CommitRequest> requests = mockSpanner.getRequestsOfType(CommitRequest.class);
        Truth.assertThat(requests).hasSize(1);
        CommitRequest request = requests.get(0);
        Assert.assertNotNull((Object)request.getRequestOptions());
        Assert.assertEquals((Object)RequestOptions.Priority.PRIORITY_HIGH, (Object)request.getRequestOptions().getPriority());
    }

    @Test
    public void testAsyncTransactionManagerCommitWithPriority() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        try (AsyncTransactionManager manager = client.transactionManagerAsync(new Options.TransactionOption[]{Options.priority((Options.RpcPriority)Options.RpcPriority.HIGH)});){
            AsyncTransactionManager.TransactionContextFuture transaction = manager.beginAsync();
            SpannerApiFutures.get((ApiFuture)transaction.then((txn, input) -> {
                txn.buffer(Mutation.delete((String)"TEST", (KeySet)KeySet.all()));
                return ApiFutures.immediateFuture(null);
            }, (Executor)executor).commitAsync());
        }
        List<CommitRequest> requests = mockSpanner.getRequestsOfType(CommitRequest.class);
        Truth.assertThat(requests).hasSize(1);
        CommitRequest request = requests.get(0);
        Assert.assertNotNull((Object)request.getRequestOptions());
        Assert.assertEquals((Object)RequestOptions.Priority.PRIORITY_HIGH, (Object)request.getRequestOptions().getPriority());
    }

    @Test
    public void testCommitWithoutMaxCommitDelay() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[0]);
        runner.run(transaction -> {
            transaction.buffer(Mutation.delete((String)"TEST", (KeySet)KeySet.all()));
            return null;
        });
        List<CommitRequest> requests = mockSpanner.getRequestsOfType(CommitRequest.class);
        Truth.assertThat(requests).hasSize(1);
        CommitRequest request = requests.get(0);
        Assert.assertFalse((boolean)request.hasMaxCommitDelay());
    }

    @Test
    public void testCommitWithMaxCommitDelay() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        TransactionRunner runner = client.readWriteTransaction(new Options.TransactionOption[]{Options.maxCommitDelay((java.time.Duration)java.time.Duration.ofMillis(100L))});
        runner.run(transaction -> {
            transaction.buffer(Mutation.delete((String)"TEST", (KeySet)KeySet.all()));
            return null;
        });
        List<CommitRequest> requests = mockSpanner.getRequestsOfType(CommitRequest.class);
        Truth.assertThat(requests).hasSize(1);
        CommitRequest request = requests.get(0);
        Assert.assertNotNull((Object)request.getMaxCommitDelay());
        Assert.assertEquals((Object)Duration.newBuilder().setNanos(100000000).build(), (Object)request.getMaxCommitDelay());
    }

    @Test
    public void testTransactionManagerCommitWithMaxCommitDelay() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        TransactionManager manager = client.transactionManager(new Options.TransactionOption[]{Options.maxCommitDelay((java.time.Duration)java.time.Duration.ofMillis(100L))});
        TransactionContext transaction = manager.begin();
        transaction.buffer(Mutation.delete((String)"TEST", (KeySet)KeySet.all()));
        manager.commit();
        List<CommitRequest> requests = mockSpanner.getRequestsOfType(CommitRequest.class);
        Truth.assertThat(requests).hasSize(1);
        CommitRequest request = requests.get(0);
        Assert.assertNotNull((Object)request.getMaxCommitDelay());
        Assert.assertEquals((Object)Duration.newBuilder().setNanos(100000000).build(), (Object)request.getMaxCommitDelay());
    }

    @Test
    public void testAsyncRunnerCommitWithMaxCommitDelay() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        AsyncRunner runner = client.runAsync(new Options.TransactionOption[]{Options.maxCommitDelay((java.time.Duration)java.time.Duration.ofMillis(100L))});
        SpannerApiFutures.get((ApiFuture)runner.runAsync(txn -> {
            txn.buffer(Mutation.delete((String)"TEST", (KeySet)KeySet.all()));
            return ApiFutures.immediateFuture(null);
        }, (Executor)executor));
        List<CommitRequest> requests = mockSpanner.getRequestsOfType(CommitRequest.class);
        Truth.assertThat(requests).hasSize(1);
        CommitRequest request = requests.get(0);
        Assert.assertNotNull((Object)request.getMaxCommitDelay());
        Assert.assertEquals((Object)Duration.newBuilder().setNanos(100000000).build(), (Object)request.getMaxCommitDelay());
    }

    @Test
    public void testAsyncTransactionManagerCommitWithMaxCommitDelay() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        try (AsyncTransactionManager manager = client.transactionManagerAsync(new Options.TransactionOption[]{Options.maxCommitDelay((java.time.Duration)java.time.Duration.ofMillis(100L))});){
            AsyncTransactionManager.TransactionContextFuture transaction = manager.beginAsync();
            SpannerApiFutures.get((ApiFuture)transaction.then((txn, input) -> {
                txn.buffer(Mutation.delete((String)"TEST", (KeySet)KeySet.all()));
                return ApiFutures.immediateFuture(null);
            }, (Executor)executor).commitAsync());
        }
        List<CommitRequest> requests = mockSpanner.getRequestsOfType(CommitRequest.class);
        Truth.assertThat(requests).hasSize(1);
        CommitRequest request = requests.get(0);
        Assert.assertNotNull((Object)request.getMaxCommitDelay());
        Assert.assertEquals((Object)Duration.newBuilder().setNanos(100000000).build(), (Object)request.getMaxCommitDelay());
    }

    @Test
    public void singleUseNoAction_ClearsCheckedOutSession() {
        DatabaseClientImpl client = (DatabaseClientImpl)this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        Set checkedOut = client.pool.checkedOutSessions;
        Truth.assertThat((Iterable)checkedOut).isEmpty();
        client.singleUse().close();
        Truth.assertThat((Iterable)checkedOut).isEmpty();
    }

    @Test
    public void singleUseReadOnlyTransactionNoAction_ClearsCheckedOutSession() {
        DatabaseClientImpl client = (DatabaseClientImpl)this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        Set checkedOut = client.pool.checkedOutSessions;
        Truth.assertThat((Iterable)checkedOut).isEmpty();
        client.singleUseReadOnlyTransaction().close();
        Truth.assertThat((Iterable)checkedOut).isEmpty();
    }

    @Test
    public void readWriteTransactionNoAction_ClearsCheckedOutSession() {
        DatabaseClientImpl client = (DatabaseClientImpl)this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        Set checkedOut = client.pool.checkedOutSessions;
        Truth.assertThat((Iterable)checkedOut).isEmpty();
        client.readWriteTransaction(new Options.TransactionOption[0]);
        Truth.assertThat((Iterable)checkedOut).isEmpty();
    }

    @Test
    public void readOnlyTransactionNoAction_ClearsCheckedOutSession() {
        DatabaseClientImpl client = (DatabaseClientImpl)this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        Set checkedOut = client.pool.checkedOutSessions;
        Truth.assertThat((Iterable)checkedOut).isEmpty();
        client.readOnlyTransaction().close();
        Truth.assertThat((Iterable)checkedOut).isEmpty();
    }

    @Test
    public void transactionManagerNoAction_ClearsCheckedOutSession() {
        DatabaseClientImpl client = (DatabaseClientImpl)this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        Set checkedOut = client.pool.checkedOutSessions;
        Truth.assertThat((Iterable)checkedOut).isEmpty();
        client.transactionManager(new Options.TransactionOption[0]).close();
        Truth.assertThat((Iterable)checkedOut).isEmpty();
    }

    @Test
    public void transactionContextFailsIfUsedMultipleTimes() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        Function<TransactionContext, Long> function = new Function<TransactionContext, Long>(){
            TransactionContext ctx;

            @Override
            public Long apply(TransactionContext transactionContext) {
                if (this.ctx == null) {
                    this.ctx = transactionContext;
                }
                try (ResultSet rs = this.ctx.executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);){
                    while (rs.next()) {
                    }
                }
                return 1L;
            }
        };
        Assert.assertEquals((Object)1L, (Object)client.readWriteTransaction(new Options.TransactionOption[0]).run(function::apply));
        SpannerException exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> client.readWriteTransaction(new Options.TransactionOption[0]).run(function::apply));
        Assert.assertTrue((boolean)exception.getMessage().contains("Context has been closed"));
    }

    @Test
    public void testGetDialectDefault() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        Assert.assertEquals((Object)Dialect.GOOGLE_STANDARD_SQL, (Object)client.getDialect());
    }

    @Test
    public void testGetDialectDefaultPreloaded() {
        try (Spanner spanner = (Spanner)((SpannerOptions)this.spanner.getOptions()).toBuilder().setSessionPoolOption(SessionPoolOptions.newBuilder().setAutoDetectDialect(true).build()).build().getService();){
            DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
            Assert.assertEquals((Object)Dialect.GOOGLE_STANDARD_SQL, (Object)client.getDialect());
        }
    }

    @Test
    public void testGetDialectPostgreSQL() {
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.detectDialectResult(Dialect.POSTGRESQL));
        try {
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
            Assert.assertEquals((Object)Dialect.POSTGRESQL, (Object)client.getDialect());
        }
        finally {
            mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.detectDialectResult(Dialect.GOOGLE_STANDARD_SQL));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetDialectPostgreSQLPreloaded() {
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.detectDialectResult(Dialect.POSTGRESQL));
        try (Spanner spanner = (Spanner)((SpannerOptions)this.spanner.getOptions()).toBuilder().setSessionPoolOption(SessionPoolOptions.newBuilder().setAutoDetectDialect(true).build()).build().getService();){
            DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
            Assert.assertEquals((Object)Dialect.POSTGRESQL, (Object)client.getDialect());
        }
        finally {
            mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.detectDialectResult(Dialect.GOOGLE_STANDARD_SQL));
        }
    }

    @Test
    public void testGetDialect_FailsDirectlyIfDatabaseNotFound() {
        mockSpanner.setBatchCreateSessionsExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.stickyDatabaseNotFoundException("invalid-database"));
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        SpannerException exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> ((DatabaseClient)client).getDialect());
        Assert.assertEquals((Object)ErrorCode.NOT_FOUND, (Object)exception.getErrorCode());
        Assert.assertTrue((boolean)exception.getMessage().contains("NOT_FOUND: Database not found: Database with id invalid-database not found"));
    }

    @Test
    public void testGetDialectDefaultPreloaded_FailsDirectlyIfDatabaseNotFound() {
        mockSpanner.setBatchCreateSessionsExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.stickyDatabaseNotFoundException("invalid-database"));
        try (Spanner spanner = (Spanner)((SpannerOptions)this.spanner.getOptions()).toBuilder().setSessionPoolOption(SessionPoolOptions.newBuilder().setAutoDetectDialect(true).build()).build().getService();){
            DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
            SpannerException exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> ((DatabaseClient)client).getDialect());
            Assert.assertEquals((Object)ErrorCode.NOT_FOUND, (Object)exception.getErrorCode());
            Assert.assertTrue((boolean)exception.getMessage().contains("NOT_FOUND: Database not found: Database with id invalid-database not found"));
        }
    }

    @Test
    public void testUntypedNullParameters() {
        Statement statement = ((Statement.Builder)Statement.newBuilder((String)"INSERT INTO FOO (BAR) VALUES (@p)").bind("p").to((Value)null)).build();
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(statement, 1L));
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        Long updateCount = (Long)client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> transaction.executeUpdate(statement, new Options.UpdateOption[0]));
        Assert.assertNotNull((Object)updateCount);
        Assert.assertEquals((long)1L, (long)updateCount);
    }

    @Test
    public void testGetDatabaseRole() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        Assert.assertEquals((Object)TEST_DATABASE_ROLE, (Object)client.getDatabaseRole());
    }

    @Test
    public void testAnalyzeUpdateStatement() {
        String sql = "update foo set bar=1 where baz=@param";
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(Statement.of((String)sql), com.google.spanner.v1.ResultSet.newBuilder().setMetadata(ResultSetMetadata.newBuilder().setUndeclaredParameters(StructType.newBuilder().addFields(StructType.Field.newBuilder().setName("param").setType(Type.newBuilder().setCode(TypeCode.STRING).build()).build()).build()).build()).setStats(ResultSetStats.newBuilder().setRowCountExact(0L).build()).build()));
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
            try (ResultSet resultSet = transaction.analyzeUpdateStatement(Statement.of((String)sql), ReadContext.QueryAnalyzeMode.PLAN, new Options.UpdateOption[0]);){
                Assert.assertFalse((boolean)resultSet.next());
                Assert.assertNotNull((Object)resultSet.getStats());
                Assert.assertEquals((long)0L, (long)resultSet.getStats().getRowCountExact());
                Assert.assertNotNull((Object)resultSet.getMetadata());
                Assert.assertEquals((long)1L, (long)resultSet.getMetadata().getUndeclaredParameters().getFieldsCount());
                Assert.assertEquals((Object)"param", (Object)resultSet.getMetadata().getUndeclaredParameters().getFields(0).getName());
                Assert.assertEquals((Object)Type.newBuilder().setCode(TypeCode.STRING).build(), (Object)resultSet.getMetadata().getUndeclaredParameters().getFields(0).getType());
            }
            return null;
        });
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        ExecuteSqlRequest request = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).get(0);
        Assert.assertEquals((Object)ExecuteSqlRequest.QueryMode.PLAN, (Object)request.getQueryMode());
    }

    @Test
    public void testByteArray() {
        Random random = new Random();
        byte[] bytes = new byte[random.nextInt(200)];
        int numRows = 5;
        ArrayList<ListValue> rows = new ArrayList<ListValue>(numRows);
        for (int i = 0; i < numRows; ++i) {
            random.nextBytes(bytes);
            rows.add(ListValue.newBuilder().addValues(com.google.protobuf.Value.newBuilder().setStringValue(i % 2 == 0 ? Base64.getEncoder().encodeToString(bytes) : BaseEncoding.base64().encode(bytes)).build()).build());
        }
        Statement statement = Statement.of((String)"select * from foo");
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(statement, com.google.spanner.v1.ResultSet.newBuilder().setMetadata(ResultSetMetadata.newBuilder().setRowType(StructType.newBuilder().addFields(StructType.Field.newBuilder().setType(Type.newBuilder().setCode(TypeCode.BYTES).build()).setName("f1").build()).build()).build()).addAllRows(rows).build()));
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        try (ResultSet resultSet = client.singleUse().executeQuery(statement, new Options.QueryOption[0]);){
            while (resultSet.next()) {
                String base64String = resultSet.getValue(0).getAsString();
                ByteArray byteArray = resultSet.getBytes(0);
                Assert.assertEquals((Object)ByteArray.fromBase64((String)base64String), (Object)byteArray);
            }
        }
    }

    @Test
    public void testGetAllTypesAsString() {
        SingerProto.SingerInfo info = SingerProto.SingerInfo.newBuilder().setSingerId(1L).build();
        for (Dialect dialect : Dialect.values()) {
            Statement statement = Statement.of((String)"select * from all_types");
            mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(statement, com.google.spanner.v1.ResultSet.newBuilder().setMetadata(RandomResultSetGenerator.generateAllTypesMetadata(RandomResultSetGenerator.generateAllTypes(dialect))).addRows(this.getRows(dialect)).build()));
            DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
            try (ResultSet resultSet = client.singleUse().executeQuery(statement, new Options.QueryOption[0]);){
                Assert.assertTrue((boolean)resultSet.next());
                int col = 0;
                DatabaseClientImplTest.assertAsString("true", resultSet, col++);
                DatabaseClientImplTest.assertAsString("100", resultSet, col++);
                DatabaseClientImplTest.assertAsString("-3.14", resultSet, col++);
                DatabaseClientImplTest.assertAsString("3.14", resultSet, col++);
                DatabaseClientImplTest.assertAsString("6.626", resultSet, col++);
                DatabaseClientImplTest.assertAsString("test-string", resultSet, col++);
                DatabaseClientImplTest.assertAsString("{\"key1\": \"value1\"}", resultSet, col++);
                DatabaseClientImplTest.assertAsString(Base64.getEncoder().encodeToString("test-bytes".getBytes(StandardCharsets.UTF_8)), resultSet, col++);
                DatabaseClientImplTest.assertAsString("2023-01-11", resultSet, col++);
                DatabaseClientImplTest.assertAsString("2023-01-11T11:55:18.123456789Z", resultSet, col++);
                if (dialect == Dialect.POSTGRESQL) {
                    DatabaseClientImplTest.assertAsString("100", resultSet, col++);
                }
                DatabaseClientImplTest.assertAsString((ImmutableList<String>)ImmutableList.of((Object)"true", (Object)"NULL", (Object)"false"), resultSet, col++);
                DatabaseClientImplTest.assertAsString((ImmutableList<String>)ImmutableList.of((Object)String.format("%d", Long.MAX_VALUE), (Object)String.format("%d", Long.MIN_VALUE), (Object)"NULL"), resultSet, col++);
                DatabaseClientImplTest.assertAsString((ImmutableList<String>)ImmutableList.of((Object)"NULL", (Object)Float.valueOf(Float.MAX_VALUE).toString(), (Object)Float.valueOf(Float.MIN_VALUE).toString(), (Object)"NaN", (Object)"3.14"), resultSet, col++);
                DatabaseClientImplTest.assertAsString((ImmutableList<String>)ImmutableList.of((Object)"NULL", (Object)"-12345.6789", (Object)"3.14"), resultSet, col++);
                DatabaseClientImplTest.assertAsString((ImmutableList<String>)ImmutableList.of((Object)"6.626", (Object)"NULL", (Object)"-8.9123"), resultSet, col++);
                DatabaseClientImplTest.assertAsString((ImmutableList<String>)ImmutableList.of((Object)"test-string1", (Object)"NULL", (Object)"test-string2"), resultSet, col++);
                DatabaseClientImplTest.assertAsString((ImmutableList<String>)ImmutableList.of((Object)"{\"key\": \"value1\"}", (Object)"{\"key\": \"value2\"}", (Object)"NULL"), resultSet, col++);
                DatabaseClientImplTest.assertAsString((ImmutableList<String>)ImmutableList.of((Object)String.format("%s", Base64.getEncoder().encodeToString("test-bytes1".getBytes(StandardCharsets.UTF_8))), (Object)String.format("%s", Base64.getEncoder().encodeToString("test-bytes2".getBytes(StandardCharsets.UTF_8))), (Object)"NULL"), resultSet, col++);
                DatabaseClientImplTest.assertAsString((ImmutableList<String>)ImmutableList.of((Object)"2000-02-29", (Object)"NULL", (Object)"2000-01-01"), resultSet, col++);
                DatabaseClientImplTest.assertAsString((ImmutableList<String>)ImmutableList.of((Object)"2023-01-11T11:55:18.123456789Z", (Object)"NULL", (Object)"2023-01-12T11:55:18Z"), resultSet, col++);
                if (dialect == Dialect.GOOGLE_STANDARD_SQL) {
                    DatabaseClientImplTest.assertAsString(Base64.getEncoder().encodeToString(info.toByteArray()), resultSet, col++);
                    DatabaseClientImplTest.assertAsString(String.valueOf(1), resultSet, col++);
                    DatabaseClientImplTest.assertAsString((ImmutableList<String>)ImmutableList.of((Object)String.format("%s", Base64.getEncoder().encodeToString(info.toByteArray())), (Object)"NULL"), resultSet, col++);
                    DatabaseClientImplTest.assertAsString((ImmutableList<String>)ImmutableList.of((Object)String.format("%d", 1), (Object)"NULL"), resultSet, col++);
                }
                if (dialect == Dialect.POSTGRESQL) {
                    DatabaseClientImplTest.assertAsString((ImmutableList<String>)ImmutableList.of((Object)String.format("%d", Long.MAX_VALUE), (Object)String.format("%d", Long.MIN_VALUE), (Object)"NULL"), resultSet, col++);
                }
                Assert.assertFalse((boolean)resultSet.next());
            }
        }
    }

    @Test
    public void testSelectUnknownType() {
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(Statement.of((String)"SELECT * FROM foo"), com.google.spanner.v1.ResultSet.newBuilder().setMetadata(ResultSetMetadata.newBuilder().setRowType(StructType.newBuilder().addFields(StructType.Field.newBuilder().setName("c").setType(Type.newBuilder().setCodeValue(Integer.MAX_VALUE).build()).build()).build()).build()).addRows(ListValue.newBuilder().addValues(com.google.protobuf.Value.newBuilder().setStringValue("bar").build()).build()).addRows(ListValue.newBuilder().addValues(com.google.protobuf.Value.newBuilder().setBoolValue(true).build()).build()).addRows(ListValue.newBuilder().addValues(com.google.protobuf.Value.newBuilder().setNumberValue(3.14).build()).build()).addRows(ListValue.newBuilder().addValues(com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build()).build()).addRows(ListValue.newBuilder().addValues(com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addValues(com.google.protobuf.Value.newBuilder().setStringValue("baz").build()).addValues(com.google.protobuf.Value.newBuilder().setBoolValue(false).build()).addValues(com.google.protobuf.Value.newBuilder().setNumberValue(6.626).build()).addValues(com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build()).build()).build()).build()).build()));
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        try (ResultSet resultSet = client.singleUse().executeQuery(Statement.of((String)"SELECT * FROM foo"), new Options.QueryOption[0]);){
            Assert.assertTrue((boolean)resultSet.next());
            DatabaseClientImplTest.assertAsString("bar", resultSet, 0);
            Assert.assertTrue((boolean)resultSet.next());
            DatabaseClientImplTest.assertAsString("true", resultSet, 0);
            Assert.assertTrue((boolean)resultSet.next());
            DatabaseClientImplTest.assertAsString("3.14", resultSet, 0);
            Assert.assertTrue((boolean)resultSet.next());
            DatabaseClientImplTest.assertAsString("NULL", resultSet, 0);
            Assert.assertTrue((boolean)resultSet.next());
            DatabaseClientImplTest.assertAsString((ImmutableList<String>)ImmutableList.of((Object)"baz", (Object)"false", (Object)"6.626", (Object)"NULL"), resultSet, 0);
            Assert.assertFalse((boolean)resultSet.next());
        }
    }

    @Test
    public void testMetadataUnknownTypes() {
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(Statement.of((String)"SELECT * FROM foo"), com.google.spanner.v1.ResultSet.newBuilder().setMetadata(ResultSetMetadata.newBuilder().setRowType(StructType.newBuilder().addFields(StructType.Field.newBuilder().setName("c1").setType(Type.newBuilder().setCodeValue(Integer.MAX_VALUE).build()).build()).addFields(StructType.Field.newBuilder().setName("c2").setType(Type.newBuilder().setCode(TypeCode.STRING).setTypeAnnotationValue(Integer.MAX_VALUE).build()).build()).addFields(StructType.Field.newBuilder().setName("c3").setType(Type.newBuilder().setCodeValue(Integer.MAX_VALUE).setTypeAnnotation(TypeAnnotationCode.PG_NUMERIC).build()).build()).addFields(StructType.Field.newBuilder().setName("c4").setType(Type.newBuilder().setCode(TypeCode.ARRAY).setArrayElementType(Type.newBuilder().setCodeValue(Integer.MAX_VALUE).build()).build()).build()).addFields(StructType.Field.newBuilder().setName("c5").setType(Type.newBuilder().setCode(TypeCode.ARRAY).setArrayElementType(Type.newBuilder().setCode(TypeCode.STRING).setTypeAnnotationValue(Integer.MAX_VALUE).build()).build()).build()).addFields(StructType.Field.newBuilder().setName("c6").setType(Type.newBuilder().setCodeValue(Integer.MAX_VALUE).setArrayElementType(Type.newBuilder().setCodeValue(Integer.MAX_VALUE).build()).build()).build()).addFields(StructType.Field.newBuilder().setName("c7").setType(Type.newBuilder().setCode(TypeCode.ARRAY).setArrayElementType(Type.newBuilder().setCodeValue(Integer.MAX_VALUE).setTypeAnnotation(TypeAnnotationCode.PG_NUMERIC).build()).build()).build()).build()).build()).build()));
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        try (ResultSet resultSet = client.singleUse().executeQuery(Statement.of((String)"SELECT * FROM foo"), new Options.QueryOption[0]);){
            Assert.assertFalse((boolean)resultSet.next());
            Assert.assertEquals((Object)"STRUCT<c1 UNRECOGNIZED, c2 STRING<UNRECOGNIZED>, c3 UNRECOGNIZED<PG_NUMERIC>, c4 ARRAY<UNRECOGNIZED>, c5 ARRAY<STRING<UNRECOGNIZED>>, c6 UNRECOGNIZED<UNRECOGNIZED>, c7 ARRAY<UNRECOGNIZED<PG_NUMERIC>>>", (Object)resultSet.getType().toString());
            Assert.assertEquals((Object)"UNRECOGNIZED", (Object)((Type.StructField)resultSet.getType().getStructFields().get(0)).getType().toString());
            Assert.assertEquals((Object)"STRING<UNRECOGNIZED>", (Object)((Type.StructField)resultSet.getType().getStructFields().get(1)).getType().toString());
            Assert.assertEquals((Object)"UNRECOGNIZED<PG_NUMERIC>", (Object)((Type.StructField)resultSet.getType().getStructFields().get(2)).getType().toString());
            Assert.assertEquals((Object)"ARRAY<UNRECOGNIZED>", (Object)((Type.StructField)resultSet.getType().getStructFields().get(3)).getType().toString());
            Assert.assertEquals((Object)Type.Code.ARRAY, (Object)((Type.StructField)resultSet.getType().getStructFields().get(3)).getType().getCode());
            Assert.assertEquals((Object)Type.Code.UNRECOGNIZED, (Object)((Type.StructField)resultSet.getType().getStructFields().get(3)).getType().getArrayElementType().getCode());
            Assert.assertEquals((Object)"ARRAY<STRING<UNRECOGNIZED>>", (Object)((Type.StructField)resultSet.getType().getStructFields().get(4)).getType().toString());
            Assert.assertEquals((Object)Type.Code.ARRAY, (Object)((Type.StructField)resultSet.getType().getStructFields().get(4)).getType().getCode());
            Assert.assertEquals((Object)Type.Code.UNRECOGNIZED, (Object)((Type.StructField)resultSet.getType().getStructFields().get(4)).getType().getArrayElementType().getCode());
            Assert.assertEquals((Object)"UNRECOGNIZED<UNRECOGNIZED>", (Object)((Type.StructField)resultSet.getType().getStructFields().get(5)).getType().toString());
            Assert.assertEquals((Object)Type.Code.UNRECOGNIZED, (Object)((Type.StructField)resultSet.getType().getStructFields().get(5)).getType().getCode());
            Assert.assertEquals((Object)Type.Code.UNRECOGNIZED, (Object)((Type.StructField)resultSet.getType().getStructFields().get(5)).getType().getArrayElementType().getCode());
            Assert.assertEquals((Object)"ARRAY<UNRECOGNIZED<PG_NUMERIC>>", (Object)((Type.StructField)resultSet.getType().getStructFields().get(6)).getType().toString());
            Assert.assertEquals((Object)Type.Code.ARRAY, (Object)((Type.StructField)resultSet.getType().getStructFields().get(6)).getType().getCode());
            Assert.assertEquals((Object)Type.Code.UNRECOGNIZED, (Object)((Type.StructField)resultSet.getType().getStructFields().get(6)).getType().getArrayElementType().getCode());
        }
    }

    @Test
    public void testStatementWithBytesArrayParameter() {
        Statement statement = ((Statement.Builder)Statement.newBuilder((String)"select id from test where b=@p1").bind("p1").toBytesArray(Arrays.asList(ByteArray.copyFrom((String)"test1"), null, ByteArray.copyFrom((String)"test2")))).build();
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(statement, MockSpannerTestUtil.SELECT1_RESULTSET));
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        try (ResultSet resultSet = client.singleUse().executeQuery(statement, new Options.QueryOption[0]);){
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((long)1L, (long)resultSet.getLong(0));
            Assert.assertFalse((boolean)resultSet.next());
        }
    }

    @Test
    public void testStreamWaitTimeout() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(100, 0));
        SpannerOptions.CallContextConfigurator configurator = new SpannerOptions.CallContextConfigurator(){

            public <ReqT, RespT> ApiCallContext configure(ApiCallContext context, ReqT request, MethodDescriptor<ReqT, RespT> method) {
                return context.withStreamWaitTimeoutDuration(java.time.Duration.ofNanos(1L));
            }
        };
        Context context = Context.current().withValue(SpannerOptions.CALL_CONTEXT_CONFIGURATOR_KEY, (Object)configurator);
        context.run(() -> {
            try (ResultSet resultSet = client.singleUse().executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);){
                SpannerException exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> ((ResultSet)resultSet).next());
                Assert.assertEquals((Object)ErrorCode.DEADLINE_EXCEEDED, (Object)exception.getErrorCode());
                Assert.assertTrue((String)exception.getMessage(), (boolean)exception.getMessage().contains("stream wait timeout"));
            }
        });
    }

    @Test
    public void testZeroStreamWaitTimeout() {
        DatabaseClient client = this.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        SpannerOptions.CallContextConfigurator configurator = new SpannerOptions.CallContextConfigurator(){

            public <ReqT, RespT> ApiCallContext configure(ApiCallContext context, ReqT request, MethodDescriptor<ReqT, RespT> method) {
                return context.withStreamWaitTimeoutDuration(java.time.Duration.ZERO);
            }
        };
        Context context = Context.current().withValue(SpannerOptions.CALL_CONTEXT_CONFIGURATOR_KEY, (Object)configurator);
        context.run(() -> {
            try (ResultSet resultSet = client.singleUse().executeQuery(MockSpannerTestUtil.SELECT1, new Options.QueryOption[0]);){
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertFalse((boolean)resultSet.next());
            }
        });
    }

    @Test
    public void testRetryOnResourceExhausted() {
        RetrySettings retrySettings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(java.time.Duration.ofSeconds(60L)).setMaxRpcTimeoutDuration(java.time.Duration.ofSeconds(60L)).setTotalTimeoutDuration(java.time.Duration.ofSeconds(60L)).setRpcTimeoutMultiplier(1.0).setInitialRetryDelayDuration(java.time.Duration.ZERO).setMaxRetryDelayDuration(java.time.Duration.ZERO).setMaxAttempts(100).build();
        SpannerOptions.Builder builder = (SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(TEST_PROJECT)).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance());
        RetryInfo retryInfo = RetryInfo.newBuilder().setRetryDelay(Duration.newBuilder().setNanos((int)java.time.Duration.ofMillis(1L).toNanos()).build()).build();
        Metadata.Key key = Metadata.Key.of((String)(retryInfo.getDescriptorForType().getFullName() + "-bin"), (Metadata.BinaryMarshaller)ProtoLiteUtils.metadataMarshaller((MessageLite)retryInfo));
        Metadata trailers = new Metadata();
        trailers.put(key, (Object)retryInfo);
        builder.getSpannerStubSettingsBuilder().executeStreamingSqlSettings().setRetryableCodes(new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.RESOURCE_EXHAUSTED}).setRetrySettings(retrySettings);
        try (Spanner spanner = (Spanner)builder.build().getService();){
            DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
            int expectedRowCount = 5;
            RandomResultSetGenerator generator = new RandomResultSetGenerator(5);
            Statement statement = Statement.of((String)"select * from random_table");
            mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(statement, generator.generate()));
            for (int errorIndex = 0; errorIndex < 4; ++errorIndex) {
                for (boolean withRetryInfo : new boolean[]{false, true}) {
                    StatusRuntimeException exception = Status.RESOURCE_EXHAUSTED.asRuntimeException((Metadata)(withRetryInfo ? trailers : null));
                    mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofStreamException((Exception)exception, errorIndex));
                    try (ResultSet resultSet = client.singleUse().executeQuery(statement, new Options.QueryOption[0]);){
                        while (resultSet.next()) {
                        }
                    }
                    Assert.assertEquals((long)2L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
                    if (errorIndex == 0) {
                        Assert.assertEquals((long)2L, (long)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).stream().filter(request -> request.getResumeToken().isEmpty()).count());
                    } else {
                        int expectedResumeToken = errorIndex;
                        Assert.assertEquals((long)1L, (long)mockSpanner.getRequestsOfType(ExecuteSqlRequest.class).stream().filter(request -> request.getResumeToken().equals((Object)ByteString.copyFromUtf8((String)String.format("%09d", expectedResumeToken)))).count());
                    }
                    mockSpanner.clearRequests();
                }
            }
        }
    }

    @Test
    public void testSessionPoolExhaustedError_containsStackTraces() {
        Assume.assumeFalse((String)"Session pool tests are skipped for multiplexed sessions", (boolean)this.isMultiplexedSessionsEnabledForRW());
        try (Spanner spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(TEST_PROJECT)).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).setSessionPoolOption(SessionPoolOptions.newBuilder().setFailIfPoolExhausted().setMinSessions(2).setMaxSessions(4).setWaitForMinSessionsDuration(java.time.Duration.ofSeconds(10L)).build()).build().getService();){
            DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
            ArrayList<TransactionManager> transactions = new ArrayList<TransactionManager>();
            for (int i = 0; i < 4; ++i) {
                transactions.add(client.transactionManager(new Options.TransactionOption[0]));
            }
            SpannerException spannerException = (SpannerException)Assert.assertThrows(SpannerException.class, () -> client.transactionManager(new Options.TransactionOption[0]));
            Assert.assertEquals((Object)ErrorCode.RESOURCE_EXHAUSTED, (Object)spannerException.getErrorCode());
            Assert.assertTrue((String)spannerException.getMessage(), (boolean)spannerException.getMessage().contains("There are currently 4 sessions checked out:"));
            Assert.assertTrue((String)spannerException.getMessage(), (boolean)spannerException.getMessage().contains("Session was checked out from the pool at"));
            SessionPool pool = ((DatabaseClientImpl)client).pool;
            Assert.assertEquals((long)0L, (long)pool.getNumberOfSessionsInPool());
            Assert.assertEquals((long)0L, (long)pool.getNumberOfSessionsInUse());
            Assert.assertEquals((long)0L, (long)pool.getMaxSessionsInUse());
            Assert.assertEquals((long)4L, (long)pool.getTotalSessionsPlusNumSessionsBeingCreated());
            for (TransactionManager transaction : transactions) {
                transaction.close();
            }
            Stopwatch watch = Stopwatch.createStarted();
            while (pool.getNumberOfSessionsInPool() < 4 && watch.elapsed(TimeUnit.MILLISECONDS) < 100L) {
                Thread.yield();
            }
            Assert.assertEquals((long)4L, (long)pool.getNumberOfSessionsInPool());
        }
    }

    static void assertAsString(String expected, ResultSet resultSet, int col) {
        Assert.assertEquals((Object)expected, (Object)resultSet.getValue(col).getAsString());
        Assert.assertEquals((Object)ImmutableList.of((Object)expected), (Object)resultSet.getValue(col).getAsStringList());
    }

    static void assertAsString(ImmutableList<String> expected, ResultSet resultSet, int col) {
        Assert.assertEquals(expected, (Object)resultSet.getValue(col).getAsStringList());
        Assert.assertEquals((Object)expected.stream().collect(Collectors.joining(",", "[", "]")), (Object)resultSet.getValue(col).getAsString());
    }

    private void consumeResults(ResultSet resultSet) {
        while (resultSet.next()) {
        }
    }

    private void consumeBatchWriteStream(ServerStream<BatchWriteResponse> stream) {
        for (BatchWriteResponse batchWriteResponse : stream) {
        }
    }

    private ListValue getRows(Dialect dialect) {
        SingerProto.SingerInfo info = SingerProto.SingerInfo.newBuilder().setSingerId(1L).build();
        ListValue.Builder valuesBuilder = ListValue.newBuilder().addValues(com.google.protobuf.Value.newBuilder().setBoolValue(true).build()).addValues(com.google.protobuf.Value.newBuilder().setStringValue("100").build()).addValues(com.google.protobuf.Value.newBuilder().setNumberValue((double)-3.14f).build()).addValues(com.google.protobuf.Value.newBuilder().setNumberValue(3.14).build()).addValues(com.google.protobuf.Value.newBuilder().setStringValue("6.626").build()).addValues(com.google.protobuf.Value.newBuilder().setStringValue("test-string").build()).addValues(com.google.protobuf.Value.newBuilder().setStringValue("{\"key1\": \"value1\"}").build()).addValues(com.google.protobuf.Value.newBuilder().setStringValue(Base64.getEncoder().encodeToString("test-bytes".getBytes(StandardCharsets.UTF_8))).build()).addValues(com.google.protobuf.Value.newBuilder().setStringValue("2023-01-11").build()).addValues(com.google.protobuf.Value.newBuilder().setStringValue("2023-01-11T11:55:18.123456789Z").build());
        if (dialect == Dialect.POSTGRESQL) {
            valuesBuilder.addValues(com.google.protobuf.Value.newBuilder().setStringValue("100").build());
        }
        valuesBuilder.addValues(com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addValues(com.google.protobuf.Value.newBuilder().setBoolValue(true).build()).addValues(com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build()).addValues(com.google.protobuf.Value.newBuilder().setBoolValue(false).build()).build())).addValues(com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addValues(com.google.protobuf.Value.newBuilder().setStringValue(String.valueOf(Long.MAX_VALUE)).build()).addValues(com.google.protobuf.Value.newBuilder().setStringValue(String.valueOf(Long.MIN_VALUE)).build()).addValues(com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build()).build())).addValues(com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addValues(com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build()).addValues(com.google.protobuf.Value.newBuilder().setNumberValue(3.4028234663852886E38).build()).addValues(com.google.protobuf.Value.newBuilder().setNumberValue((double)1.4E-45f).build()).addValues(com.google.protobuf.Value.newBuilder().setStringValue("NaN").build()).addValues(com.google.protobuf.Value.newBuilder().setNumberValue((double)3.14f).build()).build())).addValues(com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addValues(com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build()).addValues(com.google.protobuf.Value.newBuilder().setNumberValue(-12345.6789).build()).addValues(com.google.protobuf.Value.newBuilder().setNumberValue(3.14).build()).build())).addValues(com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addValues(com.google.protobuf.Value.newBuilder().setStringValue("6.626").build()).addValues(com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build()).addValues(com.google.protobuf.Value.newBuilder().setStringValue("-8.9123").build()).build())).addValues(com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addValues(com.google.protobuf.Value.newBuilder().setStringValue("test-string1").build()).addValues(com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build()).addValues(com.google.protobuf.Value.newBuilder().setStringValue("test-string2").build()).build())).addValues(com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addValues(com.google.protobuf.Value.newBuilder().setStringValue("{\"key\": \"value1\"}").build()).addValues(com.google.protobuf.Value.newBuilder().setStringValue("{\"key\": \"value2\"}").build()).addValues(com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build()).build())).addValues(com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addValues(com.google.protobuf.Value.newBuilder().setStringValue(Base64.getEncoder().encodeToString("test-bytes1".getBytes(StandardCharsets.UTF_8))).build()).addValues(com.google.protobuf.Value.newBuilder().setStringValue(Base64.getEncoder().encodeToString("test-bytes2".getBytes(StandardCharsets.UTF_8))).build()).addValues(com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build()).build())).addValues(com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addValues(com.google.protobuf.Value.newBuilder().setStringValue("2000-02-29").build()).addValues(com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build()).addValues(com.google.protobuf.Value.newBuilder().setStringValue("2000-01-01").build()).build())).addValues(com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addValues(com.google.protobuf.Value.newBuilder().setStringValue("2023-01-11T11:55:18.123456789Z").build()).addValues(com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build()).addValues(com.google.protobuf.Value.newBuilder().setStringValue("2023-01-12T11:55:18Z").build()).build()));
        if (dialect == Dialect.GOOGLE_STANDARD_SQL) {
            valuesBuilder.addValues(com.google.protobuf.Value.newBuilder().setStringValue(Base64.getEncoder().encodeToString(info.toByteArray())).build()).addValues(com.google.protobuf.Value.newBuilder().setStringValue(String.valueOf(1)).build()).addValues(com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addValues(com.google.protobuf.Value.newBuilder().setStringValue(Base64.getEncoder().encodeToString(info.toByteArray())).build()).addValues(com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build()).build())).addValues(com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addValues(com.google.protobuf.Value.newBuilder().setStringValue(String.valueOf(1)).build()).addValues(com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build()).build()));
        }
        if (dialect == Dialect.POSTGRESQL) {
            valuesBuilder.addValues(com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addValues(com.google.protobuf.Value.newBuilder().setStringValue(String.valueOf(Long.MAX_VALUE)).build()).addValues(com.google.protobuf.Value.newBuilder().setStringValue(String.valueOf(Long.MIN_VALUE)).build()).addValues(com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build()).build()));
        }
        return valuesBuilder.build();
    }

    private boolean isMultiplexedSessionsEnabled() {
        if (this.spanner.getOptions() == null || ((SpannerOptions)this.spanner.getOptions()).getSessionPoolOptions() == null) {
            return false;
        }
        return ((SpannerOptions)this.spanner.getOptions()).getSessionPoolOptions().getUseMultiplexedSession();
    }

    private boolean isMultiplexedSessionsEnabledForRW() {
        if (this.spanner.getOptions() == null || ((SpannerOptions)this.spanner.getOptions()).getSessionPoolOptions() == null) {
            return false;
        }
        return ((SpannerOptions)this.spanner.getOptions()).getSessionPoolOptions().getUseMultiplexedSessionForRW();
    }

    static {
        UPDATE_STATEMENT = Statement.of((String)"UPDATE FOO SET BAR=1 WHERE BAZ=2");
        INVALID_UPDATE_STATEMENT = Statement.of((String)"UPDATE NON_EXISTENT_TABLE SET BAR=1 WHERE BAZ=2");
        STATUS_OK = com.google.rpc.Status.newBuilder().setCode(0).build();
        MUTATION_GROUPS = ImmutableList.of((Object)MutationGroup.of((Mutation[])new Mutation[]{((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"FOO1").set("ID").to(1L)).set("NAME").to("Bar1")).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"FOO2").set("ID").to(2L)).set("NAME").to("Bar2")).build()}), (Object)MutationGroup.of((Mutation[])new Mutation[]{((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"FOO3").set("ID").to(3L)).set("NAME").to("Bar3")).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"FOO4").set("ID").to(4L)).set("NAME").to("Bar4")).build()}), (Object)MutationGroup.of((Mutation[])new Mutation[]{((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"FOO4").set("ID").to(4L)).set("NAME").to("Bar4")).build(), ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"FOO5").set("ID").to(5L)).set("NAME").to("Bar5")).build()}), (Object)MutationGroup.of((Mutation[])new Mutation[]{((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"FOO6").set("ID").to(6L)).set("NAME").to("Bar6")).build()}));
        BATCH_WRITE_RESPONSES = ImmutableList.of((Object)BatchWriteResponse.newBuilder().setStatus(STATUS_OK).addAllIndexes((Iterable)ImmutableList.of((Object)0, (Object)1)).build(), (Object)BatchWriteResponse.newBuilder().setStatus(STATUS_OK).addAllIndexes((Iterable)ImmutableList.of((Object)2, (Object)3)).build());
        DIRECTED_READ_OPTIONS1 = DirectedReadOptions.newBuilder().setIncludeReplicas(DirectedReadOptions.IncludeReplicas.newBuilder().addReplicaSelections(DirectedReadOptions.ReplicaSelection.newBuilder().setLocation("us-west1").build())).build();
        DIRECTED_READ_OPTIONS2 = DirectedReadOptions.newBuilder().setIncludeReplicas(DirectedReadOptions.IncludeReplicas.newBuilder().addReplicaSelections(DirectedReadOptions.ReplicaSelection.newBuilder().setLocation("us-east1").build())).build();
    }
}

