/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.AbstractLatencyBenchmark;
import com.google.cloud.spanner.BenchmarkingUtilityScripts;
import com.google.cloud.spanner.DatabaseClientImpl;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SessionPool;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TransactionRunner;
import com.google.common.base.Stopwatch;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;

@BenchmarkMode(value={Mode.AverageTime})
@Fork(value=1, warmups=0)
@Measurement(batchSize=1, iterations=1, timeUnit=TimeUnit.MILLISECONDS)
@OutputTimeUnit(value=TimeUnit.SECONDS)
@Warmup(iterations=0)
public class DefaultBenchmark
extends AbstractLatencyBenchmark {
    @Benchmark
    public void burstQueries(BenchmarkState server) throws Exception {
        DatabaseClientImpl client = server.client;
        SessionPool pool = client.pool;
        Truth.assertThat((Integer)pool.totalSessions()).isEqualTo((Object)((SpannerOptions)server.spanner.getOptions()).getSessionPoolOptions().getMinSessions());
        ListeningScheduledExecutorService service = MoreExecutors.listeningDecorator((ScheduledExecutorService)Executors.newScheduledThreadPool(PARALLEL_THREADS));
        ArrayList<ListenableFuture<List<Duration>>> results = new ArrayList<ListenableFuture<List<Duration>>>(PARALLEL_THREADS);
        for (int i = 0; i < PARALLEL_THREADS; ++i) {
            results.add((ListenableFuture<List<Duration>>)service.submit(() -> this.runBenchmarksForSingleUseQueries(server, TOTAL_READS_PER_RUN)));
        }
        this.collectResultsAndPrint(service, results, TOTAL_READS_PER_RUN);
    }

    @Benchmark
    public void burstQueriesAndWrites(BenchmarkState server) throws Exception {
        int i;
        DatabaseClientImpl client = server.client;
        SessionPool pool = client.pool;
        Truth.assertThat((Integer)pool.totalSessions()).isEqualTo((Object)((SpannerOptions)server.spanner.getOptions()).getSessionPoolOptions().getMinSessions());
        ListeningScheduledExecutorService service = MoreExecutors.listeningDecorator((ScheduledExecutorService)Executors.newScheduledThreadPool(PARALLEL_THREADS));
        ArrayList<ListenableFuture<List<Duration>>> results = new ArrayList<ListenableFuture<List<Duration>>>(PARALLEL_THREADS);
        for (i = 0; i < PARALLEL_THREADS; ++i) {
            results.add(service.submit(() -> this.runBenchmarksForSingleUseQueries(server, TOTAL_READS_PER_RUN)));
        }
        for (i = 0; i < PARALLEL_THREADS; ++i) {
            results.add(service.submit(() -> this.runBenchmarkForUpdates(server, TOTAL_WRITES_PER_RUN)));
        }
        this.collectResultsAndPrint(service, results, TOTAL_READS_PER_RUN + TOTAL_WRITES_PER_RUN);
    }

    @Benchmark
    public void burstUpdates(BenchmarkState server) throws Exception {
        DatabaseClientImpl client = server.client;
        SessionPool pool = client.pool;
        Truth.assertThat((Integer)pool.totalSessions()).isEqualTo((Object)((SpannerOptions)server.spanner.getOptions()).getSessionPoolOptions().getMinSessions());
        ListeningScheduledExecutorService service = MoreExecutors.listeningDecorator((ScheduledExecutorService)Executors.newScheduledThreadPool(PARALLEL_THREADS));
        ArrayList<ListenableFuture<List<Duration>>> results = new ArrayList<ListenableFuture<List<Duration>>>(PARALLEL_THREADS);
        for (int i = 0; i < PARALLEL_THREADS; ++i) {
            results.add((ListenableFuture<List<Duration>>)service.submit(() -> this.runBenchmarkForUpdates(server, TOTAL_WRITES_PER_RUN)));
        }
        this.collectResultsAndPrint(service, results, TOTAL_WRITES_PER_RUN);
    }

    private List<Duration> runBenchmarksForSingleUseQueries(BenchmarkState server, int numberOfOperations) {
        ArrayList<Duration> results = new ArrayList<Duration>(numberOfOperations);
        this.executeWarmup(server);
        for (int i = 0; i < numberOfOperations; ++i) {
            results.add(this.executeSingleUseQuery(server));
        }
        return results;
    }

    private void executeWarmup(BenchmarkState server) {
        for (int i = 0; i < 1; ++i) {
            this.executeSingleUseQuery(server);
        }
    }

    private Duration executeSingleUseQuery(BenchmarkState server) {
        Stopwatch watch = Stopwatch.createStarted();
        try (ResultSet rs = server.client.singleUse().executeQuery(DefaultBenchmark.getRandomisedReadStatement(), new Options.QueryOption[0]);){
            while (rs.next()) {
                Assert.assertEquals((long)1L, (long)rs.getColumnCount());
                Assert.assertNotNull((Object)rs.getValue(0));
            }
        }
        return watch.elapsed();
    }

    private List<Duration> runBenchmarkForUpdates(BenchmarkState server, int numberOfOperations) {
        ArrayList<Duration> results = new ArrayList<Duration>(numberOfOperations);
        this.executeWarmup(server);
        this.executeUpdate(server);
        for (int i = 0; i < numberOfOperations; ++i) {
            results.add(this.executeUpdate(server));
        }
        return results;
    }

    private Duration executeUpdate(BenchmarkState server) {
        Stopwatch watch = Stopwatch.createStarted();
        TransactionRunner runner = server.client.readWriteTransaction(new Options.TransactionOption[0]);
        runner.run(transaction -> transaction.executeUpdate(DefaultBenchmark.getRandomisedUpdateStatement(), new Options.UpdateOption[0]));
        return watch.elapsed();
    }

    static Statement getRandomisedReadStatement() {
        int randomKey = ThreadLocalRandom.current().nextInt(1000000);
        return ((Statement.Builder)Statement.newBuilder((String)"SELECT ID FROM FOO WHERE ID = @id").bind("id").to((long)randomKey)).build();
    }

    static Statement getRandomisedUpdateStatement() {
        int randomKey = ThreadLocalRandom.current().nextInt(1000000);
        return ((Statement.Builder)Statement.newBuilder((String)"UPDATE FOO SET BAR=1 WHERE ID = @id").bind("id").to((long)randomKey)).build();
    }

    void collectResultsAndPrint(ListeningScheduledExecutorService service, List<ListenableFuture<List<Duration>>> results, int numOperationsPerThread) throws Exception {
        List<Duration> collectResults = BenchmarkingUtilityScripts.collectResults(service, results, numOperationsPerThread * PARALLEL_THREADS, Duration.ofMinutes(60L));
        this.printResults(collectResults);
    }

    @State(value=Scope.Benchmark)
    public static class BenchmarkState {
        private static final String INSTANCE_ID = "";
        private static final String DATABASE_ID = "";
        private static final String SERVER_URL = "https://staging-wrenchworks.sandbox.googleapis.com";
        private Spanner spanner;
        private DatabaseClientImpl client;
        @Param(value={"100"})
        int minSessions;
        @Param(value={"400"})
        int maxSessions;

        @Setup(value=Level.Iteration)
        public void setup() throws Exception {
            SpannerOptions options = SpannerOptions.newBuilder().setSessionPoolOption(SessionPoolOptions.newBuilder().setMinSessions(this.minSessions).setMaxSessions(this.maxSessions).setWaitForMinSessionsDuration(Duration.ofSeconds(20L)).build()).setHost(SERVER_URL).setNumChannels(AbstractLatencyBenchmark.NUM_GRPC_CHANNELS).build();
            this.spanner = (Spanner)options.getService();
            this.client = (DatabaseClientImpl)this.spanner.getDatabaseClient(DatabaseId.of((String)options.getProjectId(), (String)"", (String)""));
        }

        @TearDown(value=Level.Iteration)
        public void teardown() throws Exception {
            this.spanner.close();
        }
    }
}

