/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.rpc.InternalException;
import com.google.api.gax.rpc.StatusCode;
import com.google.cloud.spanner.IsRetryableInternalError;
import com.google.common.base.Predicate;
import com.google.common.truth.Truth;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class IsRetryableInternalErrorTest {
    private Predicate<Throwable> predicate;

    @Before
    public void setUp() {
        this.predicate = new IsRetryableInternalError();
    }

    @Test
    public void http2ErrorStatusRuntimeExceptionIsRetryable() {
        StatusRuntimeException e = new StatusRuntimeException(Status.fromCode((Status.Code)Status.Code.INTERNAL).withDescription("INTERNAL: HTTP/2 error code: INTERNAL_ERROR."));
        Truth.assertThat((Boolean)this.predicate.apply((Object)e)).isTrue();
    }

    @Test
    public void http2ErrorInternalExceptionIsRetryable() {
        InternalException e = new InternalException("INTERNAL: HTTP/2 error code: INTERNAL_ERROR.", null, (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.INTERNAL), false);
        Truth.assertThat((Boolean)this.predicate.apply((Object)e)).isTrue();
    }

    @Test
    public void connectionClosedStatusRuntimeExceptionIsRetryable() {
        StatusRuntimeException e = new StatusRuntimeException(Status.fromCode((Status.Code)Status.Code.INTERNAL).withDescription("INTERNAL: Connection closed with unknown cause."));
        Truth.assertThat((Boolean)this.predicate.apply((Object)e)).isTrue();
    }

    @Test
    public void connectionClosedInternalExceptionIsRetryable() {
        InternalException e = new InternalException("INTERNAL: Connection closed with unknown cause.", null, (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.INTERNAL), false);
        Truth.assertThat((Boolean)this.predicate.apply((Object)e)).isTrue();
    }

    @Test
    public void eosStatusRuntimeExceptionIsRetryable() {
        StatusRuntimeException e = new StatusRuntimeException(Status.fromCode((Status.Code)Status.Code.INTERNAL).withDescription("INTERNAL: Received unexpected EOS on DATA frame from server."));
        Truth.assertThat((Boolean)this.predicate.apply((Object)e)).isTrue();
    }

    @Test
    public void eosInternalExceptionIsRetryable() {
        InternalException e = new InternalException("INTERNAL: Received unexpected EOS on DATA frame from server.", null, (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.INTERNAL), false);
        Truth.assertThat((Boolean)this.predicate.apply((Object)e)).isTrue();
    }

    @Test
    public void genericInternalStatusRuntimeExceptionIsRetryable() {
        StatusRuntimeException e = new StatusRuntimeException(Status.fromCode((Status.Code)Status.Code.INTERNAL).withDescription("INTERNAL: Generic."));
        Truth.assertThat((Boolean)this.predicate.apply((Object)e)).isFalse();
    }

    @Test
    public void rstStreamInternalExceptionIsRetryable() {
        InternalException e = new InternalException("INTERNAL: stream terminated by RST_STREAM.", null, (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.INTERNAL), false);
        Assert.assertTrue((boolean)this.predicate.apply((Object)e));
    }

    @Test
    public void testAuthenticationBackendInternalServerErrorIsRetryable() {
        StatusRuntimeException exception = new StatusRuntimeException(Status.fromCode((Status.Code)Status.Code.INTERNAL).withDescription("INTERNAL: Authentication backend internal server error. Please retry."));
        Assert.assertTrue((boolean)this.predicate.apply((Object)exception));
    }

    @Test
    public void genericInternalExceptionIsNotRetryable() {
        InternalException e = new InternalException("INTERNAL: Generic.", null, (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.INTERNAL), false);
        Truth.assertThat((Boolean)this.predicate.apply((Object)e)).isFalse();
    }

    @Test
    public void nullIsNotRetryable() {
        Truth.assertThat((Boolean)this.predicate.apply(null)).isFalse();
    }

    @Test
    public void genericExceptionIsNotRetryable() {
        Truth.assertThat((Boolean)this.predicate.apply((Object)new Exception())).isFalse();
    }
}

