/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseClientImpl;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SessionPool;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.StandardBenchmarkMockServer;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.spanner.v1.BatchCreateSessionsRequest;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.openjdk.jmh.annotations.AuxCounters;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;

@BenchmarkMode(value={Mode.AverageTime})
@Fork(value=1, warmups=0)
@Measurement(batchSize=1, iterations=1, timeUnit=TimeUnit.MILLISECONDS)
@Warmup(batchSize=0, iterations=0)
@OutputTimeUnit(value=TimeUnit.SECONDS)
public class LongRunningSessionsBenchmark {
    private static final String TEST_PROJECT = "my-project";
    private static final String TEST_INSTANCE = "my-instance";
    private static final String TEST_DATABASE = "my-database";
    private static final int HOLD_SESSION_TIME = 100;
    private static final int LONG_HOLD_SESSION_TIME = 10000;
    private static final int RND_WAIT_TIME_BETWEEN_REQUESTS = 100;
    private static final Random RND = new Random();

    @Benchmark
    public void burstRead(BenchmarkState server) throws Exception {
        int totalQueries = server.maxSessions * 8;
        int parallelThreads = server.maxSessions * 2;
        DatabaseClient client = server.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        SessionPool pool = ((DatabaseClientImpl)client).pool;
        Truth.assertThat((Integer)pool.totalSessions()).isEqualTo((Object)server.minSessions);
        ListeningScheduledExecutorService service = MoreExecutors.listeningDecorator((ScheduledExecutorService)Executors.newScheduledThreadPool(parallelThreads));
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>(totalQueries);
        for (int i = 0; i < totalQueries; ++i) {
            futures.add(service.submit(() -> {
                Thread.sleep(RND.nextInt(100));
                try (ResultSet rs = client.singleUse().executeQuery(StandardBenchmarkMockServer.SELECT1, new Options.QueryOption[0]);){
                    while (rs.next()) {
                        this.randomWait(server);
                    }
                    Object var4_4 = null;
                    return var4_4;
                }
            }));
        }
        pool.poolMaintainer.maintainPool();
        Futures.allAsList(futures).get();
        service.shutdown();
        this.assertNumLeakedSessionsRemoved(server, pool);
    }

    @Benchmark
    public void burstWrite(BenchmarkState server) throws Exception {
        int totalWrites = server.maxSessions * 8;
        int parallelThreads = server.maxSessions * 2;
        DatabaseClient client = server.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        SessionPool pool = ((DatabaseClientImpl)client).pool;
        Truth.assertThat((Integer)pool.totalSessions()).isEqualTo((Object)server.minSessions);
        ListeningScheduledExecutorService service = MoreExecutors.listeningDecorator((ScheduledExecutorService)Executors.newScheduledThreadPool(parallelThreads));
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>(totalWrites);
        for (int i = 0; i < totalWrites; ++i) {
            futures.add(service.submit(() -> {
                this.randomWaitForMockServer(server);
                client.executePartitionedUpdate(StandardBenchmarkMockServer.UPDATE_STATEMENT, new Options.UpdateOption[0]);
            }));
        }
        pool.poolMaintainer.maintainPool();
        Futures.allAsList(futures).get();
        service.shutdown();
        Truth.assertThat((Long)pool.numLeakedSessionsRemoved()).isEqualTo((Object)0);
    }

    @Benchmark
    public void burstReadAndWrite(BenchmarkState server) throws Exception {
        int i;
        int totalWrites = server.maxSessions * 4;
        int totalReads = server.maxSessions * 4;
        int parallelThreads = server.maxSessions * 2;
        DatabaseClient client = server.spanner.getDatabaseClient(DatabaseId.of((String)TEST_PROJECT, (String)TEST_INSTANCE, (String)TEST_DATABASE));
        SessionPool pool = ((DatabaseClientImpl)client).pool;
        Truth.assertThat((Integer)pool.totalSessions()).isEqualTo((Object)server.minSessions);
        ListeningScheduledExecutorService service = MoreExecutors.listeningDecorator((ScheduledExecutorService)Executors.newScheduledThreadPool(parallelThreads));
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>(totalReads + totalWrites);
        for (i = 0; i < totalWrites; ++i) {
            futures.add(service.submit(() -> {
                this.randomWaitForMockServer(server);
                client.executePartitionedUpdate(StandardBenchmarkMockServer.UPDATE_STATEMENT, new Options.UpdateOption[0]);
            }));
        }
        for (i = 0; i < totalReads; ++i) {
            futures.add(service.submit(() -> {
                Thread.sleep(RND.nextInt(100));
                try (ResultSet rs = client.singleUse().executeQuery(StandardBenchmarkMockServer.SELECT1, new Options.QueryOption[0]);){
                    while (rs.next()) {
                        this.randomWait(server);
                    }
                    Object var4_4 = null;
                    return var4_4;
                }
            }));
        }
        pool.poolMaintainer.maintainPool();
        Futures.allAsList(futures).get();
        service.shutdown();
        this.assertNumLeakedSessionsRemoved(server, pool);
    }

    private void randomWait(BenchmarkState server) throws InterruptedException {
        if (RND.nextBoolean()) {
            server.longRunningSessions.incrementAndGet();
            Thread.sleep(10000L);
        } else {
            Thread.sleep(100L);
        }
    }

    private void randomWaitForMockServer(BenchmarkState server) {
        if (RND.nextBoolean()) {
            server.longRunningSessions.incrementAndGet();
            server.mockServer.getMockSpanner().setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(10000, 0));
        } else {
            server.mockServer.getMockSpanner().setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofMinimumAndRandomTime(100, 0));
        }
    }

    private void assertNumLeakedSessionsRemoved(BenchmarkState server, SessionPool pool) {
        SessionPoolOptions sessionPoolOptions = ((SpannerOptions)server.spanner.getOptions()).getSessionPoolOptions();
        Truth.assertThat((Integer)server.longRunningSessions.get()).isNotEqualTo((Object)0);
        if (sessionPoolOptions.warnAndCloseInactiveTransactions() || sessionPoolOptions.closeInactiveTransactions()) {
            Truth.assertThat((Long)pool.numLeakedSessionsRemoved()).isGreaterThan(0);
        } else if (sessionPoolOptions.warnInactiveTransactions()) {
            Truth.assertThat((Long)pool.numLeakedSessionsRemoved()).isEqualTo((Object)0);
        }
    }

    @State(value=Scope.Thread)
    @AuxCounters(value=AuxCounters.Type.EVENTS)
    public static class BenchmarkState {
        private StandardBenchmarkMockServer mockServer;
        private Spanner spanner;
        private DatabaseClientImpl client;
        private AtomicInteger longRunningSessions;
        @Param(value={"100"})
        int minSessions;
        @Param(value={"400"})
        int maxSessions;
        @Param(value={"4"})
        int numChannels;

        public int numBatchCreateSessionsRpcs() {
            return this.mockServer.countRequests(BatchCreateSessionsRequest.class);
        }

        public int sessionsCreated() {
            return this.mockServer.getMockSpanner().numSessionsCreated();
        }

        @Setup(value=Level.Invocation)
        public void setup() throws Exception {
            this.mockServer = new StandardBenchmarkMockServer();
            this.longRunningSessions = new AtomicInteger();
            TransportChannelProvider channelProvider = this.mockServer.start();
            SessionPoolOptions.InactiveTransactionRemovalOptions inactiveTransactionRemovalOptions = SessionPoolOptions.InactiveTransactionRemovalOptions.newBuilder().setActionOnInactiveTransaction(SessionPoolOptions.ActionOnInactiveTransaction.WARN_AND_CLOSE).setExecutionFrequency(Duration.ofSeconds(10L)).setIdleTimeThreshold(Duration.ofSeconds(2L)).build();
            SpannerOptions options = ((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(LongRunningSessionsBenchmark.TEST_PROJECT)).setChannelProvider(channelProvider).setNumChannels(this.numChannels).setCredentials((Credentials)NoCredentials.getInstance())).setSessionPoolOption(SessionPoolOptions.newBuilder().setMinSessions(this.minSessions).setMaxSessions(this.maxSessions).setWaitForMinSessionsDuration(Duration.ofSeconds(5L)).setInactiveTransactionRemovalOptions(inactiveTransactionRemovalOptions).build()).build();
            this.spanner = (Spanner)options.getService();
            this.client = (DatabaseClientImpl)this.spanner.getDatabaseClient(DatabaseId.of((String)LongRunningSessionsBenchmark.TEST_PROJECT, (String)LongRunningSessionsBenchmark.TEST_INSTANCE, (String)LongRunningSessionsBenchmark.TEST_DATABASE));
        }

        @TearDown(value=Level.Invocation)
        public void teardown() throws Exception {
            this.spanner.close();
            this.mockServer.shutdown();
        }
    }
}

