/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.common.collect.Maps;
import io.opencensus.common.ToLongFunction;
import io.opencensus.metrics.DerivedDoubleCumulative;
import io.opencensus.metrics.DerivedDoubleGauge;
import io.opencensus.metrics.DerivedLongCumulative;
import io.opencensus.metrics.DerivedLongGauge;
import io.opencensus.metrics.DoubleCumulative;
import io.opencensus.metrics.DoubleGauge;
import io.opencensus.metrics.LabelKey;
import io.opencensus.metrics.LabelValue;
import io.opencensus.metrics.LongCumulative;
import io.opencensus.metrics.LongGauge;
import io.opencensus.metrics.MetricOptions;
import io.opencensus.metrics.MetricRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class MetricRegistryTestUtils {
    MetricRegistryTestUtils() {
    }

    public static final class FakeMetricRegistry
    extends MetricRegistry {
        private MetricsRecord record = new MetricsRecord();

        FakeMetricRegistry() {
        }

        MetricsRecord pollRecord() {
            return this.record;
        }

        public DerivedLongGauge addDerivedLongGauge(String s, MetricOptions metricOptions) {
            return new FakeDerivedLongGauge(this, s, metricOptions.getLabelKeys());
        }

        public LongGauge addLongGauge(String s, MetricOptions metricOptions) {
            throw new UnsupportedOperationException();
        }

        public DoubleGauge addDoubleGauge(String s, MetricOptions metricOptions) {
            throw new UnsupportedOperationException();
        }

        public DerivedDoubleGauge addDerivedDoubleGauge(String s, MetricOptions metricOptions) {
            throw new UnsupportedOperationException();
        }

        public LongCumulative addLongCumulative(String s, MetricOptions metricOptions) {
            throw new UnsupportedOperationException();
        }

        public DoubleCumulative addDoubleCumulative(String s, MetricOptions metricOptions) {
            throw new UnsupportedOperationException();
        }

        public DerivedLongCumulative addDerivedLongCumulative(String s, MetricOptions metricOptions) {
            return new FakeDerivedLongCumulative(this, s, metricOptions.getLabelKeys());
        }

        public DerivedDoubleCumulative addDerivedDoubleCumulative(String s, MetricOptions metricOptions) {
            throw new UnsupportedOperationException();
        }
    }

    public static final class FakeDerivedLongCumulative
    extends DerivedLongCumulative {
        private final MetricsRecord record;
        private final String name;
        private final List<LabelKey> labelKeys;

        private FakeDerivedLongCumulative(FakeMetricRegistry metricRegistry, String name, List<LabelKey> labelKeys) {
            this.record = metricRegistry.record;
            this.labelKeys = labelKeys;
            this.name = name;
        }

        public <T> void createTimeSeries(List<LabelValue> labelValues, T t, ToLongFunction<T> toLongFunction) {
            if (!this.record.metrics.containsKey(this.name)) {
                this.record.metrics.put(this.name, new ArrayList());
            }
            ((List)this.record.metrics.get(this.name)).add(new PointWithFunction<T>(t, toLongFunction, this.labelKeys, labelValues));
        }

        public void removeTimeSeries(List<LabelValue> list) {
        }

        public void clear() {
        }
    }

    public static final class FakeDerivedLongGauge
    extends DerivedLongGauge {
        private final MetricsRecord record;
        private final String name;
        private final List<LabelKey> labelKeys;

        private FakeDerivedLongGauge(FakeMetricRegistry metricRegistry, String name, List<LabelKey> labelKeys) {
            this.record = metricRegistry.record;
            this.labelKeys = labelKeys;
            this.name = name;
        }

        public <T> void createTimeSeries(List<LabelValue> labelValues, T t, ToLongFunction<T> toLongFunction) {
            if (!this.record.metrics.containsKey(this.name)) {
                this.record.metrics.put(this.name, new ArrayList());
            }
            ((List)this.record.metrics.get(this.name)).add(new PointWithFunction<T>(t, toLongFunction, this.labelKeys, labelValues));
        }

        public void removeTimeSeries(List<LabelValue> list) {
        }

        public void clear() {
        }
    }

    static class MetricsRecord {
        private final Map<String, List<PointWithFunction>> metrics = Maps.newHashMap();

        private MetricsRecord() {
        }

        Map<String, List<PointWithFunction>> getMetrics() {
            return this.metrics;
        }
    }

    static class PointWithFunction<T> {
        private final T ref;
        private final ToLongFunction<T> function;
        private final List<LabelKey> key;
        private final List<LabelValue> values;

        PointWithFunction(T obj, ToLongFunction<T> function, List<LabelKey> keys, List<LabelValue> values) {
            this.ref = obj;
            this.function = function;
            this.key = keys;
            this.values = values;
        }

        long value() {
            return this.function.applyAsLong(this.ref);
        }

        List<LabelKey> keys() {
            return this.key;
        }

        List<LabelValue> values() {
            return this.values;
        }
    }
}

