/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.JavaVersionUtil;
import com.google.cloud.spanner.MultiplexedSessionDatabaseClient;
import com.google.cloud.spanner.SessionClient;
import com.google.cloud.spanner.SessionImpl;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.SessionReference;
import com.google.cloud.spanner.SpannerImpl;
import com.google.cloud.spanner.SpannerOptions;
import com.google.common.truth.Truth;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class MultiplexedSessionDatabaseClientTest {
    @Test
    public void testMaintainer() {
        Assume.assumeTrue((boolean)this.isJava8());
        Instant now = Instant.now();
        Clock clock = (Clock)Mockito.mock(Clock.class);
        Mockito.when((Object)clock.instant()).thenReturn((Object)now);
        SessionClient sessionClient = (SessionClient)Mockito.mock(SessionClient.class);
        SpannerImpl spanner = (SpannerImpl)Mockito.mock(SpannerImpl.class);
        SpannerOptions spannerOptions = (SpannerOptions)Mockito.mock(SpannerOptions.class);
        SessionPoolOptions sessionPoolOptions = (SessionPoolOptions)Mockito.mock(SessionPoolOptions.class);
        Mockito.when((Object)sessionClient.getSpanner()).thenReturn((Object)spanner);
        Mockito.when((Object)((SpannerOptions)spanner.getOptions())).thenReturn((Object)spannerOptions);
        Mockito.when((Object)spannerOptions.getSessionPoolOptions()).thenReturn((Object)sessionPoolOptions);
        Mockito.when((Object)sessionPoolOptions.getMultiplexedSessionMaintenanceDuration()).thenReturn((Object)Duration.ofDays(7L));
        Mockito.when((Object)sessionPoolOptions.getMultiplexedSessionMaintenanceLoopFrequency()).thenReturn((Object)Duration.ofMinutes(10L));
        SessionImpl session1 = (SessionImpl)Mockito.mock(SessionImpl.class);
        SessionReference sessionReference1 = (SessionReference)Mockito.mock(SessionReference.class);
        Mockito.when((Object)session1.getSessionReference()).thenReturn((Object)sessionReference1);
        SessionImpl session2 = (SessionImpl)Mockito.mock(SessionImpl.class);
        SessionReference sessionReference2 = (SessionReference)Mockito.mock(SessionReference.class);
        Mockito.when((Object)session2.getSessionReference()).thenReturn((Object)sessionReference2);
        ((SessionClient)Mockito.doAnswer(invocationOnMock -> {
            SessionClient.SessionConsumer consumer = (SessionClient.SessionConsumer)invocationOnMock.getArgument(0);
            consumer.onSessionReady(session1);
            return null;
        }).doAnswer(invocationOnMock -> {
            SessionClient.SessionConsumer consumer = (SessionClient.SessionConsumer)invocationOnMock.getArgument(0);
            consumer.onSessionReady(session2);
            return null;
        }).when((Object)sessionClient)).asyncCreateMultiplexedSession((SessionClient.SessionConsumer)ArgumentMatchers.any(SessionClient.SessionConsumer.class));
        MultiplexedSessionDatabaseClient client = new MultiplexedSessionDatabaseClient(sessionClient, clock);
        Assert.assertEquals((Object)client.getCurrentSessionReference(), (Object)session1.getSessionReference());
        client.getMaintainer().maintain();
        Assert.assertEquals((Object)client.getCurrentSessionReference(), (Object)session1.getSessionReference());
        Mockito.when((Object)clock.instant()).thenReturn((Object)now.plus(Duration.ofDays(1L)));
        client.getMaintainer().maintain();
        Assert.assertEquals((Object)client.getCurrentSessionReference(), (Object)session1.getSessionReference());
        Mockito.when((Object)clock.instant()).thenReturn((Object)now.plus(Duration.ofDays(8L)));
        client.getMaintainer().maintain();
        Assert.assertEquals((Object)client.getCurrentSessionReference(), (Object)session2.getSessionReference());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDisableMultiplexedSessionEnvVar() throws Exception {
        Assume.assumeTrue((this.isJava8() && !this.isWindows() ? 1 : 0) != 0);
        Assume.assumeFalse((boolean)System.getenv().containsKey("GOOGLE_CLOUD_SPANNER_MULTIPLEXED_SESSIONS"));
        Assert.assertTrue((boolean)SessionPoolOptions.newBuilder().setUseMultiplexedSession(true).build().getUseMultiplexedSession());
        Class<?> classOfMap = System.getenv().getClass();
        Field field = classOfMap.getDeclaredField("m");
        field.setAccessible(true);
        Map writeableEnvironmentVariables = (Map)field.get(System.getenv());
        try {
            writeableEnvironmentVariables.put("GOOGLE_CLOUD_SPANNER_MULTIPLEXED_SESSIONS", "false");
            Assert.assertFalse((boolean)SessionPoolOptions.newBuilder().setUseMultiplexedSession(true).build().getUseMultiplexedSession());
        }
        finally {
            writeableEnvironmentVariables.remove("GOOGLE_CLOUD_SPANNER_MULTIPLEXED_SESSIONS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEnableMultiplexedSessionEnvVar() throws Exception {
        Assume.assumeTrue((this.isJava8() && !this.isWindows() ? 1 : 0) != 0);
        Assume.assumeFalse((boolean)System.getenv().containsKey("GOOGLE_CLOUD_SPANNER_MULTIPLEXED_SESSIONS"));
        Assert.assertFalse((boolean)SessionPoolOptions.newBuilder().setUseMultiplexedSession(false).build().getUseMultiplexedSession());
        Class<?> classOfMap = System.getenv().getClass();
        Field field = classOfMap.getDeclaredField("m");
        field.setAccessible(true);
        Map writeableEnvironmentVariables = (Map)field.get(System.getenv());
        try {
            writeableEnvironmentVariables.put("GOOGLE_CLOUD_SPANNER_MULTIPLEXED_SESSIONS", "true");
            Assert.assertTrue((boolean)SessionPoolOptions.newBuilder().setUseMultiplexedSession(false).build().getUseMultiplexedSession());
        }
        finally {
            writeableEnvironmentVariables.remove("GOOGLE_CLOUD_SPANNER_MULTIPLEXED_SESSIONS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIgnoreMultiplexedSessionEnvVar() throws Exception {
        Assume.assumeTrue((this.isJava8() && !this.isWindows() ? 1 : 0) != 0);
        Assume.assumeFalse((boolean)System.getenv().containsKey("GOOGLE_CLOUD_SPANNER_MULTIPLEXED_SESSIONS"));
        Assert.assertFalse((boolean)SessionPoolOptions.newBuilder().setUseMultiplexedSession(false).build().getUseMultiplexedSession());
        Class<?> classOfMap = System.getenv().getClass();
        Field field = classOfMap.getDeclaredField("m");
        field.setAccessible(true);
        Map writeableEnvironmentVariables = (Map)field.get(System.getenv());
        try {
            writeableEnvironmentVariables.put("GOOGLE_CLOUD_SPANNER_MULTIPLEXED_SESSIONS", "");
            Assert.assertFalse((boolean)SessionPoolOptions.newBuilder().setUseMultiplexedSession(false).build().getUseMultiplexedSession());
        }
        finally {
            writeableEnvironmentVariables.remove("GOOGLE_CLOUD_SPANNER_MULTIPLEXED_SESSIONS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testThrowExceptionMultiplexedSessionEnvVarInvalidValues() throws Exception {
        Assume.assumeTrue((this.isJava8() && !this.isWindows() ? 1 : 0) != 0);
        Assume.assumeFalse((boolean)System.getenv().containsKey("GOOGLE_CLOUD_SPANNER_MULTIPLEXED_SESSIONS"));
        Assert.assertFalse((boolean)SessionPoolOptions.newBuilder().setUseMultiplexedSession(false).build().getUseMultiplexedSession());
        Class<?> classOfMap = System.getenv().getClass();
        Field field = classOfMap.getDeclaredField("m");
        field.setAccessible(true);
        Map writeableEnvironmentVariables = (Map)field.get(System.getenv());
        try {
            writeableEnvironmentVariables.put("GOOGLE_CLOUD_SPANNER_MULTIPLEXED_SESSIONS", "test");
            IllegalArgumentException e = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> SessionPoolOptions.newBuilder().setUseMultiplexedSession(false).build().getUseMultiplexedSession());
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            Truth.assertThat((String)sw.toString()).contains((CharSequence)"GOOGLE_CLOUD_SPANNER_MULTIPLEXED_SESSIONS should be either true or false");
        }
        finally {
            writeableEnvironmentVariables.remove("GOOGLE_CLOUD_SPANNER_MULTIPLEXED_SESSIONS");
        }
    }

    private boolean isJava8() {
        return JavaVersionUtil.getJavaMajorVersion() == 8;
    }

    private boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("windows");
    }
}

