/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.Value;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ListValue;
import com.google.protobuf.NullValue;
import com.google.spanner.v1.CommitRequest;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.ResultSetMetadata;
import com.google.spanner.v1.StructType;
import com.google.spanner.v1.TypeAnnotationCode;
import com.google.spanner.v1.TypeCode;
import io.grpc.BindableService;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Server;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class PgNumericTest {
    private static final String PROJECT = "my-project";
    private static final String INSTANCE = "my-instance";
    private static final String DATABASE = "database";
    private static final ResultSetMetadata RESULT_SET_METADATA = ResultSetMetadata.newBuilder().setRowType(StructType.newBuilder().addFields(StructType.Field.newBuilder().setName("PgNumeric").setType(com.google.spanner.v1.Type.newBuilder().setCode(TypeCode.NUMERIC).setTypeAnnotation(TypeAnnotationCode.PG_NUMERIC).build())).addFields(StructType.Field.newBuilder().setName("PgNumericArray").setType(com.google.spanner.v1.Type.newBuilder().setCode(TypeCode.ARRAY).setArrayElementType(com.google.spanner.v1.Type.newBuilder().setCode(TypeCode.NUMERIC).setTypeAnnotation(TypeAnnotationCode.PG_NUMERIC)).build())).build()).build();
    private static MockSpannerServiceImpl mockSpanner;
    private static InetSocketAddress address;
    private static Server server;
    private Spanner spanner;
    private DatabaseClient databaseClient;

    @BeforeClass
    public static void beforeClass() throws Exception {
        mockSpanner = new MockSpannerServiceImpl();
        mockSpanner.setAbortProbability(0.0);
        address = new InetSocketAddress("localhost", 0);
        server = ((NettyServerBuilder)NettyServerBuilder.forAddress((SocketAddress)address).addService((BindableService)mockSpanner)).build().start();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        server.shutdown();
        server.awaitTermination();
    }

    @Before
    public void setUp() throws Exception {
        String endpoint = address.getHostString() + ":" + server.getPort();
        this.spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(PROJECT)).setChannelConfigurator(ManagedChannelBuilder::usePlaintext).setHost("http://" + endpoint).setCredentials((Credentials)NoCredentials.getInstance())).setSessionPoolOption(SessionPoolOptions.newBuilder().setFailOnSessionLeak().build()).build().getService();
        this.databaseClient = this.spanner.getDatabaseClient(DatabaseId.of((String)PROJECT, (String)INSTANCE, (String)DATABASE));
    }

    @After
    public void tearDown() throws Exception {
        this.spanner.close();
        mockSpanner.removeAllExecutionTimes();
        mockSpanner.reset();
    }

    @Test
    public void testQueryNoNullsAsStrings() {
        Statement statement = Statement.of((String)"SELECT PgNumeric, PgNumericArray FROM Table WHERE Id = 0");
        com.google.spanner.v1.ResultSet result = com.google.spanner.v1.ResultSet.newBuilder().setMetadata(RESULT_SET_METADATA).addRows(ListValue.newBuilder().addValues(com.google.protobuf.Value.newBuilder().setStringValue("1.23")).addValues(com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addValues(com.google.protobuf.Value.newBuilder().setStringValue("2.34")).addValues(com.google.protobuf.Value.newBuilder().setStringValue("3.45")).build())).build()).build();
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(statement, result));
        try (ResultSet resultSet = this.databaseClient.singleUse().executeQuery(Statement.of((String)"SELECT PgNumeric, PgNumericArray FROM Table WHERE Id = 0"), new Options.QueryOption[0]);){
            resultSet.next();
            Assert.assertEquals((Object)"1.23", (Object)resultSet.getString("PgNumeric"));
            Assert.assertEquals((Object)"1.23", (Object)resultSet.getString(0));
            Assert.assertEquals(Arrays.asList("2.34", "3.45"), (Object)resultSet.getStringList("PgNumericArray"));
            Assert.assertEquals(Arrays.asList("2.34", "3.45"), (Object)resultSet.getStringList(1));
        }
    }

    @Test
    public void testQueryNoNullsAsValues() {
        Statement statement = Statement.of((String)"SELECT PgNumeric, PgNumericArray FROM Table WHERE Id = 0");
        com.google.spanner.v1.ResultSet result = com.google.spanner.v1.ResultSet.newBuilder().setMetadata(RESULT_SET_METADATA).addRows(ListValue.newBuilder().addValues(com.google.protobuf.Value.newBuilder().setStringValue("1.23")).addValues(com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addValues(com.google.protobuf.Value.newBuilder().setStringValue("2.34")).addValues(com.google.protobuf.Value.newBuilder().setStringValue("3.45")).build())).build()).build();
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(statement, result));
        try (ResultSet resultSet = this.databaseClient.singleUse().executeQuery(statement, new Options.QueryOption[0]);){
            resultSet.next();
            Assert.assertEquals((Object)Value.pgNumeric((String)"1.23"), (Object)resultSet.getValue("PgNumeric"));
            Assert.assertEquals((Object)Value.pgNumeric((String)"1.23"), (Object)resultSet.getValue(0));
            Assert.assertEquals((Object)Value.pgNumericArray(Arrays.asList("2.34", "3.45")), (Object)resultSet.getValue("PgNumericArray"));
            Assert.assertEquals((Object)Value.pgNumericArray(Arrays.asList("2.34", "3.45")), (Object)resultSet.getValue(1));
        }
    }

    @Test
    public void testQueryNullElements() {
        Statement statement = Statement.of((String)"SELECT PgNumeric, PgNumericArray FROM Table WHERE Id = 3");
        com.google.spanner.v1.ResultSet result = com.google.spanner.v1.ResultSet.newBuilder().setMetadata(RESULT_SET_METADATA).addRows(ListValue.newBuilder().addValues(com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE)).addValues(com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addValues(com.google.protobuf.Value.newBuilder().setStringValue("1.23")).addValues(com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE)).addValues(com.google.protobuf.Value.newBuilder().setStringValue("2.34")).addValues(com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE)).build())).build()).build();
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(statement, result));
        try (ResultSet resultSet = this.databaseClient.singleUse().executeQuery(statement, new Options.QueryOption[0]);){
            resultSet.next();
            Assert.assertEquals((Object)Value.pgNumericArray(Arrays.asList("1.23", null, "2.34", null)), (Object)resultSet.getValue("PgNumericArray"));
            Assert.assertEquals((Object)Value.pgNumericArray(Arrays.asList("1.23", null, "2.34", null)), (Object)resultSet.getValue(1));
        }
    }

    @Test
    public void testQueryNaNs() {
        Statement statement = Statement.of((String)"SELECT PgNumeric, PgNumericArray FROM Table WHERE Id = 2");
        com.google.spanner.v1.ResultSet result = com.google.spanner.v1.ResultSet.newBuilder().setMetadata(RESULT_SET_METADATA).addRows(ListValue.newBuilder().addValues(com.google.protobuf.Value.newBuilder().setStringValue("NaN")).addValues(com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addValues(com.google.protobuf.Value.newBuilder().setStringValue("NaN")).addValues(com.google.protobuf.Value.newBuilder().setStringValue("NaN")).build())).build()).build();
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(statement, result));
        try (ResultSet resultSet = this.databaseClient.singleUse().executeQuery(statement, new Options.QueryOption[0]);){
            resultSet.next();
            Assert.assertEquals((Object)Value.pgNumeric((String)"NaN"), (Object)resultSet.getValue("PgNumeric"));
            Assert.assertEquals((Object)Value.pgNumeric((String)"NaN"), (Object)resultSet.getValue(0));
            Assert.assertEquals((Object)Value.pgNumericArray(Arrays.asList("NaN", "NaN")), (Object)resultSet.getValue("PgNumericArray"));
            Assert.assertEquals((Object)Value.pgNumericArray(Arrays.asList("NaN", "NaN")), (Object)resultSet.getValue(1));
        }
    }

    @Test
    public void testQueryNulls() {
        Statement statement = Statement.of((String)"SELECT PgNumeric, PgNumericArray FROM Table WHERE Id = 1");
        com.google.spanner.v1.ResultSet result = com.google.spanner.v1.ResultSet.newBuilder().setMetadata(RESULT_SET_METADATA).addRows(ListValue.newBuilder().addValues(com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE)).addValues(com.google.protobuf.Value.newBuilder().setNullValue(NullValue.NULL_VALUE)).build()).build();
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(statement, result));
        try (ResultSet resultSet = this.databaseClient.singleUse().executeQuery(statement, new Options.QueryOption[0]);){
            resultSet.next();
            Assert.assertTrue((boolean)resultSet.isNull("PgNumeric"));
            Assert.assertTrue((boolean)resultSet.isNull(0));
            Assert.assertTrue((boolean)resultSet.isNull("PgNumericArray"));
            Assert.assertTrue((boolean)resultSet.isNull(1));
        }
    }

    @Test
    public void testMutation() {
        List<Mutation> mutations = Collections.singletonList(((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)"Table").set("PgNumeric").to("1.23")).set("PgNumericNull").to((String)null)).set("PgNumericNaN").to("NaN")).set("PgNumericValue").to(Value.pgNumeric((String)"2.34"))).set("PgNumericArray").toStringArray(Arrays.asList("2.34", null, "3.45"))).set("PgNumericArrayNull").toStringArray(null)).build());
        ArrayList expectedMutations = new ArrayList();
        Mutation.toProtoAndReturnRandomMutation(mutations, expectedMutations);
        this.databaseClient.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> {
            transaction.buffer((Iterable)mutations);
            return null;
        });
        List<CommitRequest> requests = mockSpanner.getRequestsOfType(CommitRequest.class);
        CommitRequest request = requests.get(0);
        Assert.assertEquals((long)1L, (long)requests.size());
        Assert.assertEquals(expectedMutations, (Object)request.getMutationsList());
    }

    @Test
    public void testParameterizedStatement() {
        Statement statement = ((Statement.Builder)((Statement.Builder)((Statement.Builder)Statement.newBuilder((String)"SELECT * FROM Table WHERE PgNumeric IN (@col1, @col2, @col3)").bind("col1").to(Value.pgNumeric((String)"1.23"))).bind("col2").to(Value.pgNumeric((String)"NaN"))).bind("col3").to(Value.pgNumeric(null))).build();
        com.google.spanner.v1.ResultSet result = com.google.spanner.v1.ResultSet.newBuilder().setMetadata(RESULT_SET_METADATA).addRows(ListValue.newBuilder().build()).build();
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(statement, result));
        try (ResultSet resultSet = this.databaseClient.singleUse().executeQuery(statement, new Options.QueryOption[0]);){
            resultSet.next();
            List<ExecuteSqlRequest> requests = mockSpanner.getRequestsOfType(ExecuteSqlRequest.class);
            ExecuteSqlRequest request = requests.get(0);
            Assert.assertEquals((long)1L, (long)requests.size());
            Assert.assertEquals((Object)ImmutableMap.of((Object)"col1", (Object)Type.pgNumeric().toProto(), (Object)"col2", (Object)Type.pgNumeric().toProto(), (Object)"col3", (Object)Type.pgNumeric().toProto()), (Object)request.getParamTypesMap());
        }
    }
}

