/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.connection.AbstractMockServerTest;
import com.google.spanner.v1.BatchCreateSessionsRequest;
import com.google.spanner.v1.ExecuteSqlRequest;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Status;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.threeten.bp.Duration;

@RunWith(value=JUnit4.class)
public class RetryableInternalErrorTest
extends AbstractMockServerTest {
    @Test
    public void testTranslateInternalException() {
        mockSpanner.setBatchCreateSessionsExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)Status.INTERNAL.withDescription("Authentication backend internal server error. Please retry.").asRuntimeException()));
        mockSpanner.setExecuteStreamingSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)Status.INTERNAL.withDescription("Authentication backend internal server error. Please retry.").asRuntimeException()));
        try (Spanner spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("my-project")).setHost(String.format("http://localhost:%d", this.getPort())).setChannelConfigurator(ManagedChannelBuilder::usePlaintext).setCredentials((Credentials)NoCredentials.getInstance())).setSessionPoolOption(SessionPoolOptions.newBuilder().setMinSessions(1).setMaxSessions(1).setWaitForMinSessions(Duration.ofSeconds((long)5L)).build()).build().getService();){
            DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
            try (ResultSet resultSet = client.singleUse().executeQuery(SELECT1_STATEMENT, new Options.QueryOption[0]);){
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertFalse((boolean)resultSet.next());
            }
            Assert.assertEquals((long)2L, (long)mockSpanner.countRequestsOfType(BatchCreateSessionsRequest.class));
            Assert.assertEquals((long)2L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
            mockSpanner.clearRequests();
            Assert.assertEquals((long)0L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
            mockSpanner.setExecuteSqlExecutionTime(MockSpannerServiceImpl.SimulatedExecutionTime.ofException((Exception)Status.INTERNAL.withDescription("Authentication backend internal server error. Please retry.").asRuntimeException()));
            Assert.assertEquals((Object)1L, (Object)client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> transaction.executeUpdate(INSERT_STATEMENT, new Options.UpdateOption[0])));
            Assert.assertEquals((long)2L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        }
    }
}

