/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.AbstractMockServerTest;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import java.time.Duration;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SamplesMockServerTest
extends AbstractMockServerTest {
    @Test
    public void testSampleRetrySettings() {
        String sql = "INSERT INTO Singers (SingerId, FirstName, LastName)\nVALUES (20, 'George', 'Washington')";
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(Statement.of((String)sql), 1L));
        SpannerOptions.Builder builder = ((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("p")).setCredentials((Credentials)NoCredentials.getInstance())).setChannelProvider((TransportChannelProvider)channelProvider);
        builder.getSpannerStubSettingsBuilder().executeSqlSettings().setRetryableCodes(new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE}).setRetrySettings(RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(500L)).setMaxRetryDelayDuration(Duration.ofSeconds(16L)).setRetryDelayMultiplier(1.5).setInitialRpcTimeoutDuration(Duration.ofNanos(1L)).setMaxRpcTimeoutDuration(Duration.ofNanos(1L)).setRpcTimeoutMultiplier(1.0).setTotalTimeoutDuration(Duration.ofNanos(1L)).build());
        try (Spanner spanner = (Spanner)builder.build().getService();){
            DatabaseClient client = spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
            SpannerException exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> client.readWriteTransaction(new Options.TransactionOption[0]).run(transaction -> transaction.executeUpdate(Statement.of((String)sql), new Options.UpdateOption[0])));
            Assert.assertEquals((Object)ErrorCode.DEADLINE_EXCEEDED, (Object)exception.getErrorCode());
        }
    }
}

