/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.AbstractMockServerTest;
import com.google.cloud.spanner.Clock;
import com.google.cloud.spanner.DatabaseClientImpl;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.FakeClock;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.common.base.Stopwatch;
import com.google.protobuf.ListValue;
import com.google.protobuf.Value;
import com.google.spanner.v1.BatchCreateSessionsRequest;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.ResultSetMetadata;
import com.google.spanner.v1.StructType;
import com.google.spanner.v1.Type;
import com.google.spanner.v1.TypeCode;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SessionPoolMaintainerMockServerTest
extends AbstractMockServerTest {
    private final FakeClock clock = new FakeClock();

    @BeforeClass
    public static void setupResults() {
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.query(Statement.of((String)"SELECT 1"), com.google.spanner.v1.ResultSet.newBuilder().setMetadata(ResultSetMetadata.newBuilder().setRowType(StructType.newBuilder().addFields(StructType.Field.newBuilder().setName("C").setType(Type.newBuilder().setCode(TypeCode.INT64).build()).build()).build()).build()).addRows(ListValue.newBuilder().addValues(Value.newBuilder().setStringValue("1").build()).build()).build()));
    }

    @Override
    @Before
    public void createSpannerInstance() {
        this.clock.currentTimeMillis.set(System.currentTimeMillis());
        this.spanner = (Spanner)((SpannerOptions.Builder)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId("p")).setChannelProvider((TransportChannelProvider)channelProvider).setCredentials((Credentials)NoCredentials.getInstance())).setSessionPoolOption(SessionPoolOptions.newBuilder().setPoolMaintainerClock((Clock)this.clock).setWaitForMinSessionsDuration(Duration.ofSeconds(10L)).setFailOnSessionLeak().build()).build().getService();
    }

    @Test
    public void testMaintain() {
        int minSessions = ((SpannerOptions)this.spanner.getOptions()).getSessionPoolOptions().getMinSessions();
        DatabaseClientImpl client = (DatabaseClientImpl)this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
        Assert.assertEquals((long)minSessions, (long)mockSpanner.getSessions().size());
        Assert.assertEquals((long)0L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        this.clock.currentTimeMillis.addAndGet(Duration.ofMinutes(35L).toMillis());
        client.pool.poolMaintainer.maintainPool();
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        client.pool.poolMaintainer.maintainPool();
        Assert.assertEquals((long)2L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        this.clock.currentTimeMillis.addAndGet(Duration.ofMinutes(21L).toMillis());
        mockSpanner.freeze();
        client.pool.poolMaintainer.maintainPool();
        Assert.assertEquals((long)2L, (long)client.pool.totalSessions());
        mockSpanner.unfreeze();
        client.pool.poolMaintainer.maintainPool();
        Assert.assertEquals((long)minSessions, (long)client.pool.getTotalSessionsPlusNumSessionsBeingCreated());
        Stopwatch watch = Stopwatch.createStarted();
        while (client.pool.totalSessions() < minSessions && watch.elapsed(TimeUnit.MILLISECONDS) < ((SpannerOptions)this.spanner.getOptions()).getSessionPoolOptions().getWaitForMinSessions().toMillis()) {
        }
        Assert.assertEquals((long)minSessions, (long)client.pool.totalSessions());
    }

    @Test
    public void testSessionNotFoundIsRetried() {
        Assume.assumeFalse((String)"Session not found errors are not relevant for multiplexed sessions", (boolean)((SpannerOptions)this.spanner.getOptions()).getSessionPoolOptions().getUseMultiplexedSession());
        int minSessions = ((SpannerOptions)this.spanner.getOptions()).getSessionPoolOptions().getMinSessions();
        DatabaseClientImpl client = (DatabaseClientImpl)this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
        Assert.assertEquals((long)minSessions, (long)mockSpanner.getSessions().size());
        mockSpanner.getSessions().clear();
        try (ResultSet resultSet = client.singleUse().executeQuery(Statement.of((String)"SELECT 1"), new Options.QueryOption[0]);){
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((long)1L, (long)resultSet.getLong(0));
            Assert.assertFalse((boolean)resultSet.next());
        }
        int numRequests = mockSpanner.countRequestsOfType(ExecuteSqlRequest.class);
        Assert.assertTrue((String)String.format("Number of requests should be larger than 1, but was %d", numRequests), (numRequests > 1 ? 1 : 0) != 0);
    }

    @Test
    public void testMaintainerReplenishesPoolIfAllAreInvalid() {
        int minSessions = ((SpannerOptions)this.spanner.getOptions()).getSessionPoolOptions().getMinSessions();
        DatabaseClientImpl client = (DatabaseClientImpl)this.spanner.getDatabaseClient(DatabaseId.of((String)"p", (String)"i", (String)"d"));
        Assert.assertEquals((long)minSessions, (long)mockSpanner.getSessions().size());
        mockSpanner.getSessions().clear();
        this.clock.currentTimeMillis.addAndGet(Duration.ofMinutes(35L).toMillis());
        client.pool.poolMaintainer.maintainPool();
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        Stopwatch watch = Stopwatch.createStarted();
        while (client.pool.totalSessions() < minSessions && watch.elapsed(TimeUnit.MILLISECONDS) < ((SpannerOptions)this.spanner.getOptions()).getSessionPoolOptions().getWaitForMinSessions().toMillis()) {
        }
        Assert.assertEquals((long)minSessions, (long)client.pool.totalSessions());
        Assert.assertEquals((long)(((SpannerOptions)this.spanner.getOptions()).getNumChannels() + 1), (long)mockSpanner.countRequestsOfType(BatchCreateSessionsRequest.class));
    }
}

