/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.SessionPoolOptions;
import com.google.common.truth.Truth;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ThreadLocalRandom;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SessionPoolOptionsTest {
    @Parameterized.Parameter
    public int minSessions;
    @Parameterized.Parameter(value=1)
    public int maxSessions;

    @Parameterized.Parameters(name="min sessions = {0}, max sessions = {1}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        params.add(new Object[]{1, 1});
        params.add(new Object[]{500, 600});
        params.add(new Object[]{600, 500});
        return params;
    }

    @Test
    public void setMinMaxSessions() {
        try {
            SessionPoolOptions options = SessionPoolOptions.newBuilder().setMinSessions(this.minSessions).setMaxSessions(this.maxSessions).build();
            if (this.minSessions > this.maxSessions) {
                Assert.fail((String)"Expected exception");
            }
            Truth.assertThat((Integer)this.minSessions).isEqualTo((Object)options.getMinSessions());
            Truth.assertThat((Integer)this.maxSessions).isEqualTo((Object)options.getMaxSessions());
        }
        catch (IllegalArgumentException ex) {
            if (this.minSessions <= this.maxSessions) {
                throw ex;
            }
            Assert.assertNotNull((Object)ex.getMessage());
        }
    }

    @Test
    public void setOnlyMaxSessions() {
        int defaultMinSessions = 100;
        SessionPoolOptions options = SessionPoolOptions.newBuilder().setMaxSessions(101).build();
        Truth.assertThat((Integer)options.getMaxSessions()).isEqualTo((Object)101);
        Truth.assertThat((Integer)options.getMinSessions()).isEqualTo((Object)100);
        options = SessionPoolOptions.newBuilder().setMaxSessions(99).build();
        Truth.assertThat((Integer)options.getMaxSessions()).isEqualTo((Object)99);
        Truth.assertThat((Integer)options.getMinSessions()).isEqualTo((Object)99);
    }

    @Test
    public void setValidMinSessions() {
        SessionPoolOptions.newBuilder().setMinSessions(0).build();
        SessionPoolOptions.newBuilder().setMinSessions(1).build();
        SessionPoolOptions.newBuilder().setMinSessions(400).build();
        SessionPoolOptions.newBuilder().setMaxSessions(Integer.MAX_VALUE).setMinSessions(Integer.MAX_VALUE).build();
    }

    @Test(expected=IllegalArgumentException.class)
    public void setNegativeMinSessions() {
        SessionPoolOptions.newBuilder().setMinSessions(-1);
    }

    @Test
    public void setValidMaxSessions() {
        SessionPoolOptions.newBuilder().setMaxSessions(1).build();
        SessionPoolOptions.newBuilder().setMaxSessions(400).build();
        SessionPoolOptions.newBuilder().setMaxSessions(Integer.MAX_VALUE).build();
    }

    @Test(expected=IllegalArgumentException.class)
    public void setZeroMaxSessions() {
        SessionPoolOptions.newBuilder().setMaxSessions(0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void setNegativeMaxSessions() {
        SessionPoolOptions.newBuilder().setMaxSessions(-1);
    }

    @Test
    public void verifyDefaultInactiveTransactionRemovalOptions() {
        SessionPoolOptions sessionPoolOptions = SessionPoolOptions.newBuilder().build();
        SessionPoolOptions.InactiveTransactionRemovalOptions inactiveTransactionRemovalOptions = sessionPoolOptions.getInactiveTransactionRemovalOptions();
        Assert.assertTrue((boolean)sessionPoolOptions.warnInactiveTransactions());
        Assert.assertFalse((boolean)sessionPoolOptions.warnAndCloseInactiveTransactions());
        Assert.assertFalse((boolean)sessionPoolOptions.closeInactiveTransactions());
        Assert.assertEquals((double)0.95, (double)inactiveTransactionRemovalOptions.getUsedSessionsRatioThreshold(), (double)0.0);
        Assert.assertEquals((Object)Duration.ofMinutes(2L), (Object)inactiveTransactionRemovalOptions.getExecutionFrequency());
        Assert.assertEquals((Object)Duration.ofMinutes(60L), (Object)inactiveTransactionRemovalOptions.getIdleTimeThreshold());
    }

    @Test
    public void setWarnIfInactiveTransactions() {
        SessionPoolOptions sessionPoolOptions = SessionPoolOptions.newBuilder().setWarnIfInactiveTransactions().build();
        Assert.assertTrue((boolean)sessionPoolOptions.warnInactiveTransactions());
        Assert.assertFalse((boolean)sessionPoolOptions.warnAndCloseInactiveTransactions());
        Assert.assertFalse((boolean)sessionPoolOptions.closeInactiveTransactions());
    }

    @Test
    public void setWarnAndCloseIfInactiveTransactions() {
        SessionPoolOptions sessionPoolOptions = SessionPoolOptions.newBuilder().setWarnAndCloseIfInactiveTransactions().build();
        Assert.assertFalse((boolean)sessionPoolOptions.warnInactiveTransactions());
        Assert.assertTrue((boolean)sessionPoolOptions.warnAndCloseInactiveTransactions());
        Assert.assertFalse((boolean)sessionPoolOptions.closeInactiveTransactions());
    }

    @Test
    public void setCloseIfInactiveTransactions() {
        SessionPoolOptions sessionPoolOptions = SessionPoolOptions.newBuilder().setCloseIfInactiveTransactions().build();
        Assert.assertFalse((boolean)sessionPoolOptions.warnInactiveTransactions());
        Assert.assertFalse((boolean)sessionPoolOptions.warnAndCloseInactiveTransactions());
        Assert.assertTrue((boolean)sessionPoolOptions.closeInactiveTransactions());
    }

    @Test
    public void testSetUsedSessionsRatioThreshold() {
        double threshold = ThreadLocalRandom.current().nextDouble();
        SessionPoolOptions.InactiveTransactionRemovalOptions inactiveTransactionRemovalOptions = SessionPoolOptions.InactiveTransactionRemovalOptions.newBuilder().setUsedSessionsRatioThreshold(threshold).build();
        Assert.assertEquals((double)threshold, (double)inactiveTransactionRemovalOptions.getUsedSessionsRatioThreshold(), (double)0.0);
    }

    @Test
    public void testBlockIfPoolExhausted() {
        Assert.assertTrue((boolean)SessionPoolOptions.newBuilder().build().isBlockIfPoolExhausted());
        Assert.assertTrue((boolean)SessionPoolOptions.newBuilder().setBlockIfPoolExhausted().build().isBlockIfPoolExhausted());
        Assert.assertFalse((boolean)SessionPoolOptions.newBuilder().setFailIfPoolExhausted().build().isBlockIfPoolExhausted());
    }

    @Test
    public void testFailIfSessionNotFound() {
        Assert.assertFalse((boolean)SessionPoolOptions.newBuilder().build().isFailIfSessionNotFound());
        Assert.assertTrue((boolean)SessionPoolOptions.newBuilder().setFailIfSessionNotFound().build().isFailIfSessionNotFound());
    }

    @Test(expected=IllegalArgumentException.class)
    public void setNegativeExecutionFrequency() {
        SessionPoolOptions.InactiveTransactionRemovalOptions inactiveTransactionRemovalOptions = SessionPoolOptions.InactiveTransactionRemovalOptions.newBuilder().setExecutionFrequency(Duration.ofMillis(-1L)).build();
        SessionPoolOptions.newBuilder().setInactiveTransactionRemovalOptions(inactiveTransactionRemovalOptions);
    }

    @Test(expected=IllegalArgumentException.class)
    public void setNegativeIdleTimeThreshold() {
        SessionPoolOptions.InactiveTransactionRemovalOptions inactiveTransactionRemovalOptions = SessionPoolOptions.InactiveTransactionRemovalOptions.newBuilder().setIdleTimeThreshold(Duration.ofMillis(-1L)).build();
        SessionPoolOptions.newBuilder().setInactiveTransactionRemovalOptions(inactiveTransactionRemovalOptions);
    }

    @Test
    public void setAcquireSessionTimeout() {
        SessionPoolOptions sessionPoolOptions1 = SessionPoolOptions.newBuilder().setAcquireSessionTimeoutDuration(Duration.ofSeconds(20L)).build();
        SessionPoolOptions sessionPoolOptions2 = SessionPoolOptions.newBuilder().setAcquireSessionTimeoutDuration(Duration.ofMillis(Long.MAX_VALUE)).build();
        Assert.assertEquals((Object)Duration.ofSeconds(20L), (Object)sessionPoolOptions1.getAcquireSessionTimeout());
        Assert.assertEquals((Object)Duration.ofMillis(Long.MAX_VALUE), (Object)sessionPoolOptions2.getAcquireSessionTimeout());
    }

    @Test(expected=IllegalArgumentException.class)
    public void setAcquireSessionTimeout_valueLessThanLowerBound() {
        SessionPoolOptions.newBuilder().setAcquireSessionTimeoutDuration(Duration.ofMillis(0L)).build();
    }

    @Test(expected=IllegalArgumentException.class)
    public void setAcquireSessionTimeout_valueMoreThanUpperBound() {
        SessionPoolOptions.newBuilder().setAcquireSessionTimeoutDuration(Duration.ofSeconds(Long.MAX_VALUE)).build();
    }

    @Test
    public void verifyDefaultAcquireSessionTimeout() {
        SessionPoolOptions sessionPoolOptions = SessionPoolOptions.newBuilder().build();
        Assert.assertEquals((Object)Duration.ofSeconds(60L), (Object)sessionPoolOptions.getAcquireSessionTimeout());
    }

    @Test
    public void testRandomizePositionQPSThreshold() {
        Assert.assertEquals((long)0L, (long)SessionPoolOptions.newBuilder().build().getRandomizePositionQPSThreshold());
        Assert.assertEquals((long)4L, (long)SessionPoolOptions.newBuilder().setRandomizePositionQPSThreshold(4L).build().getRandomizePositionQPSThreshold());
        Assert.assertEquals((long)10L, (long)SessionPoolOptions.newBuilder().setRandomizePositionQPSThreshold(4L).setRandomizePositionQPSThreshold(10L).build().getRandomizePositionQPSThreshold());
        Assert.assertEquals((long)0L, (long)SessionPoolOptions.newBuilder().setRandomizePositionQPSThreshold(0L).build().getRandomizePositionQPSThreshold());
        Assert.assertThrows(IllegalArgumentException.class, () -> SessionPoolOptions.newBuilder().setRandomizePositionQPSThreshold(-1L));
    }

    @Test
    public void testUseMultiplexedSession() {
        Assume.assumeFalse((boolean)SessionPoolOptions.newBuilder().build().getUseMultiplexedSession());
        Assert.assertEquals((Object)false, (Object)SessionPoolOptions.newBuilder().build().getUseMultiplexedSession());
        Assert.assertEquals((Object)true, (Object)SessionPoolOptions.newBuilder().setUseMultiplexedSession(true).build().getUseMultiplexedSession());
        Assert.assertEquals((Object)false, (Object)SessionPoolOptions.newBuilder().setUseMultiplexedSession(true).setUseMultiplexedSession(false).build().getUseMultiplexedSession());
    }

    @Test
    public void testUseMultiplexedSessionForRW() {
        Assume.assumeFalse((boolean)SessionPoolOptions.newBuilder().build().getUseMultiplexedSession());
        Assume.assumeFalse((boolean)SessionPoolOptions.newBuilder().build().getUseMultiplexedSessionForRW());
        Assert.assertEquals((Object)false, (Object)SessionPoolOptions.newBuilder().build().getUseMultiplexedSessionForRW());
        Assert.assertEquals((Object)true, (Object)SessionPoolOptions.newBuilder().setUseMultiplexedSession(true).setUseMultiplexedSessionForRW(true).build().getUseMultiplexedSessionForRW());
        Assert.assertEquals((Object)false, (Object)SessionPoolOptions.newBuilder().setUseMultiplexedSession(true).setUseMultiplexedSessionForRW(false).build().getUseMultiplexedSessionForRW());
        Assert.assertEquals((Object)false, (Object)SessionPoolOptions.newBuilder().setUseMultiplexedSession(false).setUseMultiplexedSessionForRW(true).build().getUseMultiplexedSessionForRW());
        Assert.assertEquals((Object)false, (Object)SessionPoolOptions.newBuilder().setUseMultiplexedSession(false).setUseMultiplexedSessionForRW(false).build().getUseMultiplexedSessionForRW());
    }

    @Test
    public void testMultiplexedSessionMaintenanceDuration() {
        Assert.assertEquals((Object)Duration.ofDays(7L), (Object)SessionPoolOptions.newBuilder().build().getMultiplexedSessionMaintenanceDuration());
        Assert.assertEquals((Object)Duration.ofDays(2L), (Object)SessionPoolOptions.newBuilder().setMultiplexedSessionMaintenanceDuration(Duration.ofDays(2L)).build().getMultiplexedSessionMaintenanceDuration());
        Assert.assertEquals((Object)Duration.ofDays(10L), (Object)SessionPoolOptions.newBuilder().setMultiplexedSessionMaintenanceDuration(Duration.ofDays(2L)).setMultiplexedSessionMaintenanceDuration(Duration.ofDays(10L)).build().getMultiplexedSessionMaintenanceDuration());
    }

    @Test
    public void testToBuilder() {
        SessionPoolOptionsTest.assertToBuilderRoundtrip(SessionPoolOptions.newBuilder().build());
        SessionPoolOptionsTest.assertToBuilderRoundtrip(SessionPoolOptions.newBuilder().setUseMultiplexedSession(ThreadLocalRandom.current().nextBoolean()).build());
        SessionPoolOptionsTest.assertToBuilderRoundtrip(SessionPoolOptions.newBuilder().setUseMultiplexedSessionForRW(ThreadLocalRandom.current().nextBoolean()).build());
        SessionPoolOptionsTest.assertToBuilderRoundtrip(SessionPoolOptions.newBuilder().setMinSessions(ThreadLocalRandom.current().nextInt(400)).build());
        SessionPoolOptionsTest.assertToBuilderRoundtrip(SessionPoolOptions.newBuilder().setMaxSessions(ThreadLocalRandom.current().nextInt(1, 1000)).build());
        SessionPoolOptionsTest.assertToBuilderRoundtrip(SessionPoolOptions.newBuilder().setIncStep(ThreadLocalRandom.current().nextInt(1, 1000)).build());
        SessionPoolOptionsTest.assertToBuilderRoundtrip(SessionPoolOptions.newBuilder().setMaxIdleSessions(ThreadLocalRandom.current().nextInt(1000)).build());
        SessionPoolOptionsTest.assertToBuilderRoundtrip(SessionPoolOptions.newBuilder().setWriteSessionsFraction(ThreadLocalRandom.current().nextFloat()).build());
        SessionPoolOptionsTest.assertToBuilderRoundtrip(SessionPoolOptions.newBuilder().setInactiveTransactionRemovalOptions(SessionPoolOptions.InactiveTransactionRemovalOptions.newBuilder().setUsedSessionsRatioThreshold(ThreadLocalRandom.current().nextDouble()).build()).build());
        SessionPoolOptionsTest.assertToBuilderRoundtrip(SessionPoolOptions.newBuilder().setLoopFrequency((long)ThreadLocalRandom.current().nextInt(1000)).build());
        SessionPoolOptionsTest.assertToBuilderRoundtrip(SessionPoolOptions.newBuilder().setMultiplexedSessionMaintenanceLoopFrequency(Duration.ofMillis(ThreadLocalRandom.current().nextInt(1000))).build());
        SessionPoolOptionsTest.assertToBuilderRoundtrip(SessionPoolOptions.newBuilder().setKeepAliveIntervalMinutes(ThreadLocalRandom.current().nextInt(60)).build());
        SessionPoolOptionsTest.assertToBuilderRoundtrip(SessionPoolOptions.newBuilder().setRemoveInactiveSessionAfterDuration(Duration.ofMillis(ThreadLocalRandom.current().nextLong(10000L))).build());
        SessionPoolOptionsTest.assertToBuilderRoundtrip(SessionPoolOptions.newBuilder().setCloseIfInactiveTransactions().build());
        SessionPoolOptionsTest.assertToBuilderRoundtrip(SessionPoolOptions.newBuilder().setFailOnSessionLeak().build());
        SessionPoolOptionsTest.assertToBuilderRoundtrip(SessionPoolOptions.newBuilder().setTrackStackTraceOfSessionCheckout(ThreadLocalRandom.current().nextBoolean()).build());
        SessionPoolOptionsTest.assertToBuilderRoundtrip(SessionPoolOptions.newBuilder().setInitialWaitForSessionTimeoutMillis(ThreadLocalRandom.current().nextLong(1000L)).build());
        SessionPoolOptionsTest.assertToBuilderRoundtrip(SessionPoolOptions.newBuilder().setAutoDetectDialect(ThreadLocalRandom.current().nextBoolean()).build());
        SessionPoolOptionsTest.assertToBuilderRoundtrip(SessionPoolOptions.newBuilder().setWaitForMinSessionsDuration(Duration.ofMillis(ThreadLocalRandom.current().nextLong(10000L))).build());
        SessionPoolOptionsTest.assertToBuilderRoundtrip(SessionPoolOptions.newBuilder().setAcquireSessionTimeoutDuration(Duration.ofMillis(ThreadLocalRandom.current().nextLong(1L, 10000L))).build());
        SessionPoolOptionsTest.assertToBuilderRoundtrip(SessionPoolOptions.newBuilder().setRandomizePositionQPSThreshold(ThreadLocalRandom.current().nextLong(10000L)).build());
        SessionPoolOptionsTest.assertToBuilderRoundtrip(SessionPoolOptions.newBuilder().setMultiplexedSessionMaintenanceDuration(Duration.ofMillis(ThreadLocalRandom.current().nextLong(10000L))).build());
    }

    static void assertToBuilderRoundtrip(SessionPoolOptions options) {
        Assert.assertEquals((Object)options, (Object)options.toBuilder().build());
    }
}

