/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.admin.database.v1;

import com.google.api.client.http.HttpTransport;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.testing.MockHttpService;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.testing.FakeStatusCode;
import com.google.api.resourcenames.ResourceName;
import com.google.cloud.spanner.admin.database.v1.DatabaseAdminClient;
import com.google.cloud.spanner.admin.database.v1.DatabaseAdminSettings;
import com.google.cloud.spanner.admin.database.v1.stub.HttpJsonDatabaseAdminStub;
import com.google.common.collect.Lists;
import com.google.iam.v1.Policy;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.Duration;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import com.google.spanner.admin.database.v1.Backup;
import com.google.spanner.admin.database.v1.BackupName;
import com.google.spanner.admin.database.v1.BackupSchedule;
import com.google.spanner.admin.database.v1.BackupScheduleName;
import com.google.spanner.admin.database.v1.BackupScheduleSpec;
import com.google.spanner.admin.database.v1.CreateBackupEncryptionConfig;
import com.google.spanner.admin.database.v1.Database;
import com.google.spanner.admin.database.v1.DatabaseDialect;
import com.google.spanner.admin.database.v1.DatabaseName;
import com.google.spanner.admin.database.v1.DatabaseRole;
import com.google.spanner.admin.database.v1.EncryptionConfig;
import com.google.spanner.admin.database.v1.EncryptionInfo;
import com.google.spanner.admin.database.v1.GetDatabaseDdlResponse;
import com.google.spanner.admin.database.v1.InstanceName;
import com.google.spanner.admin.database.v1.ListBackupOperationsResponse;
import com.google.spanner.admin.database.v1.ListBackupSchedulesResponse;
import com.google.spanner.admin.database.v1.ListBackupsResponse;
import com.google.spanner.admin.database.v1.ListDatabaseOperationsResponse;
import com.google.spanner.admin.database.v1.ListDatabaseRolesResponse;
import com.google.spanner.admin.database.v1.ListDatabasesResponse;
import com.google.spanner.admin.database.v1.RestoreInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class DatabaseAdminClientHttpJsonTest {
    private static MockHttpService mockService;
    private static DatabaseAdminClient client;

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockService = new MockHttpService(HttpJsonDatabaseAdminStub.getMethodDescriptors(), DatabaseAdminSettings.getDefaultEndpoint());
        DatabaseAdminSettings settings = ((DatabaseAdminSettings.Builder)((DatabaseAdminSettings.Builder)DatabaseAdminSettings.newHttpJsonBuilder().setTransportChannelProvider((TransportChannelProvider)DatabaseAdminSettings.defaultHttpJsonTransportProviderBuilder().setHttpTransport((HttpTransport)mockService).build())).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        client = DatabaseAdminClient.create((DatabaseAdminSettings)settings);
    }

    @AfterClass
    public static void stopServer() {
        client.close();
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() throws Exception {
        mockService.reset();
    }

    @Test
    public void listDatabasesTest() throws Exception {
        Database responsesElement = Database.newBuilder().build();
        ListDatabasesResponse expectedResponse = ListDatabasesResponse.newBuilder().setNextPageToken("").addAllDatabases(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
        DatabaseAdminClient.ListDatabasesPagedResponse pagedListResponse = client.listDatabases(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getDatabasesList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listDatabasesExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
            client.listDatabases(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listDatabasesTest2() throws Exception {
        Database responsesElement = Database.newBuilder().build();
        ListDatabasesResponse expectedResponse = ListDatabasesResponse.newBuilder().setNextPageToken("").addAllDatabases(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-8887/instances/instance-8887";
        DatabaseAdminClient.ListDatabasesPagedResponse pagedListResponse = client.listDatabases(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getDatabasesList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listDatabasesExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-8887/instances/instance-8887";
            client.listDatabases(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createDatabaseTest() throws Exception {
        Database expectedResponse = Database.newBuilder().setName(DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setRestoreInfo(RestoreInfo.newBuilder().build()).setEncryptionConfig(EncryptionConfig.newBuilder().build()).addAllEncryptionInfo(new ArrayList()).setVersionRetentionPeriod("versionRetentionPeriod-629783929").setEarliestVersionTime(Timestamp.newBuilder().build()).setDefaultLeader("defaultLeader759009962").setDatabaseDialect(DatabaseDialect.forNumber((int)0)).setEnableDropProtection(true).setReconciling(true).build();
        Operation resultOperation = Operation.newBuilder().setName("createDatabaseTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
        String createStatement = "createStatement744686547";
        Database actualResponse = (Database)client.createDatabaseAsync(parent, createStatement).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createDatabaseExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
            String createStatement = "createStatement744686547";
            client.createDatabaseAsync(parent, createStatement).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void createDatabaseTest2() throws Exception {
        Database expectedResponse = Database.newBuilder().setName(DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setRestoreInfo(RestoreInfo.newBuilder().build()).setEncryptionConfig(EncryptionConfig.newBuilder().build()).addAllEncryptionInfo(new ArrayList()).setVersionRetentionPeriod("versionRetentionPeriod-629783929").setEarliestVersionTime(Timestamp.newBuilder().build()).setDefaultLeader("defaultLeader759009962").setDatabaseDialect(DatabaseDialect.forNumber((int)0)).setEnableDropProtection(true).setReconciling(true).build();
        Operation resultOperation = Operation.newBuilder().setName("createDatabaseTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String parent = "projects/project-8887/instances/instance-8887";
        String createStatement = "createStatement744686547";
        Database actualResponse = (Database)client.createDatabaseAsync(parent, createStatement).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createDatabaseExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-8887/instances/instance-8887";
            String createStatement = "createStatement744686547";
            client.createDatabaseAsync(parent, createStatement).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void getDatabaseTest() throws Exception {
        Database expectedResponse = Database.newBuilder().setName(DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setRestoreInfo(RestoreInfo.newBuilder().build()).setEncryptionConfig(EncryptionConfig.newBuilder().build()).addAllEncryptionInfo(new ArrayList()).setVersionRetentionPeriod("versionRetentionPeriod-629783929").setEarliestVersionTime(Timestamp.newBuilder().build()).setDefaultLeader("defaultLeader759009962").setDatabaseDialect(DatabaseDialect.forNumber((int)0)).setEnableDropProtection(true).setReconciling(true).build();
        mockService.addResponse((Object)expectedResponse);
        DatabaseName name = DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]");
        Database actualResponse = client.getDatabase(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getDatabaseExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            DatabaseName name = DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]");
            client.getDatabase(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getDatabaseTest2() throws Exception {
        Database expectedResponse = Database.newBuilder().setName(DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setRestoreInfo(RestoreInfo.newBuilder().build()).setEncryptionConfig(EncryptionConfig.newBuilder().build()).addAllEncryptionInfo(new ArrayList()).setVersionRetentionPeriod("versionRetentionPeriod-629783929").setEarliestVersionTime(Timestamp.newBuilder().build()).setDefaultLeader("defaultLeader759009962").setDatabaseDialect(DatabaseDialect.forNumber((int)0)).setEnableDropProtection(true).setReconciling(true).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-5262/instances/instance-5262/databases/database-5262";
        Database actualResponse = client.getDatabase(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getDatabaseExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-5262/instances/instance-5262/databases/database-5262";
            client.getDatabase(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateDatabaseTest() throws Exception {
        Database expectedResponse = Database.newBuilder().setName(DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setRestoreInfo(RestoreInfo.newBuilder().build()).setEncryptionConfig(EncryptionConfig.newBuilder().build()).addAllEncryptionInfo(new ArrayList()).setVersionRetentionPeriod("versionRetentionPeriod-629783929").setEarliestVersionTime(Timestamp.newBuilder().build()).setDefaultLeader("defaultLeader759009962").setDatabaseDialect(DatabaseDialect.forNumber((int)0)).setEnableDropProtection(true).setReconciling(true).build();
        Operation resultOperation = Operation.newBuilder().setName("updateDatabaseTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        Database database = Database.newBuilder().setName(DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setRestoreInfo(RestoreInfo.newBuilder().build()).setEncryptionConfig(EncryptionConfig.newBuilder().build()).addAllEncryptionInfo(new ArrayList()).setVersionRetentionPeriod("versionRetentionPeriod-629783929").setEarliestVersionTime(Timestamp.newBuilder().build()).setDefaultLeader("defaultLeader759009962").setDatabaseDialect(DatabaseDialect.forNumber((int)0)).setEnableDropProtection(true).setReconciling(true).build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Database actualResponse = (Database)client.updateDatabaseAsync(database, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateDatabaseExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            Database database = Database.newBuilder().setName(DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setRestoreInfo(RestoreInfo.newBuilder().build()).setEncryptionConfig(EncryptionConfig.newBuilder().build()).addAllEncryptionInfo(new ArrayList()).setVersionRetentionPeriod("versionRetentionPeriod-629783929").setEarliestVersionTime(Timestamp.newBuilder().build()).setDefaultLeader("defaultLeader759009962").setDatabaseDialect(DatabaseDialect.forNumber((int)0)).setEnableDropProtection(true).setReconciling(true).build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.updateDatabaseAsync(database, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void updateDatabaseDdlTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("updateDatabaseDdlTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        DatabaseName database = DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]");
        ArrayList statements = new ArrayList();
        client.updateDatabaseDdlAsync(database, statements).get();
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateDatabaseDdlExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            DatabaseName database = DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]");
            ArrayList statements = new ArrayList();
            client.updateDatabaseDdlAsync(database, statements).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void updateDatabaseDdlTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("updateDatabaseDdlTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String database = "projects/project-3102/instances/instance-3102/databases/database-3102";
        ArrayList statements = new ArrayList();
        client.updateDatabaseDdlAsync(database, statements).get();
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateDatabaseDdlExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String database = "projects/project-3102/instances/instance-3102/databases/database-3102";
            ArrayList statements = new ArrayList();
            client.updateDatabaseDdlAsync(database, statements).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void dropDatabaseTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        DatabaseName database = DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]");
        client.dropDatabase(database);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void dropDatabaseExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            DatabaseName database = DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]");
            client.dropDatabase(database);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void dropDatabaseTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        String database = "projects/project-3102/instances/instance-3102/databases/database-3102";
        client.dropDatabase(database);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void dropDatabaseExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String database = "projects/project-3102/instances/instance-3102/databases/database-3102";
            client.dropDatabase(database);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getDatabaseDdlTest() throws Exception {
        GetDatabaseDdlResponse expectedResponse = GetDatabaseDdlResponse.newBuilder().addAllStatements(new ArrayList()).setProtoDescriptors(ByteString.EMPTY).build();
        mockService.addResponse((Object)expectedResponse);
        DatabaseName database = DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]");
        GetDatabaseDdlResponse actualResponse = client.getDatabaseDdl(database);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getDatabaseDdlExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            DatabaseName database = DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]");
            client.getDatabaseDdl(database);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getDatabaseDdlTest2() throws Exception {
        GetDatabaseDdlResponse expectedResponse = GetDatabaseDdlResponse.newBuilder().addAllStatements(new ArrayList()).setProtoDescriptors(ByteString.EMPTY).build();
        mockService.addResponse((Object)expectedResponse);
        String database = "projects/project-3102/instances/instance-3102/databases/database-3102";
        GetDatabaseDdlResponse actualResponse = client.getDatabaseDdl(database);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getDatabaseDdlExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String database = "projects/project-3102/instances/instance-3102/databases/database-3102";
            client.getDatabaseDdl(database);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void setIamPolicyTest() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockService.addResponse((Object)expectedResponse);
        BackupName resource = BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[BACKUP]");
        Policy policy = Policy.newBuilder().build();
        Policy actualResponse = client.setIamPolicy((ResourceName)resource, policy);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void setIamPolicyExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            BackupName resource = BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[BACKUP]");
            Policy policy = Policy.newBuilder().build();
            client.setIamPolicy((ResourceName)resource, policy);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void setIamPolicyTest2() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockService.addResponse((Object)expectedResponse);
        String resource = "projects/project-1023/instances/instance-1023/databases/database-1023";
        Policy policy = Policy.newBuilder().build();
        Policy actualResponse = client.setIamPolicy(resource, policy);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void setIamPolicyExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String resource = "projects/project-1023/instances/instance-1023/databases/database-1023";
            Policy policy = Policy.newBuilder().build();
            client.setIamPolicy(resource, policy);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getIamPolicyTest() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockService.addResponse((Object)expectedResponse);
        BackupName resource = BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[BACKUP]");
        Policy actualResponse = client.getIamPolicy((ResourceName)resource);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getIamPolicyExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            BackupName resource = BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[BACKUP]");
            client.getIamPolicy((ResourceName)resource);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getIamPolicyTest2() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockService.addResponse((Object)expectedResponse);
        String resource = "projects/project-1023/instances/instance-1023/databases/database-1023";
        Policy actualResponse = client.getIamPolicy(resource);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getIamPolicyExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String resource = "projects/project-1023/instances/instance-1023/databases/database-1023";
            client.getIamPolicy(resource);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testIamPermissionsTest() throws Exception {
        TestIamPermissionsResponse expectedResponse = TestIamPermissionsResponse.newBuilder().addAllPermissions(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        BackupName resource = BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[BACKUP]");
        ArrayList permissions = new ArrayList();
        TestIamPermissionsResponse actualResponse = client.testIamPermissions((ResourceName)resource, permissions);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void testIamPermissionsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            BackupName resource = BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[BACKUP]");
            ArrayList permissions = new ArrayList();
            client.testIamPermissions((ResourceName)resource, permissions);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testIamPermissionsTest2() throws Exception {
        TestIamPermissionsResponse expectedResponse = TestIamPermissionsResponse.newBuilder().addAllPermissions(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        String resource = "projects/project-1023/instances/instance-1023/databases/database-1023";
        ArrayList permissions = new ArrayList();
        TestIamPermissionsResponse actualResponse = client.testIamPermissions(resource, permissions);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void testIamPermissionsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String resource = "projects/project-1023/instances/instance-1023/databases/database-1023";
            ArrayList permissions = new ArrayList();
            client.testIamPermissions(resource, permissions);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createBackupTest() throws Exception {
        Backup expectedResponse = Backup.newBuilder().setDatabase(DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]").toString()).setVersionTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).setName(BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[BACKUP]").toString()).setCreateTime(Timestamp.newBuilder().build()).setSizeBytes(-1796325715L).setFreeableSizeBytes(1302251206L).setExclusiveSizeBytes(-1085921554L).addAllReferencingDatabases(new ArrayList()).setEncryptionInfo(EncryptionInfo.newBuilder().build()).addAllEncryptionInformation(new ArrayList()).setDatabaseDialect(DatabaseDialect.forNumber((int)0)).addAllReferencingBackups(new ArrayList()).setMaxExpireTime(Timestamp.newBuilder().build()).addAllBackupSchedules(new ArrayList()).setIncrementalBackupChainId("incrementalBackupChainId1926005216").setOldestVersionTime(Timestamp.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("createBackupTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
        Backup backup = Backup.newBuilder().build();
        String backupId = "backupId2121930365";
        Backup actualResponse = (Backup)client.createBackupAsync(parent, backup, backupId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createBackupExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
            Backup backup = Backup.newBuilder().build();
            String backupId = "backupId2121930365";
            client.createBackupAsync(parent, backup, backupId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void createBackupTest2() throws Exception {
        Backup expectedResponse = Backup.newBuilder().setDatabase(DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]").toString()).setVersionTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).setName(BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[BACKUP]").toString()).setCreateTime(Timestamp.newBuilder().build()).setSizeBytes(-1796325715L).setFreeableSizeBytes(1302251206L).setExclusiveSizeBytes(-1085921554L).addAllReferencingDatabases(new ArrayList()).setEncryptionInfo(EncryptionInfo.newBuilder().build()).addAllEncryptionInformation(new ArrayList()).setDatabaseDialect(DatabaseDialect.forNumber((int)0)).addAllReferencingBackups(new ArrayList()).setMaxExpireTime(Timestamp.newBuilder().build()).addAllBackupSchedules(new ArrayList()).setIncrementalBackupChainId("incrementalBackupChainId1926005216").setOldestVersionTime(Timestamp.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("createBackupTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String parent = "projects/project-8887/instances/instance-8887";
        Backup backup = Backup.newBuilder().build();
        String backupId = "backupId2121930365";
        Backup actualResponse = (Backup)client.createBackupAsync(parent, backup, backupId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createBackupExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-8887/instances/instance-8887";
            Backup backup = Backup.newBuilder().build();
            String backupId = "backupId2121930365";
            client.createBackupAsync(parent, backup, backupId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void copyBackupTest() throws Exception {
        Backup expectedResponse = Backup.newBuilder().setDatabase(DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]").toString()).setVersionTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).setName(BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[BACKUP]").toString()).setCreateTime(Timestamp.newBuilder().build()).setSizeBytes(-1796325715L).setFreeableSizeBytes(1302251206L).setExclusiveSizeBytes(-1085921554L).addAllReferencingDatabases(new ArrayList()).setEncryptionInfo(EncryptionInfo.newBuilder().build()).addAllEncryptionInformation(new ArrayList()).setDatabaseDialect(DatabaseDialect.forNumber((int)0)).addAllReferencingBackups(new ArrayList()).setMaxExpireTime(Timestamp.newBuilder().build()).addAllBackupSchedules(new ArrayList()).setIncrementalBackupChainId("incrementalBackupChainId1926005216").setOldestVersionTime(Timestamp.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("copyBackupTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
        String backupId = "backupId2121930365";
        BackupName sourceBackup = BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[BACKUP]");
        Timestamp expireTime = Timestamp.newBuilder().build();
        Backup actualResponse = (Backup)client.copyBackupAsync(parent, backupId, sourceBackup, expireTime).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void copyBackupExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
            String backupId = "backupId2121930365";
            BackupName sourceBackup = BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[BACKUP]");
            Timestamp expireTime = Timestamp.newBuilder().build();
            client.copyBackupAsync(parent, backupId, sourceBackup, expireTime).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void copyBackupTest2() throws Exception {
        Backup expectedResponse = Backup.newBuilder().setDatabase(DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]").toString()).setVersionTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).setName(BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[BACKUP]").toString()).setCreateTime(Timestamp.newBuilder().build()).setSizeBytes(-1796325715L).setFreeableSizeBytes(1302251206L).setExclusiveSizeBytes(-1085921554L).addAllReferencingDatabases(new ArrayList()).setEncryptionInfo(EncryptionInfo.newBuilder().build()).addAllEncryptionInformation(new ArrayList()).setDatabaseDialect(DatabaseDialect.forNumber((int)0)).addAllReferencingBackups(new ArrayList()).setMaxExpireTime(Timestamp.newBuilder().build()).addAllBackupSchedules(new ArrayList()).setIncrementalBackupChainId("incrementalBackupChainId1926005216").setOldestVersionTime(Timestamp.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("copyBackupTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
        String backupId = "backupId2121930365";
        String sourceBackup = "sourceBackup823134653";
        Timestamp expireTime = Timestamp.newBuilder().build();
        Backup actualResponse = (Backup)client.copyBackupAsync(parent, backupId, sourceBackup, expireTime).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void copyBackupExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
            String backupId = "backupId2121930365";
            String sourceBackup = "sourceBackup823134653";
            Timestamp expireTime = Timestamp.newBuilder().build();
            client.copyBackupAsync(parent, backupId, sourceBackup, expireTime).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void copyBackupTest3() throws Exception {
        Backup expectedResponse = Backup.newBuilder().setDatabase(DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]").toString()).setVersionTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).setName(BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[BACKUP]").toString()).setCreateTime(Timestamp.newBuilder().build()).setSizeBytes(-1796325715L).setFreeableSizeBytes(1302251206L).setExclusiveSizeBytes(-1085921554L).addAllReferencingDatabases(new ArrayList()).setEncryptionInfo(EncryptionInfo.newBuilder().build()).addAllEncryptionInformation(new ArrayList()).setDatabaseDialect(DatabaseDialect.forNumber((int)0)).addAllReferencingBackups(new ArrayList()).setMaxExpireTime(Timestamp.newBuilder().build()).addAllBackupSchedules(new ArrayList()).setIncrementalBackupChainId("incrementalBackupChainId1926005216").setOldestVersionTime(Timestamp.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("copyBackupTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String parent = "projects/project-8887/instances/instance-8887";
        String backupId = "backupId2121930365";
        BackupName sourceBackup = BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[BACKUP]");
        Timestamp expireTime = Timestamp.newBuilder().build();
        Backup actualResponse = (Backup)client.copyBackupAsync(parent, backupId, sourceBackup, expireTime).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void copyBackupExceptionTest3() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-8887/instances/instance-8887";
            String backupId = "backupId2121930365";
            BackupName sourceBackup = BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[BACKUP]");
            Timestamp expireTime = Timestamp.newBuilder().build();
            client.copyBackupAsync(parent, backupId, sourceBackup, expireTime).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void copyBackupTest4() throws Exception {
        Backup expectedResponse = Backup.newBuilder().setDatabase(DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]").toString()).setVersionTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).setName(BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[BACKUP]").toString()).setCreateTime(Timestamp.newBuilder().build()).setSizeBytes(-1796325715L).setFreeableSizeBytes(1302251206L).setExclusiveSizeBytes(-1085921554L).addAllReferencingDatabases(new ArrayList()).setEncryptionInfo(EncryptionInfo.newBuilder().build()).addAllEncryptionInformation(new ArrayList()).setDatabaseDialect(DatabaseDialect.forNumber((int)0)).addAllReferencingBackups(new ArrayList()).setMaxExpireTime(Timestamp.newBuilder().build()).addAllBackupSchedules(new ArrayList()).setIncrementalBackupChainId("incrementalBackupChainId1926005216").setOldestVersionTime(Timestamp.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("copyBackupTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String parent = "projects/project-8887/instances/instance-8887";
        String backupId = "backupId2121930365";
        String sourceBackup = "sourceBackup823134653";
        Timestamp expireTime = Timestamp.newBuilder().build();
        Backup actualResponse = (Backup)client.copyBackupAsync(parent, backupId, sourceBackup, expireTime).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void copyBackupExceptionTest4() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-8887/instances/instance-8887";
            String backupId = "backupId2121930365";
            String sourceBackup = "sourceBackup823134653";
            Timestamp expireTime = Timestamp.newBuilder().build();
            client.copyBackupAsync(parent, backupId, sourceBackup, expireTime).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void getBackupTest() throws Exception {
        Backup expectedResponse = Backup.newBuilder().setDatabase(DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]").toString()).setVersionTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).setName(BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[BACKUP]").toString()).setCreateTime(Timestamp.newBuilder().build()).setSizeBytes(-1796325715L).setFreeableSizeBytes(1302251206L).setExclusiveSizeBytes(-1085921554L).addAllReferencingDatabases(new ArrayList()).setEncryptionInfo(EncryptionInfo.newBuilder().build()).addAllEncryptionInformation(new ArrayList()).setDatabaseDialect(DatabaseDialect.forNumber((int)0)).addAllReferencingBackups(new ArrayList()).setMaxExpireTime(Timestamp.newBuilder().build()).addAllBackupSchedules(new ArrayList()).setIncrementalBackupChainId("incrementalBackupChainId1926005216").setOldestVersionTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        BackupName name = BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[BACKUP]");
        Backup actualResponse = client.getBackup(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getBackupExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            BackupName name = BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[BACKUP]");
            client.getBackup(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getBackupTest2() throws Exception {
        Backup expectedResponse = Backup.newBuilder().setDatabase(DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]").toString()).setVersionTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).setName(BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[BACKUP]").toString()).setCreateTime(Timestamp.newBuilder().build()).setSizeBytes(-1796325715L).setFreeableSizeBytes(1302251206L).setExclusiveSizeBytes(-1085921554L).addAllReferencingDatabases(new ArrayList()).setEncryptionInfo(EncryptionInfo.newBuilder().build()).addAllEncryptionInformation(new ArrayList()).setDatabaseDialect(DatabaseDialect.forNumber((int)0)).addAllReferencingBackups(new ArrayList()).setMaxExpireTime(Timestamp.newBuilder().build()).addAllBackupSchedules(new ArrayList()).setIncrementalBackupChainId("incrementalBackupChainId1926005216").setOldestVersionTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-3271/instances/instance-3271/backups/backup-3271";
        Backup actualResponse = client.getBackup(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getBackupExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-3271/instances/instance-3271/backups/backup-3271";
            client.getBackup(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateBackupTest() throws Exception {
        Backup expectedResponse = Backup.newBuilder().setDatabase(DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]").toString()).setVersionTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).setName(BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[BACKUP]").toString()).setCreateTime(Timestamp.newBuilder().build()).setSizeBytes(-1796325715L).setFreeableSizeBytes(1302251206L).setExclusiveSizeBytes(-1085921554L).addAllReferencingDatabases(new ArrayList()).setEncryptionInfo(EncryptionInfo.newBuilder().build()).addAllEncryptionInformation(new ArrayList()).setDatabaseDialect(DatabaseDialect.forNumber((int)0)).addAllReferencingBackups(new ArrayList()).setMaxExpireTime(Timestamp.newBuilder().build()).addAllBackupSchedules(new ArrayList()).setIncrementalBackupChainId("incrementalBackupChainId1926005216").setOldestVersionTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        Backup backup = Backup.newBuilder().setDatabase(DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]").toString()).setVersionTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).setName(BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[BACKUP]").toString()).setCreateTime(Timestamp.newBuilder().build()).setSizeBytes(-1796325715L).setFreeableSizeBytes(1302251206L).setExclusiveSizeBytes(-1085921554L).addAllReferencingDatabases(new ArrayList()).setEncryptionInfo(EncryptionInfo.newBuilder().build()).addAllEncryptionInformation(new ArrayList()).setDatabaseDialect(DatabaseDialect.forNumber((int)0)).addAllReferencingBackups(new ArrayList()).setMaxExpireTime(Timestamp.newBuilder().build()).addAllBackupSchedules(new ArrayList()).setIncrementalBackupChainId("incrementalBackupChainId1926005216").setOldestVersionTime(Timestamp.newBuilder().build()).build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Backup actualResponse = client.updateBackup(backup, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateBackupExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            Backup backup = Backup.newBuilder().setDatabase(DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]").toString()).setVersionTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).setName(BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[BACKUP]").toString()).setCreateTime(Timestamp.newBuilder().build()).setSizeBytes(-1796325715L).setFreeableSizeBytes(1302251206L).setExclusiveSizeBytes(-1085921554L).addAllReferencingDatabases(new ArrayList()).setEncryptionInfo(EncryptionInfo.newBuilder().build()).addAllEncryptionInformation(new ArrayList()).setDatabaseDialect(DatabaseDialect.forNumber((int)0)).addAllReferencingBackups(new ArrayList()).setMaxExpireTime(Timestamp.newBuilder().build()).addAllBackupSchedules(new ArrayList()).setIncrementalBackupChainId("incrementalBackupChainId1926005216").setOldestVersionTime(Timestamp.newBuilder().build()).build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.updateBackup(backup, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteBackupTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        BackupName name = BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[BACKUP]");
        client.deleteBackup(name);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteBackupExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            BackupName name = BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[BACKUP]");
            client.deleteBackup(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteBackupTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-3271/instances/instance-3271/backups/backup-3271";
        client.deleteBackup(name);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteBackupExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-3271/instances/instance-3271/backups/backup-3271";
            client.deleteBackup(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listBackupsTest() throws Exception {
        Backup responsesElement = Backup.newBuilder().build();
        ListBackupsResponse expectedResponse = ListBackupsResponse.newBuilder().setNextPageToken("").addAllBackups(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
        DatabaseAdminClient.ListBackupsPagedResponse pagedListResponse = client.listBackups(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getBackupsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listBackupsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
            client.listBackups(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listBackupsTest2() throws Exception {
        Backup responsesElement = Backup.newBuilder().build();
        ListBackupsResponse expectedResponse = ListBackupsResponse.newBuilder().setNextPageToken("").addAllBackups(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-8887/instances/instance-8887";
        DatabaseAdminClient.ListBackupsPagedResponse pagedListResponse = client.listBackups(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getBackupsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listBackupsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-8887/instances/instance-8887";
            client.listBackups(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void restoreDatabaseTest() throws Exception {
        Database expectedResponse = Database.newBuilder().setName(DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setRestoreInfo(RestoreInfo.newBuilder().build()).setEncryptionConfig(EncryptionConfig.newBuilder().build()).addAllEncryptionInfo(new ArrayList()).setVersionRetentionPeriod("versionRetentionPeriod-629783929").setEarliestVersionTime(Timestamp.newBuilder().build()).setDefaultLeader("defaultLeader759009962").setDatabaseDialect(DatabaseDialect.forNumber((int)0)).setEnableDropProtection(true).setReconciling(true).build();
        Operation resultOperation = Operation.newBuilder().setName("restoreDatabaseTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
        String databaseId = "databaseId1688905718";
        BackupName backup = BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[BACKUP]");
        Database actualResponse = (Database)client.restoreDatabaseAsync(parent, databaseId, backup).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void restoreDatabaseExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
            String databaseId = "databaseId1688905718";
            BackupName backup = BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[BACKUP]");
            client.restoreDatabaseAsync(parent, databaseId, backup).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void restoreDatabaseTest2() throws Exception {
        Database expectedResponse = Database.newBuilder().setName(DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setRestoreInfo(RestoreInfo.newBuilder().build()).setEncryptionConfig(EncryptionConfig.newBuilder().build()).addAllEncryptionInfo(new ArrayList()).setVersionRetentionPeriod("versionRetentionPeriod-629783929").setEarliestVersionTime(Timestamp.newBuilder().build()).setDefaultLeader("defaultLeader759009962").setDatabaseDialect(DatabaseDialect.forNumber((int)0)).setEnableDropProtection(true).setReconciling(true).build();
        Operation resultOperation = Operation.newBuilder().setName("restoreDatabaseTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
        String databaseId = "databaseId1688905718";
        String backup = "backup-1396673086";
        Database actualResponse = (Database)client.restoreDatabaseAsync(parent, databaseId, backup).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void restoreDatabaseExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
            String databaseId = "databaseId1688905718";
            String backup = "backup-1396673086";
            client.restoreDatabaseAsync(parent, databaseId, backup).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void restoreDatabaseTest3() throws Exception {
        Database expectedResponse = Database.newBuilder().setName(DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setRestoreInfo(RestoreInfo.newBuilder().build()).setEncryptionConfig(EncryptionConfig.newBuilder().build()).addAllEncryptionInfo(new ArrayList()).setVersionRetentionPeriod("versionRetentionPeriod-629783929").setEarliestVersionTime(Timestamp.newBuilder().build()).setDefaultLeader("defaultLeader759009962").setDatabaseDialect(DatabaseDialect.forNumber((int)0)).setEnableDropProtection(true).setReconciling(true).build();
        Operation resultOperation = Operation.newBuilder().setName("restoreDatabaseTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String parent = "projects/project-8887/instances/instance-8887";
        String databaseId = "databaseId1688905718";
        BackupName backup = BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[BACKUP]");
        Database actualResponse = (Database)client.restoreDatabaseAsync(parent, databaseId, backup).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void restoreDatabaseExceptionTest3() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-8887/instances/instance-8887";
            String databaseId = "databaseId1688905718";
            BackupName backup = BackupName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[BACKUP]");
            client.restoreDatabaseAsync(parent, databaseId, backup).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void restoreDatabaseTest4() throws Exception {
        Database expectedResponse = Database.newBuilder().setName(DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setRestoreInfo(RestoreInfo.newBuilder().build()).setEncryptionConfig(EncryptionConfig.newBuilder().build()).addAllEncryptionInfo(new ArrayList()).setVersionRetentionPeriod("versionRetentionPeriod-629783929").setEarliestVersionTime(Timestamp.newBuilder().build()).setDefaultLeader("defaultLeader759009962").setDatabaseDialect(DatabaseDialect.forNumber((int)0)).setEnableDropProtection(true).setReconciling(true).build();
        Operation resultOperation = Operation.newBuilder().setName("restoreDatabaseTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String parent = "projects/project-8887/instances/instance-8887";
        String databaseId = "databaseId1688905718";
        String backup = "backup-1396673086";
        Database actualResponse = (Database)client.restoreDatabaseAsync(parent, databaseId, backup).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void restoreDatabaseExceptionTest4() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-8887/instances/instance-8887";
            String databaseId = "databaseId1688905718";
            String backup = "backup-1396673086";
            client.restoreDatabaseAsync(parent, databaseId, backup).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void listDatabaseOperationsTest() throws Exception {
        Operation responsesElement = Operation.newBuilder().build();
        ListDatabaseOperationsResponse expectedResponse = ListDatabaseOperationsResponse.newBuilder().setNextPageToken("").addAllOperations(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
        DatabaseAdminClient.ListDatabaseOperationsPagedResponse pagedListResponse = client.listDatabaseOperations(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getOperationsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listDatabaseOperationsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
            client.listDatabaseOperations(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listDatabaseOperationsTest2() throws Exception {
        Operation responsesElement = Operation.newBuilder().build();
        ListDatabaseOperationsResponse expectedResponse = ListDatabaseOperationsResponse.newBuilder().setNextPageToken("").addAllOperations(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-8887/instances/instance-8887";
        DatabaseAdminClient.ListDatabaseOperationsPagedResponse pagedListResponse = client.listDatabaseOperations(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getOperationsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listDatabaseOperationsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-8887/instances/instance-8887";
            client.listDatabaseOperations(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listBackupOperationsTest() throws Exception {
        Operation responsesElement = Operation.newBuilder().build();
        ListBackupOperationsResponse expectedResponse = ListBackupOperationsResponse.newBuilder().setNextPageToken("").addAllOperations(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
        DatabaseAdminClient.ListBackupOperationsPagedResponse pagedListResponse = client.listBackupOperations(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getOperationsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listBackupOperationsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
            client.listBackupOperations(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listBackupOperationsTest2() throws Exception {
        Operation responsesElement = Operation.newBuilder().build();
        ListBackupOperationsResponse expectedResponse = ListBackupOperationsResponse.newBuilder().setNextPageToken("").addAllOperations(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-8887/instances/instance-8887";
        DatabaseAdminClient.ListBackupOperationsPagedResponse pagedListResponse = client.listBackupOperations(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getOperationsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listBackupOperationsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-8887/instances/instance-8887";
            client.listBackupOperations(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listDatabaseRolesTest() throws Exception {
        DatabaseRole responsesElement = DatabaseRole.newBuilder().build();
        ListDatabaseRolesResponse expectedResponse = ListDatabaseRolesResponse.newBuilder().setNextPageToken("").addAllDatabaseRoles(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        DatabaseName parent = DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]");
        DatabaseAdminClient.ListDatabaseRolesPagedResponse pagedListResponse = client.listDatabaseRoles(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getDatabaseRolesList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listDatabaseRolesExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            DatabaseName parent = DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]");
            client.listDatabaseRoles(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listDatabaseRolesTest2() throws Exception {
        DatabaseRole responsesElement = DatabaseRole.newBuilder().build();
        ListDatabaseRolesResponse expectedResponse = ListDatabaseRolesResponse.newBuilder().setNextPageToken("").addAllDatabaseRoles(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-9347/instances/instance-9347/databases/database-9347";
        DatabaseAdminClient.ListDatabaseRolesPagedResponse pagedListResponse = client.listDatabaseRoles(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getDatabaseRolesList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listDatabaseRolesExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-9347/instances/instance-9347/databases/database-9347";
            client.listDatabaseRoles(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createBackupScheduleTest() throws Exception {
        BackupSchedule expectedResponse = BackupSchedule.newBuilder().setName(BackupScheduleName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SCHEDULE]").toString()).setSpec(BackupScheduleSpec.newBuilder().build()).setRetentionDuration(Duration.newBuilder().build()).setEncryptionConfig(CreateBackupEncryptionConfig.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        DatabaseName parent = DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]");
        BackupSchedule backupSchedule = BackupSchedule.newBuilder().build();
        String backupScheduleId = "backupScheduleId1704974708";
        BackupSchedule actualResponse = client.createBackupSchedule(parent, backupSchedule, backupScheduleId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createBackupScheduleExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            DatabaseName parent = DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]");
            BackupSchedule backupSchedule = BackupSchedule.newBuilder().build();
            String backupScheduleId = "backupScheduleId1704974708";
            client.createBackupSchedule(parent, backupSchedule, backupScheduleId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createBackupScheduleTest2() throws Exception {
        BackupSchedule expectedResponse = BackupSchedule.newBuilder().setName(BackupScheduleName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SCHEDULE]").toString()).setSpec(BackupScheduleSpec.newBuilder().build()).setRetentionDuration(Duration.newBuilder().build()).setEncryptionConfig(CreateBackupEncryptionConfig.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-9347/instances/instance-9347/databases/database-9347";
        BackupSchedule backupSchedule = BackupSchedule.newBuilder().build();
        String backupScheduleId = "backupScheduleId1704974708";
        BackupSchedule actualResponse = client.createBackupSchedule(parent, backupSchedule, backupScheduleId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createBackupScheduleExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-9347/instances/instance-9347/databases/database-9347";
            BackupSchedule backupSchedule = BackupSchedule.newBuilder().build();
            String backupScheduleId = "backupScheduleId1704974708";
            client.createBackupSchedule(parent, backupSchedule, backupScheduleId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getBackupScheduleTest() throws Exception {
        BackupSchedule expectedResponse = BackupSchedule.newBuilder().setName(BackupScheduleName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SCHEDULE]").toString()).setSpec(BackupScheduleSpec.newBuilder().build()).setRetentionDuration(Duration.newBuilder().build()).setEncryptionConfig(CreateBackupEncryptionConfig.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        BackupScheduleName name = BackupScheduleName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SCHEDULE]");
        BackupSchedule actualResponse = client.getBackupSchedule(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getBackupScheduleExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            BackupScheduleName name = BackupScheduleName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SCHEDULE]");
            client.getBackupSchedule(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getBackupScheduleTest2() throws Exception {
        BackupSchedule expectedResponse = BackupSchedule.newBuilder().setName(BackupScheduleName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SCHEDULE]").toString()).setSpec(BackupScheduleSpec.newBuilder().build()).setRetentionDuration(Duration.newBuilder().build()).setEncryptionConfig(CreateBackupEncryptionConfig.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-8764/instances/instance-8764/databases/database-8764/backupSchedules/backupSchedule-8764";
        BackupSchedule actualResponse = client.getBackupSchedule(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getBackupScheduleExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-8764/instances/instance-8764/databases/database-8764/backupSchedules/backupSchedule-8764";
            client.getBackupSchedule(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateBackupScheduleTest() throws Exception {
        BackupSchedule expectedResponse = BackupSchedule.newBuilder().setName(BackupScheduleName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SCHEDULE]").toString()).setSpec(BackupScheduleSpec.newBuilder().build()).setRetentionDuration(Duration.newBuilder().build()).setEncryptionConfig(CreateBackupEncryptionConfig.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        BackupSchedule backupSchedule = BackupSchedule.newBuilder().setName(BackupScheduleName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SCHEDULE]").toString()).setSpec(BackupScheduleSpec.newBuilder().build()).setRetentionDuration(Duration.newBuilder().build()).setEncryptionConfig(CreateBackupEncryptionConfig.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        BackupSchedule actualResponse = client.updateBackupSchedule(backupSchedule, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateBackupScheduleExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            BackupSchedule backupSchedule = BackupSchedule.newBuilder().setName(BackupScheduleName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SCHEDULE]").toString()).setSpec(BackupScheduleSpec.newBuilder().build()).setRetentionDuration(Duration.newBuilder().build()).setEncryptionConfig(CreateBackupEncryptionConfig.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.updateBackupSchedule(backupSchedule, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteBackupScheduleTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        BackupScheduleName name = BackupScheduleName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SCHEDULE]");
        client.deleteBackupSchedule(name);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteBackupScheduleExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            BackupScheduleName name = BackupScheduleName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]", (String)"[SCHEDULE]");
            client.deleteBackupSchedule(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteBackupScheduleTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-8764/instances/instance-8764/databases/database-8764/backupSchedules/backupSchedule-8764";
        client.deleteBackupSchedule(name);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteBackupScheduleExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-8764/instances/instance-8764/databases/database-8764/backupSchedules/backupSchedule-8764";
            client.deleteBackupSchedule(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listBackupSchedulesTest() throws Exception {
        BackupSchedule responsesElement = BackupSchedule.newBuilder().build();
        ListBackupSchedulesResponse expectedResponse = ListBackupSchedulesResponse.newBuilder().setNextPageToken("").addAllBackupSchedules(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        DatabaseName parent = DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]");
        DatabaseAdminClient.ListBackupSchedulesPagedResponse pagedListResponse = client.listBackupSchedules(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getBackupSchedulesList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listBackupSchedulesExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            DatabaseName parent = DatabaseName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[DATABASE]");
            client.listBackupSchedules(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listBackupSchedulesTest2() throws Exception {
        BackupSchedule responsesElement = BackupSchedule.newBuilder().build();
        ListBackupSchedulesResponse expectedResponse = ListBackupSchedulesResponse.newBuilder().setNextPageToken("").addAllBackupSchedules(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-9347/instances/instance-9347/databases/database-9347";
        DatabaseAdminClient.ListBackupSchedulesPagedResponse pagedListResponse = client.listBackupSchedules(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getBackupSchedulesList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listBackupSchedulesExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-9347/instances/instance-9347/databases/database-9347";
            client.listBackupSchedules(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

