/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.admin.instance.v1;

import com.google.api.client.http.HttpTransport;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.testing.MockHttpService;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.testing.FakeStatusCode;
import com.google.api.resourcenames.ResourceName;
import com.google.cloud.spanner.admin.instance.v1.InstanceAdminClient;
import com.google.cloud.spanner.admin.instance.v1.InstanceAdminSettings;
import com.google.cloud.spanner.admin.instance.v1.stub.HttpJsonInstanceAdminStub;
import com.google.common.collect.Lists;
import com.google.iam.v1.Policy;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import com.google.spanner.admin.instance.v1.AutoscalingConfig;
import com.google.spanner.admin.instance.v1.FreeInstanceMetadata;
import com.google.spanner.admin.instance.v1.Instance;
import com.google.spanner.admin.instance.v1.InstanceConfig;
import com.google.spanner.admin.instance.v1.InstanceConfigName;
import com.google.spanner.admin.instance.v1.InstanceName;
import com.google.spanner.admin.instance.v1.InstancePartition;
import com.google.spanner.admin.instance.v1.InstancePartitionName;
import com.google.spanner.admin.instance.v1.ListInstanceConfigOperationsResponse;
import com.google.spanner.admin.instance.v1.ListInstanceConfigsResponse;
import com.google.spanner.admin.instance.v1.ListInstancePartitionOperationsResponse;
import com.google.spanner.admin.instance.v1.ListInstancePartitionsResponse;
import com.google.spanner.admin.instance.v1.ListInstancesResponse;
import com.google.spanner.admin.instance.v1.MoveInstanceRequest;
import com.google.spanner.admin.instance.v1.MoveInstanceResponse;
import com.google.spanner.admin.instance.v1.ProjectName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class InstanceAdminClientHttpJsonTest {
    private static MockHttpService mockService;
    private static InstanceAdminClient client;

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockService = new MockHttpService(HttpJsonInstanceAdminStub.getMethodDescriptors(), InstanceAdminSettings.getDefaultEndpoint());
        InstanceAdminSettings settings = ((InstanceAdminSettings.Builder)((InstanceAdminSettings.Builder)InstanceAdminSettings.newHttpJsonBuilder().setTransportChannelProvider((TransportChannelProvider)InstanceAdminSettings.defaultHttpJsonTransportProviderBuilder().setHttpTransport((HttpTransport)mockService).build())).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        client = InstanceAdminClient.create((InstanceAdminSettings)settings);
    }

    @AfterClass
    public static void stopServer() {
        client.close();
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() throws Exception {
        mockService.reset();
    }

    @Test
    public void listInstanceConfigsTest() throws Exception {
        InstanceConfig responsesElement = InstanceConfig.newBuilder().build();
        ListInstanceConfigsResponse expectedResponse = ListInstanceConfigsResponse.newBuilder().setNextPageToken("").addAllInstanceConfigs(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        InstanceAdminClient.ListInstanceConfigsPagedResponse pagedListResponse = client.listInstanceConfigs(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getInstanceConfigsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listInstanceConfigsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            client.listInstanceConfigs(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listInstanceConfigsTest2() throws Exception {
        InstanceConfig responsesElement = InstanceConfig.newBuilder().build();
        ListInstanceConfigsResponse expectedResponse = ListInstanceConfigsResponse.newBuilder().setNextPageToken("").addAllInstanceConfigs(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-2353";
        InstanceAdminClient.ListInstanceConfigsPagedResponse pagedListResponse = client.listInstanceConfigs(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getInstanceConfigsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listInstanceConfigsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-2353";
            client.listInstanceConfigs(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getInstanceConfigTest() throws Exception {
        InstanceConfig expectedResponse = InstanceConfig.newBuilder().setName(InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]").toString()).setDisplayName("displayName1714148973").addAllReplicas(new ArrayList()).addAllOptionalReplicas(new ArrayList()).setBaseConfig(InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]").toString()).putAllLabels(new HashMap()).setEtag("etag3123477").addAllLeaderOptions(new ArrayList()).setReconciling(true).setStorageLimitPerProcessingUnit(-1769187130L).build();
        mockService.addResponse((Object)expectedResponse);
        InstanceConfigName name = InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]");
        InstanceConfig actualResponse = client.getInstanceConfig(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getInstanceConfigExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            InstanceConfigName name = InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]");
            client.getInstanceConfig(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getInstanceConfigTest2() throws Exception {
        InstanceConfig expectedResponse = InstanceConfig.newBuilder().setName(InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]").toString()).setDisplayName("displayName1714148973").addAllReplicas(new ArrayList()).addAllOptionalReplicas(new ArrayList()).setBaseConfig(InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]").toString()).putAllLabels(new HashMap()).setEtag("etag3123477").addAllLeaderOptions(new ArrayList()).setReconciling(true).setStorageLimitPerProcessingUnit(-1769187130L).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-3640/instanceConfigs/instanceConfig-3640";
        InstanceConfig actualResponse = client.getInstanceConfig(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getInstanceConfigExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-3640/instanceConfigs/instanceConfig-3640";
            client.getInstanceConfig(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createInstanceConfigTest() throws Exception {
        InstanceConfig expectedResponse = InstanceConfig.newBuilder().setName(InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]").toString()).setDisplayName("displayName1714148973").addAllReplicas(new ArrayList()).addAllOptionalReplicas(new ArrayList()).setBaseConfig(InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]").toString()).putAllLabels(new HashMap()).setEtag("etag3123477").addAllLeaderOptions(new ArrayList()).setReconciling(true).setStorageLimitPerProcessingUnit(-1769187130L).build();
        Operation resultOperation = Operation.newBuilder().setName("createInstanceConfigTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        InstanceConfig instanceConfig = InstanceConfig.newBuilder().build();
        String instanceConfigId = "instanceConfigId1750947762";
        InstanceConfig actualResponse = (InstanceConfig)client.createInstanceConfigAsync(parent, instanceConfig, instanceConfigId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createInstanceConfigExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            InstanceConfig instanceConfig = InstanceConfig.newBuilder().build();
            String instanceConfigId = "instanceConfigId1750947762";
            client.createInstanceConfigAsync(parent, instanceConfig, instanceConfigId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void createInstanceConfigTest2() throws Exception {
        InstanceConfig expectedResponse = InstanceConfig.newBuilder().setName(InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]").toString()).setDisplayName("displayName1714148973").addAllReplicas(new ArrayList()).addAllOptionalReplicas(new ArrayList()).setBaseConfig(InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]").toString()).putAllLabels(new HashMap()).setEtag("etag3123477").addAllLeaderOptions(new ArrayList()).setReconciling(true).setStorageLimitPerProcessingUnit(-1769187130L).build();
        Operation resultOperation = Operation.newBuilder().setName("createInstanceConfigTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String parent = "projects/project-2353";
        InstanceConfig instanceConfig = InstanceConfig.newBuilder().build();
        String instanceConfigId = "instanceConfigId1750947762";
        InstanceConfig actualResponse = (InstanceConfig)client.createInstanceConfigAsync(parent, instanceConfig, instanceConfigId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createInstanceConfigExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-2353";
            InstanceConfig instanceConfig = InstanceConfig.newBuilder().build();
            String instanceConfigId = "instanceConfigId1750947762";
            client.createInstanceConfigAsync(parent, instanceConfig, instanceConfigId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void updateInstanceConfigTest() throws Exception {
        InstanceConfig expectedResponse = InstanceConfig.newBuilder().setName(InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]").toString()).setDisplayName("displayName1714148973").addAllReplicas(new ArrayList()).addAllOptionalReplicas(new ArrayList()).setBaseConfig(InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]").toString()).putAllLabels(new HashMap()).setEtag("etag3123477").addAllLeaderOptions(new ArrayList()).setReconciling(true).setStorageLimitPerProcessingUnit(-1769187130L).build();
        Operation resultOperation = Operation.newBuilder().setName("updateInstanceConfigTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        InstanceConfig instanceConfig = InstanceConfig.newBuilder().setName(InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]").toString()).setDisplayName("displayName1714148973").addAllReplicas(new ArrayList()).addAllOptionalReplicas(new ArrayList()).setBaseConfig(InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]").toString()).putAllLabels(new HashMap()).setEtag("etag3123477").addAllLeaderOptions(new ArrayList()).setReconciling(true).setStorageLimitPerProcessingUnit(-1769187130L).build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        InstanceConfig actualResponse = (InstanceConfig)client.updateInstanceConfigAsync(instanceConfig, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateInstanceConfigExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            InstanceConfig instanceConfig = InstanceConfig.newBuilder().setName(InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]").toString()).setDisplayName("displayName1714148973").addAllReplicas(new ArrayList()).addAllOptionalReplicas(new ArrayList()).setBaseConfig(InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]").toString()).putAllLabels(new HashMap()).setEtag("etag3123477").addAllLeaderOptions(new ArrayList()).setReconciling(true).setStorageLimitPerProcessingUnit(-1769187130L).build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.updateInstanceConfigAsync(instanceConfig, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deleteInstanceConfigTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        InstanceConfigName name = InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]");
        client.deleteInstanceConfig(name);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteInstanceConfigExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            InstanceConfigName name = InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]");
            client.deleteInstanceConfig(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteInstanceConfigTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-3640/instanceConfigs/instanceConfig-3640";
        client.deleteInstanceConfig(name);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteInstanceConfigExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-3640/instanceConfigs/instanceConfig-3640";
            client.deleteInstanceConfig(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listInstanceConfigOperationsTest() throws Exception {
        Operation responsesElement = Operation.newBuilder().build();
        ListInstanceConfigOperationsResponse expectedResponse = ListInstanceConfigOperationsResponse.newBuilder().setNextPageToken("").addAllOperations(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        InstanceAdminClient.ListInstanceConfigOperationsPagedResponse pagedListResponse = client.listInstanceConfigOperations(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getOperationsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listInstanceConfigOperationsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            client.listInstanceConfigOperations(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listInstanceConfigOperationsTest2() throws Exception {
        Operation responsesElement = Operation.newBuilder().build();
        ListInstanceConfigOperationsResponse expectedResponse = ListInstanceConfigOperationsResponse.newBuilder().setNextPageToken("").addAllOperations(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-2353";
        InstanceAdminClient.ListInstanceConfigOperationsPagedResponse pagedListResponse = client.listInstanceConfigOperations(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getOperationsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listInstanceConfigOperationsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-2353";
            client.listInstanceConfigOperations(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listInstancesTest() throws Exception {
        Instance responsesElement = Instance.newBuilder().build();
        ListInstancesResponse expectedResponse = ListInstancesResponse.newBuilder().setNextPageToken("").addAllInstances(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        InstanceAdminClient.ListInstancesPagedResponse pagedListResponse = client.listInstances(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getInstancesList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listInstancesExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            client.listInstances(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listInstancesTest2() throws Exception {
        Instance responsesElement = Instance.newBuilder().build();
        ListInstancesResponse expectedResponse = ListInstancesResponse.newBuilder().setNextPageToken("").addAllInstances(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-2353";
        InstanceAdminClient.ListInstancesPagedResponse pagedListResponse = client.listInstances(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getInstancesList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listInstancesExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-2353";
            client.listInstances(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listInstancePartitionsTest() throws Exception {
        InstancePartition responsesElement = InstancePartition.newBuilder().build();
        ListInstancePartitionsResponse expectedResponse = ListInstancePartitionsResponse.newBuilder().setNextPageToken("").addAllInstancePartitions(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
        InstanceAdminClient.ListInstancePartitionsPagedResponse pagedListResponse = client.listInstancePartitions(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getInstancePartitionsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listInstancePartitionsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
            client.listInstancePartitions(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listInstancePartitionsTest2() throws Exception {
        InstancePartition responsesElement = InstancePartition.newBuilder().build();
        ListInstancePartitionsResponse expectedResponse = ListInstancePartitionsResponse.newBuilder().setNextPageToken("").addAllInstancePartitions(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-8887/instances/instance-8887";
        InstanceAdminClient.ListInstancePartitionsPagedResponse pagedListResponse = client.listInstancePartitions(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getInstancePartitionsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listInstancePartitionsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-8887/instances/instance-8887";
            client.listInstancePartitions(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getInstanceTest() throws Exception {
        Instance expectedResponse = Instance.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]").toString()).setConfig(InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]").toString()).setDisplayName("displayName1714148973").setNodeCount(1539922066).setProcessingUnits(-329117885).addAllReplicaComputeCapacity(new ArrayList()).setAutoscalingConfig(AutoscalingConfig.newBuilder().build()).putAllLabels(new HashMap()).addAllEndpointUris(new ArrayList()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setFreeInstanceMetadata(FreeInstanceMetadata.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        InstanceName name = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
        Instance actualResponse = client.getInstance(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getInstanceExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            InstanceName name = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
            client.getInstance(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getInstanceTest2() throws Exception {
        Instance expectedResponse = Instance.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]").toString()).setConfig(InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]").toString()).setDisplayName("displayName1714148973").setNodeCount(1539922066).setProcessingUnits(-329117885).addAllReplicaComputeCapacity(new ArrayList()).setAutoscalingConfig(AutoscalingConfig.newBuilder().build()).putAllLabels(new HashMap()).addAllEndpointUris(new ArrayList()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setFreeInstanceMetadata(FreeInstanceMetadata.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-3514/instances/instance-3514";
        Instance actualResponse = client.getInstance(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getInstanceExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-3514/instances/instance-3514";
            client.getInstance(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createInstanceTest() throws Exception {
        Instance expectedResponse = Instance.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]").toString()).setConfig(InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]").toString()).setDisplayName("displayName1714148973").setNodeCount(1539922066).setProcessingUnits(-329117885).addAllReplicaComputeCapacity(new ArrayList()).setAutoscalingConfig(AutoscalingConfig.newBuilder().build()).putAllLabels(new HashMap()).addAllEndpointUris(new ArrayList()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setFreeInstanceMetadata(FreeInstanceMetadata.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("createInstanceTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        ProjectName parent = ProjectName.of((String)"[PROJECT]");
        String instanceId = "instanceId902024336";
        Instance instance = Instance.newBuilder().build();
        Instance actualResponse = (Instance)client.createInstanceAsync(parent, instanceId, instance).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createInstanceExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ProjectName parent = ProjectName.of((String)"[PROJECT]");
            String instanceId = "instanceId902024336";
            Instance instance = Instance.newBuilder().build();
            client.createInstanceAsync(parent, instanceId, instance).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void createInstanceTest2() throws Exception {
        Instance expectedResponse = Instance.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]").toString()).setConfig(InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]").toString()).setDisplayName("displayName1714148973").setNodeCount(1539922066).setProcessingUnits(-329117885).addAllReplicaComputeCapacity(new ArrayList()).setAutoscalingConfig(AutoscalingConfig.newBuilder().build()).putAllLabels(new HashMap()).addAllEndpointUris(new ArrayList()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setFreeInstanceMetadata(FreeInstanceMetadata.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("createInstanceTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String parent = "projects/project-2353";
        String instanceId = "instanceId902024336";
        Instance instance = Instance.newBuilder().build();
        Instance actualResponse = (Instance)client.createInstanceAsync(parent, instanceId, instance).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createInstanceExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-2353";
            String instanceId = "instanceId902024336";
            Instance instance = Instance.newBuilder().build();
            client.createInstanceAsync(parent, instanceId, instance).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void updateInstanceTest() throws Exception {
        Instance expectedResponse = Instance.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]").toString()).setConfig(InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]").toString()).setDisplayName("displayName1714148973").setNodeCount(1539922066).setProcessingUnits(-329117885).addAllReplicaComputeCapacity(new ArrayList()).setAutoscalingConfig(AutoscalingConfig.newBuilder().build()).putAllLabels(new HashMap()).addAllEndpointUris(new ArrayList()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setFreeInstanceMetadata(FreeInstanceMetadata.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("updateInstanceTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        Instance instance = Instance.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]").toString()).setConfig(InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]").toString()).setDisplayName("displayName1714148973").setNodeCount(1539922066).setProcessingUnits(-329117885).addAllReplicaComputeCapacity(new ArrayList()).setAutoscalingConfig(AutoscalingConfig.newBuilder().build()).putAllLabels(new HashMap()).addAllEndpointUris(new ArrayList()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setFreeInstanceMetadata(FreeInstanceMetadata.newBuilder().build()).build();
        FieldMask fieldMask = FieldMask.newBuilder().build();
        Instance actualResponse = (Instance)client.updateInstanceAsync(instance, fieldMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateInstanceExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            Instance instance = Instance.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]").toString()).setConfig(InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]").toString()).setDisplayName("displayName1714148973").setNodeCount(1539922066).setProcessingUnits(-329117885).addAllReplicaComputeCapacity(new ArrayList()).setAutoscalingConfig(AutoscalingConfig.newBuilder().build()).putAllLabels(new HashMap()).addAllEndpointUris(new ArrayList()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setFreeInstanceMetadata(FreeInstanceMetadata.newBuilder().build()).build();
            FieldMask fieldMask = FieldMask.newBuilder().build();
            client.updateInstanceAsync(instance, fieldMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deleteInstanceTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        InstanceName name = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
        client.deleteInstance(name);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteInstanceExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            InstanceName name = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
            client.deleteInstance(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteInstanceTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-3514/instances/instance-3514";
        client.deleteInstance(name);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteInstanceExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-3514/instances/instance-3514";
            client.deleteInstance(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void setIamPolicyTest() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockService.addResponse((Object)expectedResponse);
        InstanceName resource = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
        Policy policy = Policy.newBuilder().build();
        Policy actualResponse = client.setIamPolicy((ResourceName)resource, policy);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void setIamPolicyExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            InstanceName resource = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
            Policy policy = Policy.newBuilder().build();
            client.setIamPolicy((ResourceName)resource, policy);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void setIamPolicyTest2() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockService.addResponse((Object)expectedResponse);
        String resource = "projects/project-3043/instances/instance-3043";
        Policy policy = Policy.newBuilder().build();
        Policy actualResponse = client.setIamPolicy(resource, policy);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void setIamPolicyExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String resource = "projects/project-3043/instances/instance-3043";
            Policy policy = Policy.newBuilder().build();
            client.setIamPolicy(resource, policy);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getIamPolicyTest() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockService.addResponse((Object)expectedResponse);
        InstanceName resource = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
        Policy actualResponse = client.getIamPolicy((ResourceName)resource);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getIamPolicyExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            InstanceName resource = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
            client.getIamPolicy((ResourceName)resource);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getIamPolicyTest2() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockService.addResponse((Object)expectedResponse);
        String resource = "projects/project-3043/instances/instance-3043";
        Policy actualResponse = client.getIamPolicy(resource);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getIamPolicyExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String resource = "projects/project-3043/instances/instance-3043";
            client.getIamPolicy(resource);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testIamPermissionsTest() throws Exception {
        TestIamPermissionsResponse expectedResponse = TestIamPermissionsResponse.newBuilder().addAllPermissions(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        InstanceName resource = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
        ArrayList permissions = new ArrayList();
        TestIamPermissionsResponse actualResponse = client.testIamPermissions((ResourceName)resource, permissions);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void testIamPermissionsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            InstanceName resource = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
            ArrayList permissions = new ArrayList();
            client.testIamPermissions((ResourceName)resource, permissions);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testIamPermissionsTest2() throws Exception {
        TestIamPermissionsResponse expectedResponse = TestIamPermissionsResponse.newBuilder().addAllPermissions(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        String resource = "projects/project-3043/instances/instance-3043";
        ArrayList permissions = new ArrayList();
        TestIamPermissionsResponse actualResponse = client.testIamPermissions(resource, permissions);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void testIamPermissionsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String resource = "projects/project-3043/instances/instance-3043";
            ArrayList permissions = new ArrayList();
            client.testIamPermissions(resource, permissions);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getInstancePartitionTest() throws Exception {
        InstancePartition expectedResponse = InstancePartition.newBuilder().setName(InstancePartitionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[INSTANCE_PARTITION]").toString()).setConfig(InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]").toString()).setDisplayName("displayName1714148973").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).addAllReferencingDatabases(new ArrayList()).addAllReferencingBackups(new ArrayList()).setEtag("etag3123477").build();
        mockService.addResponse((Object)expectedResponse);
        InstancePartitionName name = InstancePartitionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[INSTANCE_PARTITION]");
        InstancePartition actualResponse = client.getInstancePartition(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getInstancePartitionExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            InstancePartitionName name = InstancePartitionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[INSTANCE_PARTITION]");
            client.getInstancePartition(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getInstancePartitionTest2() throws Exception {
        InstancePartition expectedResponse = InstancePartition.newBuilder().setName(InstancePartitionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[INSTANCE_PARTITION]").toString()).setConfig(InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]").toString()).setDisplayName("displayName1714148973").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).addAllReferencingDatabases(new ArrayList()).addAllReferencingBackups(new ArrayList()).setEtag("etag3123477").build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-9266/instances/instance-9266/instancePartitions/instancePartition-9266";
        InstancePartition actualResponse = client.getInstancePartition(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getInstancePartitionExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-9266/instances/instance-9266/instancePartitions/instancePartition-9266";
            client.getInstancePartition(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createInstancePartitionTest() throws Exception {
        InstancePartition expectedResponse = InstancePartition.newBuilder().setName(InstancePartitionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[INSTANCE_PARTITION]").toString()).setConfig(InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]").toString()).setDisplayName("displayName1714148973").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).addAllReferencingDatabases(new ArrayList()).addAllReferencingBackups(new ArrayList()).setEtag("etag3123477").build();
        Operation resultOperation = Operation.newBuilder().setName("createInstancePartitionTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
        InstancePartition instancePartition = InstancePartition.newBuilder().build();
        String instancePartitionId = "instancePartitionId1364450768";
        InstancePartition actualResponse = (InstancePartition)client.createInstancePartitionAsync(parent, instancePartition, instancePartitionId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createInstancePartitionExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
            InstancePartition instancePartition = InstancePartition.newBuilder().build();
            String instancePartitionId = "instancePartitionId1364450768";
            client.createInstancePartitionAsync(parent, instancePartition, instancePartitionId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void createInstancePartitionTest2() throws Exception {
        InstancePartition expectedResponse = InstancePartition.newBuilder().setName(InstancePartitionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[INSTANCE_PARTITION]").toString()).setConfig(InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]").toString()).setDisplayName("displayName1714148973").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).addAllReferencingDatabases(new ArrayList()).addAllReferencingBackups(new ArrayList()).setEtag("etag3123477").build();
        Operation resultOperation = Operation.newBuilder().setName("createInstancePartitionTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String parent = "projects/project-8887/instances/instance-8887";
        InstancePartition instancePartition = InstancePartition.newBuilder().build();
        String instancePartitionId = "instancePartitionId1364450768";
        InstancePartition actualResponse = (InstancePartition)client.createInstancePartitionAsync(parent, instancePartition, instancePartitionId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createInstancePartitionExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-8887/instances/instance-8887";
            InstancePartition instancePartition = InstancePartition.newBuilder().build();
            String instancePartitionId = "instancePartitionId1364450768";
            client.createInstancePartitionAsync(parent, instancePartition, instancePartitionId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deleteInstancePartitionTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        InstancePartitionName name = InstancePartitionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[INSTANCE_PARTITION]");
        client.deleteInstancePartition(name);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteInstancePartitionExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            InstancePartitionName name = InstancePartitionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[INSTANCE_PARTITION]");
            client.deleteInstancePartition(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteInstancePartitionTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-9266/instances/instance-9266/instancePartitions/instancePartition-9266";
        client.deleteInstancePartition(name);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteInstancePartitionExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-9266/instances/instance-9266/instancePartitions/instancePartition-9266";
            client.deleteInstancePartition(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateInstancePartitionTest() throws Exception {
        InstancePartition expectedResponse = InstancePartition.newBuilder().setName(InstancePartitionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[INSTANCE_PARTITION]").toString()).setConfig(InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]").toString()).setDisplayName("displayName1714148973").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).addAllReferencingDatabases(new ArrayList()).addAllReferencingBackups(new ArrayList()).setEtag("etag3123477").build();
        Operation resultOperation = Operation.newBuilder().setName("updateInstancePartitionTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        InstancePartition instancePartition = InstancePartition.newBuilder().setName(InstancePartitionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[INSTANCE_PARTITION]").toString()).setConfig(InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]").toString()).setDisplayName("displayName1714148973").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).addAllReferencingDatabases(new ArrayList()).addAllReferencingBackups(new ArrayList()).setEtag("etag3123477").build();
        FieldMask fieldMask = FieldMask.newBuilder().build();
        InstancePartition actualResponse = (InstancePartition)client.updateInstancePartitionAsync(instancePartition, fieldMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateInstancePartitionExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            InstancePartition instancePartition = InstancePartition.newBuilder().setName(InstancePartitionName.of((String)"[PROJECT]", (String)"[INSTANCE]", (String)"[INSTANCE_PARTITION]").toString()).setConfig(InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]").toString()).setDisplayName("displayName1714148973").setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).addAllReferencingDatabases(new ArrayList()).addAllReferencingBackups(new ArrayList()).setEtag("etag3123477").build();
            FieldMask fieldMask = FieldMask.newBuilder().build();
            client.updateInstancePartitionAsync(instancePartition, fieldMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void listInstancePartitionOperationsTest() throws Exception {
        Operation responsesElement = Operation.newBuilder().build();
        ListInstancePartitionOperationsResponse expectedResponse = ListInstancePartitionOperationsResponse.newBuilder().setNextPageToken("").addAllOperations(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
        InstanceAdminClient.ListInstancePartitionOperationsPagedResponse pagedListResponse = client.listInstancePartitionOperations(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getOperationsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listInstancePartitionOperationsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]");
            client.listInstancePartitionOperations(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listInstancePartitionOperationsTest2() throws Exception {
        Operation responsesElement = Operation.newBuilder().build();
        ListInstancePartitionOperationsResponse expectedResponse = ListInstancePartitionOperationsResponse.newBuilder().setNextPageToken("").addAllOperations(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-8887/instances/instance-8887";
        InstanceAdminClient.ListInstancePartitionOperationsPagedResponse pagedListResponse = client.listInstancePartitionOperations(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getOperationsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listInstancePartitionOperationsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-8887/instances/instance-8887";
            client.listInstancePartitionOperations(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void moveInstanceTest() throws Exception {
        MoveInstanceResponse expectedResponse = MoveInstanceResponse.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("moveInstanceTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        MoveInstanceRequest request = MoveInstanceRequest.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]").toString()).setTargetConfig(InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]").toString()).build();
        MoveInstanceResponse actualResponse = (MoveInstanceResponse)client.moveInstanceAsync(request).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void moveInstanceExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            MoveInstanceRequest request = MoveInstanceRequest.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[INSTANCE]").toString()).setTargetConfig(InstanceConfigName.of((String)"[PROJECT]", (String)"[INSTANCE_CONFIG]").toString()).build();
            client.moveInstanceAsync(request).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }
}

