/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.AbortedDueToConcurrentModificationException;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.MockSpannerServiceImpl;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerBatchUpdateException;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.connection.AbstractMockServerTest;
import com.google.cloud.spanner.connection.Connection;
import com.google.cloud.spanner.connection.ITAbstractSpannerTest;
import com.google.cloud.spanner.connection.SavepointSupport;
import com.google.cloud.spanner.connection.SpannerPool;
import com.google.cloud.spanner.connection.StatementResult;
import com.google.common.collect.ImmutableList;
import com.google.spanner.v1.CommitRequest;
import com.google.spanner.v1.ExecuteBatchDmlRequest;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.RollbackRequest;
import io.grpc.Status;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class AutoDmlBatchMockServerTest
extends AbstractMockServerTest {
    @Override
    protected ITAbstractSpannerTest.ITConnection createConnection() {
        return this.createConnection(";auto_batch_dml=true");
    }

    @Test
    public void testDmlInAutocommit_doesNotUseAutoBatching() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            Assert.assertTrue((boolean)connection.isAutoBatchDml());
            connection.setAutocommit(true);
            Assert.assertEquals((long)1L, (long)connection.executeUpdate(INSERT_STATEMENT));
            Assert.assertEquals((long)1L, (long)connection.executeUpdate(INSERT_STATEMENT));
        }
        Assert.assertEquals((long)0L, (long)mockSpanner.countRequestsOfType(ExecuteBatchDmlRequest.class));
        Assert.assertEquals((long)2L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        Assert.assertEquals((long)2L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
    }

    @Test
    public void testQueryAfterDml() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            Assert.assertEquals((long)1L, (long)connection.executeUpdate(INSERT_STATEMENT));
            Assert.assertEquals((long)1L, (long)connection.executeUpdate(INSERT_STATEMENT));
            try (ResultSet resultSet = connection.executeQuery(SELECT1_STATEMENT, new Options.QueryOption[0]);){
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertEquals((long)1L, (long)resultSet.getLong(0));
                Assert.assertFalse((boolean)resultSet.next());
            }
            connection.commit();
        }
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteBatchDmlRequest.class));
        ExecuteBatchDmlRequest request = mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).get(0);
        Assert.assertEquals((long)2L, (long)request.getStatementsCount());
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
    }

    @Test
    public void testDmlWithReturningAfterDml() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            Assert.assertEquals((long)1L, (long)connection.executeUpdate(INSERT_STATEMENT));
            Assert.assertEquals((long)1L, (long)connection.executeUpdate(INSERT_STATEMENT));
            try (ResultSet resultSet = connection.executeQuery(INSERT_RETURNING_STATEMENT, new Options.QueryOption[0]);){
                Assert.assertFalse((boolean)resultSet.next());
            }
            connection.commit();
        }
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteBatchDmlRequest.class));
        ExecuteBatchDmlRequest request = mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).get(0);
        Assert.assertEquals((long)2L, (long)request.getStatementsCount());
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
    }

    @Test
    public void testDmlWithReturningAfterDml_usingExecute() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.execute(INSERT_STATEMENT);
            connection.execute(INSERT_STATEMENT);
            StatementResult result = connection.execute(INSERT_RETURNING_STATEMENT);
            Assert.assertEquals((Object)StatementResult.ResultType.RESULT_SET, (Object)result.getResultType());
            try (ResultSet resultSet = result.getResultSet();){
                Assert.assertFalse((boolean)resultSet.next());
            }
            connection.commit();
        }
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteBatchDmlRequest.class));
        ExecuteBatchDmlRequest request = mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).get(0);
        Assert.assertEquals((long)2L, (long)request.getStatementsCount());
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
    }

    @Test
    public void testDmlAfterQuery() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            try (ResultSet resultSet = connection.executeQuery(SELECT1_STATEMENT, new Options.QueryOption[0]);){
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertEquals((long)1L, (long)resultSet.getLong(0));
                Assert.assertFalse((boolean)resultSet.next());
            }
            Assert.assertEquals((long)1L, (long)connection.executeUpdate(INSERT_STATEMENT));
            Assert.assertEquals((long)1L, (long)connection.executeUpdate(INSERT_STATEMENT));
            connection.commit();
        }
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteBatchDmlRequest.class));
        ExecuteBatchDmlRequest request = mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).get(0);
        Assert.assertEquals((long)2L, (long)request.getStatementsCount());
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
    }

    @Test
    public void testCommitAfterDml() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            Assert.assertEquals((long)1L, (long)connection.executeUpdate(INSERT_STATEMENT));
            Assert.assertEquals((long)1L, (long)connection.executeUpdate(INSERT_STATEMENT));
            connection.commit();
        }
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteBatchDmlRequest.class));
        ExecuteBatchDmlRequest request = mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).get(0);
        Assert.assertEquals((long)2L, (long)request.getStatementsCount());
        Assert.assertEquals((long)0L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
    }

    @Test
    public void testRollbackAfterDml() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            Assert.assertEquals((long)1L, (long)connection.executeUpdate(INSERT_STATEMENT));
            Assert.assertEquals((long)1L, (long)connection.executeUpdate(INSERT_STATEMENT));
            connection.rollback();
        }
        Assert.assertEquals((long)0L, (long)mockSpanner.countRequestsOfType(ExecuteBatchDmlRequest.class));
        Assert.assertEquals((long)0L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        Assert.assertEquals((long)0L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
        Assert.assertEquals((long)0L, (long)mockSpanner.countRequestsOfType(RollbackRequest.class));
    }

    @Test
    public void testSetAfterDml() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            Assert.assertEquals((long)1L, (long)connection.executeUpdate(INSERT_STATEMENT));
            Assert.assertEquals((long)1L, (long)connection.executeUpdate(INSERT_STATEMENT));
            connection.execute(Statement.of((String)"set auto_partition_mode=true"));
            connection.commit();
        }
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteBatchDmlRequest.class));
        ExecuteBatchDmlRequest request = mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).get(0);
        Assert.assertEquals((long)2L, (long)request.getStatementsCount());
        Assert.assertEquals((long)0L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
    }

    @Test
    public void testSetBetweenDml() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            Assert.assertEquals((long)1L, (long)connection.executeUpdate(INSERT_STATEMENT));
            connection.execute(Statement.of((String)"set auto_partition_mode=true"));
            Assert.assertEquals((long)1L, (long)connection.executeUpdate(INSERT_STATEMENT));
            connection.commit();
        }
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteBatchDmlRequest.class));
        ExecuteBatchDmlRequest request = mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).get(0);
        Assert.assertEquals((long)2L, (long)request.getStatementsCount());
        Assert.assertEquals((long)0L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
    }

    @Test
    public void testShowAfterDml() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            Assert.assertEquals((long)1L, (long)connection.executeUpdate(INSERT_STATEMENT));
            Assert.assertEquals((long)1L, (long)connection.executeUpdate(INSERT_STATEMENT));
            connection.execute(Statement.of((String)"show variable auto_partition_mode"));
            connection.commit();
        }
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteBatchDmlRequest.class));
        ExecuteBatchDmlRequest request = mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).get(0);
        Assert.assertEquals((long)2L, (long)request.getStatementsCount());
        Assert.assertEquals((long)0L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
    }

    @Test
    public void testShowBetweenDml() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            Assert.assertEquals((long)1L, (long)connection.executeUpdate(INSERT_STATEMENT));
            connection.execute(Statement.of((String)"show variable auto_partition_mode"));
            Assert.assertEquals((long)1L, (long)connection.executeUpdate(INSERT_STATEMENT));
            connection.commit();
        }
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteBatchDmlRequest.class));
        ExecuteBatchDmlRequest request = mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).get(0);
        Assert.assertEquals((long)2L, (long)request.getStatementsCount());
        Assert.assertEquals((long)0L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
    }

    @Test
    public void testRunBatchInAutoBatch() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            Assert.assertEquals((long)1L, (long)connection.executeUpdate(INSERT_STATEMENT));
            Assert.assertEquals((long)1L, (long)connection.executeUpdate(INSERT_STATEMENT));
            Assert.assertArrayEquals((long[])new long[]{1L, 1L}, (long[])connection.runBatch());
            Assert.assertEquals((long)1L, (long)connection.executeUpdate(INSERT_STATEMENT));
            connection.commit();
        }
        Assert.assertEquals((long)2L, (long)mockSpanner.countRequestsOfType(ExecuteBatchDmlRequest.class));
        ExecuteBatchDmlRequest request1 = mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).get(0);
        Assert.assertEquals((long)2L, (long)request1.getStatementsCount());
        ExecuteBatchDmlRequest request2 = mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).get(1);
        Assert.assertEquals((long)1L, (long)request2.getStatementsCount());
        Assert.assertEquals((long)0L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
    }

    @Test
    public void testStartBatchDmlInAutoBatch() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            Assert.assertEquals((long)1L, (long)connection.executeUpdate(INSERT_STATEMENT));
            Assert.assertEquals((long)1L, (long)connection.executeUpdate(INSERT_STATEMENT));
            SpannerException exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> ((Connection)connection).startBatchDml());
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)exception.getErrorCode());
            Assert.assertEquals((Object)"FAILED_PRECONDITION: Cannot start a DML batch when a batch is already active", (Object)exception.getMessage());
            connection.commit();
        }
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteBatchDmlRequest.class));
        ExecuteBatchDmlRequest request = mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).get(0);
        Assert.assertEquals((long)2L, (long)request.getStatementsCount());
        Assert.assertEquals((long)0L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
    }

    @Test
    public void testStartBatchDdlInAutoBatch() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            Assert.assertEquals((long)1L, (long)connection.executeUpdate(INSERT_STATEMENT));
            Assert.assertEquals((long)1L, (long)connection.executeUpdate(INSERT_STATEMENT));
            SpannerException exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> ((Connection)connection).startBatchDdl());
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)exception.getErrorCode());
            Assert.assertEquals((Object)"FAILED_PRECONDITION: Cannot start a DDL batch when a batch is already active", (Object)exception.getMessage());
            connection.commit();
        }
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteBatchDmlRequest.class));
        ExecuteBatchDmlRequest request = mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).get(0);
        Assert.assertEquals((long)2L, (long)request.getStatementsCount());
        Assert.assertEquals((long)0L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
    }

    @Test
    public void testExecuteDdlInAutoBatch() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            Assert.assertEquals((long)1L, (long)connection.executeUpdate(INSERT_STATEMENT));
            Assert.assertEquals((long)1L, (long)connection.executeUpdate(INSERT_STATEMENT));
            SpannerException exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.execute(Statement.of((String)"CREATE TABLE foo")));
            Assert.assertEquals((Object)ErrorCode.FAILED_PRECONDITION, (Object)exception.getErrorCode());
            Assert.assertEquals((Object)"FAILED_PRECONDITION: DDL-statements are not allowed inside a read/write transaction.", (Object)exception.getMessage());
            connection.commit();
        }
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteBatchDmlRequest.class));
        ExecuteBatchDmlRequest request = mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).get(0);
        Assert.assertEquals((long)2L, (long)request.getStatementsCount());
        Assert.assertEquals((long)0L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
    }

    @Test
    public void testSavepointBetweenDml() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            Assert.assertEquals((long)1L, (long)connection.executeUpdate(INSERT_STATEMENT));
            connection.savepoint("s1");
            Assert.assertEquals((long)1L, (long)connection.executeUpdate(INSERT_STATEMENT));
            connection.commit();
        }
        Assert.assertEquals((long)2L, (long)mockSpanner.countRequestsOfType(ExecuteBatchDmlRequest.class));
        Assert.assertEquals((long)0L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
    }

    @Test
    public void testRollbackToSavepointBetweenDml() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.setSavepointSupport(SavepointSupport.ENABLED);
            connection.savepoint("s1");
            Assert.assertEquals((long)1L, (long)connection.executeUpdate(INSERT_STATEMENT));
            connection.rollbackToSavepoint("s1");
            Assert.assertEquals((long)1L, (long)connection.executeUpdate(INSERT_STATEMENT));
            connection.commit();
        }
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteBatchDmlRequest.class));
        ExecuteBatchDmlRequest request = mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).get(0);
        Assert.assertEquals((long)1L, (long)request.getStatementsCount());
        Assert.assertEquals((long)0L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
    }

    @Test
    public void testReleaseSavepointBetweenDml() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.savepoint("s1");
            Assert.assertEquals((long)1L, (long)connection.executeUpdate(INSERT_STATEMENT));
            connection.releaseSavepoint("s1");
            Assert.assertEquals((long)1L, (long)connection.executeUpdate(INSERT_STATEMENT));
            connection.commit();
        }
        Assert.assertEquals((long)2L, (long)mockSpanner.countRequestsOfType(ExecuteBatchDmlRequest.class));
        Assert.assertEquals((long)0L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
    }

    @Test
    public void testAbortBatchAfterDml() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            Assert.assertEquals((long)1L, (long)connection.executeUpdate(INSERT_STATEMENT));
            connection.abortBatch();
            Assert.assertEquals((long)1L, (long)connection.executeUpdate(INSERT_STATEMENT));
            connection.commit();
        }
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteBatchDmlRequest.class));
        ExecuteBatchDmlRequest request = mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).get(0);
        Assert.assertEquals((long)1L, (long)request.getStatementsCount());
        Assert.assertEquals((long)0L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
    }

    @Test
    public void testExecuteBatchDmlAfterDml() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            Assert.assertEquals((long)1L, (long)connection.executeUpdate(INSERT_STATEMENT));
            Assert.assertArrayEquals((long[])new long[]{1L, 1L}, (long[])connection.executeBatchUpdate((Iterable)ImmutableList.of((Object)INSERT_STATEMENT, (Object)INSERT_STATEMENT)));
            connection.commit();
        }
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteBatchDmlRequest.class));
        ExecuteBatchDmlRequest request = mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).get(0);
        Assert.assertEquals((long)3L, (long)request.getStatementsCount());
        Assert.assertEquals((long)0L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
    }

    @Test
    public void testExecuteBatchDmlAndThenDml() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.executeBatchUpdate((Iterable)ImmutableList.of((Object)INSERT_STATEMENT, (Object)INSERT_STATEMENT));
            connection.executeUpdate(INSERT_STATEMENT);
            connection.commit();
        }
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteBatchDmlRequest.class));
        ExecuteBatchDmlRequest request = mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).get(0);
        Assert.assertEquals((long)3L, (long)request.getStatementsCount());
        Assert.assertEquals((long)0L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
    }

    @Test
    public void testAnalyzeUpdateInAutoDmlBatch() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            connection.executeUpdate(INSERT_STATEMENT);
            connection.analyzeUpdateStatement(INSERT_STATEMENT, ReadContext.QueryAnalyzeMode.PLAN, new Options.UpdateOption[0]);
            connection.executeUpdate(INSERT_STATEMENT);
            connection.commit();
        }
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteBatchDmlRequest.class));
        ExecuteBatchDmlRequest request = mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).get(0);
        Assert.assertEquals((long)2L, (long)request.getStatementsCount());
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
    }

    @Test
    public void testQueryWithErrorAfterDml() {
        Statement invalidSelect = Statement.of((String)"SELECT * FROM foo");
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.exception(invalidSelect, Status.NOT_FOUND.withDescription("Table foo not found").asRuntimeException()));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            Assert.assertEquals((long)1L, (long)connection.executeUpdate(INSERT_STATEMENT));
            Assert.assertEquals((long)1L, (long)connection.executeUpdate(INSERT_STATEMENT));
            SpannerException exception = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.executeQuery(invalidSelect, new Options.QueryOption[0]));
            Assert.assertEquals((Object)ErrorCode.NOT_FOUND, (Object)exception.getErrorCode());
            connection.commit();
        }
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteBatchDmlRequest.class));
        ExecuteBatchDmlRequest request = mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).get(0);
        Assert.assertEquals((long)2L, (long)request.getStatementsCount());
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
    }

    @Test
    public void testDmlWithErrorInBatch() {
        Statement invalidInsert = Statement.of((String)"INSERT INTO foo (id) values (1)");
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.exception(invalidInsert, Status.NOT_FOUND.withDescription("Table foo not found").asRuntimeException()));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            Assert.assertEquals((long)1L, (long)connection.executeUpdate(INSERT_STATEMENT));
            Assert.assertEquals((long)1L, (long)connection.executeUpdate(invalidInsert));
            Assert.assertEquals((long)1L, (long)connection.executeUpdate(INSERT_STATEMENT));
            SpannerBatchUpdateException exception = (SpannerBatchUpdateException)Assert.assertThrows(SpannerBatchUpdateException.class, () -> connection.executeQuery(SELECT1_STATEMENT, new Options.QueryOption[0]));
            Assert.assertEquals((Object)ErrorCode.NOT_FOUND, (Object)exception.getErrorCode());
            Assert.assertArrayEquals((long[])new long[]{1L}, (long[])exception.getUpdateCounts());
            connection.commit();
        }
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteBatchDmlRequest.class));
        ExecuteBatchDmlRequest request = mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).get(0);
        Assert.assertEquals((long)3L, (long)request.getStatementsCount());
        Assert.assertEquals((long)0L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
    }

    @Test
    public void testUpdateCount() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            try {
                connection.setAutoBatchDmlUpdateCountVerification(false);
                connection.setAutoBatchDmlUpdateCount(2L);
                Assert.assertEquals((long)2L, (long)connection.executeUpdate(INSERT_STATEMENT));
                connection.setAutoBatchDmlUpdateCount(3L);
                Assert.assertEquals((long)3L, (long)connection.executeUpdate(INSERT_STATEMENT));
                connection.commit();
                connection.startBatchDml();
                Assert.assertEquals((long)-1L, (long)connection.executeUpdate(INSERT_STATEMENT));
                connection.runBatch();
                connection.commit();
            }
            finally {
                System.clearProperty("spanner.auto_batch_dml_update_count");
                System.clearProperty("spanner.auto_batch_dml_update_count_verification");
            }
        }
        Assert.assertEquals((long)2L, (long)mockSpanner.countRequestsOfType(ExecuteBatchDmlRequest.class));
        Assert.assertEquals((long)2L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
    }

    @Test
    public void testUpdateCountVerification_failsIfDifferent() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            try {
                Assert.assertEquals((long)1L, (long)connection.executeUpdate(INSERT_STATEMENT));
                connection.setAutoBatchDmlUpdateCount(3L);
                Assert.assertEquals((long)3L, (long)connection.executeUpdate(INSERT_STATEMENT));
                Assert.assertThrows(SpannerException.class, () -> ((Connection)connection).commit());
            }
            finally {
                System.clearProperty("spanner.auto_batch_dml_update_count");
            }
        }
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteBatchDmlRequest.class));
        Assert.assertEquals((long)0L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateCountVerification_succeedsIfSame() {
        Statement statement1 = Statement.of((String)"insert into foo (id, value) values (1, 'One')");
        Statement statement2 = Statement.of((String)"insert into foo (id, value) values (2, 'Two')");
        Statement statement3 = Statement.of((String)"insert into foo (id, value) values (3, 'Three')");
        Statement statement4 = Statement.of((String)"insert into foo (id, value) values (4, 'Four')");
        Statement statement5 = Statement.of((String)"insert into foo (id, value) values (5, 'Five')");
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(statement1, 1L));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(statement2, 2L));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(statement3, 3L));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(statement4, 3L));
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(statement5, 4L));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            try {
                connection.setAutoBatchDmlUpdateCount(1L);
                Assert.assertEquals((long)1L, (long)connection.executeUpdate(statement1));
                connection.setAutoBatchDmlUpdateCount(2L);
                Assert.assertEquals((long)2L, (long)connection.executeUpdate(statement2));
                connection.setAutoBatchDmlUpdateCount(3L);
                Assert.assertArrayEquals((long[])new long[]{3L, 3L}, (long[])connection.executeBatchUpdate((Iterable)ImmutableList.of((Object)statement3, (Object)statement4)));
                connection.setAutoBatchDmlUpdateCount(4L);
                Assert.assertEquals((long)4L, (long)connection.executeUpdate(statement5));
                connection.commit();
            }
            finally {
                System.clearProperty("spanner.auto_batch_dml_update_count");
            }
        }
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteBatchDmlRequest.class));
        ExecuteBatchDmlRequest request = mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).get(0);
        Assert.assertEquals((long)5L, (long)request.getStatementsCount());
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
    }

    @Test
    public void testTransactionRetry() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            Assert.assertEquals((long)1L, (long)connection.executeUpdate(INSERT_STATEMENT));
            Assert.assertEquals((long)1L, (long)connection.executeUpdate(INSERT_STATEMENT));
            try (ResultSet resultSet = connection.executeQuery(SELECT1_STATEMENT, new Options.QueryOption[0]);){
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertEquals((long)1L, (long)resultSet.getLong(0));
                Assert.assertFalse((boolean)resultSet.next());
            }
            mockSpanner.abortNextStatement();
            connection.commit();
        }
        Assert.assertEquals((long)2L, (long)mockSpanner.countRequestsOfType(ExecuteBatchDmlRequest.class));
        ExecuteBatchDmlRequest request = mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).get(0);
        Assert.assertEquals((long)2L, (long)request.getStatementsCount());
        Assert.assertEquals((long)2L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        Assert.assertEquals((long)2L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTransactionRetryFails() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            Assert.assertEquals((long)1L, (long)connection.executeUpdate(INSERT_STATEMENT));
            Assert.assertEquals((long)1L, (long)connection.executeUpdate(INSERT_STATEMENT));
            try (ResultSet resultSet = connection.executeQuery(SELECT1_STATEMENT, new Options.QueryOption[0]);){
                Assert.assertTrue((boolean)resultSet.next());
                Assert.assertEquals((long)1L, (long)resultSet.getLong(0));
                Assert.assertFalse((boolean)resultSet.next());
            }
            mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(INSERT_STATEMENT, 2L));
            mockSpanner.abortNextStatement();
            Assert.assertThrows(AbortedDueToConcurrentModificationException.class, () -> ((Connection)connection).commit());
        }
        finally {
            mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.update(INSERT_STATEMENT, 1L));
        }
        Assert.assertEquals((long)2L, (long)mockSpanner.countRequestsOfType(ExecuteBatchDmlRequest.class));
        ExecuteBatchDmlRequest request = mockSpanner.getRequestsOfType(ExecuteBatchDmlRequest.class).get(0);
        Assert.assertEquals((long)2L, (long)request.getStatementsCount());
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(ExecuteSqlRequest.class));
        Assert.assertEquals((long)1L, (long)mockSpanner.countRequestsOfType(CommitRequest.class));
    }

    @Test
    public void testSqlStatements() {
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            ResultSet resultSet;
            for (boolean bl : new boolean[]{true, false}) {
                connection.execute(Statement.of((String)("set auto_batch_dml = " + bl)));
                resultSet = connection.executeQuery(Statement.of((String)"show variable auto_batch_dml"), new Options.QueryOption[0]);
                try {
                    Assert.assertTrue((boolean)resultSet.next());
                    Assert.assertEquals((Object)bl, (Object)resultSet.getBoolean("AUTO_BATCH_DML"));
                    Assert.assertFalse((boolean)resultSet.next());
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
            for (boolean bl : new boolean[]{true, false}) {
                connection.execute(Statement.of((String)("set auto_batch_dml_update_count_verification = " + bl)));
                resultSet = connection.executeQuery(Statement.of((String)"show variable auto_batch_dml_update_count_verification"), new Options.QueryOption[0]);
                try {
                    Assert.assertTrue((boolean)resultSet.next());
                    Assert.assertEquals((Object)bl, (Object)resultSet.getBoolean("AUTO_BATCH_DML_UPDATE_COUNT_VERIFICATION"));
                    Assert.assertFalse((boolean)resultSet.next());
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
            for (long l : new long[]{0L, 5L, 100L}) {
                connection.execute(Statement.of((String)("set auto_batch_dml_update_count = " + l)));
                try (ResultSet resultSet2 = connection.executeQuery(Statement.of((String)"show variable auto_batch_dml_update_count"), new Options.QueryOption[0]);){
                    Assert.assertTrue((boolean)resultSet2.next());
                    Assert.assertEquals((long)l, (long)resultSet2.getLong("AUTO_BATCH_DML_UPDATE_COUNT"));
                    Assert.assertFalse((boolean)resultSet2.next());
                }
            }
            SpannerException spannerException = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.execute(Statement.of((String)"set auto_batch_dml_update_count=-1")));
            Assert.assertEquals((Object)ErrorCode.INVALID_ARGUMENT, (Object)spannerException.getErrorCode());
            Assert.assertEquals((Object)"INVALID_ARGUMENT: Unknown value for AUTO_BATCH_DML_UPDATE_COUNT: -1", (Object)spannerException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPostgreSQLStatements() {
        SpannerPool.closeSpannerPool();
        mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.detectDialectResult(Dialect.POSTGRESQL));
        try (ITAbstractSpannerTest.ITConnection connection = this.createConnection();){
            ResultSet resultSet;
            for (boolean bl : new boolean[]{true, false}) {
                connection.execute(Statement.of((String)("set spanner.auto_batch_dml to " + (bl ? "on" : "off"))));
                resultSet = connection.executeQuery(Statement.of((String)"show variable spanner.auto_batch_dml"), new Options.QueryOption[0]);
                try {
                    Assert.assertTrue((boolean)resultSet.next());
                    Assert.assertEquals((Object)bl, (Object)resultSet.getBoolean("SPANNER.AUTO_BATCH_DML"));
                    Assert.assertFalse((boolean)resultSet.next());
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
            for (boolean bl : new boolean[]{true, false}) {
                connection.execute(Statement.of((String)("set spanner.auto_batch_dml_update_count_verification = " + bl)));
                resultSet = connection.executeQuery(Statement.of((String)"show spanner.auto_batch_dml_update_count_verification"), new Options.QueryOption[0]);
                try {
                    Assert.assertTrue((boolean)resultSet.next());
                    Assert.assertEquals((Object)bl, (Object)resultSet.getBoolean("SPANNER.AUTO_BATCH_DML_UPDATE_COUNT_VERIFICATION"));
                    Assert.assertFalse((boolean)resultSet.next());
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
            for (long l : new long[]{0L, 5L, 100L}) {
                connection.execute(Statement.of((String)("set spanner.auto_batch_dml_update_count to " + l)));
                try (ResultSet resultSet2 = connection.executeQuery(Statement.of((String)"show  spanner.auto_batch_dml_update_count"), new Options.QueryOption[0]);){
                    Assert.assertTrue((boolean)resultSet2.next());
                    Assert.assertEquals((long)l, (long)resultSet2.getLong("SPANNER.AUTO_BATCH_DML_UPDATE_COUNT"));
                    Assert.assertFalse((boolean)resultSet2.next());
                }
            }
            SpannerException spannerException = (SpannerException)Assert.assertThrows(SpannerException.class, () -> connection.execute(Statement.of((String)"set spanner.auto_batch_dml_update_count=-1")));
            Assert.assertEquals((Object)ErrorCode.INVALID_ARGUMENT, (Object)spannerException.getErrorCode());
            Assert.assertEquals((Object)"INVALID_ARGUMENT: Unknown value for SPANNER.AUTO_BATCH_DML_UPDATE_COUNT: -1", (Object)spannerException.getMessage());
        }
        finally {
            SpannerPool.closeSpannerPool();
            mockSpanner.putStatementResult(MockSpannerServiceImpl.StatementResult.detectDialectResult(Dialect.GOOGLE_STANDARD_SQL));
        }
    }
}

