/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.spanner.BatchClient;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionManager;
import com.google.cloud.spanner.TransactionRunner;
import com.google.cloud.spanner.connection.AutocommitDmlMode;
import com.google.cloud.spanner.connection.ConnectionImpl;
import com.google.cloud.spanner.connection.ConnectionOptions;
import com.google.cloud.spanner.connection.DdlClient;
import com.google.cloud.spanner.connection.SpannerPool;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class AutocommitDmlModeTest {
    private static final String UPDATE = "UPDATE foo SET bar=1";
    private static final String URI = "cloudspanner:/projects/test-project-123/instances/test-instance/databases/test-database";
    private DatabaseClient dbClient;
    private TransactionContext txContext;

    private ConnectionImpl createConnection(ConnectionOptions options) {
        this.dbClient = (DatabaseClient)Mockito.mock(DatabaseClient.class);
        Mockito.when((Object)this.dbClient.getDialect()).thenReturn((Object)Dialect.GOOGLE_STANDARD_SQL);
        this.txContext = (TransactionContext)Mockito.mock(TransactionContext.class);
        Spanner spanner = (Spanner)Mockito.mock(Spanner.class);
        SpannerPool spannerPool = (SpannerPool)Mockito.mock(SpannerPool.class);
        Mockito.when((Object)spannerPool.getSpanner((ConnectionOptions)Mockito.any(ConnectionOptions.class), (ConnectionImpl)Mockito.any(ConnectionImpl.class))).thenReturn((Object)spanner);
        DdlClient ddlClient = (DdlClient)Mockito.mock(DdlClient.class);
        TransactionRunner txRunner = (TransactionRunner)Mockito.mock(TransactionRunner.class);
        Mockito.when((Object)this.dbClient.readWriteTransaction(new Options.TransactionOption[0])).thenReturn((Object)txRunner);
        Mockito.when((Object)txRunner.run((TransactionRunner.TransactionCallable)Mockito.any(TransactionRunner.TransactionCallable.class))).thenAnswer(invocation -> {
            TransactionRunner.TransactionCallable callable = (TransactionRunner.TransactionCallable)invocation.getArguments()[0];
            return callable.run(this.txContext);
        });
        TransactionManager txManager = (TransactionManager)Mockito.mock(TransactionManager.class);
        Mockito.when((Object)txManager.begin()).thenReturn((Object)this.txContext);
        Mockito.when((Object)this.dbClient.transactionManager(new Options.TransactionOption[0])).thenReturn((Object)txManager);
        return new ConnectionImpl(options, spannerPool, ddlClient, this.dbClient, (BatchClient)Mockito.mock(BatchClient.class));
    }

    @Test
    public void testAutocommitDmlModeTransactional() {
        try (ConnectionImpl connection = this.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri(URI).build());){
            MatcherAssert.assertThat((Object)connection.isAutocommit(), (Matcher)CoreMatchers.is((Object)true));
            MatcherAssert.assertThat((Object)connection.isReadOnly(), (Matcher)CoreMatchers.is((Object)false));
            MatcherAssert.assertThat((Object)connection.getAutocommitDmlMode(), (Matcher)CoreMatchers.is((Object)AutocommitDmlMode.TRANSACTIONAL));
            connection.execute(Statement.of((String)UPDATE));
            ((TransactionContext)Mockito.verify((Object)this.txContext)).executeUpdate(Statement.of((String)UPDATE), new Options.UpdateOption[0]);
            ((DatabaseClient)Mockito.verify((Object)this.dbClient, (VerificationMode)Mockito.never())).executePartitionedUpdate(Statement.of((String)UPDATE), new Options.UpdateOption[0]);
        }
    }

    @Test
    public void testAutocommitDmlModePartitioned() {
        try (ConnectionImpl connection = this.createConnection(ConnectionOptions.newBuilder().setCredentials((Credentials)NoCredentials.getInstance()).setUri(URI).build());){
            MatcherAssert.assertThat((Object)connection.isAutocommit(), (Matcher)CoreMatchers.is((Object)true));
            MatcherAssert.assertThat((Object)connection.isReadOnly(), (Matcher)CoreMatchers.is((Object)false));
            connection.setAutocommitDmlMode(AutocommitDmlMode.PARTITIONED_NON_ATOMIC);
            MatcherAssert.assertThat((Object)connection.getAutocommitDmlMode(), (Matcher)CoreMatchers.is((Object)AutocommitDmlMode.PARTITIONED_NON_ATOMIC));
            connection.execute(Statement.of((String)UPDATE));
            ((TransactionContext)Mockito.verify((Object)this.txContext, (VerificationMode)Mockito.never())).executeUpdate(Statement.of((String)UPDATE), new Options.UpdateOption[0]);
            ((DatabaseClient)Mockito.verify((Object)this.dbClient)).executePartitionedUpdate(Statement.of((String)UPDATE), new Options.UpdateOption[0]);
        }
    }
}

